USE master;
GO

CREATE DATABASE DB_SPORT
GO

USE DB_SPORT;
GO

CREATE TABLE dbo.T_SPORT_SPT
(
	SPT_ID int IDENTITY(1,1) NOT NULL PRIMARY KEY,
	SPT_LIBELLE varchar(32) NULL 
)
GO

CREATE TABLE dbo.T_ADHERENT_ADR
(
	ADR_ID int IDENTITY(1,1) NOT NULL PRIMARY KEY ,
	ADR_NOM char(32) NULL,
	ADR_PRENOM varchar(25) NULL,
	ADR_DATE_NAISSANCE datetime NULL,
	ADR_TEL_FIX char(20) NULL,
	ADR_TEL_MOBILE char(20) NULL,
	ADR_MAIL char(64) NULL,
	ADR_ADRESSE1 varchar(38) NULL,
	ADR_ADRESSE2 varchar(38) NULL,
	ADR_ADRESSE3 varchar(38) NULL,
	ADR_CP char(8) NULL,
	ADR_VILLE char(32) NULL,
	ADR_LOGIN char(32) NULL,
	ADR_PASS char(32) NULL,
	ADR_NUMSECU char(13) NULL,
	ADR_POINTS decimal(29, 9) NULL,
	ADR_DATE_ADHESION datetime NULL,
	ADR_CATEGORIE char(16) NULL,
	ADR_REDUCTION_PC float NULL,
	ADR_FONDATEUR bit NOT NULL DEFAULT 0
)
GO

--> modification si version > 2005
IF LEFT(@@VERSION, 25) > 'Microsoft SQL Server 2005'
   EXEC ('ALTER TABLE T_ADHERENT_ADR ALTER COLUMN ADR_DATE_NAISSANCE DATE; ALTER TABLE T_ADHERENT_ADR ALTER COLUMN ADR_DATE_ADHESION DATE;')
GO

CREATE TABLE dbo.T_PRATIQUE_PTQ
(
	ADR_ID int NOT NULL,
	SPT_ID int NOT NULL,
 CONSTRAINT PK_T_PRATIQUE_PTQ PRIMARY KEY (ADR_ID ASC, SPT_ID ASC)
)
GO

CHECKPOINT;
GO

CHECKPOINT;
GO

SET IDENTITY_INSERT dbo.T_SPORT_SPT ON;
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (1,'Aerobic sportive');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (2,'Arostation');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (3,'Aikido');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (4,'Alpinisme');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (5,'Apne');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (6,'Aqua gym');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (7,'Arts martiaux artistiques');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (8,'Athltisme');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (9,'Aviron');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (10,'Badminton');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (11,'Baseball');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (12,'Basket ball');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (13,'Beach volley');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (14,'Biathlon');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (15,'Billard');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (16,'BMX');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (17,'Boxe amricaine');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (18,'Boxe anglaise');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (19,'Boxe chinoise');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (20,'Boxe franaise');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (21,'Boxe thalandaise');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (22,'Cano kayak');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (23,'Canyonisme');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (24,'Capoeira');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (25,'Char  voile');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (26,'Course  pied');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (27,'Cyclisme sur piste');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (28,'Cyclisme sur route');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (29,'Cyclo-cross');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (30,'Deltaplane');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (31,'Equitation');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (32,'Escalade');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (33,'Escrime');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (34,'Fitness');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (35,'Football');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (36,'Football US');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (37,'Golf');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (38,'Gymnastique artistique');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (39,'Gymnastique douce');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (40,'Gymnastique rythmique');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (41,'Haltrophilie');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (42,'Handball');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (43,'Hockey sur glace');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (44,'Ju-Jitsu traditionnel');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (45,'Karat');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (46,'Karting');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (47,'Kick boxing');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (48,'Kite surf');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (49,'Krav maga');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (50,'Kung fu');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (51,'Luge');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (52,'Lutte grco-romaine');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (53,'Moto cross');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (54,'Moto vitesse');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (55,'Motoneige');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (56,'Musculation');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (57,'Nage avec palmes');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (58,'Natation');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (59,'Natation synchronise');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (60,'Parachutisme');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (61,'Parapente');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (62,'Patinage artistique');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (63,'Pche sous-marine');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (64,'Pelote basque');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (65,'Pentathlon');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (66,'Planche  voile');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (67,'Plonge');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (68,'Plongeon');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (69,'Rafting');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (70,'Randonne questre');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (71,'Randonne pdestre');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (72,'Raquette  neige');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (73,'Rugby  XIII');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (74,'Rugby  XV');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (75,'Skateboard');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (76,'Ski alpin');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (77,'Ski de fond');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (78,'Ski de randonne');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (79,'Ski de vitesse');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (80,'Ski nautique');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (81,'Snowboard');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (82,'Splologie');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (83,'Squash');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (84,'Surf');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (85,'Taekwondo');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (86,'Tennis');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (87,'Tennis de table');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (88,'Tir  l''arc');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (89,'Tir sportif');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (90,'Tir subaquatique');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (91,'Trampoline');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (92,'Triathlon');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (93,'ULM');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (94,'Voile');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (95,'Vol  voile');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (96,'Volley ball');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (97,'VTT');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (98,'Water polo');
INSERT INTO dbo.T_SPORT_SPT (SPT_ID,SPT_LIBELLE) VALUES (99,'Yoga');
SET IDENTITY_INSERT dbo.T_SPORT_SPT OFF;

CHECKPOINT;
GO

SET DATEFORMAT YMD;
GO

SET IDENTITY_INSERT dbo.T_ADHERENT_ADR ON;
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1,'CATHERINE','YVES','1930-02-24','02.47.10.44.66','06.10.07.30.18',NULL,'21 imp de l''aurore','','','14460','COLOMBELLES',NULL,NULL,'2300250643001',15.000000000,'1957-07-23','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2,'REVET','MARCEL','1934-07-17','02.80.29.15.70','06.13.93.63.02',NULL,'','','','14730','GIBERVILLE',NULL,NULL,'1340714406001',75.000000000,'1955-09-04','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (3,'GOSSET','ANDRE','1930-05-09','02.10.58.92.37','06.21.37.29.23',NULL,'','','','14480','CREULLY',NULL,NULL,'2300514022001',178.000000000,'1956-07-04','PREMIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (4,'RICHARD','Claude','1943-01-16','02.12.29.46.51','06.74.02.77.90',NULL,'10 PLACE DE L''HOTEL DE VILLE','','','14260','ROUCAMPS',NULL,NULL,'2430114275001',69.000000000,'1973-04-08','SILVER',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (5,'KAMALI','GENEVIEVE','1928-07-26','02.13.03.04.39','06.83.11.12.21',NULL,'20 av de la cite miniere','','','14270','MEZIDON CANON',NULL,NULL,'1280714437001',123.000000000,'1950-03-23','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (6,'LEFRANCOIS','ARLETTE','1936-07-12','02.74.05.90.78',NULL,NULL,'','','','14000','CAEN',NULL,NULL,'1360714592001',146.000000000,'1963-07-08','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (7,'LEMARCHAND','RENE','1939-10-23','02.76.01.64.95','06.15.91.69.48',NULL,'7 BD DU 11 NOVEMBRE','','','14123','CORMELLES LE ROYAL',NULL,NULL,'1391014654001',107.000000000,'1960-04-24','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (8,'','FRANCOISE','1929-06-17','02.94.15.61.90','06.30.19.07.53',NULL,'','','','50360','PICAUVILLE',NULL,NULL,'2290650096001',37.000000000,'1952-05-15','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (9,'BOIS','Bernard','1930-11-21','02.50.84.40.21','06.35.36.78.98',NULL,'','','','14430','DOZULE',NULL,NULL,'2301114752001',96.000000000,'1956-02-19','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (10,'BOIS','MARGUERITE','1938-02-09','02.66.95.40.44','06.57.27.29.13',NULL,'','','','61200','SARCEAUX',NULL,NULL,'2380227129001',52.000000000,'1961-12-23','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (11,'HUVIER','SANDRINE','1931-12-24','02.38.28.79.54','06.64.98.11.71',NULL,'','','','14740','BRETTEVILLE L''ORGUEILLEUSE',NULL,NULL,'1311214717001',367.000000000,'1953-07-16','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (12,'GUERIN','MICHEL','1946-01-31','02.33.61.04.21','06.24.08.16.24',NULL,'','','','14970','BENOUVILLE',NULL,NULL,'2460114424001',57.000000000,'1968-08-13','GOLD',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (13,'VANRYCKEGHEM','ADRIENNE','1935-12-21','02.86.58.50.19','06.14.55.78.95',NULL,'','','','14840','DEMOUVILLE',NULL,NULL,'2351214569001',145.000000000,'1965-03-09','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (14,'HOUSSIN','YVETTE','1946-02-17','02.86.54.17.68','06.72.62.43.67',NULL,'25 RUE LOUIS ARRAGON','','','14320','ST MARTIN DE FONTENAY',NULL,NULL,'2460250223001',439.000000000,'1969-11-02','GOLD',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (15,'LEBOURGEOIS','MARIE-JEANNE','1936-02-05','02.45.35.55.64','06.75.92.30.96',NULL,'','','','14000','CAEN',NULL,NULL,'1360261071001',138.000000000,'1958-01-26','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (16,'CALLY','EUGENIE','1939-01-10',NULL,NULL,NULL,'29 RUE DE L4ESPERANCE','','','14760','BRETTEVILLE SUR ODON',NULL,NULL,'1390122304001',107.000000000,'1964-11-19','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (17,'CARABEUF','ROLANDE','1930-11-12','02.75.82.69.76','06.22.45.09.95',NULL,'15 REU DES MOISSONEURS','','','14000','CAEN',NULL,NULL,'2301114738001',488.000000000,'1953-03-19','PREMIUM',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (18,'GASNIER','PAUL','1959-01-30','02.73.21.83.76','06.27.62.17.79',NULL,'15 RUE DE LA CAVEE','','','14860','RANVILLE',NULL,NULL,'1590114675001',158.000000000,'1982-10-19','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (19,'AZE','Claude','1933-05-10','02.42.16.95.21','06.62.87.66.62',NULL,'','','','14190','SOIGNOLLES',NULL,NULL,'2330550594001',210.000000000,'1958-07-23','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (20,'JAVELAUD','MONIQUE','1940-01-27','02.76.66.34.89','06.77.39.26.26',NULL,'','','','14370','ARGENCES',NULL,NULL,'1400114432001',401.000000000,'1965-01-28','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (21,'LIVET','CATHERINE','1956-09-29','02.12.32.25.76','06.86.82.14.15',NULL,'','','','14000','CAEN',NULL,NULL,'1560914052001',646.000000000,'1981-09-22','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (22,'ANNE','JOEL','1937-01-18','02.27.99.91.81','06.97.31.09.15',NULL,'','','','14650','CARPIQUET',NULL,NULL,'1370161307001',505.000000000,'1964-08-07','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (23,'HERVIEU','ROGER','1930-12-03','02.11.88.84.93','06.35.09.28.42',NULL,'','','','14850','ESCOVILLE',NULL,NULL,'1301214201001',3416.000000000,'1959-06-22','GOLD',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (24,'BARBIER','ANNICK','1932-07-29','02.10.26.31.42','06.86.73.57.20',NULL,'','','','14000','CAEN',NULL,NULL,'1320714537001',89.000000000,'1962-11-21','PREMIUM',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (25,'BAZIN','ALAIN','1932-04-03','02.19.47.98.09','06.39.58.91.92',NULL,'','','','14370','GIBERVILLE',NULL,NULL,'1320453276001',186.000000000,'1954-07-05','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (26,'MERIEULT','EUGENE','1930-03-21','02.79.77.88.81','06.95.19.19.74',NULL,'8 RUE HAVIN','','','14000','CAEN',NULL,NULL,'2300353079001',1144.000000000,'1957-09-06','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (27,'BERARD','CLAUDIA','1938-04-19','02.15.31.79.34','06.22.48.66.55',NULL,'14 RUE PASTEUR','','','14200','HEROUVILLE ST CLAIR',NULL,NULL,'2380414249001',153.000000000,'1962-05-30','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (28,'BERARD','ROGER','1933-10-22','02.76.28.74.21',NULL,NULL,'12 rue de lanteuil','','','14000','CAEN',NULL,NULL,'2331078504001',97.000000000,'1963-06-25','PREMIUM',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (29,'DUPONT','CLAIRE','1958-05-15','02.69.98.74.19',NULL,NULL,'12 rue st barbe','','','14120','MONDEVILLE',NULL,NULL,'1580514749001',2445.000000000,'1980-08-10','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (30,'BRUNET','JEAN','1938-11-17','02.73.33.08.75','06.11.38.52.22',NULL,'zone industrielle du martray','','','14112','BIEVILLE BEUVILLE',NULL,NULL,'2381114220001',248.000000000,'1961-03-17','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (31,'THUILLIETTE','PIERRE','1959-01-18',NULL,NULL,NULL,'','','','14740','LASSON',NULL,NULL,'2590153238001',38.000000000,'1980-08-29','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (32,'MANCEL','JACQUELINE','1943-04-15','02.90.01.38.94','06.65.23.39.87',NULL,'','','','14740','LASSON',NULL,NULL,'1430414336001',7.000000000,'1973-09-05','SILVER',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (33,'LEMERAY','GERARD','1937-09-03','02.38.30.21.17','06.44.98.72.82',NULL,'102 rue de branville','','','14490','BALLEROY',NULL,NULL,'2370914347001',462.000000000,'1967-11-23','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (34,'GAUTIER','REGIS','1929-01-01','02.85.34.72.26','06.79.13.29.95',NULL,'22 bvd raymond poincare','','','14220','BARBERY',NULL,NULL,'2290114071001',191.000000000,'1959-03-13','PREMIUM',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (35,'LEGELEUX','GERARD','1937-06-05','02.53.13.30.95','06.44.54.85.38',NULL,'38 avenue ste therese','','','14400','BAYEUX',NULL,NULL,'1370614039001',628.000000000,'1965-10-11','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (36,'ROUSSEL','CLAUDE','1923-08-12','02.45.80.39.03','06.50.45.39.94',NULL,'','','','14114','VER SUR MER',NULL,NULL,'1230850394001',42.000000000,'1951-02-02','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (37,'BISSON','JEAN','1949-02-09','02.71.48.88.82','06.92.23.27.55',NULL,'','','','14540','GRENTHEVILLE',NULL,NULL,'2490261321001',13.000000000,'1970-07-27','PREMIUM',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (38,'BALLUAS','ROBERT','1940-08-02','02.57.42.05.40','06.48.54.34.76',NULL,'18 rue de stocklhome','','','14000','CAEN',NULL,NULL,'1400861102001',2974.000000000,'1964-06-18','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (39,'BARBIER','JEAN MARIE','1957-10-02','02.88.01.55.44','06.10.40.89.58',NULL,'','','','14680','CINTHEAUX',NULL,NULL,'2571014215001',767.000000000,'1979-03-20','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (40,'JAMES','SYLVIE','1933-12-20','02.19.49.15.02','06.30.47.21.46',NULL,'','','','14000','CAEN',NULL,NULL,'1331253043001',128.000000000,'1955-05-22','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (41,'LEPELTIER','SERGE','1933-08-31','02.29.49.36.43','06.65.58.85.48',NULL,'','','','14240','ST GERMAIN D''ECTOT',NULL,NULL,'1330814622001',12.000000000,'1954-09-19','PREMIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (42,'LEROSIER','NICOLLE','1932-02-09','02.34.83.53.46','06.63.95.26.55',NULL,'','','','14000','CAEN',NULL,NULL,'2320214372001',573.000000000,'1961-06-26','PREMIUM',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (43,'LANOS','Christine','1934-10-15','02.52.42.83.51','06.36.53.77.83',NULL,'16 AVENUE DU 43 IEME REGT D ARTI','LLERIE','','14000','CAEN',NULL,NULL,'1341014651001',30.000000000,'1964-02-28','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (44,'LEREBOUR','MICHEL','1979-03-17','02.56.49.82.01','06.47.24.14.04',NULL,'2 rue meaise','','','14320','ST MARTIN DE FONTENAY',NULL,NULL,'1790356152001',719.000000000,'2005-03-07','PREMIUM',10,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (45,'MALASSENET','ARLETTE','1932-06-27','02.12.28.42.00','06.33.37.28.35',NULL,'','','','14370','CLEVILLE',NULL,NULL,'2320614735001',146.000000000,'1959-05-10','PLATINIUM',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (46,'LENEVEU','RENE',NULL,'02.34.86.08.56','06.11.89.41.74',NULL,'le mesnil touffray','','','14270','MAGNY LA CAMPAGNE',NULL,NULL,'',117.000000000,'2010-07-08','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (47,'BECQUET','MONIQUE',NULL,'02.28.55.51.47','06.55.10.80.34',NULL,'33 chemin de l''arguilly','','','14320','ST MARTIN DE FONTENAY',NULL,NULL,'',15.000000000,'2008-06-17','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (48,'BOUSQUET','GILLES',NULL,'02.52.85.48.57','06.23.78.17.09',NULL,'11 RUE DE LA PAIX','','','14170','ST PIERRE SUR DIVES',NULL,NULL,'',160.000000000,'2012-01-01','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (49,'MADELAINE','JEAN',NULL,'02.78.31.38.77','06.94.94.40.59',NULL,'27 RUE DE LA CHENEVOTTE','','','14000','CAEN',NULL,NULL,'',675.000000000,'2008-02-07','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (50,'ANNE','JEAN',NULL,'02.20.85.82.74',NULL,NULL,'1 PLACE DES NOYERS','','','14000','CAEN',NULL,NULL,'',357.000000000,'2010-08-16','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (51,'DUCLOS','Michel',NULL,'02.78.32.00.09','06.33.35.13.70',NULL,'','','','14000','CAEN',NULL,NULL,'',914.000000000,'2011-08-03','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (52,'DURAND','GINETTE',NULL,'02.19.67.90.57','06.89.78.01.68',NULL,'','','','14540','SOLIERS',NULL,NULL,'',179.000000000,'2009-05-27','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (53,'GRANDMOUGIN','PATRICK',NULL,'02.19.64.71.85','06.11.46.76.99',NULL,'11 rue felici charles','','','14120','MONDEVILLE',NULL,NULL,'',9.000000000,'2008-10-31','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (54,'GUERIN','ROLAND FELIX MA',NULL,'02.65.15.82.29','06.54.67.34.13',NULL,'19 rue des genevriers','','','14000','CAEN',NULL,NULL,'',2.000000000,'2011-10-31','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (55,'LAURENT','ODETTE',NULL,'02.90.60.38.62','06.11.78.64.90',NULL,'16 RUE EMILE ZOLA','','','14000','CAEN',NULL,NULL,'',877.000000000,'2009-05-07','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (56,'GOUMAULT','JEANNINE',NULL,'02.88.27.03.63','06.69.35.95.66',NULL,'5 rue de sully','','','14780','LION SUR MER',NULL,NULL,'',320.000000000,'2010-12-03','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (57,'PEPIN','PATRICE',NULL,'02.58.20.01.85','06.52.72.03.96',NULL,'','','','14123','CORMELLES LE ROYAL',NULL,NULL,'',355.000000000,'2013-08-13','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (58,'MAIZERAY','HENRI',NULL,'02.64.46.87.71','06.19.34.39.45',NULL,'8 impasse reine matilde','','','14120','MONDEVILLE',NULL,NULL,'',3624.000000000,'2008-02-28','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (59,'HEUGUET','MAURICETTE',NULL,'02.90.61.48.52','06.20.18.05.29',NULL,'','','','61320','LALACELLE',NULL,NULL,'',16.000000000,'2013-03-09','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (60,'COSTALONGA','CECILE',NULL,'02.86.19.51.42','06.80.51.82.40',NULL,'4 RUE GUILBERT','','','14123','IFS',NULL,NULL,'',243.000000000,'2011-06-24','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (61,'COSTALONGA','JEAN',NULL,'02.92.26.34.96','06.57.76.17.69',NULL,'4 RUE DE VERDUN','','','14930','ETERVILLE',NULL,NULL,'',24.000000000,'2013-01-21','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (62,'THOMAS','LAURENCE',NULL,'02.18.82.63.13','06.69.53.66.32',NULL,'','','','14680','BRETTEVILLE SUR LAIZE',NULL,NULL,'',67.000000000,'2012-10-28','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (63,'DREYFUS','GEORGES',NULL,'02.90.70.34.20','06.38.20.14.87',NULL,'','','','14320','MAY SUR ORNE',NULL,NULL,'',445.000000000,'2011-12-28','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (64,'JOYAUX','NICOLE',NULL,'02.89.69.30.20','06.14.51.96.31',NULL,'','','','14000','CAEN',NULL,NULL,'',43.000000000,'2007-11-27','PREMIUM',10,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (65,'MARIE','BERNARD',NULL,'02.80.07.31.20','06.58.13.44.94',NULL,'2 rue edouard manet','','','14000','CAEN',NULL,NULL,'',107.000000000,'2012-01-31','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (66,'BUNEL','FRANCOISE',NULL,'02.68.48.00.28','06.81.94.49.97',NULL,'HAMEAU DE BELLEFONTAINE','','','61800','ST CORNIER DES LANDES',NULL,NULL,'',171.000000000,'2009-11-10','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (67,'BRILLANT','PATRICIA',NULL,'02.29.32.79.81','06.34.47.56.59',NULL,'3 RUE SOULIER','','','50300','ST OVIN',NULL,NULL,'',22.000000000,'2010-07-11','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (68,'KOPYLA','PAULETTE',NULL,'02.42.37.90.32','06.28.77.19.63',NULL,'304 Haute Folie','','','14320','ST ANDRE SUR ORNE',NULL,NULL,'',267.000000000,'2012-10-01','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (69,'AVRIL','GISELE',NULL,'02.73.49.63.36','06.17.85.67.69',NULL,'34 Rue Gaston Manneville','','','14610','VILLONS LES BUISSONS',NULL,NULL,'',1547.000000000,'2008-01-21','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (70,'FOUBERT','LOUIS','1962-05-28','02.28.19.69.67','06.29.09.49.71',NULL,'','','','14270','MEZIDON CANON',NULL,NULL,'16205610010',844.000000000,'1986-12-26','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (71,'HAVIN','GERARD','1982-01-22','02.84.01.98.74',NULL,NULL,'','','','50880','PONT HEBERT',NULL,NULL,'282017142200',31.000000000,'2003-04-21','PREMIUM',11,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (72,'VIRGEL','ROGER','1981-05-01','02.70.86.70.44','06.60.89.91.47',NULL,'52 avenue Bayview Pointe-Claire','Qubec','','14260','BREMOY',NULL,NULL,'1810599000000',208.000000000,'2005-10-02','PREMIUM',10,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (73,'LAUSSINE','DANIEL','1984-07-29','02.63.60.63.01','06.60.69.28.06',NULL,'11 rue guillaume trebutien','','','14540','BOURGUEBUS',NULL,NULL,'1840714118000',8.000000000,'2012-12-12','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (74,'POULIQUEN','GILBERT','1987-09-04','02.47.12.38.63','06.71.63.40.34',NULL,'','','','14370','BELLENGREVILLE',NULL,NULL,'1870961214000',25.000000000,'2012-12-12','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (75,'BASLEY','NATHALIE','1965-09-02','02.31.11.44.38','06.46.30.49.60',NULL,'','','','14000','CAEN',NULL,NULL,'2650914075001',177.000000000,'1995-12-04','PREMIUM',12,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (76,'CASTEL','GEORGETTE','1940-06-10','02.39.24.34.63','06.64.04.25.20',NULL,'17 rue de la liberation','','','14000','CAEN',NULL,NULL,'1400651285001',2460.000000000,'1966-12-14','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (77,'PASQUET','MAURICETTE','1929-11-22','02.64.46.79.12','00 33 6.86.51.94.70',NULL,'Route de St Sylvain','','','14760','BRETTEVILLE SUR ODON',NULL,NULL,'2291178038001',410.000000000,'1950-06-29','PREMIUM',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (78,'TSIKLAURI','PAULETTE','1936-03-19','02.96.75.23.93','06.60.67.08.81',NULL,'','','','50160','ST AMAND',NULL,NULL,'1360314530001',106.000000000,'1957-07-09','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (79,'JEANNE','MARTINE','1946-10-29','02.40.57.43.16','06.27.71.47.42',NULL,'BELLOU','','','14000','CAEN',NULL,NULL,'1461014149001',19.000000000,'1974-09-17','GOLD',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (80,'CHAUVIN','ANDRE','1937-07-01','02.10.94.93.78','06.77.88.20.46',NULL,'','','','14190','MAIZIERES',NULL,NULL,'1370714266001',190.000000000,'1958-07-09','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (81,'PILLIER','MICHELINE','1932-10-25','02.33.02.83.91','06.12.23.70.70',NULL,'33 bvd general vannier','','','14000','CAEN',NULL,NULL,'1321014013001',91.000000000,'1962-06-13','GOLD',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (82,'PITANCE','BERNARD','1931-08-27','02.58.34.97.40','06.85.91.09.34',NULL,'','','','14000','CAEN',NULL,NULL,'1310814762001',8.000000000,'1952-06-25','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (83,'DODEMAN','JEAN CLAUDE','1939-06-26','02.10.40.75.49','06.48.38.36.81',NULL,'67 rue de bayeux','','','27210','FATOUVILLE GRESTAIN',NULL,NULL,'2390627422001',27.000000000,'1962-05-16','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (84,'JULIEN','CLAUDE','1967-02-05','02.12.04.70.63','06.49.13.26.79',NULL,'INSTITUT MEDICO PROFESSIONNEL','','','14610','EPRON',NULL,NULL,'1670214137001',131.000000000,'1994-02-26','PREMIUM',12,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (85,'CHARBONNIER','CHARLES','1934-02-14','02.36.00.59.41','06.15.37.06.07',NULL,'','','','14840','DEMOUVILLE',NULL,NULL,'1340214392001',1533.000000000,'1955-02-05','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (86,'SIMON','MADELEINE','1939-09-17','02.11.12.57.10','06.49.46.69.50',NULL,'','','','14000','CAEN',NULL,NULL,'2390914657001',69.000000000,'1960-04-16','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (87,'NORMAND','DENIS','1928-12-14','02.10.98.17.44','06.88.08.47.03',NULL,'7 chemin des bruyres','','','14000','CAEN',NULL,NULL,'1281214572001',669.000000000,'1950-02-25','PREMIUM',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (88,'MILOUX','CHRISTIAN',NULL,'02.14.23.99.69','06.71.90.91.73',NULL,'3 ROUTE D ARGENCE','','','14320','ST ANDRE SUR ORNE',NULL,NULL,'1320214039001',648.000000000,'2008-03-29','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (89,'DUMONT','MARIE MADELEINE','1962-01-17','02.79.85.89.47','06.75.18.59.93',NULL,'hameaux de cavigny','','','14340','CAMBREMER',NULL,NULL,'2620114581001',40.000000000,'1983-11-29','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (90,'COURTIN','THERESE','1939-10-22','02.11.64.20.60','06.78.72.50.54',NULL,'la cour d''enfer','','','14000','CAEN',NULL,NULL,'1391078158001',130.000000000,'1963-08-07','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (91,'JOUAULT','PIERRE','1943-07-01','02.24.68.98.31','06.76.49.54.30',NULL,'','','','14123','CORMELLES LE ROYAL',NULL,NULL,'1430750246001',89.000000000,'1968-07-13','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (92,'REQUIS','HERVE',NULL,'02.10.86.75.53','06.24.64.50.88',NULL,'','','','14220','DONNAY',NULL,NULL,'',1472.000000000,'2012-03-31','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (93,'LEMASSON','MADELEINE',NULL,'02.79.03.44.41','06.35.78.47.68',NULL,'','','','14760','BRETTEVILLE SUR ODON',NULL,NULL,'',121.000000000,'2010-04-10','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (94,'BISSON','LEA',NULL,'02.72.18.30.26','06.10.69.86.84',NULL,'','','','14000','CAEN',NULL,NULL,'',57.000000000,'2007-12-12','PREMIUM',10,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (95,'PERROTTE','JEAN CLAUDE',NULL,'02.74.04.14.37',NULL,NULL,'95 BVD LEROY','','','14120','MONDEVILLE',NULL,NULL,'',800.000000000,'2013-07-09','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (96,'MELET','JEANNINE',NULL,'02.29.24.94.56','06.58.74.21.00',NULL,'33 RUE GAMBETTA','','','14000','CAEN',NULL,NULL,'',104.000000000,'2011-10-27','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (97,'FLEURY','RAYMOND',NULL,'02.40.64.43.40','06.45.77.27.88',NULL,'3 RUE SOULLIERS','','','14350','LE TOURNEUR',NULL,NULL,'',17.000000000,'2012-05-31','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (98,'COLOMBERT','ELIANE',NULL,'02.85.69.65.31','06.34.74.49.77',NULL,'','','','14000','CAEN',NULL,NULL,'',36.000000000,'2009-08-04','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (99,'MAECKE','CLAUDE',NULL,'02.99.74.18.63',NULL,NULL,'71 route d harcout','','','14540','SOLIERS',NULL,NULL,'',698.000000000,'2011-12-19','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (100,'ROULLIER','ELISABETH',NULL,'02.61.96.13.00','06.55.77.88.34',NULL,'','','','14840','DEMOUVILLE',NULL,NULL,'',349.000000000,'2013-08-30','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (101,'AMICHOT','DANIEL',NULL,'02.44.37.71.90','06.51.51.13.86',NULL,'le calvaire','','','14123','FLEURY SUR ORNE',NULL,NULL,'',6.000000000,'2008-03-24','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (102,'LEFAVRAIS','JACQUELINE',NULL,'02.75.66.59.35','06.66.70.92.55',NULL,'141 rue de falaise','','','14420','POTIGNY',NULL,NULL,'',884.000000000,'2013-01-10','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (103,'BELLAIR','EDITH',NULL,'02.38.01.40.33','06.35.24.06.16',NULL,'4 rue glenn miler','','','14320','MAY SUR ORNE',NULL,NULL,'',30.000000000,'2012-10-05','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (104,'FONNARD','GILLES',NULL,'02.83.36.03.11','06.23.74.07.52',NULL,'1 place de la liberte','','','50460','QUERQUEVILLE',NULL,NULL,'',692.000000000,'2010-12-14','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (105,'BOURDON','NADEGE',NULL,'02.87.46.95.33','06.46.06.93.80',NULL,'26 rue de l ancienne gare','','','27750','LA COUTURE BOUSSEY',NULL,NULL,'',747.000000000,'2012-09-15','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (106,'HAMEL','SUZANNE',NULL,'02.16.62.74.27',NULL,NULL,'','','','14000','CAEN',NULL,NULL,'',27.000000000,'2013-08-18','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (107,'MONFORT','Michel',NULL,'02.16.94.17.64','06.25.96.20.30',NULL,'4 RUE J JACQUES ROUSSEAU','','','14123','IFS',NULL,NULL,'',32.000000000,'2011-12-03','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (108,'VILLEROY','GEORGETTE',NULL,'02.62.81.33.66','06.11.38.06.89',NULL,'5 allee de dieldt','','','50580','DENNEVILLE',NULL,NULL,'',87.000000000,'2009-12-09','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (109,'COLLET','PATRICE',NULL,'02.55.88.15.45','06.20.90.80.55',NULL,'','','','14123','IFS',NULL,NULL,'',18.000000000,'2008-05-13','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (110,'JAMARD','Pierre',NULL,'02.81.57.51.54','06.18.72.18.77',NULL,'','','','61250','COLOMBIERS',NULL,NULL,'',508.000000000,'2013-09-23','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (111,'PHILIPPE','JACQUES',NULL,'02.70.66.02.48','06.11.15.02.59',NULL,'101 rue du chemin vert','','','14190','FIERVILLE BRAY',NULL,NULL,'',87.000000000,'2009-02-22','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (112,'LOREL','BERNARD',NULL,'02.12.10.61.04','06.26.94.74.42',NULL,'101 rue du chemin vert','','','14000','CAEN',NULL,NULL,'',159.000000000,'2009-02-26','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (113,'LAUNAY','MARIUS',NULL,'02.62.78.37.99','06.97.26.76.89',NULL,'24 rue des grands lacs','','','14120','MONDEVILLE',NULL,NULL,'',17.000000000,'2012-09-02','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (114,'HERVIEU','ROGER JACQUES',NULL,'02.10.26.05.31','06.11.67.98.48',NULL,'','','','14123','CORMELLES LE ROYAL',NULL,NULL,'',929.000000000,'2010-11-07','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (115,'MARGUERIE','DANIEL',NULL,'02.79.99.39.38','06.14.39.96.68',NULL,'19 RUE LE PETIT VICEL','','','61160','TRUN',NULL,NULL,'',4105.000000000,'2013-05-26','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (116,'D ANDREA','COLETTE',NULL,'02.80.78.98.60','06.22.37.51.61',NULL,'15 rue de la olaine','','','14190','FIERVILLE BRAY',NULL,NULL,'',4095.000000000,'2010-04-23','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (117,'CERE','JANINE',NULL,'02.38.80.51.10','06.32.94.76.90',NULL,'','','','14690','PONT D''OUILLY',NULL,NULL,'',438.000000000,'2012-01-13','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (118,'CAIRON','JEAN',NULL,'02.11.24.82.70','06.64.52.35.81',NULL,'','','','14540','GARCELLES SECQUEVILLE',NULL,NULL,'',106.000000000,'2013-07-10','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (119,'LAVILLE','GUY',NULL,'02.35.82.95.94','06.70.95.78.28',NULL,'','','','14320','ST MARTIN DE FONTENAY',NULL,NULL,'',1164.000000000,'2009-10-15','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (120,'ROLLAND','PAUL',NULL,'02.69.21.60.23','06.15.47.29.29',NULL,'','','','14120','MONDEVILLE',NULL,NULL,'',150.000000000,'2010-06-30','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (121,'BUISARD','THERESE',NULL,'02.54.93.19.04','06.58.94.35.54',NULL,'10 IMP MARECHAL COURONNE','','','14700','FALAISE',NULL,NULL,'',36.000000000,'2013-06-26','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (122,'HENRY','CLAUDE',NULL,'02.45.41.58.03','06.11.69.32.56',NULL,'ferme de la mare / cour ste cath','erine de sienne','','14000','CAEN',NULL,NULL,'',57.000000000,'2013-09-05','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (123,'JALET','Solange',NULL,'02.11.48.52.16','06.41.85.35.53',NULL,'','','','14200','HEROUVILLE ST CLAIR',NULL,NULL,'',42.000000000,'2009-12-14','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (124,'MARIE','roger',NULL,'02.88.44.18.28','06.15.57.98.04',NULL,'15 RUE ST GABRIEL','','','14540','ST AIGNAN DE CRAMESNIL',NULL,NULL,'',59.000000000,'2009-09-06','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (125,'JEAN','JULES',NULL,'02.47.76.62.39','06.71.81.08.97',NULL,'10 RUE DU 11 NOVEMBRE','','','14860','RANVILLE',NULL,NULL,'',420.000000000,'2010-04-28','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (126,'GUERARD','HENRI',NULL,'02.48.41.20.43','06.90.04.55.47',NULL,'1 rue des sirets','','','14000','CAEN',NULL,NULL,'',106.000000000,'2011-01-27','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (127,'CAPELLO','ROBERT','1937-11-28','02.78.28.09.48','06.80.67.95.84',NULL,'14 ALLEE DU LOSION','','','14730','GIBERVILLE',NULL,NULL,'2371114015001',30.000000000,'1963-10-22','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (128,'BONNIVARD','SIMONE','1964-10-28','02.60.09.72.26','06.90.68.29.16',NULL,'','','','14840','DEMOUVILLE',NULL,NULL,'1641050129001',35.000000000,'1987-06-23','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (129,'MARHIC','LOUIS','1932-12-07','02.37.35.48.97','06.21.54.52.91',NULL,'','','','14123','IFS',NULL,NULL,'1321214290001',205.000000000,'1954-07-22','PREMIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (130,'LASTELLE','DENISE','1935-07-29','02.48.86.92.91','06.70.51.03.80',NULL,'','','','14000','CAEN',NULL,NULL,'1350714005001',525.000000000,'1956-09-05','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (131,'MURIEL','FRANCOISE','1930-01-11','02.49.73.61.65','06.13.18.94.37',NULL,'','','','14800','DEAUVILLE',NULL,NULL,'1300161222001',39.000000000,'1952-02-25','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (132,'JOUVIN','PIERRE','1934-08-09','02.60.76.60.31','06.37.32.39.50',NULL,'','','','14400','BAYEUX',NULL,NULL,'1340814700001',651.000000000,'1958-12-22','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (133,'PERRIER','GEORGES','1937-08-15','02.38.68.77.65','06.67.96.26.19',NULL,'','','','14940','SANNERVILLE',NULL,NULL,'1370814192001',3032.000000000,'1961-04-11','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (134,'LEVERRIER','DANIELE','1956-04-16','02.11.61.29.43','06.10.94.72.81',NULL,'16 RUE DE MORTAIN','','','14200','HEROUVILLE ST CLAIR',NULL,NULL,'2560414640001',92.000000000,'1985-05-22','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (135,'LEDRU','JEAN','1937-02-05','02.81.51.05.83','06.31.83.52.93',NULL,'','','','14000','CAEN',NULL,NULL,'1370261344001',230.000000000,'1964-01-19','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (136,'SCELLES','COLETTE','1936-06-17','02.76.02.18.90','06.12.29.66.46',NULL,'','','','14670','TROARN',NULL,NULL,'2360614672001',747.000000000,'1958-02-23','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (137,'PERAUD','PIERRE','1965-04-14','02.33.35.41.28','06.48.20.73.35',NULL,'','','',NULL,NULL,NULL,NULL,'2650414651001',29.000000000,'1994-02-24','PREMIUM',12,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (138,'SPRENGER','LEON','1936-01-30','02.56.47.49.58','06.91.97.79.87',NULL,'','','','14123','FLEURY SUR ORNE',NULL,NULL,'1360155500001',2825.000000000,'1958-02-27','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (139,'BLACHET','YVETTE',NULL,'02.79.37.65.64','06.31.10.75.41',NULL,'1 rue des sirets','','','14370','BILLY',NULL,NULL,'',19.000000000,'2008-03-08','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (140,'BENARD','JEANNINE',NULL,'02.78.02.31.14','06.11.41.27.88',NULL,'','','','14350','LE DESERT',NULL,NULL,'',222.000000000,'2012-12-13','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (141,'BUSNEL','DANIELLE',NULL,'02.40.52.25.06','06.73.68.94.58',NULL,'10023 RES LES BOIS DU TEMPLE','','','14200','HEROUVILLE ST CLAIR',NULL,NULL,'',25.000000000,'2008-04-16','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (142,'BARTI','GERMAINE',NULL,'02.69.22.76.00','06.58.20.07.30',NULL,'14 rue ed herioz','','','14123','CORMELLES LE ROYAL',NULL,NULL,'',106.000000000,'2012-10-10','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (143,'CATHERINE','SUZANNE',NULL,'02.80.79.30.19','06.19.06.19.70',NULL,'','','','14120','MONDEVILLE',NULL,NULL,'',1111.000000000,'2009-09-26','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (144,'DUFAY','VERONIQUE',NULL,'02.26.06.99.56','06.66.82.47.83',NULL,'','','','14200','HEROUVILLE ST CLAIR',NULL,NULL,'',187.000000000,'2011-11-05','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (145,'WISS','JEAN CLAUDE',NULL,NULL,NULL,NULL,'2 rue de l''egalite','','','14970','BENOUVILLE',NULL,NULL,'',5327.000000000,'2012-01-28','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (146,'LAMOTTE','DIDIER',NULL,'02.40.44.85.59','06.40.37.61.07',NULL,'','','','14210','GIBERVILLE',NULL,NULL,'',66.000000000,'2009-06-05','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (147,'BRILLAUD','ANDRE',NULL,'02.42.51.15.42','06.26.21.04.66',NULL,'','','','14000','CAEN',NULL,NULL,'',10.000000000,'2013-04-05','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (148,'PANIZZON','PIERRE',NULL,'02.26.60.93.11','06.35.02.12.35',NULL,'3 allee j cartier','','','14123','IFS',NULL,NULL,'',6.000000000,'2009-09-23','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (149,'TERRY','Remi',NULL,'02.52.94.11.67','06.61.02.38.17',NULL,'13 rue des bergeronettes','','','14730','GIBERVILLE',NULL,NULL,'',1.000000000,'2008-10-19','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (150,'ADAM','PIERRE',NULL,'02.25.86.10.52','06.62.49.31.52',NULL,'','','','14270','OUEZY',NULL,NULL,'',109.000000000,'2009-12-05','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (151,'GALLOT','LUCIENNE',NULL,'02.59.98.79.90','06.11.01.75.90',NULL,'35 allee du coti','','','14000','CAEN',NULL,NULL,'',39.000000000,'2009-09-04','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (152,'LEMAROIS','JACQUES',NULL,'02.20.72.18.62','06.91.72.00.53',NULL,'','','','14630','CAGNY',NULL,NULL,'',957.000000000,'2009-03-10','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (153,'LECOEUR','PAULETTE',NULL,'02.22.90.45.67','06.32.94.56.09',NULL,'','','','14000','CAEN',NULL,NULL,'',1713.000000000,'2012-11-19','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (154,'JEHANNE','JANINE',NULL,'02.51.82.53.08','06.68.47.19.52',NULL,'','','','14670','TROARN',NULL,NULL,'',497.000000000,'2012-09-08','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (155,'ALBA','STEPHANE',NULL,'02.24.31.70.60','06.78.25.59.22',NULL,'','','','14330','LE MOLAY LITTRY',NULL,NULL,'',346.000000000,'2011-11-21','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (156,'LECOQ','PASCAL',NULL,'02.57.56.70.57','06.61.99.42.05',NULL,'','','','14320','ST ANDRE SUR ORNE',NULL,NULL,'',282.000000000,'2009-03-21','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (157,'DESOUBEAUX','ROBERT',NULL,'02.21.71.01.46','06.78.79.11.63',NULL,'','','','14120','MONDEVILLE',NULL,NULL,'',26.000000000,'2011-08-19','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (158,'FOULIARD','COLETTE',NULL,'02.54.06.68.91','06.83.24.99.76',NULL,'','','','61200','FONTENAI SUR ORNE',NULL,NULL,'',84.000000000,'2011-05-21','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (159,'ANGEL DIT HUGO','HELENE',NULL,'02.23.19.86.12','06.84.33.38.99',NULL,'','','','14000','CAEN',NULL,NULL,'',62.000000000,'2011-07-30','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (160,'DELAUNAY','GENEVIEVE',NULL,'02.60.48.66.98','06.10.64.35.99',NULL,'','','','14390','CABOURG',NULL,NULL,'',387.000000000,'2012-09-22','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (161,'EURY','NADINE',NULL,'02.49.75.19.81','06.25.76.08.10',NULL,'route de falaise','','','50750','STE SUZANNE SUR VIRE',NULL,NULL,'',1044.000000000,'2009-10-26','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (162,'DODEMAN','MARIE MADELEINE',NULL,'02.74.33.06.25',NULL,NULL,'2 impasse des charmes','','','14000','CAEN',NULL,NULL,'',168.000000000,'2009-05-30','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (163,'ISIDOR','FRANCOISE',NULL,'02.93.55.99.57','06.80.91.02.18',NULL,'29 rue robert bothereau','','','14190','ST GERMAIN LE VASSON',NULL,NULL,'',30.000000000,'2011-05-02','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (164,'AUGUET','BEATRICE',NULL,'02.13.82.63.48','06.53.27.83.59',NULL,'1801 quaretier du bois','','','14200','HEROUVILLE ST CLAIR',NULL,NULL,'',59.000000000,'2010-09-03','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (165,'DESMYTER','Micheline',NULL,'02.45.23.34.06','06.81.40.18.65',NULL,'14 rue de la marne','','','14280','ST GERMAIN LA BLANCHE HERBE',NULL,NULL,'',847.000000000,'2013-01-26','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (166,'MOUVILLE','HUGUETTE',NULL,'02.50.10.78.22','06.54.51.28.38',NULL,'','','','14000','CAEN',NULL,NULL,'',94.000000000,'2009-03-16','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (167,'MARIE','MARTINE',NULL,'02.11.69.30.43','06.19.92.95.30',NULL,'','','','14200','HEROUVILLE ST CLAIR',NULL,NULL,'',32.000000000,'2008-06-10','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (168,'PIETRALUNGA','ANNIE',NULL,'02.45.84.22.97','06.85.33.44.42',NULL,'','','','14120','MONDEVILLE',NULL,NULL,'',830.000000000,'2011-10-18','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (169,'LEBRUN','LUC',NULL,'02.41.47.51.88','06.11.50.51.32',NULL,'','','','14123','CORMELLES LE ROYAL',NULL,NULL,'',631.000000000,'2011-11-02','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (170,'HENRI','BERNADETTE',NULL,'02.27.94.32.44','06.82.37.29.12',NULL,'','','','14610','VILLONS LES BUISSONS',NULL,NULL,'',418.000000000,'2010-01-29','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (171,'QUONIAM','jean luc',NULL,'02.30.19.75.33','06.72.44.28.20',NULL,'','','',NULL,NULL,NULL,NULL,'',941.000000000,'2012-03-27','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (172,'LESIMPLE','MICHEL',NULL,'02.11.33.22.45','06.73.39.82.57',NULL,'','','','14650','CARPIQUET',NULL,NULL,'',54.000000000,'2008-02-17','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (173,'FEREY','ALAIN','1954-04-14','02.61.01.35.04','06.75.13.42.70',NULL,'5 RUE JULES FERRY','','','14190','ST GERMAIN LE VASSON',NULL,NULL,'2540450614001',18.000000000,'1978-04-22','PREMIUM',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (174,'FRANDEMICHE','SERGE','1933-10-02','02.10.48.44.34','06.80.96.01.47',NULL,'11 allee j racine','','','14000','CAEN',NULL,NULL,'1331014277001',2161.000000000,'1956-04-13','PREMIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (175,'DERIEN','J FRANCOI','1937-10-07','02.80.56.17.07','06.11.52.01.69',NULL,'','','','14000','CAEN',NULL,NULL,'2371014670001',441.000000000,'1959-05-06','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (176,'BLANCHARD','RAYMOND','1937-10-12','02.28.50.40.40','06.17.77.85.82',NULL,'38 rue des ecuyers','','','14120','MONDEVILLE',NULL,NULL,'1371014733001',909.000000000,'1967-05-15','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (177,'LEPY','XAVIER','1955-01-03','02.69.12.90.58','06.38.84.64.08',NULL,'','','','14240','CAHAGNES',NULL,NULL,'1550135355001',148.000000000,'1985-08-15','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (178,'','COLETTE','1962-05-19','02.19.59.19.00','06.50.66.79.56',NULL,'','','','14150','OUISTREHAM',NULL,NULL,'2620514170001',38.000000000,'1984-07-12','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (179,'','','1939-11-13','02.10.39.70.16','06.38.18.42.39',NULL,'','','','14123','CORMELLES LE ROYAL',NULL,NULL,'1391114066001',38.000000000,'1968-11-26','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (180,'MARTY','DANIEL','1928-09-17','02.76.38.10.37','06.29.77.33.51',NULL,'10 rue louis pasteur','','','14680','BRETTEVILLE SUR LAIZE',NULL,NULL,'1280935072001',341.000000000,'1952-05-28','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (181,'VIVIER','nathalie','1934-01-31','02.72.69.80.22','06.90.24.23.78',NULL,'','','','50100','CHERBOURG',NULL,NULL,'2340114595001',40.000000000,'1958-04-17','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (182,'PICARD','MICHEL','1943-05-14','02.94.21.34.50','06.51.88.08.49',NULL,'','','','50450','GAVRAY',NULL,NULL,'1430578158001',671.000000000,'1965-03-11','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (183,'AUMONT','AUGUSTE','1963-02-27','02.79.10.44.78','06.79.50.58.47',NULL,'21 RUE DES MIMOSAS','','','14123','IFS',NULL,NULL,'3630282121001',54.000000000,'1985-12-21','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (184,'HUE','Christelle','1937-12-30','02.63.67.49.95','06.50.15.31.16',NULL,'32 RUE EUGENE MAES','','','14123','FLEURY SUR ORNE',NULL,NULL,'1371214506001',2155.000000000,'1964-01-27','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (185,'LEHAIN','Lionel','1940-03-15','02.11.34.94.11','06.25.07.79.70',NULL,'RTE DE TESSY','','','14370','CHICHEBOVILLE',NULL,NULL,'1400361377001',238.000000000,'1969-04-18','SILVER',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (186,'LE MARQUIS','CHARLES','1964-05-25','02.14.83.33.26','06.38.12.26.58',NULL,'','','','14680','BRETTEVILLE SUR LAIZE',NULL,NULL,'1640514118001',167.000000000,'1994-04-02','PREMIUM',12,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (187,'SZYMANSKI','MARGUERITE','1934-01-31','02.43.66.36.91','06.39.15.63.24',NULL,'74 quai vendeuvre','','','14780','LION SUR MER',NULL,NULL,'2340127164001',265.000000000,'1963-03-13','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (188,'LEGRAND','MARC','1931-05-02','02.15.53.94.14','06.87.02.84.19',NULL,'','','','14200','HEROUVILLE ST CLAIR',NULL,NULL,'1310514026001',87.000000000,'1954-01-09','PLATINIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (189,'RIBET','DANIEL',NULL,'02.37.08.07.34','06.65.77.65.17',NULL,'','','','14123','CORMELLES LE ROYAL',NULL,NULL,'2650750262001',650.000000000,'2010-10-20','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (190,'DUBOSQ','CYRILLE','1929-10-03','02.19.05.46.08','06.23.49.42.40',NULL,'120 rue emile zola 120 rue em','ile zola','','14950','ST PIERRE AZIF',NULL,NULL,'1291050498001',699.000000000,'1954-05-01','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (191,'HAVARD','herve','1935-01-16','02.18.96.74.85',NULL,NULL,'5 RUE DE LA HAIE VIGNE','','','14120','GIBERVILLE',NULL,NULL,'1350127036001',14.000000000,'1956-10-30','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (192,'PRECOURT','ROBERT','1933-02-01','02.17.80.85.90','06.35.73.51.77',NULL,'','','','14000','CAEN',NULL,NULL,'2330214688001',87.000000000,'1957-12-06','PREMIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (193,'CATHERINE','JEAN','1930-05-25','02.52.49.71.78','06.34.15.60.84',NULL,'','','','14630','CAGNY',NULL,NULL,'1300514037001',9.000000000,'1953-11-29','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (194,'SABINE','JEAN PIERRE','1965-11-20','02.26.84.34.73','06.11.69.22.01',NULL,'','','','14370','CLEVILLE',NULL,NULL,'2651114455001',54.000000000,'1995-10-25','PREMIUM',12,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (195,'ROSSIGNOL','GUY','1948-02-20','02.15.67.13.18','06.27.96.87.90',NULL,'','','','14370','ARGENCES',NULL,NULL,'1480214547001',1151.000000000,'1972-09-02','GOLD',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (196,'PONTES','BERNARD','1939-11-18','02.11.20.91.73','06.29.81.30.49',NULL,'','','','14370','ARGENCES',NULL,NULL,'2391161038001',659.000000000,'1968-11-07','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (197,'LEROY','GERARD',NULL,'02.95.51.76.84','06.51.17.25.69',NULL,'','','','14390','CABOURG',NULL,NULL,'2390114368001',24.000000000,'2011-11-30','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (198,'LUCAS','BERNARD','1929-05-26','02.32.45.09.54','06.11.47.63.97',NULL,'','','','14320','FEUGUEROLLES BULLY',NULL,NULL,'2290576594001',631.000000000,'1957-06-27','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (199,'LELIEVRE','JOSEPH','1984-07-11','02.47.97.62.95','06.12.33.47.51',NULL,'','','','14430','ANNEBAULT',NULL,NULL,'2840714039001',20.000000000,'2009-03-12','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (200,'POULLAIN','ROBERT','1928-03-07','02.32.17.82.59','06.82.06.63.89',NULL,'','','','14370','BELLENGREVILLE',NULL,NULL,'2280327021001',61.000000000,'1956-11-29','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (201,'DUVAL','VALERIE','1962-12-09','02.52.72.14.27','06.52.90.47.78',NULL,'','','','14700','ST PIERRE DU BU',NULL,NULL,'1621299122001',12.000000000,'1991-11-17','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (202,'PATELLI','CHRISTIANE','1937-12-11','02.34.53.83.31','06.65.94.41.56',NULL,'','','','14000','CAEN',NULL,NULL,'2371214485001',10.000000000,'1966-07-15','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (203,'ESNEYS','GENEVIEVE','1932-03-08','02.43.85.81.39','06.36.90.49.91',NULL,'','','','14730','GIBERVILLE',NULL,NULL,'1320314643001',2686.000000000,'1953-09-02','PREMIUM',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (204,'GUYONNET','HELENE','1945-02-12','02.69.26.16.47','06.94.72.22.67',NULL,'','','','14840','DEMOUVILLE',NULL,NULL,'2450214290001',137.000000000,'1973-05-14','GOLD',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (205,'LEPLANQUOIS','GENEVIEVE','1935-03-12','02.46.12.83.88','06.42.04.63.23',NULL,'','','','14250','FONTENAY LE PESNEL',NULL,NULL,'1350314629001',15.000000000,'1959-03-31','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (206,'LEROUGE','auguste','1940-04-16','02.80.03.25.59','06.28.76.93.76',NULL,'14 rue de la marne','','','76600','LE HAVRE',NULL,NULL,'1400461385001',38.000000000,'1964-08-04','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (207,'BURIN','GEORGES','1942-04-21','02.19.56.87.29','06.50.42.40.03',NULL,'8 rue marivaux','','','14000','CAEN',NULL,NULL,'1420478239001',3000.000000000,'1966-12-19','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (208,'AUGER','JULIEN','1941-01-24','02.12.23.37.02','06.35.06.31.10',NULL,'','','','14680','FRESNEY LE PUCEUX',NULL,NULL,'2410114050001',1015.000000000,'1962-04-10','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (209,'BOUET','alain','1966-07-20','02.27.88.20.36','06.39.78.36.65',NULL,'','','','14210','STE HONORINE DU FAY',NULL,NULL,'2660714034001',1431.000000000,'1991-09-14','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (210,'METAYER','MARIE LOUISE','1969-07-29','02.99.29.74.84',NULL,NULL,'','','',NULL,NULL,NULL,NULL,'1690759183001',8.000000000,'1995-07-04','PREMIUM',12,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (211,'MELINOU','JEAN','1959-12-28','02.11.47.01.19','06.37.98.82.01',NULL,'','','',NULL,NULL,NULL,NULL,'1591214344001',36.000000000,'1980-01-25','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (212,'SOUCY','ELISABETH','1934-07-09','02.30.94.05.95','06.13.08.14.43',NULL,'5 rue du temps perdu','','',NULL,NULL,NULL,NULL,'1340714538001',55.000000000,'1963-09-29','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (213,'SOCROUN','YVETTE','1934-08-28','02.47.35.84.74',NULL,NULL,'89 rue j chagford','','',NULL,NULL,NULL,NULL,'2340814354001',162.000000000,'1960-11-18','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (214,'ALEXANDRE','marcel','1977-08-10','02.12.94.07.53','06.87.56.68.58',NULL,'','','',NULL,NULL,NULL,NULL,'2770899322001',37.000000000,'1999-02-09','PREMIUM',11,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (215,'LOUVEL','PIERRETTE','1929-01-29','02.73.76.49.19','06.14.35.50.80',NULL,'','','',NULL,NULL,NULL,NULL,'2290114659001',334.000000000,'1958-05-16','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (216,'CATILLON','JEANNINE','1958-01-18','02.57.18.47.78','06.22.73.45.87',NULL,'','','','14123','IFS',NULL,NULL,'2580114092001',70.000000000,'1988-05-27','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (217,'FONTAINE','ERIC','1935-12-18','02.21.29.88.27','06.71.89.45.42',NULL,'','','','14630','CAGNY',NULL,NULL,'2351214145001',798.000000000,'1958-07-11','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (218,'CARBONNE','THERESE','1945-01-04','02.32.29.25.34','06.13.41.71.47',NULL,'','','','14460','COLOMBELLES',NULL,NULL,'2450114118001',67.000000000,'1972-09-29','GOLD',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (219,'SIMEON','RAYMONDE','1964-01-23','02.90.87.17.32','06.40.53.63.43',NULL,'','','','14200','HEROUVILLE ST CLAIR',NULL,NULL,'2640178370001',4.000000000,'1991-02-26','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (220,'DAUPHIN','ROGER','1937-04-05','02.29.73.31.55','06.64.03.26.58',NULL,'14 rue des carrelles','','','14000','CAEN',NULL,NULL,'2370414591001',74.000000000,'1960-03-11','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (221,'GERAULT','roland','1942-03-01','02.78.18.06.30','06.50.55.46.29',NULL,'72 RUE DES EPIVAS','','',NULL,NULL,NULL,NULL,'2420314675001',1447.000000000,'1964-03-30','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (222,'LEMORE','HENRIETTE','1961-03-29','02.60.33.80.58','06.56.96.95.68',NULL,'','','',NULL,NULL,NULL,NULL,'2610314542001',186.000000000,'1990-12-17','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (223,'POZNANSKI','LOUIS','1949-01-25','02.23.49.77.19','06.89.01.40.32',NULL,'21 rue des aulnes','','',NULL,NULL,NULL,NULL,'2490114338001',37.000000000,'1972-07-15','PREMIUM',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (224,'BANDRAC','ROGER','1949-03-01','02.44.56.15.12','06.53.91.70.36',NULL,'30 RUE ALEXANDRE CHORON','','',NULL,NULL,NULL,NULL,'1490314499001',38.000000000,'1973-07-09','PREMIUM',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (225,'LAUNAY','CLAUDE','1936-09-02','02.23.04.73.87','06.11.76.12.98',NULL,'40 bd leroy','','',NULL,NULL,NULL,NULL,'2360950083001',188.000000000,'1959-05-13','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (226,'PASNEL','DOMINIQUE','1952-01-16','02.10.62.95.00','06.10.30.16.54',NULL,'16 AV DU 43 EME REGIMENT D ARTIL','LERIE CHEZ MR SARDORI','',NULL,NULL,NULL,NULL,'1520102585001',17.000000000,'1978-04-15','PREMIUM',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (227,'NEDELEC','claude','1937-10-18','02.29.58.69.59','06.61.25.52.73',NULL,'','','',NULL,NULL,NULL,NULL,'1371061303001',6.000000000,'1963-09-08','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (228,'DUPREY','MAURICE','1922-06-02','02.56.15.06.22','06.11.89.87.40',NULL,'','','','14220','BARBERY',NULL,NULL,'1220614491001',1207.000000000,'1951-01-19','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (229,'THOMASSE','Monique','1935-06-16','02.97.65.21.31','06.82.48.32.26',NULL,'','','','14760','BRETTEVILLE SUR ODON',NULL,NULL,'2350614457001',26.000000000,'1957-10-30','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (230,'JOUSSELIN','MARGUERITE','1954-05-19','02.26.61.16.74',NULL,NULL,'','','','14320','ST MARTIN DE FONTENAY',NULL,NULL,'1540514084001',2531.000000000,'1981-06-17','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (231,'PHILIPPAU','GILBERT','1966-03-04','02.48.21.87.15','06.72.98.52.48',NULL,'','','','14160','DIVES SUR MER',NULL,NULL,'2660314554001',886.000000000,'1988-09-08','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (232,'GILLE','MAURICE','1937-11-04','02.47.17.68.11','06.10.70.72.58',NULL,'126 rue brancion','','','14123','CORMELLES LE ROYAL',NULL,NULL,'2371150054001',4027.000000000,'1961-05-14','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (233,'DUHOMME','LILIANE','1937-11-02','02.50.66.65.53','06.19.43.95.25',NULL,'12 bis reu de l eglise','','','14220','HAMARS',NULL,NULL,'1371114097001',35.000000000,'1961-06-22','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (234,'PELTIER','CLAUDE','1932-03-28','02.88.36.05.43','06.36.83.02.76',NULL,'901 rue du chemin vert','','','14210','AVENAY',NULL,NULL,'1320314227001',1408.000000000,'1961-09-15','PLATINIUM',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (235,'GRIEUX','MONIQUE','1937-07-13','02.99.04.15.38','06.55.38.58.62',NULL,'1 rue de la haie pature','','','14210','LA CAINE',NULL,NULL,'1370714291001',63.000000000,'1958-03-24','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (236,'FERDJALLAT','RENE','1932-09-26','02.10.82.16.77','06.36.92.49.46',NULL,'20 rue de lisbone','','','14210','TOURVILLE SUR ODON',NULL,NULL,'2320914282001',84.000000000,'1955-05-22','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (237,'VAUQUELIN','GERARD','1950-10-17','02.14.80.49.87','06.67.78.48.01',NULL,'55 rue des epivas','','','14850','HEROUVILLETTE',NULL,NULL,'2501014075001',174.000000000,'1971-06-19','PREMIUM',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (238,'LANGE','SP','1939-10-16','02.48.65.37.57','06.78.42.41.20',NULL,'14 rue jean simon','','','14000','CAEN',NULL,NULL,'2391014171001',1704.000000000,'1962-08-23','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (239,'BARRIERE','PATRICIA','1934-11-08','02.77.72.00.42','06.33.03.50.87',NULL,'village de l''eglise','','','14630','FRENOUVILLE',NULL,NULL,'1341137101001',30.000000000,'1956-10-26','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (240,'GUILLEMETTE','BERNARD','1931-01-05','02.12.02.27.35','06.14.73.44.56',NULL,'POIX','','','14000','CAEN',NULL,NULL,'2310114370001',108.000000000,'1959-05-08','GOLD',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (241,'MARTY','GENEVIEVE','1959-02-11','02.75.33.41.59','06.58.63.77.14',NULL,'25 rue des jonchets','','','14500','VIRE',NULL,NULL,'1590250376001',23.000000000,'1982-06-18','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (242,'LOPES DOS SANTOS','ANDREE','1961-01-12','02.89.68.09.31','06.44.40.43.56',NULL,'LE BOURG','','','14210','BARON SUR ODON',NULL,NULL,'2610114092001',1050.000000000,'1984-05-13','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (243,'LACROIX','ANNE MARIE','1961-04-01','02.53.90.85.39','06.72.17.91.10',NULL,'RESIDENCE LA ROSERAIE 28 RUE DU',' MANOIR','','14540','BOURGUEBUS',NULL,NULL,'1610414455001',121.000000000,'1983-12-09','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (244,'MOTEL','JEAN-PAUL','1935-06-23','02.50.69.95.50','06.11.38.60.66',NULL,'','','','14120','MONDEVILLE',NULL,NULL,'2350614218001',27.000000000,'1957-07-13','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (245,'PAILLARD','PATRICK',NULL,'02.18.14.67.10','06.80.50.18.89',NULL,'15 AV DE NORMANDIE','','','14120','MONDEVILLE',NULL,NULL,'1340450397001',168.000000000,'2007-12-01','PREMIUM',10,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (246,'RENARD','GILLES','1957-02-05','02.10.92.45.46','06.28.09.87.83',NULL,'5 rue chanoine levasseur','','','14120','MONDEVILLE',NULL,NULL,'1570214628001',35.000000000,'1978-02-11','PREMIUM',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (247,'RUBELT','GISELE','1957-04-21','02.47.67.44.22','06.10.59.02.06',NULL,'CAO 4 rue Guilbert','','','14123','IFS',NULL,NULL,'1570499255001',2948.000000000,'1981-10-30','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (248,'LESAGE','CLAUDINE','1941-01-27','02.30.07.39.88','06.11.22.36.08',NULL,'80 rue de Rouen Cour des acacias','','','14000','CAEN',NULL,NULL,'2410114125001',57.000000000,'1970-07-24','SILVER',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (249,'LECONTE','MAURICE',NULL,'02.74.63.18.43',NULL,NULL,'16 RUE DE L EGALITE','','','14320','ST ANDRE SUR ORNE',NULL,NULL,'1460514721001',162.000000000,'2013-05-19','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (250,'POULAIN','EUGENE','1935-01-14','02.36.36.65.80','06.48.54.08.89',NULL,'','','','14370','BELLENGREVILLE',NULL,NULL,'1350114486001',210.000000000,'1961-07-08','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (251,'LAZARD','MARIE MADELEINE','1936-02-17','02.63.70.63.28','06.95.32.80.75',NULL,'22 rue guillaume le conquerant','','','14320','MAY SUR ORNE',NULL,NULL,'1360214114001',6.000000000,'1963-01-01','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (252,'COURTOIS','CHRISTIANE','1933-07-05','02.10.42.90.81','06.24.88.44.97',NULL,'','','','14000','CAEN',NULL,NULL,'1330714477001',174.000000000,'1954-10-03','PREMIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (253,'CHAPRON','JEANINE',NULL,'02.10.71.15.45','06.11.32.19.50',NULL,'','','','14610','BASLY',NULL,NULL,'1460414588001',878.000000000,'2011-12-03','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (254,'VILLEROY','ODETTE','1945-03-18','02.81.75.67.83','06.88.54.00.39',NULL,'','','','14860','RANVILLE',NULL,NULL,'1450314181001',6.000000000,'1969-10-31','GOLD',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (255,'BOISNEL','MARIE CLAIRE','1932-06-12','02.24.61.64.73','06.12.31.40.00',NULL,'10 rue pasteur','','','14270','MEZIDON CANON',NULL,NULL,'1320614384001',295.000000000,'1956-01-22','PREMIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (256,'LEROULLIER','YVONNE','1967-12-19','02.33.85.59.48','06.12.18.07.51',NULL,'','','','14710','ECRAMMEVILLE',NULL,NULL,'2671261417001',5.000000000,'1994-03-01','PREMIUM',12,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (257,'','XAVIER','1940-03-06','02.33.73.01.86','06.64.34.09.36',NULL,'12 route de belengreville','','','14470','COURSEULLES SUR MER',NULL,NULL,'2400314517001',4.000000000,'1968-05-18','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (258,'PEZERIL','NICOLE','1930-05-14','02.70.26.89.35','06.61.38.42.11',NULL,'24 VOIE DE BIERE','','','14480','CREULLY',NULL,NULL,'2300527641001',80.000000000,'1951-02-09','PREMIUM',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (259,'JARRY','ODETTE','1941-01-16','02.71.82.93.06','06.79.33.65.68',NULL,'','','','14123','CORMELLES LE ROYAL',NULL,NULL,'2410114553001',760.000000000,'1971-02-03','SILVER',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (260,'FLOCH','THIERRY','1975-02-10','02.11.25.39.16','06.26.55.10.11',NULL,'','','','14190','URVILLE',NULL,NULL,'2750250031001',160.000000000,'1996-04-25','PREMIUM',12,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (261,'LE NOEL','MARIE LEONIE','1968-03-17','02.97.04.49.34','06.79.82.64.05',NULL,'','','','14120','MONDEVILLE',NULL,NULL,'1680314589001',3219.000000000,'1991-10-20','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (262,'CHICHUA','DAVID','1958-02-21','02.92.18.46.03','06.31.69.00.02',NULL,'','','','14220','MUTRECY',NULL,NULL,'2580214114001',78.000000000,'1983-09-15','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (263,'NIARD','REJANE','1959-09-05','02.74.89.98.05',NULL,NULL,'(131 avenue de guynemer) SDF!!!!','!!!!!!','','14670','TROARN',NULL,NULL,'1590914075001',32.000000000,'1984-01-07','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (264,'LEMASSON','SERGE','1942-01-09','02.18.59.58.33','06.26.23.11.64',NULL,'','','','14540','GARCELLES SECQUEVILLE',NULL,NULL,'1420114744001',762.000000000,'1967-08-26','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (265,'DUCHESNE','Andre',NULL,'02.61.69.50.34','06.25.03.27.60',NULL,'128 RUE DE LA DELIVRANDE','','','14111','LOUVIGNY',NULL,NULL,'2290778689001',145.000000000,'2008-08-11','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (266,'CHARPIOT','ANDRE','1928-09-09','02.77.78.63.41','06.72.67.15.66',NULL,'14 rue du stade','','','14000','CAEN',NULL,NULL,'2280914008001',63.000000000,'1950-02-24','PLATINIUM',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (267,'MARQUE','JOEL','1930-06-23','02.36.95.46.79','06.12.23.10.67',NULL,'4 RUE DE LA CHENEVOTTE','','','14400','BAYEUX',NULL,NULL,'2300614623001',22.000000000,'1955-01-05','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (268,'ANDRISIK','GENEVIEVE','1959-03-23','02.30.26.33.49','06.11.47.05.26',NULL,'HAMEAU DE LA HOGUE','','','14270','MEZIDON CANON',NULL,NULL,'1590314413001',8.000000000,'1989-12-13','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (269,'BAGDASARIAN','SIMONE','1967-04-22','02.80.35.75.23','06.69.81.58.84',NULL,'26 RUE DE LA RESISTANCE','','',NULL,NULL,NULL,NULL,'1670414668001',8.000000000,'1997-10-22','PREMIUM',12,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (270,'LESIEUR','GUSTAVE','1934-07-17','02.30.27.12.28','06.54.96.96.13',NULL,'','','',NULL,NULL,NULL,NULL,'2340772044001',103.000000000,'1962-12-28','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (271,'BROSSARD','PIERRE','1933-07-09','02.55.54.32.26','06.12.23.51.24',NULL,'','','',NULL,NULL,NULL,NULL,'2330750494001',39.000000000,'1963-06-18','GOLD',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (272,'ALBA','PAULETTE','1943-01-30','02.38.95.84.88','06.43.32.85.97',NULL,'','','','14000','CAEN',NULL,NULL,'1430114249001',1507.000000000,'1965-09-16','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (273,'LE ROUX','LILIANE','1932-03-06','02.58.72.90.15','06.12.31.17.18',NULL,'80 BD LEROY','','','14150','OUISTREHAM',NULL,NULL,'2320314437001',1327.000000000,'1961-09-30','PLATINIUM',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (274,'VINCENT','JEAN LOU','1932-03-04','02.97.10.62.15','06.62.28.83.33',NULL,'12 allee de l''alberta','','','14000','CAEN',NULL,NULL,'1320361482001',14.000000000,'1957-11-09','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (275,'MARIE','CAROLE',NULL,'02.10.17.57.08','06.65.55.87.07',NULL,'','','',NULL,NULL,NULL,NULL,'2390914266001',1053.000000000,'2007-12-31','PREMIUM',10,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (276,'ROBERT','JEAN LOUIS','1955-02-21','02.10.14.66.14','06.63.82.94.77',NULL,'34 RUE DES SABLONNETTES','','','14250','TILLY SUR SEULLES',NULL,NULL,'1550214254001',3279.000000000,'1976-05-01','PREMIUM',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (277,'DESLOGES','carole','1938-04-11','02.11.57.13.03','06.93.23.25.60',NULL,'19 b rue albert souboule','','','14100','LISIEUX',NULL,NULL,'1380450160001',23.000000000,'1961-02-05','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (278,'SUR','ANDREE','1929-09-05','02.58.59.00.95','06.55.66.05.50',NULL,'10 rue des jardins','','','50130','OCTEVILLE',NULL,NULL,'2290914594001',83.000000000,'1958-01-13','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (279,'PERRELLE','Jacqueline','1934-03-20','02.66.94.33.59','06.21.54.74.92',NULL,'','','','14730','GIBERVILLE',NULL,NULL,'1340314181001',33.000000000,'1958-04-08','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (280,'BRICET','JULIEN','1943-05-18','02.63.21.72.65','06.13.35.39.30',NULL,'','','','14123','IFS',NULL,NULL,'1430578158001',421.000000000,'1972-01-11','SILVER',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (281,'GISZLER','CLAUDE','1939-07-14','02.34.39.58.32','06.77.96.30.83',NULL,'15 RUE DE LA FONTAINE','','','14730','GIBERVILLE',NULL,NULL,'2390714437001',36.000000000,'1965-06-26','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (282,'DEMESTRE','CLAUDE',NULL,'02.80.20.83.38','06.29.82.15.37',NULL,'','','','14000','CAEN',NULL,NULL,'1310686273001',20.000000000,'2012-09-24','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (283,'BEEUWSAERT','FRANCINE','1949-01-24','02.78.08.37.16','06.54.53.30.87',NULL,'','','','14123','IFS',NULL,NULL,'1490150503001',27.000000000,'1971-09-07','PREMIUM',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (284,'RIVOGNAC','RENE','1938-11-23','02.11.11.59.99','06.61.05.22.31',NULL,'','','','14120','MONDEVILLE',NULL,NULL,'2381114138001',69.000000000,'1963-02-07','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (285,'MORIN','VERONIQUE','1933-11-02','02.10.01.47.62','06.35.11.62.63',NULL,'172 rue caponiere','','','14123','IFS',NULL,NULL,'1331114226001',2704.000000000,'1957-01-10','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (286,'LEPELTIER','GUY','1929-07-08','02.11.81.39.41','06.19.87.99.26',NULL,'14 rue des verts pres','','','14430','CRESSEVEUILLE',NULL,NULL,'1290760353001',1231.000000000,'1959-02-19','PLATINIUM',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (287,'BARBANCHON','MICHELINE','1939-08-03','02.13.07.98.94','06.11.15.69.14',NULL,'20 rue ch peggy','','','50500','ST HILAIRE PETITVILLE',NULL,NULL,'2390814332001',731.000000000,'1968-07-21','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (288,'DESMONTS','CLAUDE','1960-03-25','02.90.54.62.29','06.72.46.17.08',NULL,'','','','14000','CAEN',NULL,NULL,'1600350371001',199.000000000,'1988-03-04','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (289,'MADELAINE','AGNES','1962-03-20','02.56.43.93.48','06.16.31.67.38',NULL,'','','','14430','DOZULE',NULL,NULL,'1620350365001',1848.000000000,'1983-08-05','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (290,'MALLET','GERARD','1962-05-08','02.12.18.01.69','06.29.70.88.85',NULL,'LE LONDE','','','14420','VILLERS CANIVET',NULL,NULL,'2620514278001',539.000000000,'1988-11-19','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (291,'TRESGOTS','Nicole','1933-03-01','02.57.81.06.33','06.59.96.14.29',NULL,'5 RUE DU LAVOIR','','','14200','HEROUVILLE ST CLAIR',NULL,NULL,'1330314422001',114.000000000,'1963-10-29','GOLD',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (292,'HAMARD','GENEVIEVE','1959-12-21','02.16.43.82.13','06.39.47.08.41',NULL,'','','','14110','CONDE SUR NOIREAU',NULL,NULL,'1591214531001',39.000000000,'1984-04-06','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (293,'BISSON','MARIE LOUISE','1934-12-30','02.24.48.66.38','06.11.67.75.45',NULL,'','','','14220','THURY HARCOURT',NULL,NULL,'1341214702001',23.000000000,'1957-02-05','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (294,'BISSON','OCTAVIE','1938-01-11','02.67.50.46.07','06.11.66.51.15',NULL,'','','','14123','IFS',NULL,NULL,'1380114207001',857.000000000,'1962-02-10','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (295,'MAURICE','PHILIPPE','1913-01-07','02.11.07.29.95','06.81.49.24.89',NULL,'','','','14123','FLEURY SUR ORNE',NULL,NULL,'1130133243001',36.000000000,'1934-04-12','GOLD',24,1);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (296,'MARIE','GERARD','1939-05-22','02.12.10.07.81','06.30.24.73.53',NULL,'903 QUARTIER DU VAL','','','14990','BERNIERES SUR MER',NULL,NULL,'1390550300001',82.000000000,'1962-09-23','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (297,'PASCAL','PHILIPPE','1964-03-19','02.25.74.64.72',NULL,NULL,'2 rue des marchands','','','14123','FLEURY SUR ORNE',NULL,NULL,'2640314134001',420.000000000,'1994-06-27','PREMIUM',12,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (298,'L HOSTIS','PIERRE','1957-03-01','02.59.80.58.24','06.38.80.31.99',NULL,'','','','14400','ST VIGOR LE GRAND',NULL,NULL,'2570314454001',63.000000000,'1978-05-31','PREMIUM',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (299,'GELINAUD','GERMAINE','1968-10-31','02.11.84.15.03','06.30.31.28.98',NULL,'6 RUE ALEXANDRE DRIA','','',NULL,NULL,NULL,NULL,'2681095063001',3233.000000000,'1990-11-28','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (300,'KOTOWSKI','ODETTE','1938-07-06','02.90.17.04.17','06.56.53.21.57',NULL,'16 rue juliot curie','','',NULL,NULL,NULL,NULL,'1380708497001',377.000000000,'1961-02-16','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (301,'','GEORGES','1937-06-07','02.33.00.22.58','06.44.47.26.56',NULL,'','','',NULL,NULL,NULL,NULL,'2370614025001',810.000000000,'1961-01-18','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (302,'DROUET','ARMAND','1932-08-26','02.30.45.45.57','06.18.97.05.76',NULL,'8 RUE DE LA TUILERIE','','','14123','IFS',NULL,NULL,'1320850504001',88.000000000,'1957-11-19','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (303,'LESIEUR','JANINE','1951-01-01','02.56.61.62.25','06.70.92.06.32',NULL,'la grande bruyere','','','14710','RUSSY',NULL,NULL,'2510161332001',92.000000000,'1978-01-29','PREMIUM',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (304,'AUVRAY','BERNARD','1959-02-27','02.23.43.12.74',NULL,NULL,'','','','14000','CAEN',NULL,NULL,'2590214034001',2477.000000000,'1982-12-25','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (305,'LE COGUIC','Andre','1928-01-14','02.10.51.43.25','06.11.78.76.47',NULL,'60 place champlain','','','14200','HEROUVILLE ST CLAIR',NULL,NULL,'2280114346001',189.000000000,'1958-09-20','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (306,'ROULET','PIERRE','1945-06-01','02.41.38.60.62','06.99.54.00.06',NULL,'20 rue du chateau d''eau','','','14160','DIVES SUR MER',NULL,NULL,'2450661505001',645.000000000,'1975-12-13','GOLD',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (307,'LETELLIER','MICHEL','1935-10-05','02.81.14.39.31','06.38.78.49.66',NULL,'','','',NULL,NULL,NULL,NULL,'1351014138001',19.000000000,'1959-10-14','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (308,'CATHERINE','GISELE','1929-06-02','02.51.47.01.91','06.25.22.15.54',NULL,'4 IMPASSE DES POMMIERS','','',NULL,NULL,NULL,NULL,'1290614319001',358.000000000,'1950-03-30','PREMIUM',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (309,'DREAN','LOUISE','1938-06-23','02.15.80.56.43','06.10.75.99.60',NULL,'CITE UNIVERSITAIRE LE BISEY BAT','NORD 2 CHAMBRE  229','',NULL,NULL,NULL,NULL,'1380650166001',1.000000000,'1968-12-16','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (310,'GODARD','LEON','1950-01-28','02.27.76.73.71','06.90.96.83.50',NULL,'18 RUE LECONTE','','','14000','CAEN',NULL,NULL,'1500114355001',236.000000000,'1975-11-09','PREMIUM',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (311,'TABOUREL','BERNARD','1958-09-02','02.41.98.29.00','06.49.61.92.23',NULL,'8 RUE JULES VERNE','','',NULL,NULL,NULL,NULL,'1580914005001',37.000000000,'1979-07-31','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (312,'GOUVAZE','ANDRE','1970-03-13','02.26.34.44.44','06.47.19.38.22',NULL,'2 rue jean zay','','',NULL,NULL,NULL,NULL,'2700327050001',979.000000000,'1994-10-17','PREMIUM',12,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (313,'MARESQ','OCTAVE','1935-01-26','02.14.10.09.45','06.69.18.04.75',NULL,'2 rue du clos st mathieu','','','14320','FONTENAY LE MARMION',NULL,NULL,'2350114678001',43.000000000,'1961-02-11','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (314,'VIGAN','MICHEL','1951-01-31','02.44.91.34.49','06.23.70.76.97',NULL,'24 RUE D''ARDENNES','','','14540','CONTEVILLE',NULL,NULL,'2510150564001',47.000000000,'1979-02-18','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (315,'MARIE','CATHERINE','1938-02-04','02.87.59.01.23','06.10.06.76.47',NULL,'2 rue henri davoisne','','',NULL,NULL,NULL,NULL,'2380214123001',716.000000000,'1962-05-30','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (316,'POISSON BAILLY','MARC','1966-10-27','02.19.92.19.35','06.32.56.56.60',NULL,'route de st pierre sur dives','','','14140','LIVAROT',NULL,NULL,'2661014145001',15.000000000,'1996-06-15','PREMIUM',12,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (317,'GOST','FERNAND','1938-01-05','02.31.96.01.25','06.83.24.26.48',NULL,'6 RUE GUSTAVE FLAUBERT','','','14730','GIBERVILLE',NULL,NULL,'1380114332001',38.000000000,'1967-12-08','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (318,'JARLAUD','georges','1945-09-14','02.29.23.25.90','06.40.44.61.29',NULL,'6 rue Mesnil Vitey','','',NULL,NULL,NULL,NULL,'1450914749001',114.000000000,'1966-09-01','GOLD',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (319,'GUILBERT','JOSIANE','1932-02-12','02.59.97.58.82','06.26.40.87.83',NULL,'17 SQUARE LOUIS DUBOSQ','','',NULL,NULL,NULL,NULL,'1320214520001',5220.000000000,'1959-03-13','GOLD',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (320,'BROCHARD','ERIC','1937-07-26','02.10.54.41.95','06.23.22.66.79',NULL,'86 RUE DES LUTHIERS','','','14460','COLOMBELLES',NULL,NULL,'1370714291001',91.000000000,'1964-06-02','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (321,'LE GOFF','RAYMONDE','1941-01-19','02.57.78.07.72','06.66.61.39.11',NULL,'27 RUE PAUL CLAUDEL','','','14680','GOUVIX',NULL,NULL,'2410161186001',153.000000000,'1970-08-08','SILVER',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (322,'DILASSER','LIONEL','1928-02-14','02.77.32.98.19','06.49.14.90.01',NULL,'','','','14540','POUSSY LA CAMPAGNE',NULL,NULL,'2280277178001',623.000000000,'1951-03-24','PREMIUM',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (323,'LAMER','CLAUDE','1929-08-25','02.59.94.09.78','06.81.70.74.36',NULL,'','','','61380','SOLIGNY LA TRAPPE',NULL,NULL,'2290814470001',2538.000000000,'1953-12-23','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (324,'TISON','Remy','1958-07-17','02.26.54.70.74',NULL,NULL,'5 RESIDENCE  DES FONTAINES','','','14320','MAY SUR ORNE',NULL,NULL,'1580714581001',138.000000000,'1982-08-23','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (325,'TISON','DANIEL','1938-03-18','02.33.55.01.38','06.41.72.41.72',NULL,'9 RUE DU PAVILLON','','','14270','MAGNY LA CAMPAGNE',NULL,NULL,'1380359252001',1379.000000000,'1968-05-18','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (326,'WYTROWA','JEANNINE','1936-08-30','02.12.86.24.46','06.65.99.57.99',NULL,'','','','14120','MONDEVILLE',NULL,NULL,'2360861339001',34.000000000,'1958-07-30','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (327,'LACROIX','JEANINNE','1931-05-11','02.35.41.55.80','06.26.24.56.47',NULL,'','','',NULL,NULL,NULL,NULL,'2310528285001',18.000000000,'1952-10-21','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (328,'ODIENNE','ANDRE','1961-03-30','02.65.65.80.01','06.10.41.49.75',NULL,'23 RUE J PREVERT','','','14000','CAEN',NULL,NULL,'1610314651001',30.000000000,'1982-02-05','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (329,'LE MAITRE','Jean pierre','1936-09-23','02.93.12.17.15','06.53.89.93.25',NULL,'','','','14240','CAUMONT L''EVENTE',NULL,NULL,'2360914229001',0.000000000,'1963-03-15','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (330,'AMAND','Jeannine','1958-04-06','02.26.57.78.78','06.55.04.13.70',NULL,'','','','14120','MONDEVILLE',NULL,NULL,'2580414537001',492.000000000,'1983-09-01','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (331,'FASOLI','MARCEL','1917-02-01','02.78.49.77.99','06.18.52.18.31',NULL,'','','','14000','CAEN',NULL,NULL,'2170236101001',43.000000000,'1941-09-13','GOLD',23,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (332,'JOUVE','MICHEL',NULL,'02.24.24.61.79','06.57.50.67.52',NULL,'19 residence le bois de la couli','niere','','50620','ST FROMOND',NULL,NULL,'1480314421001',42.000000000,'2012-10-25','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (333,'','SOLANGE','1935-08-01','02.18.85.27.28','06.11.76.82.84',NULL,'','','','61400','LA CHAPELLE MONTLIGEON',NULL,NULL,'1350861139001',186.000000000,'1960-03-03','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (334,'JOUANNE','ODETTE','1941-04-03','02.11.48.84.40','06.20.60.80.22',NULL,'20/1 RUE DES BLEUETS','','','14370','ARGENCES',NULL,NULL,'1410431069001',48.000000000,'1966-07-15','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (335,'LEPRAEL','MARCEL','1940-06-13','02.67.58.42.33','06.29.87.69.59',NULL,'20/1 RUE DES BLEUETS','','','14370','ARGENCES',NULL,NULL,'2400653127001',94.000000000,'1963-02-25','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (336,'LEHONGRE','MIREILLE','1939-10-13','02.94.66.76.91','06.10.22.43.89',NULL,'','','','50110','TOURLAVILLE',NULL,NULL,'1391050356001',182.000000000,'1965-05-02','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (337,'MARIE','BRIGITTE','1941-01-23','02.10.08.82.27','06.26.93.17.12',NULL,'5 rue de l abbaye','','','14123','FLEURY SUR ORNE',NULL,NULL,'1410150265001',37.000000000,'1963-06-28','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (338,'AMAURY','ABEL','1950-04-27','02.82.32.24.24','06.12.30.22.86',NULL,'19 rue du pere samson','','','14000','CAEN',NULL,NULL,'1500414356001',879.000000000,'1973-08-14','PREMIUM',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (339,'BODY','YOLANDE','1942-05-30','02.36.19.63.91','06.14.66.00.05',NULL,'25 bis av pere charles de foucau','lt','','14000','CAEN',NULL,NULL,'1420578398001',66.000000000,'1966-06-26','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (340,'LEPETIT','BERNARD','1934-09-27','02.54.91.93.36','06.86.10.50.23',NULL,'42 rue du milieux','','','14123','IFS',NULL,NULL,'2340914247001',225.000000000,'1960-08-19','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (341,'BENOIST','GERARD','1934-07-27','02.14.67.90.43','06.54.91.40.07',NULL,'','','','14000','CAEN',NULL,NULL,'2340714659001',16.000000000,'1958-04-10','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (342,'PIVET','MONIQUE','1968-09-06','02.59.26.85.47','06.67.45.86.81',NULL,'1 E ROGER POULAIN','','',NULL,NULL,NULL,NULL,'1680927681001',895.000000000,'1993-03-04','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (343,'DUMAS','LIONEL','1937-06-03','02.22.55.90.46','06.74.10.91.44',NULL,'66 RUE DU MARAIS','','',NULL,NULL,NULL,NULL,'1370614497001',181.000000000,'1959-02-18','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (344,'DUMONT','CHRISTIANE','1954-04-17','02.65.87.95.95','06.69.10.25.24',NULL,'31 RUE DU MABREY','','','14000','CAEN',NULL,NULL,'1540461417001',33.000000000,'1977-11-29','PREMIUM',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (345,'DUMONT','AUGUSTE','1932-08-04','02.51.99.39.64','06.30.29.49.91',NULL,'4 rue du boulhoullay','','','14000','CAEN',NULL,NULL,'1320814432001',258.000000000,'1955-05-30','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (346,'','JANINE','1936-06-05','02.43.66.38.66','06.10.33.27.77',NULL,'','','','14123','IFS',NULL,NULL,'1360662393001',105.000000000,'1960-01-03','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (347,'WISS','JEAN','1929-11-21','02.54.75.84.97','06.60.28.85.31',NULL,'48 RUE DU CANADA','','',NULL,NULL,NULL,NULL,'1291114735001',15.000000000,'1951-10-05','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (348,'CLEMENCE','CATHERINE','1932-03-22','02.38.99.83.32','06.64.35.22.89',NULL,'48 RUE DU CANADA','','','50760','ANNEVILLE EN SAIRE',NULL,NULL,'1320314076001',2550.000000000,'1962-05-21','GOLD',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (349,'SUAZE','ALFRED','1932-11-04','02.80.77.33.83','06.42.10.37.80',NULL,'','','','14320','FEUGUEROLLES BULLY',NULL,NULL,'2321161402001',2.000000000,'1955-12-25','PREMIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (350,'MAURAND','olivier','1932-02-28','02.48.36.02.80','06.71.08.39.62',NULL,'','','',NULL,NULL,NULL,NULL,'2320261283001',71.000000000,'1962-09-21','PREMIUM',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (351,'LEMONNIER','NICOLE','1934-10-17','02.94.57.47.33','06.17.75.95.42',NULL,'','','',NULL,NULL,NULL,NULL,'1341014431001',782.000000000,'1964-12-27','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (352,'GRENET','SYLVAIN','1941-01-28','02.24.63.45.36','06.95.52.66.89',NULL,'5 RUE DE LA QUERRIERE AU ROSSIGN','OL','',NULL,NULL,NULL,NULL,'1410114268001',1036.000000000,'1966-09-17','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (353,'RAVEAU','DANIEL','1966-06-13','02.67.16.39.95','06.37.65.18.07',NULL,'6 rue de martinville','','',NULL,NULL,NULL,NULL,'1660614046001',39.000000000,'1996-12-16','PREMIUM',12,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (354,'CATHERINE','JACQUELINE','1928-04-15','02.72.94.22.22','06.10.30.64.10',NULL,'','','','14370','BELLENGREVILLE',NULL,NULL,'2280450523001',171.000000000,'1952-07-14','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (355,'PIERRE','ROBERT','1931-10-20','02.78.61.00.05','06.66.66.58.75',NULL,'','','','14740','ST MANVIEU NORREY',NULL,NULL,'1311014119001',164.000000000,'1952-10-21','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (356,'REBOURS','GABRIEL','1935-06-05','02.93.90.31.28','06.35.24.96.25',NULL,'','','','14360','TROUVILLE SUR MER',NULL,NULL,'2350650440001',92.000000000,'1957-11-15','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (357,'DUPONT','JACQUES','1929-04-27','02.36.39.90.63','06.33.69.53.09',NULL,'17 RUE DE L AUBEPINE','','','14000','CAEN',NULL,NULL,'1290414027001',1593.000000000,'1951-06-17','PLATINIUM',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (358,'BURIN','CELINE','1928-02-24','02.11.31.08.36','06.10.69.47.07',NULL,'','','','14320','FONTENAY LE MARMION',NULL,NULL,'1280214042001',91.000000000,'1953-04-16','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (359,'LECARDONNEL','Josiane','1920-01-15','02.10.14.86.31','06.93.58.72.72',NULL,'8 rue mac mahon','','','14123','CORMELLES LE ROYAL',NULL,NULL,'1200114655001',11.000000000,'1943-10-20','GOLD',23,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (360,'NEEL','Emile','1941-08-29','02.11.84.72.56','06.78.38.32.81',NULL,'5 RUE JACQUES PREVERT','','','14123','CORMELLES LE ROYAL',NULL,NULL,'2410814733001',227.000000000,'1967-09-27','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (361,'LESEUR','ANNICK','1931-03-02','02.11.01.61.52','06.11.72.64.58',NULL,'','','',NULL,NULL,NULL,NULL,'2310314412001',1421.000000000,'1952-06-25','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (362,'COSTARD','MAURICETTE','1944-01-20','02.31.24.14.79','06.52.50.94.76',NULL,'','','','93390','CLICHY SOUS BOIS',NULL,NULL,'2440161081001',83.000000000,'1969-04-28','GOLD',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (363,'CHANTEPIE','GINETTE','1930-02-08','02.75.07.86.28','06.55.79.64.26',NULL,'6 LE CLOS DE BULLY','','','14160','DIVES SUR MER',NULL,NULL,'2300229045001',484.000000000,'1953-11-16','PREMIUM',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (364,'LEMARCHAND','ANDREE','1934-01-12','02.28.77.30.54','06.55.53.87.93',NULL,'','','',NULL,NULL,NULL,NULL,'2340150261001',805.000000000,'1960-07-01','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (365,'LALLEMAND','ALAIN','1964-01-28','02.32.84.51.39','06.10.68.94.99',NULL,'341 BD DE GRAVILLE','','',NULL,NULL,NULL,NULL,'2640161293001',152.000000000,'1990-10-04','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (366,'QUESNEL','ALINE','1937-08-11','02.29.45.38.80','06.11.01.90.09',NULL,'','','','14123','CORMELLES LE ROYAL',NULL,NULL,'1370814724001',16.000000000,'1962-04-07','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (367,'DENIS','henri','1930-07-10','02.44.84.78.00','06.30.06.44.27',NULL,'7 impasse leo ferre','','','14190','OUILLY LE TESSON',NULL,NULL,'1300714047001',8.000000000,'1960-09-15','PREMIUM',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (368,'ROBINE','LOUIS','1933-03-11','02.36.93.74.32',NULL,NULL,'','','',NULL,NULL,NULL,NULL,'1330314483001',562.000000000,'1957-08-18','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (369,'ROBINE','NATHALIE','1933-04-01','02.10.77.65.37','06.55.21.04.28',NULL,'20 ROUTE DE CAEN','','',NULL,NULL,NULL,NULL,'2330414069001',12.000000000,'1956-12-11','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (370,'ALEXANDRE','JACQUELINE','1957-03-14','02.31.98.11.22','06.45.44.54.62',NULL,'','','','14230','ISIGNY SUR MER',NULL,NULL,'1570314568001',91.000000000,'1981-02-28','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (371,'GABRIEL','THIERRY','1929-05-30','02.41.19.05.94','06.11.88.87.58',NULL,'','','','14670','TROARN',NULL,NULL,'1290514679001',422.000000000,'1951-09-29','PLATINIUM',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (372,'LEMENUEL','GERARD','1944-10-26','02.29.65.15.71','06.25.56.76.73',NULL,'2 Alle des Meliers','','','14120','MONDEVILLE',NULL,NULL,'2441014208001',163.000000000,'1970-01-09','GOLD',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (373,'LE GOUPILLOT','BERNARD','1938-02-09','02.39.60.43.04','06.33.95.29.91',NULL,'2 ALLEE DES MELIERS chez mme Ge','lato','','14000','CAEN',NULL,NULL,'2380214610001',40.000000000,'1963-04-26','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (374,'MOINS','VALERIE','1968-09-29','02.72.18.82.59','06.83.87.92.28',NULL,'','','',NULL,NULL,NULL,NULL,'1680927681001',788.000000000,'1992-08-30','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (375,'MELIN','CHRISTIANE','1945-01-27','02.49.52.17.12','06.42.40.00.13',NULL,'','','','14540','BOURGUEBUS',NULL,NULL,'1450149342001',208.000000000,'1968-07-31','GOLD',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (376,'FOSSEY','PAULETTE','1965-11-03','02.10.67.17.31','06.85.09.71.87',NULL,'','','',NULL,NULL,NULL,NULL,'2651114578001',77.000000000,'1986-10-17','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (377,'NICOLLE','GINETTE','1959-03-13','02.91.21.48.14','06.74.74.89.75',NULL,'11 place des bleuts','','','14000','CAEN',NULL,NULL,'2590350363001',5131.000000000,'1987-07-14','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (378,'VASNIER','ROGER','1933-02-23','02.60.54.48.31','06.44.74.80.84',NULL,'2 place andre schoeff','','','14550','BLAINVILLE SUR ORNE',NULL,NULL,'1330214174001',647.000000000,'1963-07-11','PREMIUM',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (379,'FREMONT','BRIGITTE','1932-11-28','02.12.25.98.19','06.56.93.57.18',NULL,'24 RUE DE L ANCIENNE GARE','','',NULL,NULL,NULL,NULL,'2321150025001',41.000000000,'1954-08-17','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (380,'SENTILLY','CHRISTINE','1964-08-05','02.21.91.29.37','06.20.10.68.04',NULL,'322 LES BELLES PORTES','','','14540','GARCELLES SECQUEVILLE',NULL,NULL,'1640814430001',2325.000000000,'1989-01-06','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (381,'TOURNIERE','LUCIEN','1936-04-01','02.57.52.23.69','06.47.67.55.25',NULL,'50 route de gouvix','','','14370','VIMONT',NULL,NULL,'1360414327001',78.000000000,'1958-02-16','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (382,'HAMON','GENEVIEVE','1937-10-11','02.51.03.90.34','06.65.45.48.82',NULL,'LA LANDE','','','14270','VIEUX FUME',NULL,NULL,'2371086137001',38.000000000,'1964-03-12','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (383,'HEUZE','MARIE','1947-01-25','02.11.49.18.85','06.10.09.40.06',NULL,'4 MOISSY','','','14700','ST MARTIN DE MIEUX',NULL,NULL,'2470150289001',12.000000000,'1971-07-20','GOLD',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (384,'LELOGEAIS','JEAN','1953-03-31','02.76.29.84.72','06.77.36.25.36',NULL,'2 RESIDENCE  DU BOCAGE','','',NULL,NULL,NULL,NULL,'1530314305001',3.000000000,'1982-03-12','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (385,'DUMONT','PIERRE','1952-03-27','02.51.11.93.23','06.94.34.83.95',NULL,'XXXXXXXXXXXXXXXXXXX','','',NULL,NULL,NULL,NULL,'1520314164001',1055.000000000,'1982-07-31','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (386,'RENEE','JEANNE','1934-01-28','02.70.76.26.35','06.28.17.85.86',NULL,'12 RUE DE LA GARENNE','','','75015','PARIS 15',NULL,NULL,'1340150559001',79.000000000,'1961-08-21','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (387,'GABRIEL','JEAN LOUIS','1940-10-01','02.37.63.34.31','06.31.25.86.27',NULL,'7-5 RUE DU BOIS','','','14940','TOUFFREVILLE',NULL,NULL,'2401014277001',15.000000000,'1965-05-26','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (388,'SEBERT','ETIENNE','1945-01-29','02.10.74.75.22',NULL,NULL,'CHEMIN DU MARAIS','','','14123','IFS',NULL,NULL,'1450114406001',8.000000000,'1974-05-15','GOLD',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (389,'LEREVEREND','GHISLAINE','1938-02-13','02.41.45.48.55','06.11.10.53.89',NULL,'rue de picardie','','','14123','CORMELLES LE ROYAL',NULL,NULL,'2380261076001',7.000000000,'1964-10-13','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (390,'DOUCHIN','JOELLE','1932-05-29','02.88.60.70.18','06.48.47.41.48',NULL,'21 RUE SAINT MARTIN','','','14120','MONDEVILLE',NULL,NULL,'1320514542001',953.000000000,'1954-03-22','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (391,'JEAN MARIE','JACKY','1938-03-28','02.40.20.70.43','06.67.66.52.54',NULL,'','','','14123','CORMELLES LE ROYAL',NULL,NULL,'1380314472001',2317.000000000,'1968-07-29','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (392,'BOUTELOUP','ALCIDE','1988-02-05','02.93.41.83.42','06.78.00.09.83',NULL,'2 IMPASSE DES GLAIEULS','','','14680','BRETTEVILLE SUR LAIZE',NULL,NULL,'1880299344001',450.000000000,'2010-02-03','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (393,'DESLOGES','pierre','1959-07-16','02.56.50.29.88','06.10.75.09.52',NULL,'6 RUE DE LA BRUYERE','','','50390','ST JACQUES DE NEHOU',NULL,NULL,'2590714157001',26.000000000,'1981-02-22','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (394,'BAYEUX','THERESE','1934-05-23','02.13.05.14.85','06.58.37.96.27',NULL,'35 RUE CHATEAU BRIAND','','','61380','STE CERONNE LES MORTAGNE',NULL,NULL,'1340514535001',50.000000000,'1957-07-23','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (395,'CORBET','MARIE THERESE','1920-04-06','02.47.50.17.18','06.11.55.42.61',NULL,'5 bis impasse du manoir','','','14123','CORMELLES LE ROYAL',NULL,NULL,'2200432305001',168.000000000,'1947-07-12','PREMIUM',22,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (396,'PEDELOUP','DAVID','1924-10-29','02.35.38.04.53','06.23.21.21.72',NULL,'13 rue des grandes patures','','','14270','CESNY AUX VIGNES OUEZY',NULL,NULL,'2241003310001',1025.000000000,'1950-03-03','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (397,'VICTOR','GEORGES','1941-01-27','02.70.89.27.94','06.61.59.47.30',NULL,'903 QUARTIER DU VAL','','','14360','TROUVILLE SUR MER',NULL,NULL,'2410150558001',2.000000000,'1962-10-28','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (398,'LEGRAND','CHRISTINE','1935-12-09','02.51.64.27.15','06.81.52.32.90',NULL,'3 2 ALLEE DES CAPUCINES','','',NULL,NULL,NULL,NULL,'1351250215001',97.000000000,'1957-07-25','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (399,'MARIE','GENEVIEVE','1955-06-05','02.91.41.80.52','06.83.46.06.87',NULL,'LA HOUSSAYE','','','14123','IFS',NULL,NULL,'1550614086001',87.000000000,'1984-02-09','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (400,'ROGUELIN','JEAN','1958-02-11','02.46.49.44.64','06.37.27.27.51',NULL,'le bourg','','','14670','TROARN',NULL,NULL,'1580214396001',77.000000000,'1979-04-15','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (401,'PEAN','CLAUDE','1938-04-27','02.28.29.40.43','06.11.96.63.47',NULL,'23 bis bvd leroy','','','14000','CAEN',NULL,NULL,'2380414012001',34.000000000,'1962-07-02','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (402,'RADIGUET','JACQUES','1958-02-26','02.11.76.33.17','06.66.08.75.10',NULL,'10- 2 avenue du rond point','','','14670','TROARN',NULL,NULL,'2580214331001',188.000000000,'1988-09-06','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (403,'MORISSET','ALBERT','1939-04-09','02.10.60.65.53','06.90.11.22.45',NULL,'chemin des bruyeres','','','14730','GIBERVILLE',NULL,NULL,'1390414342001',408.000000000,'1963-04-26','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (404,'GODEAU','ALAIN','1930-06-11','02.88.90.03.99','06.18.39.49.29',NULL,'4 rue des freres vigouroux','','',NULL,NULL,NULL,NULL,'1300650194001',6.000000000,'1953-05-02','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (405,'CAPELLO','EDDY','1938-09-05','02.12.67.59.79','06.16.10.42.46',NULL,'5 RUE DU BOIS','','','14370','VIMONT',NULL,NULL,'2380914158001',309.000000000,'1960-02-24','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (406,'LEQUESNE','JEANNINE','1956-05-10','02.41.85.55.78','06.83.49.92.66',NULL,'76 RUE DU PLESSIS TREVISE','','','14123','IFS',NULL,NULL,'1560561208001',862.000000000,'1977-08-10','PREMIUM',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (407,'MAUNY','CHRISTIAN','1935-09-13','02.44.47.18.75','06.27.01.58.28',NULL,'22 RUE CAILLEMER','','','14123','IFS',NULL,NULL,'1350914046001',1018.000000000,'1958-06-08','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (408,'LEMONNIER','ARLETTE','1947-05-01','02.58.21.35.80','06.49.81.46.34',NULL,'RUE DE LA DIME','','',NULL,NULL,NULL,NULL,'1470578495001',1614.000000000,'1974-01-25','GOLD',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (409,'HOREL','MARTHE','1929-08-31','02.12.10.55.00','06.90.73.16.38',NULL,'40 RUE DE L EGLISE','','',NULL,NULL,NULL,NULL,'2290850194001',17.000000000,'1951-09-27','PLATINIUM',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (410,'LETONDEUR','JOSETTE','1959-10-06','02.10.48.47.59','06.11.33.12.84',NULL,'89 RUE DU MARECHAL FOCH','','',NULL,NULL,NULL,NULL,'1591014517001',342.000000000,'1984-03-24','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (411,'HUET','claude','1940-07-30','02.19.61.15.30','06.32.33.68.22',NULL,'','','','14123','FLEURY SUR ORNE',NULL,NULL,'1400714083001',211.000000000,'1968-12-03','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (412,'DACHICOURT','THERESE','1933-02-21','02.62.28.69.88','06.34.39.70.03',NULL,'37 rue de normandie','','',NULL,NULL,NULL,NULL,'2330214329001',32.000000000,'1957-08-07','PREMIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (413,'PICARD','MARIE LOUISE','1950-01-13','02.85.89.59.46','06.47.27.10.86',NULL,'4 RUE DES MARCHES','','','14400','MONCEAUX EN BESSIN',NULL,NULL,'1500150185001',532.000000000,'1974-12-12','PREMIUM',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (414,'MORIN','YVES','1934-11-08','02.12.08.43.76','06.27.72.72.18',NULL,'13 RUE GEORGES BRASSENS','','','14000','CAEN',NULL,NULL,'2341114625001',980.000000000,'1961-11-17','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (415,'VANNIER','tengiz','1936-11-15','02.40.13.19.89','06.38.83.04.65',NULL,'7 RUE DES CORDES','','','14111','LOUVIGNY',NULL,NULL,'2361114006001',157.000000000,'1963-04-20','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (416,'DUBREUIL','GINETTE','1967-04-09','02.64.62.26.00','06.99.51.21.25',NULL,'','','','14000','CAEN',NULL,NULL,'1670414537001',594.000000000,'1988-08-14','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (417,'MOUSSEL','JANINE','1961-01-22','02.21.71.54.50','06.56.19.51.14',NULL,'11 RUE JOSEPH DE  DELENTE','','','14670','TROARN',NULL,NULL,'2610114225001',4.000000000,'1982-06-26','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (418,'LANGLOIS','GUY','1933-05-30','02.18.63.68.07','06.11.77.61.33',NULL,'','','',NULL,NULL,NULL,NULL,'2330514071001',108.000000000,'1960-09-20','GOLD',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (419,'DUVERLIE','','1937-05-28','02.12.12.38.61','06.70.81.48.77',NULL,'','','','14000','CAEN',NULL,NULL,'1370554067001',10.000000000,'1959-07-02','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (420,'CHARNY','roland','1940-05-25','02.89.02.42.22','06.13.99.83.72',NULL,'','','','14000','CAEN',NULL,NULL,'2400550312001',408.000000000,'1964-04-28','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (421,'RENARD','Raoul','1951-06-26',NULL,NULL,NULL,'133 RUE DES ACCACIAS','','',NULL,NULL,NULL,NULL,'2510614118001',10.000000000,'1976-02-27','PREMIUM',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (422,'ADAM','Bernard','1928-06-20','02.11.72.81.76','06.18.79.59.37',NULL,'27 BD DU 13 JUIN','','','14320','FEUGUEROLLES BULLY',NULL,NULL,'2280614319001',99.000000000,'1955-09-17','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (423,'LEFAUCONNIER','Paul','1930-12-27','02.40.58.56.50','06.86.26.05.00',NULL,'16 rue antoine galland','','','14840','CUVERVILLE',NULL,NULL,'2301235022001',27.000000000,'1960-09-15','PLATINIUM',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (424,'ROUXELIN','FRANCOIS','1921-12-14','02.62.93.80.16','06.85.28.12.74',NULL,'2 RUE JACQUES BREL','','','14210','ESQUAY NOTRE DAME',NULL,NULL,'1211219090001',3.000000000,'1946-04-22','GOLD',22,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (425,'DAUGUET','ADAM','1940-05-21','02.27.84.14.31','06.61.57.87.70',NULL,'30 rue de la republique','','',NULL,NULL,NULL,NULL,'1400510387001',515.000000000,'1969-08-14','SILVER',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (426,'LECOUTURIER','MADELEINE','1939-09-18','02.53.53.00.26','06.52.46.13.00',NULL,'HAMEAU DE CAHIER','','',NULL,NULL,NULL,NULL,'2390961182001',196.000000000,'1962-05-03','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (427,'BESNIER','JOSIANE','1958-11-01','02.29.89.52.25','06.91.08.14.08',NULL,'la mare potier','','',NULL,NULL,NULL,NULL,'2581114118001',699.000000000,'1979-05-20','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (428,'LESAGE','GEORGES','1970-01-27','02.11.12.63.10','06.26.78.99.31',NULL,'HAMEAU DE NEUMER','','',NULL,NULL,NULL,NULL,'1700114020001',34.000000000,'1991-10-29','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (429,'RICHARD','DENISE','1940-11-20','02.11.63.56.60','06.88.80.82.08',NULL,'64 route de st pierre sur dives','','',NULL,NULL,NULL,NULL,'1401129083001',333.000000000,'1962-03-06','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (430,'MARC','GENEVIEVE','1940-10-03','02.66.00.39.77','06.75.68.90.22',NULL,'1 rue p semard','','',NULL,NULL,NULL,NULL,'2401014408001',332.000000000,'1965-04-18','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (431,'PRIOULT','COLETTE','1964-07-30','02.62.92.99.71','06.46.66.25.44',NULL,'3 rue des anamones','','',NULL,NULL,NULL,NULL,'1640714090001',15.000000000,'1993-01-28','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (432,'DUCHEMIN','YVETTE','1930-05-24','02.75.88.83.64','06.87.90.78.05',NULL,'lieu dit le mesnil gouffier','','','50000','ST LO',NULL,NULL,'1300514668001',54.000000000,'1960-08-30','GOLD',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (433,'RIFFAUD','MARIE ANTOINETTE','1968-01-26','02.99.06.02.17','06.59.77.40.77',NULL,'11 rue camille blaisot','','','14123','FLEURY SUR ORNE',NULL,NULL,'2680114327001',26.000000000,'1993-02-08','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (434,'MESLIN','JEAN-JACQUES','1932-07-11','02.38.09.53.08','06.31.74.99.43',NULL,'87 rue de falaise','','','14000','CAEN',NULL,NULL,'1320714394001',646.000000000,'1957-02-01','PREMIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (435,'DESCHAMPS','MERABI','1945-01-17','02.63.75.94.03','06.48.53.12.67',NULL,'11 cite de la sucrerie','','','14320','MAY SUR ORNE',NULL,NULL,'2450114513001',4912.000000000,'1973-04-04','GOLD',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (436,'ARDOIN','YVETTE','1928-02-12','02.65.24.67.89','06.39.02.65.22',NULL,'2 residence st gerbold rue forge','t','','14730','GIBERVILLE',NULL,NULL,'1280250416001',52.000000000,'1951-03-14','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (437,'GOUJON','Robert','1932-04-06','02.52.51.52.28','06.26.52.53.12',NULL,'la bourbe','','',NULL,NULL,NULL,NULL,'1320414257001',2373.000000000,'1962-04-08','PREMIUM',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (438,'ALBA','REMI','1932-08-18','02.10.52.99.86','06.77.16.66.61',NULL,'20 RUE DES FRAISIERS','','',NULL,NULL,NULL,NULL,'2320861311001',40.000000000,'1958-07-01','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (439,'NICOLLE','GEORGETTE','1933-11-26','02.49.71.10.52','06.40.26.64.20',NULL,'301 QUARTIER DU VAL','','','14000','CAEN',NULL,NULL,'1331114099001',15.000000000,'1954-04-18','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (440,'CAR','ALAIN','1965-06-08','02.10.88.36.66','06.20.20.69.13',NULL,'11 rue de speyside balsaque','','','14000','CAEN',NULL,NULL,'1650672045001',747.000000000,'1986-05-09','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (441,'PATRIX','TENGIZ','1929-06-24','02.21.15.61.57','06.67.83.10.10',NULL,'route de la suisse normande','','','14000','CAEN',NULL,NULL,'1290614319001',727.000000000,'1950-03-28','PREMIUM',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (442,'SAMOYEAU','andre','1932-04-16','02.41.10.09.10','06.77.50.94.70',NULL,'31 rue auguste lechesne','','',NULL,NULL,NULL,NULL,'1320461344001',1063.000000000,'1953-06-12','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (443,'CORDELET','ODILE','1938-07-26','02.32.35.98.62','06.91.00.48.57',NULL,'11 rue monseigneur adam','','',NULL,NULL,NULL,NULL,'1380714005001',17.000000000,'1965-10-02','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (444,'LEMARCHAND','','1936-02-23','02.98.88.80.89','06.72.95.36.70',NULL,'la chapelle','','','14320','ST ANDRE SUR ORNE',NULL,NULL,'1360214554001',66.000000000,'1962-07-21','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (445,'RONARC H','BERNARD','1957-02-09','02.96.14.77.10','06.11.47.66.75',NULL,'13 RUE PAUL THOMASSE','','',NULL,NULL,NULL,NULL,'1570217234001',396.000000000,'1980-08-14','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (446,'BOSCHER','BERNARD','1962-04-09','02.11.50.30.27','06.53.32.12.03',NULL,'24 allee du jeu de paume','','',NULL,NULL,NULL,NULL,'2620414133001',38.000000000,'1985-04-16','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (447,'BACON','CLAUDE','1929-03-17','02.48.18.01.24','06.29.65.90.40',NULL,'23 RUE TOURMALINE','','',NULL,NULL,NULL,NULL,'1290314345001',97.000000000,'1952-11-28','PREMIUM',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (448,'LEMOISSON','CHRISTIAN','1943-01-20','02.50.76.70.32','06.10.66.13.11',NULL,'12 rue amiral courbet','','',NULL,NULL,NULL,NULL,'2430160494001',596.000000000,'1973-03-14','SILVER',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (449,'LEMONNIER','CLAUDE','1966-08-28','02.25.64.04.34','06.94.31.81.04',NULL,'18 rue foch','','','14000','CAEN',NULL,NULL,'2660814323001',35.000000000,'1990-04-24','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (450,'BOULARD','MARIE-JOSEPHE','1932-11-13','02.99.12.83.52','06.67.92.62.42',NULL,'18 RUE DES FAUVETTES','','','14860','AMFREVILLE',NULL,NULL,'1321114341001',244.000000000,'1953-12-23','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (451,'HAMEL','DANIEL','1933-07-12','02.37.82.81.08','06.47.23.03.39',NULL,'2 4 imp du peintre','','',NULL,NULL,NULL,NULL,'2330761489001',658.000000000,'1957-09-18','PREMIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (452,'LE MASLE','JEAN','1940-02-28','02.11.72.52.69','06.98.81.97.21',NULL,'32 RUE DES ECOLES','','','14260','AUNAY SUR ODON',NULL,NULL,'1400214556001',95.000000000,'1961-07-10','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (453,'ROCANCOURT','','1935-12-26','02.31.30.59.94','06.23.35.52.29',NULL,'25 rte d''hacourt','','',NULL,NULL,NULL,NULL,'2351214592001',44.000000000,'1957-03-13','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (454,'BUISARD','','1928-04-13','02.79.08.54.06','06.83.17.01.93',NULL,'3 rue du lieu vautier','','',NULL,NULL,NULL,NULL,'1280450627001',33.000000000,'1952-03-17','PREMIUM',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (455,'LEMOIGNE','ANDRE','1936-03-23','02.51.02.62.89','06.88.51.66.67',NULL,'les pedouzes','','',NULL,NULL,NULL,NULL,'2360327627001',1140.000000000,'1957-12-19','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (456,'RALLO','JEAN','1957-01-23','02.12.08.97.09','06.51.60.39.06',NULL,'53 RUE DE LA MARJOLAINE','','',NULL,NULL,NULL,NULL,'2570114714001',1734.000000000,'1981-04-28','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (457,'QUETIL','MICHEL','1937-06-01','02.78.49.18.00','06.85.03.34.42',NULL,'NORON LA POTRY','','',NULL,NULL,NULL,NULL,'1370676466001',40.000000000,'1959-05-22','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (458,'ENGUEHARD','ODILE','1940-05-26','02.42.07.22.41','06.30.30.97.40',NULL,'2AV G CLEMENCEAU','','','14000','CAEN',NULL,NULL,'1400514133001',107.000000000,'1964-03-21','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (459,'LEFEVRE','JEANNE','1961-06-28','02.26.92.93.77','06.39.60.72.06',NULL,'8 AV DU 43me RGT D ARTILLERIE','','',NULL,NULL,NULL,NULL,'1610614118001',191.000000000,'1990-02-28','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (460,'','GERARD','1937-08-16','02.90.08.67.45','06.68.11.40.63',NULL,'','','',NULL,NULL,NULL,NULL,'1370814726001',2600.000000000,'1958-06-01','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (461,'BARBE','ANDREE','1939-10-05','02.71.58.47.55','06.34.71.40.66',NULL,'11 RUE EMILI ZOLA','','','14370','CROISSANVILLE',NULL,NULL,'1391014162001',15.000000000,'1963-05-30','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (462,'DESCHAMP','GISELE','1954-10-09','02.21.01.20.28','06.68.00.16.70',NULL,'12 rue albert suel','','','14210','TOURVILLE SUR ODON',NULL,NULL,'1541014118001',878.000000000,'1983-06-08','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (463,'MATHISSART','SYLVIANE','1938-10-22',NULL,NULL,NULL,'6 RUE DU CLOS DE FRANCE','','',NULL,NULL,NULL,NULL,'1381014453001',11.000000000,'1962-11-26','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (464,'ROUSSELET','Andre','1935-10-16','02.11.07.66.98','06.99.40.59.88',NULL,'','','','14123','CORMELLES LE ROYAL',NULL,NULL,'2351014098001',246.000000000,'1956-02-24','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (465,'DOUSSON','GERARD','1952-01-27','02.71.02.62.17','06.50.63.82.99',NULL,'','','',NULL,NULL,NULL,NULL,'1520150410001',274.000000000,'1976-01-20','PREMIUM',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (466,'GUINNEBAULT','MADELEINE','1928-10-19','02.64.47.11.31','06.50.34.12.59',NULL,'17 RUE BERTHIER','','',NULL,NULL,NULL,NULL,'2281014074001',49.000000000,'1954-10-25','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (467,'POTIER','christophe','1939-05-28','02.22.39.94.73','06.33.89.71.71',NULL,'','','',NULL,NULL,NULL,NULL,'2390514493001',34.000000000,'1961-10-16','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (468,'BERRANGER','JEAN CLAUDE','1928-07-18','02.28.35.03.60','00 33 6.71.82.13.41',NULL,'70 RUE DE LA MER','','','14370','ARGENCES',NULL,NULL,'1280735271001',359.000000000,'1953-05-08','PLATINIUM',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (469,'BRANGER','FRANCOISE','1964-05-07','02.46.17.45.93','06.80.70.25.53',NULL,'1 RUE DES CHAMPS FLEURIS','','',NULL,NULL,NULL,NULL,'1640514087001',188.000000000,'1993-09-09','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (470,'LEMENAGER','HELENE',NULL,'02.41.50.82.52','06.39.25.51.55',NULL,'16 RUE EDMOND VILLEY DESMEZERETS','','',NULL,NULL,NULL,NULL,'2380614480001',159.000000000,'2012-10-01','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (471,'ALLAIN','LEONE','1937-06-26',NULL,NULL,NULL,'24 RUE DU CIVISME','','',NULL,NULL,NULL,NULL,'1370614311001',207.000000000,'1964-07-24','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (472,'LE LOGE','LEA','1934-08-15','02.81.83.13.93','06.76.47.73.71',NULL,'2 CITE DES CASTORS','','','14370','ARGENCES',NULL,NULL,'1340814629001',94.000000000,'1955-07-01','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (473,'LELOUTRE','DANIEL','1967-08-10','02.11.86.19.87','06.34.27.31.49',NULL,'13 rue de la grasse de dieu','','',NULL,NULL,NULL,NULL,'2670850464001',690.000000000,'1992-06-22','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (474,'FRANCOISE','JEAN',NULL,'02.30.40.74.15',NULL,NULL,'272 RUE DU VIEU PAITIS','','',NULL,NULL,NULL,NULL,'1580214543001',91.000000000,'2009-06-24','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (475,'VINCENT','MARIE JEANNE','1934-04-29','02.54.78.31.74',NULL,NULL,'84 place de l''eglise','','','14000','CAEN',NULL,NULL,'1340414063001',919.000000000,'1960-03-17','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (476,'DELARUE','ANDRE','1966-04-21','02.57.99.88.45','06.62.64.14.86',NULL,'hameau lahaye','','','14000','CAEN',NULL,NULL,'2660450563001',1312.000000000,'1996-11-02','PREMIUM',12,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (477,'DEVAUX','FRANCOIS','1946-03-26','02.61.39.13.55','06.33.42.52.80',NULL,'11 BIS RUE CAMILLE PELLETAN','','','14380','PONT FARCY',NULL,NULL,'1460314057001',174.000000000,'1976-08-25','GOLD',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (478,'FAHEIM','MONIQUE','1948-11-18','02.13.03.90.15','06.75.97.88.48',NULL,'19 rue armand marie','','','14123','IFS',NULL,NULL,'2481114092001',67.000000000,'1970-01-06','GOLD',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (479,'BICORNE','TAHAR','1955-07-10','02.39.13.04.69','06.34.37.01.98',NULL,'8 bd impratrice eugnie','','',NULL,NULL,NULL,NULL,'1550778554001',13.000000000,'1979-01-27','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (480,'SYLVAND','JEANNINE','1943-07-29','02.11.66.42.54','06.10.81.90.40',NULL,'5 ALLEE DU ROC','','',NULL,NULL,NULL,NULL,'1430711183001',220.000000000,'1964-12-19','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (481,'RAGOT','CATHERINE','1938-12-28','02.63.49.94.02','06.38.79.73.21',NULL,'7 IMPASSE DES HIRONDELLES','','','14980','ROTS',NULL,NULL,'1381272298001',630.000000000,'1963-06-19','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (482,'LECORDIER','AIMEE','1939-09-28','02.61.28.30.13','06.24.97.97.33',NULL,'RESIDENCE ARC EN CIEL BAT B 19','','','14150','OUISTREHAM',NULL,NULL,'1390914240001',71.000000000,'1962-12-07','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (483,'LECOT','JEAN','1936-03-16','02.18.96.01.54','06.39.98.79.00',NULL,'7 RUE GEORGES MAUDOUIT','','',NULL,NULL,NULL,NULL,'2360314387001',888.000000000,'1959-05-27','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (484,'ACHIN','ANDRE','1936-12-09','02.47.79.40.37','06.71.18.01.73',NULL,'RESIDENCE TERREFOUR','','',NULL,NULL,NULL,NULL,'2361214392001',886.000000000,'1966-09-20','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (485,'LEROY','BRIGITTE','1927-04-05','02.10.90.96.11','06.87.48.95.47',NULL,'12 RUE GANDIE','','','14320','ST ANDRE SUR ORNE',NULL,NULL,'1270487061001',320.000000000,'1948-03-14','GOLD',22,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (486,'LITHARE','GASTON','1938-02-26','02.10.97.44.59','06.80.67.95.87',NULL,'11 RUE D ANJOU','','',NULL,NULL,NULL,NULL,'1380214433001',32.000000000,'1961-08-25','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (487,'CARRE','PIERRETTE','1938-12-17','02.12.08.98.41','06.20.75.30.69',NULL,'3 rue d''ober kochen','','',NULL,NULL,NULL,NULL,'2381250074001',38.000000000,'1968-09-28','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (488,'CONFLANT','RENE','1940-12-27','02.11.91.41.78','06.11.58.29.41',NULL,'7 bis rue rougeT de lisle','','',NULL,NULL,NULL,NULL,'1401214722001',64.000000000,'1963-11-19','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (489,'LEROUX','GINETTE','1962-02-06','02.22.41.60.89','06.11.39.56.22',NULL,'13 rue des roses','','','14100','BEUVILLERS',NULL,NULL,'1620250043001',108.000000000,'1991-06-16','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (490,'SAMSON','GILBERTE','1938-09-06','02.70.27.27.25','06.40.84.16.27',NULL,'6 RUE PASTEUR','','',NULL,NULL,NULL,NULL,'2380914489001',665.000000000,'1961-06-23','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (491,'SANSON','NELLY','1929-05-21','02.65.90.50.09','06.73.58.29.21',NULL,'7 RUE DU DR PLANTAIN','','','14730','GIBERVILLE',NULL,NULL,'2290550507001',38.000000000,'1954-06-10','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (492,'LUCAS','CLAUDE','1933-08-30','02.11.68.53.79','06.28.47.75.51',NULL,'19 BD RAYMOND POINCARE','','','14730','GIBERVILLE',NULL,NULL,'1330814274001',93.000000000,'1954-10-14','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (493,'TUBOEUF','GILBERT','1961-03-16','02.12.33.43.28','06.18.72.41.27',NULL,'481 RUE DU GABLE BLANC','','',NULL,NULL,NULL,NULL,'2610350422001',4512.000000000,'1986-02-04','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (494,'BELLIARD','LOUISE','1959-04-09','02.48.93.13.47','06.71.97.61.10',NULL,'1 RUE DES ORMES','','','27260','CORMEILLES',NULL,NULL,'2590414396001',1505.000000000,'1987-06-20','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (495,'VAN WYNSBERGHE','PAUL','1935-12-03','02.21.44.04.04','06.26.79.91.24',NULL,'LE PONT D''ILLEY','','','14000','CAEN',NULL,NULL,'1351214281001',580.000000000,'1960-07-30','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (496,'GOUBIN','MARCEL','1955-02-08','02.74.10.44.74',NULL,NULL,'LE BOURG','','','14000','CAEN',NULL,NULL,'2550214125001',67.000000000,'1983-01-24','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (497,'SAULNIER','MARIE CLAIRE','1932-03-15','02.94.59.93.70','06.17.63.00.05',NULL,'','','','14000','CAEN',NULL,NULL,'1320314098001',365.000000000,'1962-10-10','PREMIUM',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (498,'BECQUET','BERNARD','1943-07-27','02.55.17.45.30','06.78.75.18.95',NULL,'27 RUE DES CANADIENS','','',NULL,NULL,NULL,NULL,'1430714214001',147.000000000,'1965-07-19','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (499,'LEDANOIS','DENISE','1940-09-07','02.49.83.44.80','06.43.17.18.10',NULL,'129 RESIDENCE DE PARIS, BD RAYMO','ND POINCARE','',NULL,NULL,NULL,NULL,'2400914229001',41.000000000,'1970-08-03','SILVER',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (500,'ROBIN','FERNANDE','1945-01-09','02.61.55.67.27','06.66.68.06.55',NULL,'14 RUE DU CLOS DE BAS','','','76600','LE HAVRE',NULL,NULL,'1450161339001',305.000000000,'1968-10-04','GOLD',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (501,'ROBIN','ROSE','1935-12-18','02.94.68.20.57','06.26.70.12.89',NULL,'5 rue louvet','','','14000','CAEN',NULL,NULL,'2351214193001',213.000000000,'1957-03-16','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (502,'BARBIER','JEANNINE','1939-08-18','02.49.65.39.58','06.64.71.31.49',NULL,'33 BLV RAYMOND POINCARE','','','14000','CAEN',NULL,NULL,'2390814427001',103.000000000,'1961-10-30','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (503,'TANQUEREL','DANIEL','1937-04-15','02.11.68.70.30','06.56.27.70.01',NULL,'8 RUE PIERRE MENOCHET','','','14770','ST JEAN LE BLANC',NULL,NULL,'1370414164001',22.000000000,'1960-07-19','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (504,'CHEMIN','HELENE','1935-11-12','02.36.80.08.24','06.34.41.66.51',NULL,'2 rue Andr Gide','','','14190','ST GERMAIN LE VASSON',NULL,NULL,'2351114301001',800.000000000,'1962-11-10','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (505,'BARETTE','MAURICE','1931-03-27','02.41.78.96.56','06.59.38.27.00',NULL,'18 rue du blanc','','',NULL,NULL,NULL,NULL,'2310314251001',36.000000000,'1956-04-03','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (506,'SAUVAGE','LEONE','1931-11-10','02.36.72.02.50','06.32.61.51.67',NULL,'6 rue des carrieres','','','14110','CONDE SUR NOIREAU',NULL,NULL,'1311161096001',2192.000000000,'1957-09-02','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (507,'SAUVAGE','Michel','1934-11-03','02.10.34.15.45','06.91.41.75.50',NULL,'4 chemin des moires','','',NULL,NULL,NULL,NULL,'2341114042001',1395.000000000,'1957-03-10','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (508,'LECARPENTIER','CLAUDE','1941-02-18','02.11.62.61.10','06.59.30.84.04',NULL,'15 RUE DU DR THIBAUT DE LA FRESN','AYE','',NULL,NULL,NULL,NULL,'1410214409001',10.000000000,'1962-08-11','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (509,'LEBARBEY','ROGER','1940-06-17','02.65.97.61.10','06.55.68.25.11',NULL,'40 avenue albert 1er','','',NULL,NULL,NULL,NULL,'2400614197001',29.000000000,'1963-09-06','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (510,'BUQUET','SUZANNE','1969-11-21','02.14.54.66.90','06.43.05.84.74',NULL,'15 RUE PARABOLE DU CLOS','','',NULL,NULL,NULL,NULL,'2691114162001',847.000000000,'1991-12-25','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (511,'MOREL','SUZANNE','1933-10-14','02.75.38.73.86','06.11.91.48.37',NULL,'7 RUE CLOS DU PAVILLON','','',NULL,NULL,NULL,NULL,'1331014060001',734.000000000,'1955-08-01','PREMIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (512,'BULLIAN','Gilles',NULL,'02.96.05.11.17','06.54.72.61.17',NULL,'CLOS DU PAVILLON N.12','','',NULL,NULL,NULL,NULL,'2290514164001',50.000000000,'2009-03-10','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (513,'','jean louis','1938-04-24','02.18.03.76.59','06.22.10.88.28',NULL,'bretteville','','','14123','IFS',NULL,NULL,'2380414119001',766.000000000,'1964-03-25','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (514,'BOUCHARD','MICHEL','1936-06-05','02.27.03.32.87','06.74.05.05.28',NULL,'13 rue des mineurs','','',NULL,NULL,NULL,NULL,'1360650099001',7.000000000,'1957-07-20','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (515,'BELLANGER','HUBERT','1928-09-15','02.18.91.38.97','06.86.12.20.03',NULL,'9 PLACE PABLO NERUDA','','','14000','CAEN',NULL,NULL,'2280901153001',111.000000000,'1952-05-24','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (516,'CANTELOUP','JEANNE','1946-01-02','02.27.57.42.67','06.10.14.09.35',NULL,'2 rue jugan','','',NULL,NULL,NULL,NULL,'1460150130001',131.000000000,'1974-02-20','GOLD',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (517,'DIVET','Christiane','1968-06-18','02.52.14.61.82','06.35.66.58.26',NULL,'223 IMPASSE DU VILLAGE','','',NULL,NULL,NULL,NULL,'1680661437001',700.000000000,'1996-02-28','PREMIUM',12,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (518,'LE BATARD','ANDREE','1965-02-12','02.44.85.81.77','06.46.91.97.91',NULL,'30 RUE LA FRESNAIE','','','14120','MONDEVILLE',NULL,NULL,'1650214208001',484.000000000,'1986-04-26','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (519,'BLANCHET','JEAN LOUIS','1958-10-06','02.10.92.38.53','06.65.96.73.43',NULL,'11a rue de st aubin sur mer','','','14000','CAEN',NULL,NULL,'1581035238001',163.000000000,'1980-01-30','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (520,'HARDEL','ODETTE','1936-06-28','02.97.15.06.94','06.55.38.14.65',NULL,'17 RUE DU STADE','','',NULL,NULL,NULL,NULL,'1360614268001',1327.000000000,'1960-12-10','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (521,'GENTILETTI','Marie rose','1957-01-22','02.64.36.62.45','06.54.98.94.86',NULL,'607 LES BELLES PORTES','','',NULL,NULL,NULL,NULL,'1570187146001',38.000000000,'1979-09-15','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (522,'CARDONNEL','VALERIE','1950-01-11','02.79.00.81.06','06.84.88.23.88',NULL,'301 HAUTE FOLIE','','',NULL,NULL,NULL,NULL,'1500176390001',4291.000000000,'1975-05-06','PREMIUM',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (523,'MIDY','FREDERIC','1930-04-07','02.57.53.17.65','06.71.60.11.33',NULL,'FERME DE LA PRAIRIE','','',NULL,NULL,NULL,NULL,'1300414118001',37.000000000,'1959-03-18','GOLD',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (524,'GUILLERY','PIERRE','1932-11-10','02.66.68.25.07','06.11.55.50.77',NULL,'5 rue des fleurs','','',NULL,NULL,NULL,NULL,'1321161052001',36.000000000,'1962-02-09','PREMIUM',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (525,'LENOBLE','MICHEL','1949-06-22','02.22.33.46.27','00 33 6.61.40.22.92',NULL,'','','',NULL,NULL,NULL,NULL,'1490614002001',581.000000000,'1978-02-12','PREMIUM',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (526,'LETELLIER','MAXIMILIEN','1952-06-01','02.55.11.52.72','06.38.48.34.93',NULL,'32 RUE DU PONT DU COUDRAY','','',NULL,NULL,NULL,NULL,'1520699350001',98.000000000,'1976-03-08','PREMIUM',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (527,'DANJOU','PIERRE','1930-02-10','02.10.44.25.49','06.89.09.79.79',NULL,'6 rue jean genest','','',NULL,NULL,NULL,NULL,'1300227138001',1469.000000000,'1952-08-04','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (528,'MARIE','JOSETTE',NULL,'02.25.50.33.51','06.11.44.83.41',NULL,'5 RUE DES ROSES','','',NULL,NULL,NULL,NULL,'1340514225001',3.000000000,'2008-01-24','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (529,'CRESTAUX','YVES','1969-10-03','02.15.28.08.27','06.54.68.90.24',NULL,'28 rue des chasses','','',NULL,NULL,NULL,NULL,'2691042187001',3016.000000000,'1991-08-28','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (530,'PROUX','MICHEL','1929-12-06','02.42.81.91.15','06.30.99.14.13',NULL,'4/3 alle des capucines','','',NULL,NULL,NULL,NULL,'2291214207001',201.000000000,'1955-12-04','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (531,'BOCAGE','COLETTE','1936-06-03','02.26.91.75.22','06.20.87.66.08',NULL,'12 RUE  DES SAUTS CABRI','','',NULL,NULL,NULL,NULL,'2360614174001',137.000000000,'1962-10-28','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (532,'LEGER','RAYMOND','1935-08-22','02.43.73.74.42',NULL,NULL,'3 RUE DE BERLIN','','',NULL,NULL,NULL,NULL,'2350814301001',1514.000000000,'1963-01-25','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (533,'CHALTON','EDITH','1929-10-01','02.15.60.24.99','06.68.25.65.43',NULL,'9 RUE DE L ESPERANCE','','',NULL,NULL,NULL,NULL,'2291050621001',498.000000000,'1952-01-20','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (534,'','Genevieve','1935-09-18','02.81.44.30.74',NULL,NULL,'26 ALLEES DES TISSERANDS','','','14000','CAEN',NULL,NULL,'1350950614001',89.000000000,'1956-02-12','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (535,'BARBE','MICHEL','1929-01-23','02.28.28.49.64','06.12.75.09.73',NULL,'4 RUE JEAN MOULIN','','','14123','IFS',NULL,NULL,'1290172142001',31.000000000,'1950-09-05','PREMIUM',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (536,'','GISELE','1938-06-15','02.28.80.06.35','06.49.77.30.34',NULL,'3 RUE GANDHI','','',NULL,NULL,NULL,NULL,'1380650511001',52.000000000,'1967-07-30','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (537,'BOTCAZOU','NICOLE','1940-10-30','02.11.08.13.06','06.11.70.82.18',NULL,'9 rue gandhi','','',NULL,NULL,NULL,NULL,'1401027163001',166.000000000,'1963-11-09','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (538,'DELAUNAY','MARCELLE','1933-05-20','02.11.70.84.35','06.44.13.80.79',NULL,'11 RUE DU PARC','','',NULL,NULL,NULL,NULL,'1330514229001',99.000000000,'1960-10-19','PREMIUM',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (539,'JEANNE','MARGUERITE','1936-06-26','02.11.96.79.13','06.74.30.96.30',NULL,'ROUTE DE LIVAROT','','','14000','CAEN',NULL,NULL,'2360614526001',872.000000000,'1961-06-13','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (540,'JUBAULT','PASCAL','1947-01-21','02.67.31.26.33','06.16.35.95.47',NULL,'35 RUE DU POMMIER GRIS','','',NULL,NULL,NULL,NULL,'1470114233001',386.000000000,'1971-07-25','GOLD',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (541,'RIVIERE','NELLY','1943-04-30','02.26.70.22.89','06.24.42.17.49',NULL,'21 RUE BASSE','','','14000','CAEN',NULL,NULL,'1430414037001',26.000000000,'1966-04-05','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (542,'BOURSIN','GERARD','1940-06-19','02.99.52.88.70','06.46.00.40.48',NULL,'19 RUE JEAN JACQUES ROUSSEAU','','','14840','DEMOUVILLE',NULL,NULL,'1400614296001',15.000000000,'1966-10-04','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (543,'LEMENAGER','GEORGETTE','1946-03-22','02.40.63.90.80','06.37.20.68.19',NULL,'ROUTE DE TILLY SUR SEULLES','','',NULL,NULL,NULL,NULL,'1460350299001',31.000000000,'1970-01-08','GOLD',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (544,'THOMAS','LOUIS','1928-02-14','02.34.70.80.78','06.85.51.20.19',NULL,'','','','14440','DOUVRES LA DELIVRANDE',NULL,NULL,'2280250488001',736.000000000,'1953-01-01','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (545,'CALBRY','JEANNINE','1940-12-29','02.62.51.03.87','06.78.07.62.15',NULL,'1 rue de la coile','','','14000','CAEN',NULL,NULL,'2401214119001',237.000000000,'1962-09-13','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (546,'MESNIL','Angele','1943-01-11','02.65.28.39.69','06.20.83.81.24',NULL,'3 PLACE CLAUDE DE BUSSY','','','14320','ST ANDRE SUR ORNE',NULL,NULL,'1430114090001',982.000000000,'1968-04-13','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (547,'BINET','DENISE','1964-11-14','02.79.76.78.18','06.56.41.11.03',NULL,'40 RUE ERNEST RENAN','','','14000','CAEN',NULL,NULL,'1641199255001',19.000000000,'1986-03-18','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (548,'BINET','SUZANNE','1928-02-27','02.41.30.08.36','06.49.84.52.90',NULL,'57 rue du manoir','','',NULL,NULL,NULL,NULL,'2280214325001',62.000000000,'1951-02-12','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (549,'VOISVENEL','NELLY','1938-05-26','02.11.33.50.39','06.45.64.83.57',NULL,'CHEMIN DE LA CROIX MARIE','','','14540','GARCELLES SECQUEVILLE',NULL,NULL,'2380550465001',145.000000000,'1962-10-17','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (550,'LEBRETHON','FLORENCE','1934-10-28','02.40.91.12.15','06.73.92.12.91',NULL,'LE BOURG','','',NULL,NULL,NULL,NULL,'1341014108001',102.000000000,'1962-02-22','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (551,'MICHEL','SABINE','1933-12-29','02.49.53.93.79','06.15.53.08.45',NULL,'1 le marronnier','','','14200','HEROUVILLE ST CLAIR',NULL,NULL,'1331214664001',4771.000000000,'1955-03-21','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (552,'QUIDOR DIT PASQUET','JOEL','1954-07-22','02.79.03.52.55','06.10.64.25.86',NULL,'34 RUE DE LA MUANCE','','','14000','CAEN',NULL,NULL,'1540714189001',2914.000000000,'1977-04-24','PREMIUM',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (553,'GUELLE','JOCELYNE','1931-09-26','02.27.97.55.12','06.74.88.05.55',NULL,'15 rue charles peggy','','',NULL,NULL,NULL,NULL,'1310961232001',178.000000000,'1957-04-22','PLATINIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (554,'LATINI','HENRIETTE','1933-05-18','02.84.09.91.72','06.11.98.71.96',NULL,'roucamps','','',NULL,NULL,NULL,NULL,'2330514378001',86.000000000,'1954-11-24','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (555,'LITHARD','JEAN CLAUDE','1940-05-29','02.84.74.64.92',NULL,NULL,'19 RUE DU STADE','','',NULL,NULL,NULL,NULL,'2400527045001',15.000000000,'1970-03-14','SILVER',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (556,'MESNIL','SERGE','1928-06-01','02.11.93.05.08','06.45.80.11.80',NULL,'23 RUE DE LA BIENFAISANCE','','',NULL,NULL,NULL,NULL,'2280614276001',105.000000000,'1956-01-13','PREMIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (557,'MORIN','DANIEL',NULL,'02.49.70.94.20','06.22.21.35.25',NULL,'6 RUE JULES FLAMBARD','','','14120','MONDEVILLE',NULL,NULL,'2410214038001',41.000000000,'2008-04-22','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (558,'DETRAIN','LYDIE','1932-03-22','02.11.28.02.91','06.85.75.67.20',NULL,'LE MOULIN DE FRESNAY','','',NULL,NULL,NULL,NULL,'2320350051001',192.000000000,'1961-07-09','GOLD',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (559,'VEREL','FRANCOISE','1940-04-12','02.19.92.30.52','06.75.31.39.94',NULL,'6 RUE DE SAINT HILAIRE','','','14370','CHICHEBOVILLE',NULL,NULL,'1400414071001',375.000000000,'1962-11-21','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (560,'CAILLY','PAULETTE','1943-04-27','02.76.98.71.34','06.82.65.41.43',NULL,'7 rue des castors','','','14400','BAYEUX',NULL,NULL,'2430461039001',142.000000000,'1971-02-01','SILVER',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (561,'VIVIEN','PATRICK','1932-01-12','02.95.89.40.65','06.12.61.74.01',NULL,'61 RUE LOUIS LE CHATELIER','','',NULL,NULL,NULL,NULL,'2320114499001',1498.000000000,'1957-12-12','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (562,'KOPER','MARIE LINE','1958-01-31','02.70.34.32.59','06.21.94.81.11',NULL,'9 RUE CHEMIN AUX BOEUFS','','',NULL,NULL,NULL,NULL,'1580153013001',90.000000000,'1979-05-25','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (563,'ANDRISIK','SERGE','1929-01-05','02.62.43.06.87','06.54.33.35.39',NULL,'3 IMPASSE DES BLEUETS','','',NULL,NULL,NULL,NULL,'2290114553001',18.000000000,'1959-09-08','PREMIUM',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (564,'COCHARD','MARTIAL','1980-12-09','02.60.11.68.46','06.82.92.97.21',NULL,'3 RUE ST GILLES','','',NULL,NULL,NULL,NULL,'1801299255001',98.000000000,'2009-06-05','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (565,'GRARD','CHARLOTTE','1938-09-13','02.41.39.01.41','06.65.26.43.96',NULL,'53 RUE J VILAR','','','14000','CAEN',NULL,NULL,'2380972066001',266.000000000,'1962-07-12','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (566,'MANCHON','LUCIEN','1932-12-18','02.52.60.78.04','06.45.32.48.35',NULL,'8 RUE LEONARD GILLES','','',NULL,NULL,NULL,NULL,'1321214497001',59.000000000,'1956-09-08','PLATINIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (567,'FESTOC','GERMAIN','1934-06-10','02.59.30.88.80','06.21.05.49.83',NULL,'HAMEAU VALETTE','','','14000','CAEN',NULL,NULL,'1340661303001',221.000000000,'1963-08-29','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (568,'WALKER','GUSTAVE','1938-01-19','02.83.00.57.32','06.71.71.28.67',NULL,'22 RUE ALFRED CASSIGNEUL','','','14123','CORMELLES LE ROYAL',NULL,NULL,'1380114100001',38.000000000,'1959-06-07','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (569,'LOREL','JACQUELINE','1938-04-04','02.92.94.44.79','06.21.31.34.82',NULL,'5 RUE DES PRES','','','14123','CORMELLES LE ROYAL',NULL,NULL,'1380422162001',2.000000000,'1959-12-30','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (570,'ALIX','BERNARD','1936-10-05','02.47.09.11.67','06.34.03.57.41',NULL,'15 BD A BRIAND','','','14540','BOURGUEBUS',NULL,NULL,'2361014076001',929.000000000,'1961-02-25','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (571,'GERMOND','AIME','1945-01-25','02.50.11.57.97','00 33 6.75.92.94.53',NULL,'BATIMENT U RESIDENCE COLBERT','','','14630','FRENOUVILLE',NULL,NULL,'2450114549001',26.000000000,'1967-08-30','GOLD',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (572,'BOISSEL','MARIANNE','1932-11-03','02.88.53.12.23','06.90.16.85.74',NULL,'68  ROUTE DE LA GUERINIERE','','',NULL,NULL,NULL,NULL,'1321114672001',366.000000000,'1958-02-05','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (573,'FONTAINE','lucien','1932-03-27','02.87.51.33.83','06.91.83.73.77',NULL,'24 RUE DE RONCEVAUX','','',NULL,NULL,NULL,NULL,'1320314468001',50.000000000,'1955-01-05','PREMIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (574,'FONTAINE','MARTIAL','1940-12-31','02.42.97.09.95','06.10.20.35.30',NULL,'6 RUE DU 8 MAI','','',NULL,NULL,NULL,NULL,'2401214118001',796.000000000,'1970-07-04','SILVER',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (575,'LOREL','JULIEN','1953-01-22','02.38.83.87.12','06.11.46.90.25',NULL,'11 RUE DES PRIMEVERES','','','14000','CAEN',NULL,NULL,'2530114099001',982.000000000,'1975-05-21','PREMIUM',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (576,'LENORAIS','BERNARD','1948-03-23','02.34.98.77.84','06.65.07.18.51',NULL,'1 RUE CLOS DU CAPRICE','','','14123','IFS',NULL,NULL,'1480314164001',163.000000000,'1973-02-22','GOLD',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (577,'LEMARCHAND','THERESE','1962-02-14','02.10.82.41.09','06.81.46.59.31',NULL,'19 RUE MAURICE LAFON','','',NULL,NULL,NULL,NULL,'2620214213001',31.000000000,'1987-09-04','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (578,'LAUNAY','LOUIS','1938-05-03','02.42.06.81.09','06.56.18.46.81',NULL,'38 RUE SALVADOR ALLENDE','','',NULL,NULL,NULL,NULL,'1380561040001',218.000000000,'1961-01-07','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (579,'LECANU','STEPHANE','1936-04-28','02.10.80.03.54','06.13.10.65.80',NULL,'544 rue du chemin vert','','','14000','CAEN',NULL,NULL,'1360414657001',35.000000000,'1960-08-27','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (580,'LE ROUX','STEPHANE','1955-03-15','02.20.06.78.58','06.42.87.33.48',NULL,'1 rue des clematires','','','14860','RANVILLE',NULL,NULL,'2550314294001',1907.000000000,'1977-02-18','PREMIUM',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (581,'LEROUX','BERNADETTE','1957-01-04','02.20.10.99.00','06.51.43.39.19',NULL,'1 rue claude debussy','','','14370','MOULT',NULL,NULL,'1570114530001',535.000000000,'1987-11-24','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (582,'MOREL','SERGE','1931-03-30','02.99.99.45.19','06.86.27.67.41',NULL,'RUE DES COMMERCES','','','50130','OCTEVILLE',NULL,NULL,'1310314291001',80.000000000,'1956-01-24','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (583,'PERREE','FREDERIC','1937-12-18','02.78.41.24.97','06.98.43.10.89',NULL,'','','','50680','AIREL',NULL,NULL,'1371214410001',90.000000000,'1966-09-19','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (584,'BILLANT','FREDERIC','1952-04-13','02.21.89.37.14','06.30.52.43.28',NULL,'1 rue des mesanges','','','14400','BAYEUX',NULL,NULL,'2520414170001',25.000000000,'1976-09-05','PREMIUM',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (585,'LE PASTEUR','JEAN CLAUDE','1966-03-18','02.61.48.58.46','06.73.94.98.97',NULL,'Rue de Picardie','','','14000','CAEN',NULL,NULL,'1660314453001',1413.000000000,'1988-09-15','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (586,'','GUY','1936-12-30','02.67.49.02.39','06.74.98.24.51',NULL,'35 GRANDE RUE','','','14730','GIBERVILLE',NULL,NULL,'2361214400001',105.000000000,'1959-05-20','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (587,'GUILLOT','JACQUES','1923-08-10','02.11.77.77.05','06.12.22.94.95',NULL,'7 rue du lavoir','','','14000','CAEN',NULL,NULL,'1230850394001',16.000000000,'1953-12-31','PREMIUM',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (588,'CONTENTIN','ELIANE','1928-03-07','02.56.72.32.52','06.35.16.59.26',NULL,'24 RUE GEORGES HARRISON','','','14840','DEMOUVILLE',NULL,NULL,'2280314282001',73.000000000,'1950-05-15','PREMIUM',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (589,'VIEL','Sylvie','1952-02-13','02.50.48.27.91','06.55.89.39.94',NULL,'7 RUE DES PRIMEVERES','','','50740','CAROLLES',NULL,NULL,'1520214545001',2064.000000000,'1980-06-10','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (590,'HANOUET','CHRISTIANE','1950-10-19','02.58.76.38.46','06.69.72.72.32',NULL,'47 rue du port','','','14000','CAEN',NULL,NULL,'1501014018001',355.000000000,'1974-03-15','PREMIUM',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (591,'LE GARGAM','HUBERT',NULL,'02.34.88.32.08','06.40.09.65.65',NULL,'27 rue des acacias','','','14000','CAEN',NULL,NULL,'1430214470001',94.000000000,'2012-05-11','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (592,'','AUGUSTE','1928-09-10','02.93.00.49.91','06.11.23.64.95',NULL,'3 av des clairieres','','','14760','BRETTEVILLE SUR ODON',NULL,NULL,'2280922054001',49.000000000,'1952-01-27','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (593,'LAURENT','FRANCIS','1928-09-29','02.26.77.59.48','06.10.60.45.68',NULL,'10 RUE SULLY','','','14123','CORMELLES LE ROYAL',NULL,NULL,'2280922054001',24.000000000,'1951-11-06','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (594,'CORDRAY','JEAN FRANCOIS','1952-01-30','02.60.66.59.53','06.24.35.86.97',NULL,'1 ALLEE DES JARDINS','','','14123','CORMELLES LE ROYAL',NULL,NULL,'1520114654001',986.000000000,'1973-07-01','PREMIUM',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (595,'LIETOT','LOUIS','1935-04-12','02.55.55.33.58','06.56.57.18.58',NULL,'','','','50560','GEFFOSSES',NULL,NULL,'1350475116001',1338.000000000,'1959-01-27','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (596,'LAROSE','','1940-04-27','02.91.95.44.18','06.22.04.24.27',NULL,'1 allee louis edouard garrido','','','14123','CORMELLES LE ROYAL',NULL,NULL,'1400436087001',77.000000000,'1967-09-04','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (597,'LEGRIX','ELISABETH','1937-03-16','02.66.68.55.70','06.69.01.39.32',NULL,'1 RUE DES HORTENSIAS','','',NULL,NULL,NULL,NULL,'1370314437001',154.000000000,'1963-08-25','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (598,'BROSSON','JEAN','1935-04-10','02.76.25.67.83','06.25.88.43.88',NULL,'2 CLOS DU MONASTERE','','',NULL,NULL,NULL,NULL,'1350414325001',4284.000000000,'1963-09-21','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (599,'LEPAISANT','MIREILLE',NULL,'02.65.84.17.31','06.46.44.56.24',NULL,'4 RUE PIERRE DE RONSARD','','','14200','HEROUVILLE ST CLAIR',NULL,NULL,'2430114011001',31.000000000,'2012-02-06','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (600,'HOLLEY','',NULL,'02.72.15.79.12','06.94.68.07.24',NULL,'18 Bis Place du Marchand','','','14000','CAEN',NULL,NULL,'1520214090001',377.000000000,'2010-09-28','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (601,'LETELLIER','PATRICIA','1932-08-28','02.29.19.19.18','06.11.83.34.80',NULL,'TERCEI','','','14123','FLEURY SUR ORNE',NULL,NULL,'2320853159001',18.000000000,'1953-10-28','PREMIUM',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (602,'HOUEIX','PAULETTE','1932-06-14','02.73.23.76.10','06.61.18.11.47',NULL,'5 rue louis lachenal','','','14630','FRENOUVILLE',NULL,NULL,'1320614106001',418.000000000,'1956-06-18','PREMIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (603,'LELANDAIS','THERESE',NULL,'02.81.21.56.83','06.80.79.89.75',NULL,'9 RUE MAURICE ARROT','','',NULL,NULL,NULL,NULL,'2310880706001',204.000000000,'2010-11-25','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (604,'DUVERNOIS','jean','1933-09-23','02.90.89.11.50','06.70.17.77.14',NULL,'CAREL ROUTE DE FALAISE','','','14320','MAY SUR ORNE',NULL,NULL,'1330914666001',91.000000000,'1956-07-29','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (605,'AUMONT','z','1964-01-30','02.57.08.47.47','06.82.80.24.50',NULL,'3 RUE DE L''EGLISE','','','14320','MAY SUR ORNE',NULL,NULL,'2640114290001',205.000000000,'1986-04-12','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (606,'VIGNOLLES','PIERRETTE','1931-06-17','02.34.22.63.41','06.42.45.40.99',NULL,'7 RUE HELENE BOUCHER','','',NULL,NULL,NULL,NULL,'1310614124001',51.000000000,'1954-10-15','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (607,'LATOUR','VALERIE','1958-01-28',NULL,NULL,NULL,'10 avenue de cabourg','','',NULL,NULL,NULL,NULL,'1580114668001',36.000000000,'1981-04-11','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (608,'BESNIER','GILBERTE','1961-01-13','02.24.81.00.62','06.10.14.19.26',NULL,'61 RUE VICTOR LEPINE','','',NULL,NULL,NULL,NULL,'2610150547001',2640.000000000,'1983-06-14','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (609,'LECOQ','ROLAND','1966-01-18','02.44.36.00.53','06.17.52.77.08',NULL,'LES TILLEUILS','','','14740','PUTOT EN BESSIN',NULL,NULL,'1660114246001',3048.000000000,'1987-06-18','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (610,'LECARPENTIER','GILBERT','1936-02-13','02.61.37.44.75','06.56.61.71.95',NULL,'11 RUE PAUL LANGEVIN','','','14680','GOUVIX',NULL,NULL,'1360214411001',413.000000000,'1957-12-05','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (611,'GASSON','ROGER','1938-07-20','02.11.89.16.43','06.38.48.37.77',NULL,'1 RUE MICHEL LASNE','','',NULL,NULL,NULL,NULL,'2380714364001',1333.000000000,'1968-10-29','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (612,'QUIQUEMELLE','TUBO','1937-02-05','02.57.01.48.42','06.75.67.73.21',NULL,'1 rue de troarn','','',NULL,NULL,NULL,NULL,'1370214565001',1535.000000000,'1964-08-16','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (613,'FAINE','RAYMOND','1929-07-23','02.46.99.85.73','06.10.72.33.55',NULL,'5 rue bulletieres','','',NULL,NULL,NULL,NULL,'1290714050001',41.000000000,'1959-08-04','GOLD',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (614,'COADOU','THIERRY','1934-02-27','02.89.31.34.83','06.83.94.00.04',NULL,'7 route de bretagne','','','14123','CORMELLES LE ROYAL',NULL,NULL,'1340214672001',101.000000000,'1955-10-17','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (615,'DESCHAMPS','CHRISTIANE',NULL,'02.76.29.25.48','06.43.91.65.10',NULL,'24 RUE MAURICE GENEVOIX','','',NULL,NULL,NULL,NULL,'2321253127001',114.000000000,'2009-09-19','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (616,'LEBEDEL','BRIGITTE','1933-06-19','02.83.27.61.82','06.70.82.87.95',NULL,'26 RUE DES DRAKKARS','','','14610','CAIRON',NULL,NULL,'2330614221001',468.000000000,'1959-02-10','PREMIUM',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (617,'VALLEE','MAURICE','1933-08-20','02.29.41.96.80','06.73.24.18.09',NULL,'1 RUE EDMOND GOMBAUX','','','14320','FONTENAY LE MARMION',NULL,NULL,'1330850268001',28.000000000,'1963-09-18','GOLD',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (618,'PICQUENARD','MARCEL','1953-03-29','02.87.85.40.99','06.12.21.37.50',NULL,'LE MESNIL AU GRAIN','','',NULL,NULL,NULL,NULL,'2530314247001',76.000000000,'1974-09-04','PREMIUM',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (619,'DELBRAYELLE','LOUIS','1929-03-18',NULL,NULL,NULL,'8 RUE DE LA CHAUSSEE','','',NULL,NULL,NULL,NULL,'2290350160001',7.000000000,'1954-07-08','PREMIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (620,'ROCHER','MARCELLE','1929-12-24','02.10.81.34.17','06.35.18.80.41',NULL,'144 BD LEROY','','','14370','MOULT',NULL,NULL,'2291261287001',166.000000000,'1956-10-14','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (621,'MOCQUES','MARGUERITE','1970-03-05','02.11.80.90.36','06.46.66.17.15',NULL,'RUE DE GLATIGNY','','','14630','CAGNY',NULL,NULL,'1700399255001',2936.000000000,'1998-05-12','PREMIUM',12,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (622,'PIQUOT','MADELEINE','1929-12-22','02.64.40.61.83','06.55.00.50.65',NULL,'24 BLD DE LA HAGUE','','','14000','CAEN',NULL,NULL,'2291214685001',103.000000000,'1953-09-16','PREMIUM',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (623,'BEAUGEARD','CHANTAL','1939-08-03','02.54.36.32.04','06.39.77.58.80',NULL,'55 RUE DE LA PIGACIERE','','','53220','PONTMAIN',NULL,NULL,'1390814489001',174.000000000,'1962-09-16','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (624,'HEBERT','PIERRE GEORGES','1957-07-12','02.10.52.33.88','06.11.26.75.13',NULL,'LE PARC DAVOUST','','','14000','CAEN',NULL,NULL,'1570750138001',405.000000000,'1985-09-22','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (625,'ABED BAHTSOU','THERESE EUGENIE','1934-02-24','02.59.82.74.68',NULL,NULL,'','','','14200','HEROUVILLE ST CLAIR',NULL,NULL,'2340250261001',162.000000000,'1958-12-08','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (626,'MONTAJAULT','MARIE LOUI','1958-10-19','02.23.01.11.69','06.22.59.87.62',NULL,'22 bis rue du jardin','','','14800','TOUQUES',NULL,NULL,'1581014499001',13.000000000,'1984-09-01','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (627,'LECOQ','GISELE','1964-11-08','02.28.81.87.40','06.21.88.68.23',NULL,'7 rue des accacias','','','14220','BARBERY',NULL,NULL,'1641199255001',2182.000000000,'1988-08-10','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (628,'HEBERT','YVES','1938-03-01','02.25.38.83.27','06.85.48.62.51',NULL,'','','','14000','CAEN',NULL,NULL,'1380314517001',35.000000000,'1965-12-13','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (629,'LERICHE','JEAN CLAUDE','1930-12-30','02.48.35.95.52','06.58.71.44.07',NULL,'16 rue erik satie','','','14000','CAEN',NULL,NULL,'2301250080001',1365.000000000,'1953-12-25','PREMIUM',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (630,'BETTE','JEAN CLAUDE','1969-07-13','02.50.63.76.72','06.91.66.80.38',NULL,'3 RUE DES MERISIERS','','','61100','FLERS',NULL,NULL,'1690714109001',207.000000000,'1990-12-14','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (631,'BLANCHERIE','NICOLLE','1944-05-15','02.88.60.45.70','06.22.48.91.65',NULL,'2 allee cl hamelin','','','14840','CUVERVILLE',NULL,NULL,'1440561304001',35.000000000,'1966-03-03','GOLD',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (632,'SEILLIER','CHANTAL','1944-05-24','02.52.86.15.19','06.80.29.72.79',NULL,'1 rue a richard','','','14150','OUISTREHAM',NULL,NULL,'1440561304001',87.000000000,'1970-09-10','GOLD',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (633,'JACQ','SERGE','1934-12-07','02.13.53.62.22','06.62.48.21.51',NULL,'18 rue barbeux','','','14320','MAY SUR ORNE',NULL,NULL,'1341277070001',97.000000000,'1955-02-04','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (634,'PASNEL','ANNE MARIE','1950-01-05','02.64.37.10.31','06.50.15.68.59',NULL,'LA SAUVEGARDE','','','14112','BIEVILLE BEUVILLE',NULL,NULL,'1500114173001',0.000000000,'1973-09-05','PREMIUM',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (635,'LACROIX','NOEL','1945-06-12','02.17.31.89.15','00 33 6.58.24.74.14',NULL,'LA VALLEE','','','14630','FRENOUVILLE',NULL,NULL,'1450614404001',205.000000000,'1968-04-26','GOLD',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (636,'RIVIERE','','1936-01-04','02.32.67.89.37','06.95.02.30.38',NULL,'33 RUE GEORGES GAILLARD','','','14320','ST MARTIN DE FONTENAY',NULL,NULL,'2360150180001',89.000000000,'1959-03-13','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (637,'BACON','JEAN CLAUDE','1940-04-13','02.91.01.25.85','06.70.85.34.34',NULL,'15 rue du dr derrien','','','14000','CAEN',NULL,NULL,'1400414506001',402.000000000,'1964-06-30','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (638,'BACON','NATHALIE','1935-10-14','02.60.25.19.00','06.82.41.45.56',NULL,'27 RTE DE PERRIERS','','','14320','ST MARTIN DE FONTENAY',NULL,NULL,'1351014368001',1287.000000000,'1963-04-04','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (639,'LECORDIER','ODETTE','1943-08-30','02.56.37.75.79','06.61.18.40.21',NULL,'2 RUE J GUESDES','','','14123','FLEURY SUR ORNE',NULL,NULL,'1430814298001',174.000000000,'1964-02-04','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (640,'GORIN','BERNARD','1940-09-07','02.60.10.63.18','06.50.91.82.48',NULL,'7 RUE DU CLOS ST GILLES','','','14250','AUDRIEU',NULL,NULL,'2400914439001',348.000000000,'1962-08-05','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (641,'LEDAIN','JEANNINE','1950-02-22','02.55.22.28.73','06.56.93.20.04',NULL,'LES ECOUVIARIES','','','14200','HEROUVILLE ST CLAIR',NULL,NULL,'2500261444001',2.000000000,'1973-09-01','PREMIUM',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (642,'CAILLON','HUGUETTE','1949-03-12','02.80.00.83.33','06.29.08.72.87',NULL,'13 RUE DU VIEUX PRESSOIR','','',NULL,NULL,NULL,NULL,'1490399134001',130.000000000,'1971-12-28','PREMIUM',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (643,'TIRARD','BEATRICE','1945-01-12','02.11.92.74.26',NULL,NULL,'13 RUE  HARRY HAWKINS','','','50150','SOURDEVAL',NULL,NULL,'2450150597001',10.000000000,'1969-01-10','GOLD',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (644,'BRIENS','MOISE','1934-05-14',NULL,NULL,NULL,'20 AVENUE LOUIS TOUSSAINT','','',NULL,NULL,NULL,NULL,'1340527367001',2783.000000000,'1955-08-08','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (645,'DEVAUX','JACQUES','1932-11-07','02.20.61.51.40','06.61.94.06.80',NULL,'22 RUE D''AMOZANE','','',NULL,NULL,NULL,NULL,'2321161070001',228.000000000,'1960-01-18','GOLD',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (646,'PERRETTE','HUGUETTE','1935-07-06','02.12.01.44.38','06.70.51.19.00',NULL,'19 impasse des roses','','',NULL,NULL,NULL,NULL,'1350714659001',1165.000000000,'1958-01-17','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (647,'MELINOU','LUCIENNE','1931-04-18','02.59.40.70.15','06.98.47.43.17',NULL,'3 AVENUE D''HARCOURT','','',NULL,NULL,NULL,NULL,'1310414357001',10.000000000,'1960-10-27','PREMIUM',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (648,'KARWECKI','RAYMONDE','1938-08-25','02.10.56.06.63','06.12.04.90.92',NULL,'2-4 rue de l''arbalete','','','14123','IFS',NULL,NULL,'1380814357001',191.000000000,'1966-04-03','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (649,'IVON','RAYMONDE','1964-01-15','02.71.27.06.59','00 33 6.66.26.14.25',NULL,'7 RUE DE LA CHARMILLE','','','14111','LOUVIGNY',NULL,NULL,'2640114437001',520.000000000,'1993-11-30','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (650,'PIGEON','ANNICK','1932-12-21','02.19.55.54.49','06.45.68.22.44',NULL,'11 rue georges clemenceau','','','14000','CAEN',NULL,NULL,'2321261093001',167.000000000,'1958-06-06','PLATINIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (651,'QUERE','GASTON','1935-10-06','02.49.25.76.49','06.50.18.56.06',NULL,'36 RUE DE L''EGLISE','','',NULL,NULL,NULL,NULL,'2351014268001',830.000000000,'1964-01-09','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (652,'GAUTHIER','JEAN CLAUDE','1939-02-10','02.11.87.18.85','06.12.33.40.54',NULL,'272 RUE DU VIEU PAITIS','','',NULL,NULL,NULL,NULL,'1390250636001',85.000000000,'1960-01-22','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (653,'TEISSEDRE','PIERRE','1933-09-28','02.33.24.29.20','06.31.01.09.11',NULL,'10 IMPASSE DU 14 JUIN','','','14320','FEUGUEROLLES BULLY',NULL,NULL,'1330950066001',6.000000000,'1958-07-02','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (654,'PATRIX','JACQUELINE','1939-08-27','02.84.43.21.74',NULL,NULL,'141 BD DE FRANCE','','',NULL,NULL,NULL,NULL,'1390814100001',199.000000000,'1960-09-25','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (655,'LEU','MAURICE','1964-08-05','02.10.47.73.78','06.75.92.21.28',NULL,'4 RUE CAMILLE DEMOULIN','','',NULL,NULL,NULL,NULL,'2640814251001',312.000000000,'1994-10-13','PREMIUM',12,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (656,'GUESNON','DENISE','1938-07-26',NULL,NULL,NULL,'10 RUE DE MOLIERE','','',NULL,NULL,NULL,NULL,'1380714217001',48.000000000,'1960-05-28','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (657,'LEGRAND','','1963-02-27','02.92.48.30.25','06.34.52.59.66',NULL,'CHEMIN DE LA CROIX AUX NOBLES','','','14000','CAEN',NULL,NULL,'2630214308001',76.000000000,'1987-04-11','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (658,'LETHIMONNIER OUDIN','CLAUDE','1932-07-19','02.11.69.10.01','06.63.74.22.72',NULL,'62 AVENUE DE LA MER','','','14123','CORMELLES LE ROYAL',NULL,NULL,'1320714266001',770.000000000,'1958-05-21','PREMIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (659,'PISTIS','JOSEPH','1939-11-21','02.10.19.05.58','06.37.99.78.43',NULL,'23 RUE DU RUEL','','','14000','CAEN',NULL,NULL,'2391114241001',37.000000000,'1964-01-04','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (660,'LE THIMONNIER','JEAN','1933-10-18','02.77.06.33.24','06.79.29.88.81',NULL,'5 RUE OBLOND','','',NULL,NULL,NULL,NULL,'1331050214001',209.000000000,'1958-06-05','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (661,'MARCINKOWSKI','BERNARD','1967-04-26','02.77.10.87.81','06.89.54.39.96',NULL,'RUE DES SITELLES','','',NULL,NULL,NULL,NULL,'2670489460001',41.000000000,'1997-06-09','PREMIUM',12,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (662,'LECHASLES','YVETTE','1940-02-24','02.89.09.62.86','06.61.29.28.25',NULL,'RES BEL AIR 22 RUE DU DR ROUX','','','14220','BOULON',NULL,NULL,'1400214437001',22.000000000,'1964-07-23','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (663,'VOISIN','CLAUDE','1940-01-03','02.10.66.49.93','06.12.01.02.46',NULL,'LE BOURG','','','14220','ESPINS',NULL,NULL,'2400114274001',1352.000000000,'1969-07-12','SILVER',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (664,'ROSTAING','THERESE','1941-01-13','02.71.07.53.64','06.10.63.71.60',NULL,'LE BEL AIR','','',NULL,NULL,NULL,NULL,'2410114284001',86.000000000,'1965-01-01','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (665,'FEREY','MICHEL','1928-05-19','02.76.82.92.38','06.63.07.62.97',NULL,'LA PLANCHE A LA HOUSSE','','',NULL,NULL,NULL,NULL,'2280514659001',1753.000000000,'1952-10-30','PREMIUM',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (666,'ANNE','ANDRE','1932-09-22','02.26.79.23.18','06.28.75.68.22',NULL,'48 rue des caillouins','','',NULL,NULL,NULL,NULL,'2320914060001',0.000000000,'1959-10-18','GOLD',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (667,'ALIX','ALBERT','1938-12-30','02.11.71.86.23','06.44.95.52.63',NULL,'9 RUE DU CLOS NEUF','','',NULL,NULL,NULL,NULL,'2381250025001',2495.000000000,'1959-11-04','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (668,'GARNIER','NICOLE','1959-02-03','02.77.75.47.47','06.37.53.00.49',NULL,'6 av guy de maupassant','','',NULL,NULL,NULL,NULL,'2590214556001',32.000000000,'1982-04-19','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (669,'DUDOUET-MALASSIS','','1942-01-10','02.34.28.82.79','06.67.14.46.12',NULL,'51 rue du pont crion','','','14210','GRAINVILLE SUR ODON',NULL,NULL,'1420117358001',123.000000000,'1970-06-08','SILVER',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (670,'CHORON','DOMINIQUE','1930-08-06','02.81.15.29.49','06.35.84.16.36',NULL,'4 rue leon guigne','','',NULL,NULL,NULL,NULL,'1300883099001',333.000000000,'1960-10-01','GOLD',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (671,'PATARD','LUCIEN','1967-04-21','02.74.53.95.54',NULL,NULL,'41 rue d''alencon','','','14780','LION SUR MER',NULL,NULL,'2670414356001',330.000000000,'1989-12-15','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (672,'DESMEULLES','PASCAL','1938-11-09','02.16.46.52.53','06.80.43.05.81',NULL,'6 AVENUE DU PRESIDENT COTY','','',NULL,NULL,NULL,NULL,'2381161316001',569.000000000,'1963-02-28','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (673,'OSMOND','DANIEL','1967-05-23','02.57.70.70.06','06.16.23.76.71',NULL,'8 rue du hennin','','',NULL,NULL,NULL,NULL,'1670514197001',42.000000000,'1997-11-23','PREMIUM',12,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (674,'LEMIERE','GILLES','1945-01-29','02.51.55.26.75','06.53.41.00.81',NULL,'9 LE COUDRAY','','','14123','CORMELLES LE ROYAL',NULL,NULL,'1450114140001',77.000000000,'1975-06-29','GOLD',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (675,'','PIERRE','1933-08-23','02.19.31.23.49','06.43.97.42.90',NULL,'24 BIS ROUTE D''HARCOURT','','','14123','CORMELLES LE ROYAL',NULL,NULL,'1330814335001',74.000000000,'1963-05-12','PREMIUM',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (676,'CAPDEPON','RENE','1965-05-03','02.21.13.97.92','06.31.04.94.21',NULL,'4 RUE PIERRE DE RONSARD','','',NULL,NULL,NULL,NULL,'2650514166001',544.000000000,'1987-02-19','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (677,'LEFEVRE','MARCEL','1939-05-10','02.12.03.50.11','06.11.74.51.05',NULL,'2 RUE DE LA POUDRIERE','','',NULL,NULL,NULL,NULL,'2390550530001',38.000000000,'1965-01-22','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (678,'BERTAU','Alain','1935-01-01','02.30.78.67.66','06.13.34.55.58',NULL,'LA FONTAINE BALAN','','',NULL,NULL,NULL,NULL,'2350161017001',87.000000000,'1961-10-28','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (679,'AVICE','ANDRE','1935-09-04','02.36.57.38.15','06.77.95.76.97',NULL,'4 RUE DU SOIR','','','14610','THAON',NULL,NULL,'2350972155001',761.000000000,'1956-05-08','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (680,'NOWICKI','DANIELLE','1931-02-15','02.42.39.81.22','+ 33 6.68.51.39.67',NULL,'10 RUE DE MARIVAUX','','','14840','CUVERVILLE',NULL,NULL,'1310214111001',1373.000000000,'1958-01-28','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (681,'LIGERON','ANDRE','1935-11-30','02.33.52.90.73','06.82.87.60.55',NULL,'16 rue des renardieres','','','14000','CAEN',NULL,NULL,'2351114367001',178.000000000,'1956-10-23','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (682,'GUILLEMETTE','JOSEPH','1929-01-20','02.83.29.94.33','06.74.12.84.64',NULL,'LAUNAY','','','27470','SERQUIGNY',NULL,NULL,'2290163162001',621.000000000,'1959-04-14','PLATINIUM',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (683,'CARRE','daniel','1933-03-19','02.68.17.02.93','06.10.61.59.86',NULL,'6 CHEMIN DE GRUCHY','','',NULL,NULL,NULL,NULL,'1330314346001',33.000000000,'1954-05-09','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (684,'LENFANT','MARCEL','1930-02-18','02.85.38.42.05','06.10.65.08.06',NULL,'6 DOMAINE','','','50620','ST FROMOND',NULL,NULL,'1300250195001',2244.000000000,'1960-02-02','GOLD',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (685,'MACHU','GHISLAINE','1940-03-08','02.15.18.71.23','06.11.57.27.38',NULL,'LA COUR DES MARETTES','','','14940','TOUFFREVILLE',NULL,NULL,'2400350592001',116.000000000,'1963-10-09','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (686,'VARDON','NADINE','1940-08-03','02.39.08.67.98','06.12.06.23.05',NULL,'9 bvd de la charite','','',NULL,NULL,NULL,NULL,'1400819134001',596.000000000,'1970-10-18','SILVER',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (687,'FRIGOULT','MARIE JOSEPHE','1939-11-12','02.31.54.65.57','06.35.70.25.24',NULL,'9 RUE DU 18 JUIN','','','14000','CAEN',NULL,NULL,'1391114429001',82.000000000,'1960-06-02','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (688,'GRIMAULT','JEAN DOMINIQUE','1936-04-02','02.87.94.33.33','06.19.91.47.81',NULL,'1 RUE GEORGES CAZIN','','','14000','CAEN',NULL,NULL,'1360414107001',98.000000000,'1966-10-03','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (689,'PHILIPPE','ODILE','1933-07-27','02.74.79.01.23',NULL,NULL,'LE BAS DU VEY','','','14550','BLAINVILLE SUR ORNE',NULL,NULL,'2330714453001',96.000000000,'1960-07-09','PLATINIUM',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (690,'','BERNARD','1931-06-13','02.10.32.03.70','06.54.61.60.22',NULL,'42 bd georges pompidou','','','14120','MONDEVILLE',NULL,NULL,'2310661424001',600.000000000,'1956-01-11','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (691,'FONNARD','LUCIENNE','1954-03-24','02.53.49.38.82','06.87.17.39.70',NULL,'4 RUE DES SOURCES','','','14930','MALTOT',NULL,NULL,'2540314057001',8.000000000,'1979-07-08','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (692,'LAHAYE','Agnes','1935-07-17','02.11.32.29.75','06.11.55.20.93',NULL,'97 RUE DES ACACIAS','','',NULL,NULL,NULL,NULL,'1350714568001',27.000000000,'1958-03-11','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (693,'VOYER','MARIE CLAUDE','1951-03-06','02.63.54.05.46','06.45.92.34.15',NULL,'16 RUE DES CANADIENS','','',NULL,NULL,NULL,NULL,'1510350234001',813.000000000,'1972-04-01','PREMIUM',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (694,'GUERIN','DANIEL','1932-01-04','02.17.31.25.77','06.39.44.24.25',NULL,'6 RUE DU BEL AIR','','','14360','TROUVILLE SUR MER',NULL,NULL,'2320114408001',3.000000000,'1954-07-25','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (695,'FISCHER','DANIEL','1969-07-10','02.70.21.57.10','06.67.19.59.58',NULL,'8 RUE LEON BLUM','','',NULL,NULL,NULL,NULL,'1690714109001',408.000000000,'1990-07-26','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (696,'MORIN','','1937-01-30','02.11.72.72.64','06.47.01.87.75',NULL,'1 RUE ST ANDRE','','',NULL,NULL,NULL,NULL,'2370161192001',5058.000000000,'1958-07-04','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (697,'DENOYES','marguerite','1930-01-04','02.64.51.87.56','06.44.07.28.95',NULL,'CHEMIN DES MARAIS','','',NULL,NULL,NULL,NULL,'1300150214001',458.000000000,'1951-12-13','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (698,'COLLET','DOMINIQUE','1953-06-12','02.69.25.98.87','06.37.74.95.32',NULL,'13 RUE DE LA REPUBLIQUE','','','14123','CORMELLES LE ROYAL',NULL,NULL,'2530661291001',89.000000000,'1974-01-21','PREMIUM',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (699,'DENIER','MARTHE','1929-10-18','02.34.28.16.31','06.60.90.58.85',NULL,'144 BD LEROY','','','14680','BRETTEVILLE SUR LAIZE',NULL,NULL,'2291014408001',192.000000000,'1951-07-21','PREMIUM',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (700,'SYRYN','VERONIQUE','1933-02-22','02.30.70.06.95','06.94.66.82.79',NULL,'34 rue de cormelles','','',NULL,NULL,NULL,NULL,'1330214348001',720.000000000,'1960-05-15','PREMIUM',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (701,'DUCHEMIN','THERESE','1939-12-31','02.77.58.03.79','06.11.18.58.47',NULL,'28 rue georges clmenceau','','',NULL,NULL,NULL,NULL,'2391214500001',34.000000000,'1963-07-25','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (702,'RABASSE','JEAN','1959-01-07','02.87.37.83.21','06.70.62.98.15',NULL,'4 impasse des glantiers','','',NULL,NULL,NULL,NULL,'2590114311001',795.000000000,'1982-07-07','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (703,'MINERBE','BERNARD','1962-09-08','02.12.77.88.28','06.51.50.84.52',NULL,'LE MESNIL TOUFFRAY','','',NULL,NULL,NULL,NULL,'1620914319001',1838.000000000,'1986-02-26','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (704,'MURER','JEANNE','1929-01-24','02.22.13.99.95','06.49.31.11.93',NULL,'22 RUE DES MESANGES','','',NULL,NULL,NULL,NULL,'2290114408001',412.000000000,'1953-01-25','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (705,'LELANDAIS','JOSEPH','1929-01-09','02.12.72.48.61','06.12.40.44.78',NULL,'46 RUE DE L''EGLISE','','',NULL,NULL,NULL,NULL,'2290114634001',229.000000000,'1954-01-31','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (706,'LAMBERT','MARTINE','1935-04-13','02.15.13.57.72','06.80.89.92.19',NULL,'7 rue de villiers','','','14840','DEMOUVILLE',NULL,NULL,'1350415118001',31.000000000,'1965-03-13','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (707,'BARBE','DENISE','1931-01-04','02.12.67.00.66','06.24.59.80.76',NULL,'1 rue elsa triolet','','','14123','CORMELLES LE ROYAL',NULL,NULL,'1310114126001',209.000000000,'1958-02-10','PREMIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (708,'DESCHAMPS','ROLAND','1937-12-29','02.71.16.19.40','06.76.58.85.95',NULL,'4-4 rue de l''arbalette','','',NULL,NULL,NULL,NULL,'2371214704001',83.000000000,'1963-01-12','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (709,'LEMAIRE','THERESE','1928-04-15','02.44.63.12.51','06.10.67.04.28',NULL,'19 bvd alsace lorraine','','','14123','IFS',NULL,NULL,'1280450182001',25.000000000,'1958-05-30','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (710,'LECHAT','YVETTE','1934-09-20',NULL,NULL,NULL,'7 RUE FRANCK REES','','','14700','FALAISE',NULL,NULL,'1340914540001',221.000000000,'1959-12-22','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (711,'JOSEPHINE','LILIANE','1935-12-08','02.53.06.32.93','06.68.94.52.69',NULL,'RESIDENCE LES TROTTEBEC APPT7','','','14000','CAEN',NULL,NULL,'1351214610001',84.000000000,'1958-01-05','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (712,'PELCOQ','DENISE',NULL,'02.24.24.47.49','06.65.90.71.34',NULL,'24 rue l lecornu','','','14000','CAEN',NULL,NULL,'1510114118001',8.000000000,'2012-12-10','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (713,'ROBERT','SIMONE','1929-08-02','02.44.02.76.93','06.55.87.63.44',NULL,'12.2 RUE DES MARGUERITES','','',NULL,NULL,NULL,NULL,'1290883124001',502.000000000,'1956-10-03','PREMIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (714,'AUZOU','EVELYNE','1932-11-17','02.74.41.02.81',NULL,NULL,'16 BIS PLACE ST MARTIN','','',NULL,NULL,NULL,NULL,'1321114479001',145.000000000,'1958-08-05','PREMIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (715,'GRENIER','CHRISTIANE','1936-07-14','02.44.07.47.55','06.40.50.46.17',NULL,'9 RUE DE BERNAY','','','14730','GIBERVILLE',NULL,NULL,'1360714047001',1172.000000000,'1957-07-07','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (716,'PORQUET','RENE','1935-01-04','02.50.27.30.34','06.82.56.88.25',NULL,'25 RUE DU DR BRANLY','','','14170','ST PIERRE SUR DIVES',NULL,NULL,'2350149002001',75.000000000,'1956-06-14','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (717,'LOREL','ALICE','1931-09-08','02.18.62.20.43','06.12.32.61.83',NULL,'37 RUEJEAN MERMOZ','','','14540','GARCELLES SECQUEVILLE',NULL,NULL,'1310902071001',152.000000000,'1953-02-03','PREMIUM',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (718,'MAUGER','BERNADETTE','1936-09-11','02.86.87.65.58','06.21.70.79.32',NULL,'171 RUE D AUGE','','','14120','MONDEVILLE',NULL,NULL,'1360914701001',57.000000000,'1959-05-17','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (719,'MARIE','JACQUELINE','1948-04-02','02.68.61.17.89','06.87.70.21.25',NULL,'4 ALLEE DES AUBEPINES','','','14310','VILLERS BOCAGE',NULL,NULL,'2480414213001',37.000000000,'1970-11-08','GOLD',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (720,'JEHANNE','ELIANE','1936-05-20','02.89.59.68.11','06.37.80.41.91',NULL,'9 rue p de courbertin','','','14120','MONDEVILLE',NULL,NULL,'1360514651001',160.000000000,'1963-03-25','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (721,'GAUBERT','CHARLES','1937-01-12','02.22.05.46.44','06.71.49.78.08',NULL,'LA MADELEINE','','','14550','BLAINVILLE SUR ORNE',NULL,NULL,'2370114422001',598.000000000,'1962-06-18','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (722,'SOISMIER','PAULETTE','1931-11-16','02.82.48.68.08','06.50.76.42.09',NULL,'le val de cis','','','61100','FLERS',NULL,NULL,'2311150641001',1456.000000000,'1952-02-14','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (723,'ANNE','LEON','1937-11-20','02.91.57.15.12','06.55.76.42.23',NULL,'14 rue r le magnifique','','','14730','GIBERVILLE',NULL,NULL,'1371114469001',21.000000000,'1961-06-12','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (724,'MATHISSART','NELLY','1964-10-13','02.23.47.89.62','06.43.64.92.33',NULL,'3 BIS RUE DAMOZANNE','','','14000','CAEN',NULL,NULL,'2641050409001',73.000000000,'1985-10-18','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (725,'MARIE','RENE','1962-05-07','02.12.72.09.92','06.91.17.59.67',NULL,'14 rue de la cayriere','','','14000','CAEN',NULL,NULL,'2620514170001',3580.000000000,'1983-01-20','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (726,'BREANT','GISELE','1928-11-30','02.10.47.14.08','06.55.97.97.55',NULL,'LES PEDOUZES','','','14320','ST MARTIN DE FONTENAY',NULL,NULL,'2281114039001',798.000000000,'1952-06-17','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (727,'LE BRIZAUT','DANIELLE','1930-10-12','02.84.41.73.22','06.74.74.80.05',NULL,'29 rue d argouge porte 400','','','14170','HIEVILLE',NULL,NULL,'2301014241001',41.000000000,'1953-05-27','PREMIUM',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (728,'LE BATARD','MARTHE','1957-02-06','02.68.80.96.77','06.37.02.86.23',NULL,'56 rue des caillouins','','','14123','CORMELLES LE ROYAL',NULL,NULL,'1570214367001',1330.000000000,'1979-06-26','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (729,'ARMAND','EMILE','1958-02-24','02.79.50.42.27','06.76.84.83.87',NULL,'16 RUE DU 15 JUIN','','','14000','CAEN',NULL,NULL,'2580214315001',150.000000000,'1980-05-17','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (730,'LEGIRET','BERNARD','1929-12-18','02.10.75.88.49','06.75.29.92.83',NULL,'LE BOURG LOPIN','','','14000','GIBERVILLE',NULL,NULL,'1291214236001',75.000000000,'1954-06-02','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (731,'HOUEIX','PIERRE','1939-02-16','02.37.32.67.15','06.11.08.58.12',NULL,'3 rue a dumas','','','14250','ELLON',NULL,NULL,'2390278600001',152.000000000,'1963-04-01','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (732,'PICHON','GINETTE','1955-01-13','02.38.88.36.92','06.72.34.13.24',NULL,'4 RUE LA HAUTE GUETTE','','','14670','TROARN',NULL,NULL,'2550114312001',72.000000000,'1976-05-21','PREMIUM',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (733,'FRANCOISE','DOMINIQUE','1952-10-15','02.24.68.03.45','06.84.20.17.90',NULL,'ROUTE D AROMANCHE','','','14200','HEROUVILLE ST CLAIR',NULL,NULL,'2521014379001',24.000000000,'1977-02-11','PREMIUM',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (734,'QUINTAINE','MICHELE','1931-02-12','02.34.61.88.47','06.95.48.19.91',NULL,'8 RUE PABLO PICASSO','','','14680','BRETTEVILLE SUR LAIZE',NULL,NULL,'1310214337001',68.000000000,'1954-07-24','PLATINIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (735,'LANGLINE','RAYMOND','1936-06-19','02.99.25.21.04','06.94.86.81.84',NULL,'3 CITE DES JARDINS','','','14310','VILLERS BOCAGE',NULL,NULL,'1360614087001',562.000000000,'1959-02-03','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (736,'LAMENDOUR','THERESE','1932-01-21','02.27.66.21.37','06.75.80.39.14',NULL,'1603 GRANDE DELLE','','','14000','CAEN',NULL,NULL,'1320114320001',939.000000000,'1960-12-26','GOLD',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (737,'QUETEL','JEAN EDOUARD','1965-03-22','02.12.36.12.66','06.10.84.49.77',NULL,'clairtison','','','14460','COLOMBELLES',NULL,NULL,'1650314245001',479.000000000,'1988-09-27','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (738,'FABLET','CLAUDE','1934-10-05','02.77.29.34.77','06.89.42.68.75',NULL,'33 RUE PERE SANSONU','','','14220','BOULON',NULL,NULL,'1341014516001',17.000000000,'1958-09-12','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (739,'POUSSIER','JEAN PAUL','1929-05-26','02.48.61.41.31','06.74.94.19.01',NULL,'15 CHEMIN DES BOIS','','','14210','MISSY',NULL,NULL,'2290535291001',18.000000000,'1953-01-28','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (740,'LETOURNEUR','ROGER','1942-03-21','02.27.63.69.29','06.54.50.61.93',NULL,'68 RUE ARMAND MARIE','','','14350','BEAULIEU',NULL,NULL,'2420314336001',137.000000000,'1965-02-10','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (741,'MICHEL','DELPHIN','1934-12-29','02.60.41.25.13','06.75.77.56.96',NULL,'12 RUE MOZART','','','14220','OUFFIERES',NULL,NULL,'1341214335001',1851.000000000,'1961-11-01','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (742,'LACAILLE','CLAUDINE','1933-01-01','02.43.20.75.04','06.13.84.49.14',NULL,'12 AVENUE JACQUES PREVERT','','','14340','CREVECOEUR EN AUGE',NULL,NULL,'2330177126001',780.000000000,'1963-11-23','PREMIUM',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (743,'TURGIS','GISELE','1943-02-24','02.11.49.02.27','06.83.29.14.82',NULL,'31 RUE DU PRESSOIR','','','14123','FLEURY SUR ORNE',NULL,NULL,'2430214682001',24.000000000,'1964-04-23','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (744,'DORNIER','EMILE','1948-01-30','02.11.79.33.48','06.15.31.45.03',NULL,'16 RUE DE BEAUVOIR','','','14111','LOUVIGNY',NULL,NULL,'2480114376001',118.000000000,'1975-04-03','GOLD',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (745,'AMELINE','BERNARD','1930-04-03','02.71.76.23.84','06.58.76.64.99',NULL,'28 RUE VAL ES DUNE','','','61350','PASSAIS LA CONCEPTION',NULL,NULL,'2300414714001',261.000000000,'1953-02-09','PREMIUM',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (746,'JAMES','Jacqueline','1960-10-16','02.80.30.37.12','06.79.99.55.05',NULL,'23 allee des poetes','','','14120','MONDEVILLE',NULL,NULL,'2601014112001',99.000000000,'1984-09-21','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (747,'CHOPIN','MAX','1951-02-22','02.49.88.14.70','06.11.72.14.08',NULL,'12 avenue Charles de Foucault','','','14000','CAEN',NULL,NULL,'1510214732001',115.000000000,'1975-01-31','PREMIUM',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (748,'TOLLEMER','LINA','1953-01-29','02.17.12.66.03','06.82.06.42.17',NULL,'6 RUE DES TILLEULS','','','83460','LES ARCS',NULL,NULL,'2530172256001',1665.000000000,'1976-06-27','PREMIUM',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (749,'MARIE','GISELE','1954-01-26','02.32.66.36.48','06.48.70.54.82',NULL,'58 GRANDE RUE','','','14120','MONDEVILLE',NULL,NULL,'1540114532001',176.000000000,'1984-08-12','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (750,'BAZEILLE','THIERRY','1967-02-26','02.31.68.17.53','06.50.20.48.68',NULL,'31 RUE DES FRERES BOUTROIS','','','77100','MEAUX',NULL,NULL,'1670214407001',114.000000000,'1991-12-10','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (751,'BENJENEC','ODETTE','1959-01-02','02.59.51.28.89','06.91.37.52.33',NULL,'49 RUE HECTOR BERLIOZ','','','14000','CAEN',NULL,NULL,'2590114258001',9.000000000,'1983-08-04','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (752,'TAFFIN','CLAUDINE','1925-01-19','02.61.11.94.38','06.11.92.08.02',NULL,'route de la folie','','','14123','IFS',NULL,NULL,'1250132029001',50.000000000,'1947-04-20','PREMIUM',22,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (753,'VANOVERBEKE','PAUL','1939-08-19','02.43.09.53.52','06.28.34.40.92',NULL,'22 rue du 7 aout 1944','','','14160','DIVES SUR MER',NULL,NULL,'2390814736001',128.000000000,'1963-05-03','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (754,'BREHON','GABRIEL','1940-06-16','02.44.55.94.37','06.48.00.94.71',NULL,'13 RUE DU DR ROUX','','','14000','CAEN',NULL,NULL,'1400656036001',474.000000000,'1962-12-11','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (755,'MAUREY','MAURICE','1939-12-15','02.85.00.00.48','06.36.43.34.24',NULL,'8 ALLEE DE LA VARENDE','','','14800','TOUQUES',NULL,NULL,'2391214008001',26.000000000,'1965-08-10','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (756,'RICHARD','BERNADETTE','1929-11-06','02.10.53.75.22','06.10.09.23.93',NULL,'18 RUE DE LA DIVES','','','61200','ARGENTAN',NULL,NULL,'2291114698001',542.000000000,'1950-06-09','PREMIUM',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (757,'ROLLAND','GERARD','1936-06-05','02.49.01.80.87','06.37.99.44.42',NULL,'129 BD RAYMOND POINCARE','','','14370','ARGENCES',NULL,NULL,'2360614649001',20.000000000,'1966-09-14','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (758,'MARIE','MONIQUE','1935-05-04','02.57.48.26.13','06.10.98.18.99',NULL,'82 RUE VICTOR LEPINE','','','14000','CAEN',NULL,NULL,'1350550475001',91.000000000,'1965-05-01','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (759,'ROGER','GILBERT','1951-01-06','02.71.68.34.82','06.11.95.34.18',NULL,'31 rue de formigny','','','14220','BOULON',NULL,NULL,'1510114009001',1532.000000000,'1976-12-29','PREMIUM',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (760,'LEPAGE','ALEXIA','1929-05-30','02.69.55.05.10','06.34.75.64.45',NULL,'7 rue des ancien d''afn','','','50180','AGNEAUX',NULL,NULL,'2290514643001',2854.000000000,'1958-08-13','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (761,'TURBAN','BRIGITTE','1930-12-10','02.72.44.47.68','06.54.80.02.64',NULL,'1 RESIDENCE DES PINCONS','','','14490','CAHAGNOLLES',NULL,NULL,'1301214506001',13.000000000,'1952-01-15','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (762,'LEPETIT','MARIE','1929-04-04','02.31.91.28.93','06.89.61.62.01',NULL,'RUE BISSIERES','','','61230','ST EVROULT DE MONTFORT',NULL,NULL,'1290414733001',46.000000000,'1955-05-08','PREMIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (763,'DUPONT','JOCELYNE','1949-01-15','02.13.03.76.45','06.19.48.91.30',NULL,'7 rue du berry','','','14170','VENDEUVRE',NULL,NULL,'2490161152001',576.000000000,'1972-04-30','PREMIUM',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (764,'JANET','MADELEINE','1950-03-31','02.86.29.73.42','06.41.23.46.59',NULL,'38 rue desmant','','','14190','ST SYLVAIN',NULL,NULL,'1500314113001',64.000000000,'1978-12-29','PREMIUM',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (765,'CLATOT','HUBERT','1930-10-15','02.91.06.23.43','06.51.77.16.18',NULL,'16 rte de tilly','','','14610','ANISY',NULL,NULL,'1301014689001',1296.000000000,'1953-07-08','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (766,'ALLAIN','CHRISTOPHE','1930-08-25','02.84.89.36.67','06.65.93.16.89',NULL,'LONGCHAMPS','','','14123','FLEURY SUR ORNE',NULL,NULL,'1300814181001',61.000000000,'1952-01-19','PREMIUM',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (767,'DELAQUAIZE','GILBERTE','1938-05-20','02.11.46.41.62','06.95.28.14.97',NULL,'10 RUE DES CHARDONNERETS','','','14760','BRETTEVILLE SUR ODON',NULL,NULL,'1380561040001',91.000000000,'1968-11-07','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (768,'RAS','LUCIEN','1967-02-26','02.92.21.02.58','06.12.00.80.40',NULL,'7 rue porte millet les petites s','oeurs des pauvres','','14370','MOULT',NULL,NULL,'1670214407001',149.000000000,'1997-03-01','PREMIUM',12,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (769,'DELASALLE','EMILE','1943-03-10','02.10.27.89.49','06.49.22.69.93',NULL,'13 RUE ARAGO','','','14670','TROARN',NULL,NULL,'1430361251001',26.000000000,'1973-03-17','SILVER',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (770,'DELAITRE','DOMINIQUE','1936-01-28','02.79.18.67.78','06.38.05.17.17',NULL,'8 RUE GEORGES MAUDUIT','','','14490','BALLEROY',NULL,NULL,'1360114618001',199.000000000,'1964-12-22','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (771,'FESTOC','EUGENE','1933-12-09','02.47.94.28.12','06.65.58.98.24',NULL,'2 IMPASSE IRENE ET J.LOUIS CURIE','','','14380','ST SEVER CALVADOS',NULL,NULL,'2331214654001',35.000000000,'1957-01-30','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (772,'LANGLOIS','DANIELLE','1961-02-05','02.22.88.96.69','06.10.49.90.22',NULL,'10 rue leroy','','','14730','GIBERVILLE',NULL,NULL,'2610250354001',95.000000000,'1982-07-09','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (773,'CLEMENT','CLAUDE','1932-09-09','02.27.34.10.46','06.10.74.96.04',NULL,'ST MARDS DE BLACARVILLE','','','61100','FLERS',NULL,NULL,'1320914712001',14.000000000,'1962-05-26','PLATINIUM',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (774,'SILINE','ALI','1935-06-03','02.22.85.02.45','06.71.62.94.51',NULL,'2 rue du vercors','','','14000','CAEN',NULL,NULL,'1350614277001',46.000000000,'1959-04-23','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (775,'FLEURY','LOUIS','1932-01-06','02.71.47.09.29','06.88.38.89.10',NULL,'26 RUE GEORGES GAILLARD','','','14670','TROARN',NULL,NULL,'2320114133001',366.000000000,'1955-06-26','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (776,'ROBERT','bernard','1930-10-01','02.14.14.90.30','06.10.35.79.72',NULL,'26 RUE LEONARD GILLES','','','14000','CAEN',NULL,NULL,'2301014339001',91.000000000,'1951-02-18','PREMIUM',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (777,'OSSEMONT','ROBERT','1935-10-18','02.66.63.37.03','06.20.06.74.55',NULL,'203 bis rue de falaise','','','14460','COLOMBELLES',NULL,NULL,'2351014590001',376.000000000,'1963-02-14','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (778,'BUSNOT','SIMONE','1935-10-11','02.40.21.40.80','06.30.01.08.52',NULL,'14 al  des poetes','','','14123','CORMELLES LE ROYAL',NULL,NULL,'2351014590001',31.000000000,'1963-12-15','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (779,'EUDINE','ROGER','1940-12-09','02.20.46.25.84','06.70.31.63.80',NULL,'3 RUE DU NID DE CHIEN','','','14123','IFS',NULL,NULL,'2401278555001',2488.000000000,'1961-07-18','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (780,'BAUPIN','FELIX','1937-11-14','02.74.98.84.97',NULL,NULL,'3 RUE PASTEUR','','','50700','ST JOSEPH',NULL,NULL,'2371114045001',86.000000000,'1962-03-21','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (781,'PATERN','MARIE THERESE','1959-03-29','02.10.46.74.16',NULL,NULL,'CHEMIN DE L''HOPITAL','','','14610','BASLY',NULL,NULL,'1590314422001',1016.000000000,'1981-05-26','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (782,'FOSSEY','MICHEL','1932-03-20','02.65.91.81.75','06.35.86.49.80',NULL,'ROUTE DE MAIZIERES','','','14510','HOULGATE',NULL,NULL,'2320314201001',1715.000000000,'1953-05-29','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (783,'THEZARD','MICHEL','1940-05-15','02.30.60.68.26','06.40.40.84.35',NULL,'44 B RUE DE BAYEUX','','','14200','HEROUVILLE ST CLAIR',NULL,NULL,'2400568250001',1014.000000000,'1963-10-22','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (784,'GUILBERT','BERNARD','1969-07-09','02.40.85.38.44','06.42.60.67.17',NULL,'RUE DU CLOS BAVENT','','','14200','HEROUVILLE ST CLAIR',NULL,NULL,'2690780021001',92.000000000,'1992-01-07','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (785,'NOEL','MONIQUE','1966-02-10','02.76.59.30.58','06.56.76.20.92',NULL,'214 RUE D''AUGE','','','14710','RUBERCY',NULL,NULL,'1660214675001',414.000000000,'1995-01-05','PREMIUM',12,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (786,'LORANT','DANIEL','1932-10-19','02.23.58.92.33','06.16.35.78.70',NULL,'5 RUE DU PETIT MARAIS','','','14850','HEROUVILLETTE',NULL,NULL,'1321014112001',30.000000000,'1956-06-18','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (787,'BRIONNE','JOSETTE','1938-12-04','02.11.34.54.03','06.16.11.64.00',NULL,'25 RUE DU GROS ORME','','','14170','L''OUDON',NULL,NULL,'1381214221001',35.000000000,'1959-05-25','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (788,'DRION','SIMONE','1936-06-03','02.27.44.60.00','06.62.95.13.87',NULL,'81 AVENUE JEAN JAURES','','','14320','FEUGUEROLLES BULLY',NULL,NULL,'1360614221001',27.000000000,'1959-09-08','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (789,'GRAS','THERESE','1933-01-25','02.58.55.07.83','06.11.34.37.02',NULL,'21 rue de persil','','','14120','MONDEVILLE',NULL,NULL,'2330114608001',32.000000000,'1955-11-09','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (790,'BERNIER','ISABELLE','1925-01-22','02.58.80.85.34','06.26.60.70.20',NULL,'1 CHEMIN DE ST AIGNAN','','','14123','CORMELLES LE ROYAL',NULL,NULL,'1250132029001',216.000000000,'1946-05-23','PREMIUM',22,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (791,'DEROUET','SIMONE','1939-10-06','02.86.88.58.61','06.65.44.17.48',NULL,'28 RUE DES TILLEULS','','','14880','HERMANVILLE SUR MER',NULL,NULL,'1391014667001',449.000000000,'1961-02-20','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (792,'DESLANDES','CLAUDE','1932-04-16','02.75.17.84.82','06.64.99.68.82',NULL,'5 RUE DES QUATRES VENTS','','','14270','MEZIDON CANON',NULL,NULL,'1320414436001',183.000000000,'1961-06-19','GOLD',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (793,'DALIGAULT','GERARD','1940-10-30','02.11.12.90.82','06.56.38.57.61',NULL,'24 RUE VAN BEETHOVEN','','','14150','OUISTREHAM',NULL,NULL,'2401014730001',1294.000000000,'1961-03-20','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (794,'MOUCHEL','JEAN PIERRE','1924-01-11','02.77.11.65.25','06.20.66.57.72',NULL,'5 ROUTE DE LA HERSERIE','','','14550','BLAINVILLE SUR ORNE',NULL,NULL,'1240166090001',32.000000000,'1953-03-31','PREMIUM',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (795,'LETALLEC','JEAN','1934-01-22','02.92.92.16.64','06.59.89.26.13',NULL,'80 RUE DE LA SEINE','','','14000','CAEN',NULL,NULL,'2340114026001',199.000000000,'1964-04-17','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (796,'TOUQUET','Michel','1956-08-31','02.87.03.16.18','06.90.94.99.00',NULL,'27 RUE DES CHANTERELLES','','','14680','BRETTEVILLE SUR LAIZE',NULL,NULL,'1560814747001',89.000000000,'1978-03-19','PREMIUM',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (797,'MARIE','LUCIEN','1937-08-10','02.63.39.52.04','06.15.80.04.66',NULL,'49 RESIDENCE DES CHARDONNERETS','','','14390','CABOURG',NULL,NULL,'1370814090001',3.000000000,'1959-12-21','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (798,'GASTON','JACKY','1939-10-28','02.87.39.66.78','06.11.57.18.95',NULL,'ALLEE DES FAUVETTES','','','14370','AIRAN',NULL,NULL,'1391014020001',1118.000000000,'1961-08-31','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (799,'DUPONT','MADELEINE','1928-08-25','02.26.08.41.29','06.65.72.81.38',NULL,'1685 RUE DE BRETTEVILLE','','','14111','LOUVIGNY',NULL,NULL,'1280814737001',1450.000000000,'1951-05-11','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (800,'LEBAILLY','SIMONE','1943-01-28','02.12.85.27.28','06.38.17.78.60',NULL,'2 impasse pierre lefevre','','','14350','LE BENY BOCAGE',NULL,NULL,'1430114618001',102.000000000,'1966-06-04','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (801,'LECOURT','SIMONE','1928-05-09','02.45.50.61.98','06.26.51.53.38',NULL,'16.3 grande rue','','','14000','CAEN',NULL,NULL,'2280514735001',205.000000000,'1954-08-17','PREMIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (802,'BERTRAND','YVES','1946-01-06','02.10.93.93.53','06.73.34.06.71',NULL,'8 rue du manoir','','','14620','DAMBLAINVILLE',NULL,NULL,'1460114736001',1.000000000,'1970-06-29','GOLD',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (803,'FLAMBARD','LOUISE','1932-03-09','02.67.79.80.37','06.31.72.88.57',NULL,'','','','14700','ST MARTIN DE MIEUX',NULL,NULL,'2320314418001',600.000000000,'1959-10-11','GOLD',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (804,'LAPORTE','MICHEL','1949-07-31','02.11.98.99.59','06.66.70.37.45',NULL,'98 AVENUE FOSCH','','','14680','FRESNEY LE PUCEUX',NULL,NULL,'1490714565001',157.000000000,'1972-11-12','PREMIUM',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (805,'GESLIN','COLETTE','1938-10-02','02.41.34.65.41','06.10.33.64.70',NULL,'19 RUE DE L''OFFICIALITE','','','14220','CESNY BOIS HALBOUT',NULL,NULL,'2381050502001',4170.000000000,'1968-07-04','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (806,'RATTIER','YVES','1946-09-21','02.30.95.49.47','06.86.58.95.93',NULL,'LE CLOS COCHON','','','50550','ST VAAST LA HOUGUE',NULL,NULL,'2460921153001',223.000000000,'1967-05-18','GOLD',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (807,'LAFFILARD','THERESE','1964-01-21','02.82.42.05.18','06.15.72.58.86',NULL,'le pavillon','','','50140','ROMAGNY',NULL,NULL,'2640160166001',49.000000000,'1988-09-13','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (808,'SALLIOT','COLETTE','1963-03-12','02.80.84.15.34','06.99.94.06.73',NULL,'20 RUE DES PERVENCHES','','','14370','MOULT',NULL,NULL,'1630314535001',41.000000000,'1984-04-21','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (809,'TREFEU','JOELLE','1954-01-31','02.39.63.92.51','06.61.71.17.43',NULL,'5 RUE DE L''ABBAYE','','','14000','CAEN',NULL,NULL,'2540114181001',3.000000000,'1981-02-04','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (810,'DESCLOS','RENEE','1933-07-06','02.55.63.00.67','06.50.62.25.10',NULL,'13 RUE DES PLATANES','','','14260','ROUCAMPS',NULL,NULL,'2330714173001',405.000000000,'1954-04-20','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (811,'MAUNY','HENRIETTE','1939-03-16','02.50.39.82.85','06.81.20.32.60',NULL,'23 RUE DES ROSIERS','','','14700','FALAISE',NULL,NULL,'1390314229001',40.000000000,'1963-08-16','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (812,'COTARD DUPARQUE','SERGE','1951-02-03','02.84.15.93.91','06.74.65.79.31',NULL,'17 RES ST JACQUES','','','14000','CAEN',NULL,NULL,'1510214712001',4720.000000000,'1976-04-13','PREMIUM',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (813,'BOUTRY','MARC','1943-01-04','02.72.59.78.38','06.41.57.25.14',NULL,'356 RUE DE LA CHAPELLE','','','14530','LUC SUR MER',NULL,NULL,'1430102195001',165.000000000,'1965-12-15','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (814,'THOMASSE','HENRI','1958-04-23','02.85.67.35.00','06.27.89.26.03',NULL,'19 BD MARECHAL LYAUTEY','','','61210','NEUVY AU HOULME',NULL,NULL,'2580414327001',939.000000000,'1982-08-20','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (815,'PAGNON','ANDRE','1933-11-23','02.59.45.06.97','06.61.22.41.00',NULL,'25 rue salvador allende','','','14190','GRAINVILLE LANGANNERIE',NULL,NULL,'2331114686001',127.000000000,'1958-07-26','PREMIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (816,'HASTAIN','alain','1936-05-19','02.81.21.77.09','06.37.57.85.77',NULL,'2 ALLEE DES ACACIAS','','','14320','FONTENAY LE MARMION',NULL,NULL,'2360550595001',1138.000000000,'1957-12-16','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (817,'DUVENT','SUZANNE','1957-02-22','02.47.31.88.62','06.26.64.57.02',NULL,'1312 RUE DU STADE','','','14000','CAEN',NULL,NULL,'1570250626001',362.000000000,'1981-02-09','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (818,'BENOIT','ANDRE','1969-12-03','02.53.50.77.93','00 33 6.25.82.22.18',NULL,'14 allee andre gides','','','14630','FRENOUVILLE',NULL,NULL,'2691214537001',34.000000000,'1993-12-06','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (819,'VASTEL','THIERRY','1949-06-25','02.14.36.02.99','06.19.34.48.51',NULL,'51 rue michel lasne','','','14540','ROCQUANCOURT',NULL,NULL,'1490614335001',237.000000000,'1974-05-10','PREMIUM',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (820,'FRANCOIS','GERARD','1939-04-29','02.41.30.59.36','06.50.68.70.30',NULL,'3 rue du stade','','','14000','CAEN',NULL,NULL,'2390414247001',135.000000000,'1962-02-25','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (821,'LE NOEL','FLORENCE',NULL,'02.10.52.29.84','06.66.39.26.22',NULL,'2 chemin aux boeufs','','','14000','CAEN',NULL,NULL,'2631110420001',18.000000000,'2008-06-22','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (822,'DUCHEMIN','DENISE','1940-02-07','02.53.68.36.95','06.62.69.41.40',NULL,'1 rue bleriot','','','14120','MONDEVILLE',NULL,NULL,'2400250427001',175.000000000,'1965-11-29','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (823,'LAINE','Gaston','1937-07-22','02.38.67.77.49','06.27.13.93.17',NULL,'3 sente au coin','','','14630','CAGNY',NULL,NULL,'1370714708001',7.000000000,'1966-03-04','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (824,'GUILLOREAU','Jeannine','1944-03-26','02.88.41.92.38','06.11.21.89.56',NULL,'1 Frres des Vigouroux','','',NULL,NULL,NULL,NULL,'1440314037001',99.000000000,'1965-12-05','GOLD',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (825,'DAVOULT','JOSIANE','1934-10-10','02.21.90.07.75','06.39.10.55.39',NULL,'7 RUE DES ACCACIAS','','','14850','ESCOVILLE',NULL,NULL,'2341014426001',187.000000000,'1957-11-17','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (826,'GRANDIERE','DOMINIQUE','1930-01-20','02.62.53.89.38','06.71.10.49.49',NULL,'37 bld des felibres','','','14000','CAEN',NULL,NULL,'2300150332001',617.000000000,'1958-03-04','PLATINIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (827,'MOGIS','BERNARD','1930-05-28','02.50.81.05.83','06.84.00.70.34',NULL,'50 LE FRESNE','','','14370','ARGENCES',NULL,NULL,'1300514440001',5.000000000,'1954-02-20','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (828,'LE COHUE','SIMONE','1936-06-15','02.53.01.72.65','06.86.12.90.41',NULL,'23 ROUTE DU PONT DU COUDRAY','','','14160','DIVES SUR MER',NULL,NULL,'1360650149001',4003.000000000,'1957-08-20','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (829,'LAMBERT','MICHEL','1936-04-02','02.17.22.78.78','06.12.05.70.80',NULL,'30 RUE DE L EGLISE','','','14370','MOULT',NULL,NULL,'1360461263001',11.000000000,'1963-03-04','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (830,'LAMOTTE','YVETTE','1932-02-21','02.40.19.94.11','06.78.19.92.92',NULL,'235 RUE DE LA REPUBLIQUE','','','14860','AMFREVILLE',NULL,NULL,'1320214469001',223.000000000,'1957-09-23','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (831,'LEGRAND','THERESE','1937-05-17','02.54.06.79.30','06.35.33.36.21',NULL,'34 ROUTE DE CAEN','','','14270','MEZIDON CANON',NULL,NULL,'1370550074001',73.000000000,'1959-07-27','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (832,'MOTTIN','JEAN CLAUDE','1930-11-17','02.16.35.79.79','06.51.39.34.11',NULL,'12 RUE DE LA BARONNIE','','','14000','CAEN',NULL,NULL,'2301114698001',1128.000000000,'1953-06-13','PLATINIUM',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (833,'LEGIRET','RAYMOND','1938-04-17','02.56.26.66.60','06.10.12.49.09',NULL,'16 RUE ST EXUPERY','','','14190','CAUVICOURT',NULL,NULL,'2380414044001',941.000000000,'1960-07-09','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (834,'PLE','JOCELYNE','1969-12-31','02.16.80.25.24','06.56.27.69.20',NULL,'29 BOULEVARD RAYMOND POINCARE','','','14840','DEMOUVILLE',NULL,NULL,'1691292063001',104.000000000,'1990-05-21','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (835,'RICHARD','JEANNE','1936-08-05','02.11.88.80.40','06.95.58.87.84',NULL,'16 RUE  JEAN  GREMILLON','','','14200','HEROUVILLE ST CLAIR',NULL,NULL,'1360814647001',49.000000000,'1957-08-12','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (836,'SAMSON','SYLVIE',NULL,'02.87.80.54.03','06.87.58.46.10',NULL,'7 rue alexandre','','','14120','MONDEVILLE',NULL,NULL,'2650414651001',1281.000000000,'2010-06-20','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (837,'LE NOEL','','1939-10-14','02.40.44.58.48','06.49.29.05.61',NULL,'11 AVENUE DU CHATEAU','','','50150','SOURDEVAL',NULL,NULL,'2391050226001',196.000000000,'1961-07-28','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (838,'PETITBOIS','DOMINIQUE','1936-03-31','02.43.85.66.63','06.63.97.31.01',NULL,'4 RUE GUILBERT','','','14220','ESSON',NULL,NULL,'1360314753001',58.000000000,'1957-09-14','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (839,'LANGRAND','','1936-12-20','02.40.54.49.10','06.47.97.23.10',NULL,'14 RUE DU CLOS DE LA MARE','','','14000','CAEN',NULL,NULL,'1361214271001',39.000000000,'1958-06-11','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (840,'POUTREL','DIDIER','1930-10-17','02.43.37.84.39','06.12.01.19.42',NULL,'la martelerie','','','14460','COLOMBELLES',NULL,NULL,'1301014221001',150.000000000,'1955-01-08','PREMIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (841,'BELLEE','FRANCOISE','1930-09-09','02.10.94.59.01','06.26.44.75.90',NULL,'120 RUE DU VILLAGE','','','14210','VACOGNES NEUILLY',NULL,NULL,'1300950117001',4542.000000000,'1958-03-03','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (842,'MAHEUT','HUBERT','1952-01-04','02.10.40.54.80','06.15.17.78.56',NULL,'LE CLOS JULIEN','','','14190','OUILLY LE TESSON',NULL,NULL,'1520114133001',80.000000000,'1975-07-23','PREMIUM',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (843,'EUGENE','MARCEL','1986-07-13','02.10.26.16.19','06.15.47.23.53',NULL,'43 ROUTE DE BENEAUVILLE','','','14670','TROARN',NULL,NULL,'1860722123001',78.000000000,'2012-12-12','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (844,'COQUIN','MARCEL','1931-06-08','02.78.66.51.37','06.10.90.34.92',NULL,'18 RUE ST ANDRE  3 EME ETAGE POR','TE 27','','94500','CHAMPIGNY SUR MARNE',NULL,NULL,'2310614219001',77.000000000,'1961-06-18','GOLD',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (845,'DESFEUX','EUGENIE','1950-01-25','02.33.88.70.35','06.59.15.60.13',NULL,'22 BIS RUE JOSEPH LEVILLY','','','14320','ST ANDRE SUR ORNE',NULL,NULL,'1500114752001',178.000000000,'1978-05-07','PREMIUM',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (846,'EURY','CHRISTOPHE','1949-01-14','02.90.49.70.41','06.48.14.20.42',NULL,'26 rue l lecornu','','','14740','SECQUEVILLE EN BESSIN',NULL,NULL,'2490114225001',149.000000000,'1979-03-08','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (847,'BRAULT','MICHELLE','1949-01-18','02.85.64.83.49','06.77.60.97.06',NULL,'10 RUE GEORGES BRASSENS','','','14830','LANGRUNE SUR MER',NULL,NULL,'1490114747001',867.000000000,'1970-01-10','PREMIUM',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (848,'LEFEBVRE','DIDIER',NULL,NULL,NULL,NULL,'3 impasse du home','','','14730','GIBERVILLE',NULL,NULL,'2391150601001',46.000000000,'2010-12-12','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (849,'CHEBANA','CLAUDE','1977-08-05','02.12.28.11.66','06.11.54.36.13',NULL,'9 ALLEE DES BOULOTS','','','14000','CAEN',NULL,NULL,'2770899322001',63.000000000,'2007-12-10','PREMIUM',10,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (850,'TETI','HELENE','1937-02-05','02.68.89.98.29','06.83.63.79.69',NULL,'5 impasse de l''escalier','','','14840','DEMOUVILLE',NULL,NULL,'2370214300001',1272.000000000,'1959-08-21','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (851,'SICOT','BERNARD','1930-11-19','02.68.87.47.75','06.68.59.03.62',NULL,'6 rue de la paix','','','14630','CAGNY',NULL,NULL,'2301102401001',1059.000000000,'1951-12-25','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (852,'MULLOT','CHRISTIANE','1949-02-19','02.87.22.84.53','06.15.59.94.12',NULL,'ferme st nicolas','','','14610','EPRON',NULL,NULL,'1490250322001',132.000000000,'1971-08-14','PREMIUM',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (853,'MULLOT','DANIEL','1933-08-30','02.53.52.00.98','06.12.57.57.76',NULL,'1402 quartier du bois','','','14880','HERMANVILLE SUR MER',NULL,NULL,'1330814675001',5.000000000,'1963-11-25','PREMIUM',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (854,'ROMEUF','FERNANDE','1930-10-13','02.58.56.29.61','06.10.72.27.99',NULL,'52 RUE BELLEVUE','','','45200','AMILLY',NULL,NULL,'2301050013001',312.000000000,'1952-10-08','PREMIUM',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (855,'PERIER','JACQUES','1937-10-19','02.85.81.99.76','06.97.07.93.10',NULL,'LA BERTHERIE','','','14250','LINGEVRES',NULL,NULL,'1371014557001',1186.000000000,'1959-08-29','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (856,'VINCENT','THIERRY','1966-02-05','02.54.75.43.30','06.42.34.02.33',NULL,'7 route de paris','','','50130','OCTEVILLE',NULL,NULL,'1660241070001',10.000000000,'1994-09-25','PREMIUM',12,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (857,'OUZOUF','MONIQUE','1938-01-03','02.45.64.86.18','06.50.26.37.90',NULL,'5 AUTELS RUE DE LA FORGE','','','14000','CAEN',NULL,NULL,'2380114623001',18.000000000,'1960-04-29','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (858,'CHAMPS','MARIE-THERESE','1953-01-23','02.69.17.00.35','06.20.05.24.39',NULL,'2 IMPASSE PAUL ELIE GERMEZ','','','06000','NICE',NULL,NULL,'1530114497001',460.000000000,'1974-04-29','PREMIUM',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (859,'FRANCOISE','REMI','1940-01-21','02.64.46.51.98','06.30.42.59.11',NULL,'1 chemin de coz-castel1','','','14200','HEROUVILLE ST CLAIR',NULL,NULL,'2400114271001',5.000000000,'1970-03-18','SILVER',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (860,'LOPES DOS SANTOS','SYLVIE','1963-05-23','02.55.97.26.43','06.30.47.36.97',NULL,'13 rue des coteaux','','','14210','ESQUAY NOTRE DAME',NULL,NULL,'2630514099001',146.000000000,'1984-02-25','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (861,'LAVILLE','SOLANGE','1981-12-31','02.47.66.60.78','06.98.14.70.58',NULL,'ru e des ecoles','','','14400','ST VIGOR LE GRAND',NULL,NULL,'1811299255001',537.000000000,'2011-07-06','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (862,'LEPAN','BERNARD','1953-06-13','02.96.68.42.62','06.48.33.29.41',NULL,'3 SQUARE LA VARONDE','','','14000','CAEN',NULL,NULL,'2530614651001',101.000000000,'1978-01-09','PREMIUM',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (863,'ABRAHAM','CHRISTIANE','1968-08-13','02.30.71.97.43','06.64.55.57.99',NULL,'7 rue paul langevin','','','14850','HEROUVILLETTE',NULL,NULL,'2680814009001',5.000000000,'1991-11-11','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (864,'BENJDIR','ROGER','1931-07-23','02.99.54.59.38','06.52.07.21.98',NULL,'','','','14000','CAEN',NULL,NULL,'2310761074001',189.000000000,'1959-01-03','PLATINIUM',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (865,'LAMBERT','SIMONE','1933-02-08','02.47.64.20.91','06.10.28.49.42',NULL,'1 rue hector berlioz','','','14270','PERCY EN AUGE',NULL,NULL,'1330201265001',154.000000000,'1962-05-19','GOLD',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (866,'POUCHIN','COLETTE','1933-02-17','02.11.57.58.20','06.74.30.75.39',NULL,'BRETTEVILLE LE RABET','','','14120','MONDEVILLE',NULL,NULL,'1330264445001',86.000000000,'1957-03-05','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (867,'GROSINI','PIERRE','1929-01-12','02.55.58.08.54','06.91.68.33.29',NULL,'22 REGIMENT DES MAISONS NEUVES','','','14000','CAEN',NULL,NULL,'1290161490001',109.000000000,'1952-02-16','PREMIUM',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (868,'GOUEY','CLAUDE','1936-01-16','02.59.45.70.16','06.48.67.43.61',NULL,'30 BIS RUE DU MILIEU','','','14260','ST GEORGES D''AUNAY',NULL,NULL,'2360161505001',269.000000000,'1963-05-29','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (869,'EUGENE','BERNARD','1934-11-15','02.53.32.57.94','06.44.69.01.95',NULL,'30 rue de la montagne','','','61160','CHAMBOIS',NULL,NULL,'2341114224001',444.000000000,'1962-11-01','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (870,'BRION','ODETTE','1948-10-23','02.55.39.80.86','06.10.91.74.81',NULL,'36 rue eugenie','','','50270','BARNEVILLE CARTERET',NULL,NULL,'1481014178001',4726.000000000,'1972-12-29','GOLD',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (871,'LETELLIER','MICHEL','1931-09-24','02.49.94.83.61','06.25.33.85.68',NULL,'5 avenue du 19 mars 1962','','','92700','COLOMBES',NULL,NULL,'1310914140001',1402.000000000,'1954-10-26','PLATINIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (872,'LE MAGNEN','CLAUDETTE','1929-12-01','02.61.41.61.90','06.48.72.84.88',NULL,'168 QUARTIER DES BELLES PORTES','','','14000','CAEN',NULL,NULL,'2291214073001',62.000000000,'1951-05-11','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (873,'DERENEMESNIL','GENEVIEVE','1931-05-26','02.15.39.83.54','06.81.78.89.95',NULL,'1874 rte de bretteville','','','14730','GIBERVILLE',NULL,NULL,'1310514097001',119.000000000,'1952-11-23','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (874,'DERENEMESNIL','GERARD','1942-05-25','02.86.64.02.40','06.44.36.48.45',NULL,'29 bd raymond poincare','','','14160','BRUCOURT',NULL,NULL,'1420514665001',2940.000000000,'1965-11-01','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (875,'STETTLER','JOSETTE','1956-12-01','02.24.59.21.23','06.40.29.15.22',NULL,'LE BOURG','','','14220','FRESNEY LE VIEUX',NULL,NULL,'2561214657001',649.000000000,'1977-03-06','PREMIUM',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (876,'TRICARD','JANE','1953-03-10','02.37.52.61.02','06.25.50.16.44',NULL,'3 RUE BERLIOZ','','','14240','CAUMONT L''EVENTE',NULL,NULL,'2530314119001',17.000000000,'1976-04-30','PREMIUM',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (877,'CHOPIN','Jean louis','1957-01-14','02.36.89.28.47','06.17.39.15.98',NULL,'56 RUE DE L''ARQUETTE','','',NULL,NULL,NULL,NULL,'1570114407001',21.000000000,'1980-01-25','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (878,'ROUSSEL','LUCIENNE','1932-05-11','02.88.38.03.85','06.80.40.65.09',NULL,'cambridge 6 place wurzbourg n','2264','','14123','IFS',NULL,NULL,'1320572139001',78.000000000,'1962-12-07','PLATINIUM',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (879,'DESAUNAY','DENISE','1944-06-30','02.21.27.87.50','06.11.41.01.60',NULL,'9 RUE DE BRETAGNE','','','14210','AMAYE SUR ORNE',NULL,NULL,'1440650297001',117.000000000,'1971-04-21','GOLD',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (880,'JOUAN','MARIE MARGUERIT','1962-09-26','02.69.01.61.13','06.63.91.19.38',NULL,'56 rue louis robillard cada sona','tra b 101','','14670','TROARN',NULL,NULL,'1620914328001',526.000000000,'1989-03-10','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (881,'GOUABAULT','MICHEL','1931-08-06','02.53.39.57.16','06.59.64.24.77',NULL,'19 RESIDENCE DU PARC','','','14730','GIBERVILLE',NULL,NULL,'2310814370001',12.000000000,'1960-05-04','PREMIUM',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (882,'DETERVILLE','PIERRE','1936-08-26','02.11.95.88.56','06.29.07.25.65',NULL,'42 ROUTE DE PARIS','','','14540','BOURGUEBUS',NULL,NULL,'1360814990001',295.000000000,'1966-09-13','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (883,'DODOLIN','GEORGES','1927-10-07','02.77.17.64.27','06.73.25.42.58',NULL,'le lieu dit meheudin','','','50630','QUETTEHOU',NULL,NULL,'1271071279001',10.000000000,'1950-09-23','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (884,'DEMORTREUX','FRANCOISE','1931-04-08','02.37.99.99.02','06.10.32.84.80',NULL,'5 rue des perrees','','','14840','DEMOUVILLE',NULL,NULL,'1310427243001',506.000000000,'1952-05-19','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (885,'DEMORTREUX','CLAUDE','1931-01-02','02.38.71.63.31','06.56.56.43.27',NULL,'10 impasse des pommiers','','','14320','ST ANDRE SUR ORNE',NULL,NULL,'2310114221001',363.000000000,'1961-07-09','PREMIUM',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (886,'GROSSET','CHRISTIAN','1940-07-13','02.56.24.78.50','06.28.17.75.05',NULL,'25 AVENUE PIERRE ET MARIE CURIE','','','14000','CAEN',NULL,NULL,'1400703071001',98.000000000,'1963-12-04','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (887,'BUTEL','YVETTE','1933-12-06','02.11.77.77.95','06.68.89.95.84',NULL,'LA RUFAUVIERE','','','14550','BLAINVILLE SUR ORNE',NULL,NULL,'1331214297001',28.000000000,'1954-02-08','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (888,'MAUBANT','JACQUELINE','1960-04-24','02.62.61.70.18','06.50.14.06.05',NULL,'35 RUE GEORGES POMPIDOU','','','14000','CAEN',NULL,NULL,'2600478670001',76.000000000,'1985-11-18','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (889,'LANOS','GILBERT','1936-02-14','02.70.77.50.28','06.74.25.70.51',NULL,'5 RUE DE LA MULLOISIERE','','','14000','CAEN',NULL,NULL,'1360245324001',197.000000000,'1962-06-11','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (890,'','JEAN','1954-04-12','02.11.90.46.86','06.81.00.21.89',NULL,'1 place de la liberte appt 14','','','14540','ROCQUANCOURT',NULL,NULL,'1540414530001',141.000000000,'1977-07-25','PREMIUM',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (891,'PINEL','MICHEL','1939-01-06','02.47.51.89.58','06.62.84.98.41',NULL,'11 rue pasteur','','','14000','CAEN',NULL,NULL,'1390114646001',296.000000000,'1962-07-18','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (892,'MORAINE','SIMONE','1933-09-30','02.62.52.90.49','06.44.40.21.93',NULL,'168 RUE DE FALAISE','','','14123','CORMELLES LE ROYAL',NULL,NULL,'1330950446001',63.000000000,'1961-10-13','PREMIUM',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (893,'SABINE','GEORGETTE','1931-09-11','02.71.74.22.96',NULL,NULL,'9 allee st marcouf','','','14320','ST MARTIN DE FONTENAY',NULL,NULL,'2310914016001',2502.000000000,'1955-09-02','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (894,'DEPONT','YOLANDE','1946-03-11','02.16.87.32.34','06.10.80.72.33',NULL,'22 RUE DU PARC','','','14160','DIVES SUR MER',NULL,NULL,'1460314590001',76.000000000,'1968-02-04','GOLD',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (895,'LETULLIER','ALBERT','1946-03-22','02.11.64.82.52','06.52.68.46.97',NULL,'3 PARVIS NOTRE DAME','','','14340','MANERBE',NULL,NULL,'1460314590001',418.000000000,'1968-02-28','GOLD',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (896,'RATUSZNIK','CLAUDE','1940-05-03','02.74.70.22.04',NULL,NULL,'5 rue des anciens de l''afn','','','14320','ST MARTIN DE FONTENAY',NULL,NULL,'2400527045001',707.000000000,'1962-01-16','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (897,'AILLET','MARCEL','1928-08-20','02.86.18.13.36','06.89.05.91.78',NULL,'22 rue pasteur','','','14123','IFS',NULL,NULL,'2280814182001',1717.000000000,'1956-08-06','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (898,'LEFEVRE','JANINE','1933-09-11','02.54.72.04.76','06.11.31.20.47',NULL,'2 chemine de caen','','','14120','MONDEVILLE',NULL,NULL,'2330914201001',5.000000000,'1960-09-09','GOLD',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (899,'MESNIL','FABIENNE','1930-11-25','02.10.64.87.96','06.33.26.85.64',NULL,'515 rue du tour de ville','','','14840','CUVERVILLE',NULL,NULL,'2301114720001',240.000000000,'1951-04-23','PREMIUM',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (900,'SOBOL','RAYMOND','1961-03-09','02.25.79.44.87','06.90.93.05.23',NULL,'34 RUE DE CHAMPAGNE','','','14430','DOUVILLE EN AUGE',NULL,NULL,'2610361135001',384.000000000,'1984-09-08','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (901,'DEMOOR','MAURICE','1966-01-27','02.19.83.65.75','06.91.04.10.51',NULL,'14 RUE DE LA HAIE BRETON','','','14270','MAGNY LE FREULE',NULL,NULL,'2660114057001',1166.000000000,'1991-08-30','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (902,'VIOLLET','ANNICK','1948-02-19','02.63.52.45.22','06.97.27.23.51',NULL,'','','','14800','TOUQUES',NULL,NULL,'2480250347001',362.000000000,'1976-12-28','GOLD',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (903,'FRANC','ANDREE','1947-06-06','02.47.32.39.14','06.10.20.63.32',NULL,'15 rue du stade','','','14123','CORMELLES LE ROYAL',NULL,NULL,'1470650129001',753.000000000,'1974-08-10','GOLD',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (904,'LELONG','MICHELINE','1959-01-10','02.56.16.02.40','06.61.48.83.76',NULL,'LE MESNIL HERMIER','','','50500','CARENTAN',NULL,NULL,'2590114206001',21.000000000,'1984-07-16','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (905,'THIBOUT','BERNARD','1950-01-09','02.58.95.65.45','06.10.72.12.88',NULL,'12 rue gandhi','','','61200','ARGENTAN',NULL,NULL,'1500114746001',170.000000000,'1973-11-23','PREMIUM',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (906,'LENEGRE','COLETTE','1959-02-13','02.59.99.04.28','06.41.86.41.69',NULL,'7 RUE DAMOZANNE','','','61570','ST LOYER DES CHAMPS',NULL,NULL,'2590214538001',93.000000000,'1983-03-10','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (907,'ROUSSEL','JEAN CLAUDE','1932-10-31','02.52.20.70.02','06.18.22.89.35',NULL,'15 rte de cabourg','','','14000','CAEN',NULL,NULL,'2321014409001',36.000000000,'1953-10-04','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (908,'COLETTI','WANDA','1928-03-28','02.62.27.33.70','06.21.39.57.91',NULL,'MAISONCELLES S/AJON','','','14000','CAEN',NULL,NULL,'2280350553001',76.000000000,'1951-08-14','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (909,'JOUENNE','Roger','1928-05-04','02.74.76.30.32',NULL,NULL,'12 RUE LECOMTE','','','14170','ST PIERRE SUR DIVES',NULL,NULL,'1280514220001',35.000000000,'1952-04-10','PREMIUM',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (910,'FOUCHER','ROGER','1942-04-21','02.70.79.10.17','06.33.19.27.41',NULL,'2 rue du boulhoullay','','','14320','CLINCHAMPS SUR ORNE',NULL,NULL,'1420478239001',418.000000000,'1964-12-05','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (911,'ROGUE','JEANNE','1940-01-09','02.40.39.19.95','06.37.69.03.99',NULL,'8 rue j. catherine','','','14270','ERNES',NULL,NULL,'1400177280001',3.000000000,'1968-11-03','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (912,'HARTEL','PATRICK','1941-07-04','02.86.22.03.12','06.77.37.64.54',NULL,'10 rue louis braille','','','14370','AIRAN',NULL,NULL,'1410760219001',1098.000000000,'1965-10-28','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (913,'DUFEIL','YVETTE','1929-08-26','02.23.56.93.68','06.50.67.56.60',NULL,'76 AVENUE DE PARIS','','','61310','VILLEBADIN',NULL,NULL,'1290850515001',596.000000000,'1951-02-13','PREMIUM',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (914,'BOULLIER','MADELEINE','1959-01-13','02.11.56.31.18','06.87.48.61.25',NULL,'8 RUE DU BERRY','','','14980','ROTS',NULL,NULL,'1590114719001',48.000000000,'1989-04-01','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (915,'CHAUVET','Jean pierre','1933-11-24','02.57.69.22.96','06.12.38.26.51',NULL,'1 RUE PIERRE LEPRESTRE','','','50160','GUILBERVILLE',NULL,NULL,'1331127169001',286.000000000,'1956-09-22','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (916,'ISABEL','FRANCOISE','1930-11-02','02.33.98.33.22','06.39.47.43.49',NULL,'27 RUE DU PONT CREON','','','14170','OUVILLE LA BIEN TOURNEE',NULL,NULL,'2301193710001',98.000000000,'1952-12-16','PLATINIUM',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (917,'HUE','GENEVIEVE','1956-05-02','02.47.24.98.63','06.63.69.52.78',NULL,'4 RUE DU STADE','','','14000','CAEN',NULL,NULL,'2560514049001',144.000000000,'1978-01-23','PREMIUM',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (918,'EUDES','NICOLE','1940-06-24','02.58.78.95.25','06.13.35.63.58',NULL,'','','','14250','TILLY SUR SEULLES',NULL,NULL,'2400614228001',1394.000000000,'1969-06-08','SILVER',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (919,'RIGOT','DOMINIQUE','1957-08-15','02.10.11.36.84','06.95.79.56.44',NULL,'RUE DES MESLIERS','','','14000','CAEN',NULL,NULL,'1570814502001',30.000000000,'1980-09-21','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (920,'DALISSON','LUCIEN','1938-01-29','02.76.90.18.13','06.65.91.44.68',NULL,'LA FERME DU BOURG','','','14190','OUILLY LE TESSON',NULL,NULL,'2380114060001',2068.000000000,'1962-10-30','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (921,'GODEFROY','JACKIE','1951-03-30','02.48.97.76.02','06.65.29.90.03',NULL,'CHEMIN DU DOUET NOLENT','','','14370','ARGENCES',NULL,NULL,'2510314176001',118.000000000,'1981-07-08','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (922,'LEBATARD','COLETTE','1959-01-23','02.83.06.43.26','06.26.91.82.05',NULL,'132 rue de poterie','','','83120','STE MAXIME',NULL,NULL,'1590114014001',104.000000000,'1981-03-13','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (923,'DESCHAMPS','PHILOMIN','1929-02-05','02.52.84.34.27','06.44.21.34.52',NULL,'LE BEAU TONNE','','','14370','ARGENCES',NULL,NULL,'1290261401001',833.000000000,'1952-01-17','PLATINIUM',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (924,'VANOVERBEKE','ODETTE','1928-10-02','02.11.62.86.04','06.69.59.76.42',NULL,'3 RUE DES PRIMEVERES','','','14320','FEUGUEROLLES BULLY',NULL,NULL,'2281014328001',354.000000000,'1949-03-26','PREMIUM',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (925,'HEBERT','RAYMOND','1932-03-01','02.84.74.81.78',NULL,NULL,'7 rue du chateau d''eau','','','14000','CAEN',NULL,NULL,'1320314376001',269.000000000,'1953-12-15','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (926,'CHANTREUIL','Batrice','1930-12-17','02.44.80.46.49','06.94.42.56.93',NULL,'','','','14220','BOULON',NULL,NULL,'2301272220001',0.000000000,'1953-04-26','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (927,'LEMARQUAND','SIMONE','1965-02-21','02.83.69.42.90','06.36.93.79.37',NULL,'133 rue haute','','','14123','IFS',NULL,NULL,'1650214396001',167.000000000,'1991-02-03','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (928,'LEFEVRE','GEORGES','1969-04-23','02.61.47.39.89','06.55.04.77.71',NULL,'5 impasse des marniers','','','14940','SANNERVILLE',NULL,NULL,'1690437242001',5136.000000000,'1996-10-04','PREMIUM',12,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (929,'COIGNEAUX','ARLETTE','1933-12-25','02.91.10.66.04','06.59.53.01.92',NULL,'17 rue paul eluard','','','14120','MONDEVILLE',NULL,NULL,'2331214200001',14.000000000,'1961-06-06','GOLD',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (930,'BELMONTE','NATACHA','1936-02-16','02.70.84.80.35','06.23.28.50.93',NULL,'FONTAINE HALBOUT','','','14190','GRAINVILLE LANGANNERIE',NULL,NULL,'1360261071001',388.000000000,'1957-07-11','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (931,'TESSIER','LUCIENNE','1968-12-01','02.11.90.86.37','06.41.47.99.98',NULL,'','','','14190','ESTREES LA CAMPAGNE',NULL,NULL,'1681214525001',1577.000000000,'1996-11-14','PREMIUM',12,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (932,'GUILLARD','PASCAL','1968-12-20','02.64.84.08.20','06.51.72.03.81',NULL,'6 RUE DE LA MUTUALITE','','','14111','LOUVIGNY',NULL,NULL,'1681214525001',85.000000000,'1996-01-10','PREMIUM',12,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (933,'MARIE','GERMAINE','1939-02-08','02.46.45.44.50','06.11.92.96.84',NULL,'7 route d ifs','','','14220','FRESNEY LE VIEUX',NULL,NULL,'1390214566001',106.000000000,'1963-01-13','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (934,'SIRAUT','PIERRE','1938-03-19','02.10.68.72.98','06.40.48.55.48',NULL,'2 RUE DES LILAS','','','14123','FLEURY SUR ORNE',NULL,NULL,'1380314157001',71.000000000,'1964-07-05','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (935,'GAIGNON','bernard','1932-09-07','02.16.12.34.72','06.64.34.88.22',NULL,'31 rue auguste lechesne','','','14860','BAVENT',NULL,NULL,'1320914449001',116.000000000,'1961-01-09','GOLD',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (936,'ROBERT','','1937-12-21','02.78.10.92.71','06.82.93.80.06',NULL,'24 RUE BOULLEU','','','14700','FALAISE',NULL,NULL,'2371214485001',1045.000000000,'1960-07-17','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (937,'PRUNEAU','MARIE LAURENCE',NULL,'02.51.34.29.47','06.16.85.23.91',NULL,'2 rue de la liberation','','','14000','CAEN',NULL,NULL,'2660114386001',17.000000000,'2011-03-03','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (938,'LANCHAS','JEANINE','1937-12-18','02.77.29.05.18','06.37.35.64.05',NULL,'LE FEY','','','14160','DIVES SUR MER',NULL,NULL,'2371214211001',662.000000000,'1962-07-24','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (939,'RICHIER','Paulette','1951-02-08','02.15.81.87.36','06.58.19.91.28',NULL,'4 rue des ifs','','','14123','CORMELLES LE ROYAL',NULL,NULL,'1510214499001',102.000000000,'1975-05-29','PREMIUM',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (940,'CACHARD','Chantal','1934-04-19','02.53.61.00.88','06.23.31.45.91',NULL,'','','','14123','IFS',NULL,NULL,'1340414063001',259.000000000,'1962-11-18','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (941,'LORY','MARIETTE','1937-04-20','02.49.97.59.24','06.79.52.42.05',NULL,'909 Bd du Val','','','14000','CAEN',NULL,NULL,'1370414328001',25.000000000,'1958-08-19','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (942,'LAURENT','SYLVIE','1968-01-24','02.43.48.15.32','06.39.65.62.06',NULL,'14 rue ed herioz','','','14000','CAEN',NULL,NULL,'1680114384001',18.000000000,'1989-09-25','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (943,'FRANCOIS','ANDRE',NULL,'02.71.27.55.65','06.14.73.05.23',NULL,'10 RUE ALBERT BAYET','','','14320','ST ANDRE SUR ORNE',NULL,NULL,'2430314205001',1845.000000000,'2012-08-10','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (944,'BAUTMANS','PATRICIA','1961-05-07','02.53.99.48.61','06.35.80.06.31',NULL,'5 RUE LECHARTIER DE LA VARIGNIER','E','','14123','IFS',NULL,NULL,'1610572225001',46.000000000,'1988-12-11','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (945,'EURIN','RAYMOND','1933-02-01','02.23.54.83.26','06.31.29.25.90',NULL,'2 RUE DES VIKINGS','','','14123','FLEURY SUR ORNE',NULL,NULL,'1330214574001',554.000000000,'1961-11-22','PREMIUM',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (946,'BEDEL','JANINE','1934-02-25','02.19.22.29.94','06.36.82.01.39',NULL,'9 RUE DES PETITES COUTURES','','','14210','GRAINVILLE SUR ODON',NULL,NULL,'2340250288001',952.000000000,'1955-08-10','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (947,'DELACOUR','GERARD','1947-06-22','02.12.03.06.41','06.47.63.33.43',NULL,'residence les matine 10 avenue d','e paris','','14540','ROCQUANCOURT',NULL,NULL,'1470614339001',24.000000000,'1976-07-13','GOLD',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (948,'GADY','ODETTE','1946-05-10','02.23.51.55.47','06.37.98.88.07',NULL,'9 RUE FRANCHE','','','14250','FONTENAY LE PESNEL',NULL,NULL,'2460536227001',169.000000000,'1970-07-02','GOLD',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (949,'BOUZFOUR','LILIANE','1932-01-18','02.71.30.16.15','06.28.59.16.98',NULL,'10 rue pasteur','','','14200','HEROUVILLE ST CLAIR',NULL,NULL,'1320114390001',1226.000000000,'1954-03-04','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (950,'BRIERE','THERESE','1938-11-21','02.45.67.53.12','06.21.65.80.14',NULL,'2 RUE AUGUSTE LECHESNE','','','14000','CAEN',NULL,NULL,'2381114714001',2217.000000000,'1961-07-05','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (951,'MARIE','JACQUES','1942-01-11','02.66.12.30.34','06.86.43.53.33',NULL,'74 RUE GENERAL DE GAULLE','','','14500','COULONCES',NULL,NULL,'1420114610001',180.000000000,'1965-03-02','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (952,'LECHEVALIER','JACQUES','1963-08-21','02.34.81.54.73','06.12.18.52.39',NULL,'29 RUE DE LA FOLIE','','','14370','VIMONT',NULL,NULL,'1630821460001',1644.000000000,'1989-02-07','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (953,'ROBERT','SERGE','1938-07-31','02.11.72.42.43','06.92.78.59.90',NULL,'7 RUE DES BOULEAUX','','','14190','FIERVILLE BRAY',NULL,NULL,'2380714218001',17.000000000,'1960-10-26','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (954,'LEBLANC','JEANINE','1935-07-21','02.52.70.01.84','06.52.65.88.11',NULL,'CHEMIN DU RIGOLET','','','14123','IFS',NULL,NULL,'2350750462001',202.000000000,'1958-06-07','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (955,'LEBENOIT','MARIE-CLAIRE','1935-05-14','02.38.57.58.45','06.88.62.58.31',NULL,'8 place pablo neruda','','','22730','TREGASTEL',NULL,NULL,'1350550281001',46.000000000,'1957-09-07','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (956,'TRANCHANT','SOLANGE','1940-07-16','02.34.02.29.11','06.95.55.44.92',NULL,'6 RUE DES SABLONS','','','14220','BARBERY',NULL,NULL,'1400772039001',80.000000000,'1970-08-23','SILVER',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (957,'TRAVERS','YVETTE','1929-12-27','02.54.43.19.06','06.37.63.34.52',NULL,'21 RUE LEONARD GILLES','','','14111','LOUVIGNY',NULL,NULL,'2291214073001',1630.000000000,'1957-07-26','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (958,'GABRIEL','JANINE','1928-07-07','02.65.56.87.44','06.41.03.21.93',NULL,'GRANDE RUE','','','14220','CESNY BOIS HALBOUT',NULL,NULL,'1280722143001',100.000000000,'1953-08-02','PREMIUM',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (959,'RICHARD','RENEE','1959-03-23','02.10.06.65.41','06.24.84.11.73',NULL,'61 RUE DE FALAISE','','','14520','PORT EN BESSIN HUPPAIN',NULL,NULL,'2590361022001',102.000000000,'1989-12-29','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (960,'BRASIL','FRANCOISE','1929-11-06','02.85.02.70.37','06.50.20.43.02',NULL,'HAMEAU DE SOQUENCE','','','14730','GIBERVILLE',NULL,NULL,'2291114378001',155.000000000,'1952-11-23','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (961,'COLLET','DANIEL','1930-02-02','02.85.89.22.61','06.49.11.04.73',NULL,'9 BOULEVARD RICHEMOND','','','14460','COLOMBELLES',NULL,NULL,'1300272097001',9.000000000,'1957-05-03','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (962,'MARIE','NICOLE','1931-09-29','02.68.18.17.96','06.39.17.05.31',NULL,'6 avenue des chevaliers','','','14123','IFS',NULL,NULL,'2310914247001',1182.000000000,'1952-02-08','PLATINIUM',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (963,'FILOCHE','MICHEL','1939-03-05','02.26.58.08.44','06.48.83.61.78',NULL,'ROUTE DE BISSIERE','','','14340','CREVECOEUR EN AUGE',NULL,NULL,'2390314167001',130.000000000,'1969-12-16','SILVER',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (964,'LEFEVRE','SUZANNE','1938-04-28','02.53.89.54.04','06.10.15.54.67',NULL,'8 rue des pres','','','50110','TOURLAVILLE',NULL,NULL,'2380461062001',48.000000000,'1962-10-09','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (965,'LEVANNIER','CHRISTIANE','1931-04-09','02.11.13.36.88','06.61.18.15.75',NULL,'ZA LE MARESQUIER','','','14000','CAEN',NULL,NULL,'2310435084001',80.000000000,'1954-03-08','PREMIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (966,'CARINI','JEANNINE','1930-09-29','02.12.08.27.80','06.65.14.44.74',NULL,'14 RUE LECONTE','','','14730','GIBERVILLE',NULL,NULL,'2300914326001',3626.000000000,'1952-12-27','PREMIUM',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (967,'SIMEON','JACQUELINE','1950-05-15','02.99.68.34.10','06.81.81.19.39',NULL,'7 RUE JEAN MERMOZ','','','14000','CAEN',NULL,NULL,'2500514198001',26.000000000,'1979-03-28','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (968,'COLOMBE','MARC','1934-09-01','02.89.97.83.51','06.24.65.15.08',NULL,'7 rue roger bastion','','','14123','CORMELLES LE ROYAL',NULL,NULL,'1340950544001',122.000000000,'1961-10-04','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (969,'SIMON','MARC','1932-07-11','02.97.52.14.49','06.55.46.86.21',NULL,'24 place du marche','','','14540','SOLIERS',NULL,NULL,'1320714416001',2640.000000000,'1955-05-20','PLATINIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (970,'','NADINE','1956-03-20','02.72.98.35.51','06.59.15.03.06',NULL,'38 rue val es dunes','','','14810','MERVILLE FRANCEVILLE PLAGE',NULL,NULL,'2560314011001',156.000000000,'1984-04-14','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (971,'BREHAM','DENISE','1964-11-29','02.62.55.30.71','06.37.50.29.14',NULL,'la corniere','','','14000','CAEN',NULL,NULL,'1641199255001',34.000000000,'1987-08-30','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (972,'QUERTINMONT','GISELE','1968-01-24','02.41.77.35.96','06.47.60.02.23',NULL,'48 bd de la forbine','','','14680','BRETTEVILLE SUR LAIZE',NULL,NULL,'1680153166001',38.000000000,'1992-01-06','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (973,'COISPEL','','1930-06-04','02.81.09.61.68','06.99.60.49.24',NULL,'3 rue saint sernin','','','14100','LISIEUX',NULL,NULL,'1300661397001',125.000000000,'1959-05-01','PREMIUM',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (974,'DOINEL','CLAUDETTE','1966-01-11','02.17.32.28.53','06.83.50.98.66',NULL,'39 RUE DES ACCACIAS','','','14000','CAEN',NULL,NULL,'1660162557001',12.000000000,'1991-11-21','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (975,'MENARD','MARGUERITE','1939-09-26','02.33.37.62.47','06.10.27.43.17',NULL,'2 allee du general sismonds','','','14000','CAEN',NULL,NULL,'1390914261001',962.000000000,'1963-12-24','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (976,'PAVIE','FRANCOIS','1960-05-04','02.61.34.49.83','06.11.25.24.21',NULL,'','','','14370','CROISSANVILLE',NULL,NULL,'1600514482001',59.000000000,'1982-08-22','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (977,'CHETOUH','ERIC','1937-05-17','02.40.77.15.30','06.91.98.48.87',NULL,'LE BOURG','','','14320','ST MARTIN DE FONTENAY',NULL,NULL,'1370550640001',11.000000000,'1958-08-11','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (978,'LACOUR','ISABELLE','1951-03-26','02.36.61.02.91','06.74.01.12.66',NULL,'3 RUE DES PLUVIERS','','','50500','CARENTAN',NULL,NULL,'1510361081001',23.000000000,'1974-07-05','PREMIUM',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (979,'JENVRIN','MAURICE','1937-10-29','02.66.42.46.38','06.41.74.85.93',NULL,'5 CHEMIN DU MOULIN','','','14570','ST REMY',NULL,NULL,'1371061081001',1047.000000000,'1960-01-16','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (980,'HERICY','EDMONDE','1956-05-29','02.80.53.31.74',NULL,NULL,'LA FARCIERE','','','14130','ST GATIEN DES BOIS',NULL,NULL,'1560561208001',593.000000000,'1980-09-07','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (981,'BULTEY','PHILIPPE','1933-04-29','02.25.05.32.38','06.11.74.00.98',NULL,'79 RUE SAINT PATRICE','','','14370','ARGENCES',NULL,NULL,'1330414722001',156.000000000,'1954-05-24','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (982,'JAMES','GEORGES','1948-11-02','02.19.69.72.44','06.10.13.67.35',NULL,'8 BOULEVARD LONGUET','','','14500','VIRE',NULL,NULL,'1481128107001',20.000000000,'1972-06-23','GOLD',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (983,'','MICHEL','1936-07-07','02.46.24.88.83','06.75.83.28.99',NULL,'11 RUE DES HOMMETS','','','14730','GIBERVILLE',NULL,NULL,'1360714120001',29.000000000,'1963-06-10','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (984,'BINET','GILLES','1955-04-08','02.82.14.95.31','06.95.56.13.36',NULL,'12 rue des sablonnettes','','','50300','LE VAL ST PERE',NULL,NULL,'2550427384001',160.000000000,'1979-06-26','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (985,'BOURREE','ROGER','1966-07-11','02.49.21.25.56','06.70.50.67.77',NULL,'14 rue du limousin','','','14960','MEUVAINES',NULL,NULL,'1660728390001',39.000000000,'1988-05-29','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (986,'JOUANNE','DANIELE','1959-01-05','02.88.52.49.89','06.75.98.09.32',NULL,'','','','14730','GIBERVILLE',NULL,NULL,'2590114057001',3553.000000000,'1986-02-08','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (987,'PESNELLE','CHRISTIAN','1939-06-29','02.12.27.32.76','06.33.81.72.37',NULL,'5 RUE LUCIE MANGEMATIN FOYER GOU','ESLARD','','14000','CAEN',NULL,NULL,'1390661197001',429.000000000,'1960-02-13','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (988,'ARZUR','CHARLES','1931-09-21','02.39.99.07.82','06.11.92.67.88',NULL,'8 RUE CORISANDE','','','14840','DEMOUVILLE',NULL,NULL,'1310914760001',350.000000000,'1955-09-22','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (989,'BONNET','ANDREE','1938-04-28','02.43.46.70.25','06.25.42.09.35',NULL,'LIEU DIT MONT ROTI','','','14000','CAEN',NULL,NULL,'2380461030001',3867.000000000,'1968-07-06','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (990,'GEFRAIN','THIERRY','1950-03-02','02.98.01.66.08','06.11.50.48.12',NULL,'QUARTIER DE L''EGLISE','','','14123','FLEURY SUR ORNE',NULL,NULL,'1500314610001',856.000000000,'1975-06-14','PREMIUM',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (991,'TOMBETTE','MAURICE','1929-01-09','02.53.58.61.81','06.14.56.36.23',NULL,'','','','14200','HEROUVILLE ST CLAIR',NULL,NULL,'2290149143001',33.000000000,'1950-07-02','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (992,'SAVARY','THERESE','1936-02-25','02.12.03.64.45','06.98.04.95.16',NULL,'RUE DU VAL DE QUESNAY','','','14123','IFS',NULL,NULL,'2360250609001',69.000000000,'1962-05-01','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (993,'FOUCHER','CHRISTIANE','1963-02-14','02.61.31.63.15','06.19.61.04.13',NULL,'7 RUE ANDRE PIERRE MARIE','','','14000','CAEN',NULL,NULL,'1630214057001',34.000000000,'1993-04-03','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (994,'RAULINE','MICHEL','1936-12-24','02.23.93.34.18','06.23.41.35.92',NULL,'109 bd general vasnier','','','61200','FLEURE',NULL,NULL,'2361214118001',525.000000000,'1965-08-26','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (995,'CULOT','GILBERT','1930-07-20','02.49.60.43.22','06.32.52.94.32',NULL,'la hogue','','','14123','IFS',NULL,NULL,'2300750002001',133.000000000,'1955-11-27','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (996,'BLOUET','ROGER','1964-03-14','02.10.95.61.96','06.11.33.82.52',NULL,'2-1 ALLEE SERPENTINE','','','14000','CAEN',NULL,NULL,'1640350545001',126.000000000,'1991-03-29','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (997,'JAGUIN','SUZANNE','1930-03-15','02.17.21.17.19','06.54.59.90.21',NULL,'LE PARC DAVOUST','','','14000','CAEN',NULL,NULL,'2300314137001',10.000000000,'1953-05-23','PREMIUM',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (998,'','GERARD','1940-02-04','02.70.56.81.40','06.89.99.14.17',NULL,'36 rue du 07 aout 1944','','','14740','BRETTEVILLE L''ORGUEILLEUSE',NULL,NULL,'2400214695001',36.000000000,'1970-08-28','SILVER',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (999,'GERMOND','christophe','1957-03-27','02.12.09.89.85','06.38.26.66.58',NULL,'ROUTE DE FONTAINE HENRY','','','14440','DOUVRES LA DELIVRANDE',NULL,NULL,'1570361360001',8.000000000,'1978-11-21','PREMIUM',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1000,'LEMAHIEU','ERIC','1982-01-26','02.21.73.37.48','06.11.60.13.88',NULL,'16 RUE DE L''EGLISE','','','14630','CAGNY',NULL,NULL,'2820199253001',127.000000000,'2004-05-19','PREMIUM',10,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1001,'BAUCHER','NOELLE','1936-07-17','02.79.04.89.04','06.51.06.92.69',NULL,'7 RUE DE LA COOPERATIVE','','','14840','DEMOUVILLE',NULL,NULL,'1360735137001',503.000000000,'1957-11-21','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1002,'BARON','Michel','1964-06-08','02.12.04.16.76','06.39.52.34.82',NULL,'14 RUE DE BURON','','','14260','AUNAY SUR ODON',NULL,NULL,'1640675041001',198.000000000,'1987-07-29','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1003,'BEAUDRON','Michel','1939-05-05','02.64.86.08.95','06.12.08.70.06',NULL,'34 RUE DES TILLEULS','','','14460','COLOMBELLES',NULL,NULL,'2390550530001',1250.000000000,'1962-01-10','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1004,'FORTIN','CHRISTOPHE','1955-03-01','02.17.37.63.81','06.81.29.97.08',NULL,'7 rue de la vallee','','','14700','FALAISE',NULL,NULL,'2550361430001',15.000000000,'1983-11-26','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1005,'GROSOS','GUY','1940-03-28','02.39.07.24.65','06.34.90.23.41',NULL,'15 rue des bons enfants','','','14000','CAEN',NULL,NULL,'1400314060001',329.000000000,'1968-04-14','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1006,'DUBOC','WILLIAM','1935-05-15','02.46.59.26.42','06.62.65.12.15',NULL,'2 avenue de la concorde','','','14260','AUNAY SUR ODON',NULL,NULL,'1350514340001',56.000000000,'1958-07-25','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1007,'JOSEPH','SIMONE','1938-07-23','02.11.96.42.69','06.28.10.83.26',NULL,'5 RUE ROGER POULAIN','','','61200','ARGENTAN',NULL,NULL,'1380714349001',1910.000000000,'1962-02-11','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1008,'BOURGOIS','OLIVIER','1930-02-21','02.11.43.88.79','06.12.42.24.41',NULL,'11 ALLEE DE VARSOVIE','','','14000','CAEN',NULL,NULL,'2300261173001',844.000000000,'1953-12-18','PLATINIUM',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1009,'LE FRAPPER','DOMINIQUE','1936-06-26','02.48.71.43.79','06.55.95.69.33',NULL,'9 RUE DU TEMPS PERDU','','','14000','CAEN',NULL,NULL,'2360614116001',41.000000000,'1957-03-13','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1010,'MARIE','HERVE','1933-11-20','02.14.29.21.33','06.12.26.96.10',NULL,'21 RUE ST JEAN BAPTISTE','','','14740','STE CROIX GRAND TONNE',NULL,NULL,'2331114461001',172.000000000,'1956-08-25','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1011,'HUET','GERARD','1950-03-08','02.54.47.37.11','06.16.54.05.91',NULL,'24 ROUTE DE PARIS','','','14550','BLAINVILLE SUR ORNE',NULL,NULL,'2500350262001',197.000000000,'1972-01-18','PREMIUM',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1012,'BRAULT','GERARD','1933-05-22','02.83.99.15.52','06.71.83.82.94',NULL,'401 BD DU VAL','','','14000','CAEN',NULL,NULL,'2330514544001',1808.000000000,'1956-04-26','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1013,'OLIVE','eugene','1934-02-15','02.48.23.76.93','06.23.20.79.35',NULL,'15 RUE LEON JOUHAUX','','','14410','VASSY',NULL,NULL,'1340214714001',19.000000000,'1955-07-08','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1014,'LAGRAVE','BERNARD','1952-01-17','02.62.62.98.25','06.98.82.44.02',NULL,'18 porte millet','','','14570','LE VEY',NULL,NULL,'2520114195001',881.000000000,'1981-01-21','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1015,'LEMOIGNE','EMILIENNE','1939-05-02','02.12.10.84.11','06.83.68.41.94',NULL,'LE VAL D''OR APPT 21 18 RUE R.AI','NI','','14000','CAEN',NULL,NULL,'1390559580001',3443.000000000,'1962-11-15','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1016,'BALLIERE','lucie','1929-10-17','02.37.05.48.90','06.16.07.90.41',NULL,'rue des haies d''argence','','','14860','BAVENT',NULL,NULL,'2291021404001',63.000000000,'1954-05-06','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1017,'MAURICE','JEAN CLAUDE','1940-05-03','02.60.41.21.22','06.16.93.75.04',NULL,'residence de l''eglise bat b2 r1','','','14123','CORMELLES LE ROYAL',NULL,NULL,'2400514304001',173.000000000,'1961-11-22','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1018,'ROUSSEL','MARIE JEANNE','1959-01-19','02.26.84.93.99','06.10.87.73.91',NULL,'9 rue jean le carpentier','','','14320','ST ANDRE SUR ORNE',NULL,NULL,'2590114271001',82.000000000,'1981-11-10','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1019,'KEDZIORA','EVELINE','1941-07-07',NULL,NULL,NULL,'10 RUE TESTE DE BUCH','','','14000','CAEN',NULL,NULL,'1410714499001',13.000000000,'1963-09-16','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1020,'BOISET','SYLVIE','1941-07-27','02.87.19.90.81','06.24.76.19.39',NULL,'34 RUE VICTOR HUGO','','','14270','MEZIDON CANON',NULL,NULL,'1410714499001',1666.000000000,'1965-12-18','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1021,'BEAUDOIN','MARIE-JEANNE','1938-12-18','02.21.21.98.57','06.30.71.39.13',NULL,'22 ROUTE DE GACE','','','14123','FLEURY SUR ORNE',NULL,NULL,'2381250025001',34.000000000,'1961-06-16','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1022,'RATUSZNIK','MARIE','1938-12-12','02.82.25.95.75','06.35.15.67.72',NULL,'14 RUE PAUL LANGEVIN','','','14370','CLEVILLE',NULL,NULL,'2381250025001',478.000000000,'1961-11-11','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1023,'BEQUET','ANDREE','1955-05-23','02.33.21.64.00','06.99.18.92.89',NULL,'23 rue charles de foucault','','','14000','CAEN',NULL,NULL,'1550514548001',287.000000000,'1979-06-20','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1024,'MAISERAY','ARNAUD',NULL,'02.10.00.34.76','06.10.51.54.56',NULL,'48 ROUTE DE BENOUVILLE','','','14370','ARGENCES',NULL,NULL,'1520253199001',102.000000000,'2011-08-29','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1025,'CAPDEPON','CHANTAL','1967-07-04','02.29.70.09.24','06.50.73.08.99',NULL,'2 RUE DU PRESSOIR','','','50500','CARENTAN',NULL,NULL,'2670714107001',27.000000000,'1997-04-16','PREMIUM',12,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1026,'DUBOURG','HENRIETTE','1932-08-19','02.21.09.11.62','06.20.01.69.51',NULL,'RESIDENCE HELITAS  33 RUE ST OUE','N','','14123','FLEURY SUR ORNE',NULL,NULL,'2320814140001',238.000000000,'1956-12-06','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1027,'MORICE','Gerard','1935-06-12','02.81.82.72.32','06.98.68.26.21',NULL,'15 RUE VICTOR HUGO','','','50320','LA LUCERNE D''OUTREMER',NULL,NULL,'1350614059001',408.000000000,'1958-12-18','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1028,'VAN WYNSBERGHE','SIMONE','1930-08-14','02.29.84.39.26','06.27.08.90.95',NULL,'101 impasse des cypres','','','61130','ST OUEN DE LA COUR',NULL,NULL,'2300850531001',105.000000000,'1953-04-08','PREMIUM',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1029,'LANDAIS','JANINE','1961-01-31','02.64.18.85.73','06.10.51.14.57',NULL,'16 RUE DU PETIT PLAIN','','','14120','MONDEVILLE',NULL,NULL,'1610114109001',584.000000000,'1985-01-16','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1030,'GIRARD','PIERRE','1935-10-09','02.60.16.00.73','06.32.28.39.40',NULL,'CHEMINA DU BUISSON LIROSE','','','14123','FLEURY SUR ORNE',NULL,NULL,'2351014266001',359.000000000,'1959-06-03','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1031,'TARRAGO','MARCEL','1933-12-19','02.36.05.37.49','06.35.64.10.91',NULL,'PLACE DE L''EGLISE','','','14190','FIERVILLE BRAY',NULL,NULL,'1331275018001',8.000000000,'1958-07-09','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1032,'BARBOTTE','MICHEL','1940-06-09','02.44.06.67.96','06.28.76.43.99',NULL,'811 quartier des belles portes','','','14740','BRETTEVILLE L''ORGUEILLEUSE',NULL,NULL,'1400650400001',38.000000000,'1961-11-09','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1033,'COTEL','HENRI','1956-08-13','02.10.29.44.49','06.72.96.59.37',NULL,'16 rue du puits picard','','','14270','CESNY AUX VIGNES OUEZY',NULL,NULL,'1560814747001',25.000000000,'1977-01-25','PREMIUM',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1034,'BOUQUEREL','JEAN','1939-03-07','02.64.09.18.84','06.79.01.76.62',NULL,'6 rue alfred nobel','','','14000','CAEN',NULL,NULL,'2390361002001',493.000000000,'1969-01-14','SILVER',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1035,'CARRE','CHRISTIAN','1939-07-17','02.70.84.20.15','06.15.46.45.74',NULL,'28 RUE DE L''ESPERANCE','','','14270','MEZIDON CANON',NULL,NULL,'1390714101001',3976.000000000,'1962-07-17','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1036,'LORIDAN','LILIANE','1948-03-31','02.67.31.67.94','06.10.76.49.39',NULL,'88 RUE CHAPRON','','','14000','CAEN',NULL,NULL,'2480314287001',588.000000000,'1970-12-11','GOLD',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1037,'CASTEL','RAYMOND','1928-05-19','02.42.61.86.91','06.12.22.27.95',NULL,'38 RUE CALMETTE','','','14270','MEZIDON CANON',NULL,NULL,'2280514667001',1658.000000000,'1949-06-11','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1038,'LETELLIER','RAYMOND','1938-10-19','02.23.38.68.48','06.31.08.05.27',NULL,'887 rue du chemin vert','','','27330','LA BARRE EN OUCHE',NULL,NULL,'2381061237001',191.000000000,'1959-04-05','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1039,'','JACK','1926-02-18','02.10.13.15.90','06.11.83.38.76',NULL,'20 rue de caen','','','14160','DIVES SUR MER',NULL,NULL,'1260218082001',9.000000000,'1947-10-12','PREMIUM',22,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1040,'LOPEZ','GERARD','1934-01-22','02.28.94.45.47','06.93.30.88.26',NULL,'1 blvd des ducs','','','14000','CAEN',NULL,NULL,'2340127613001',484.000000000,'1961-12-17','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1041,'BIDARD','Jeanne','1935-02-04','02.92.48.70.76','06.64.03.89.62',NULL,'50 RUE DE CUSSY','','','14000','CAEN',NULL,NULL,'2350214703001',200.000000000,'1961-10-18','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1042,'BRAULT','FATIMA','1938-08-27','02.18.68.85.44','06.14.12.28.58',NULL,'11 rue de l''esperance','','','14760','BRETTEVILLE SUR ODON',NULL,NULL,'2380814370001',95.000000000,'1961-09-18','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1043,'BRAULT','JEANNE','1940-10-24','02.15.63.33.58','06.55.08.28.69',NULL,'28 RUE DE L''ANCIENNE GARE','','','14730','GIBERVILLE',NULL,NULL,'2401078430001',349.000000000,'1969-12-14','SILVER',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1044,'MOULIN','THERESE','1965-03-04','02.75.00.54.32','06.52.87.67.04',NULL,'39 avenue robert schumann','','','14123','IFS',NULL,NULL,'1650314245001',1244.000000000,'1987-04-18','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1045,'LECOQ','ALBERT','1937-02-12','02.67.18.02.51','06.30.84.04.90',NULL,'la forge cambro','','','14540','GRENTHEVILLE',NULL,NULL,'1370214508001',2306.000000000,'1962-06-20','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1046,'ENAULT','HENRI','1938-09-05','02.36.78.80.40','06.87.38.17.24',NULL,'route de la gare','','','14200','HEROUVILLE ST CLAIR',NULL,NULL,'2380914702001',93.000000000,'1962-05-26','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1047,'TILLARD','JANIQUE','1928-05-29','02.33.66.67.93','06.46.15.57.80',NULL,'56 av guynemer','','','14220','TOURNEBU',NULL,NULL,'1280550610001',189.000000000,'1955-05-12','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1048,'GUERIN','LEA','1939-06-20','02.12.27.36.64','06.16.29.65.70',NULL,'la moinerie','','','14000','CAEN',NULL,NULL,'1390614046001',70.000000000,'1968-04-13','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1049,'LE PERON','ROLAND','1942-09-04','02.84.50.43.99','06.81.58.40.51',NULL,'22 RUE DE LA GARE','','','14320','FEUGUEROLLES BULLY',NULL,NULL,'1420977089001',20.000000000,'1972-11-19','SILVER',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1050,'BONNETOT','denis','1919-12-24','02.37.56.09.11','06.48.68.01.80',NULL,'6 ALLEE DU GENERAL SIMONDS','','','14000','CAEN',NULL,NULL,'1191214228001',303.000000000,'1940-04-24','PREMIUM',23,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1051,'JEANNE','CHRISTIANE','1932-09-14','02.71.49.39.16','06.58.76.07.25',NULL,'3 RUE MARTIN LIEU DIT"LES PEDOUZ','ES"','','14370','MOULT',NULL,NULL,'1320914239001',0.000000000,'1953-02-27','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1052,'CHETOUH','YVETTE','1954-01-09','02.68.87.21.54','06.57.43.27.71',NULL,'29 AVENUE  CONSEIL','','','14400','BAYEUX',NULL,NULL,'2540150027001',90.000000000,'1984-02-09','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1053,'DALISSON','FERNAND','1939-04-18','02.11.10.55.47','06.37.10.62.88',NULL,'ROUTE DE ROUEN','','','14280','ST CONTEST',NULL,NULL,'2390461293001',1231.000000000,'1966-11-23','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1054,'CORDIER','HENRIETTE','1937-01-24','02.58.01.01.70','06.22.20.12.24',NULL,'3 RUE DES PRUNIERS','','','14220','THURY HARCOURT',NULL,NULL,'1370114488001',1055.000000000,'1960-01-27','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1055,'LEMONNIER','JACQUELINE','1929-04-19','02.38.42.40.18','06.80.42.80.62',NULL,'HAMEAU PLANCHE A LAHOUSSE','','','14540','BOURGUEBUS',NULL,NULL,'1290472386001',64.000000000,'1950-05-18','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1056,'LEPAS','JEAN PIERRE','1933-08-03','02.32.38.01.51','06.53.30.26.18',NULL,'4 RUE DE GENEVE','','','14120','MONDEVILLE',NULL,NULL,'2330814716001',188.000000000,'1956-03-05','PREMIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1057,'DEBAUDRE','HENRI','1953-05-09','02.87.26.89.84','06.60.93.22.68',NULL,'22 rue de verdin','','','14000','CAEN',NULL,NULL,'1530527035001',193.000000000,'1976-01-01','PREMIUM',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1058,'BELLAUNAY','CHARLES','1932-01-25','02.39.78.53.48','06.55.90.79.82',NULL,'56 rue louis robillard','','','14270','CONDE SUR IFS',NULL,NULL,'2320114235001',3937.000000000,'1954-01-21','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1059,'HARANG','YVETTE','1937-05-03','02.35.75.34.07','06.51.02.61.58',NULL,'16 rue gujan mestras','','','50460','QUERQUEVILLE',NULL,NULL,'2370561375001',207.000000000,'1962-01-07','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1060,'LABBE','VIVIANE','1969-09-21','02.55.01.40.77','06.32.38.45.66',NULL,'4 rue camille drapeau','','','14000','CAEN',NULL,NULL,'2690914118001',138.000000000,'1993-11-25','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1061,'QUELARD','ARLETTE','1928-01-14','02.42.34.71.36','06.27.81.14.25',NULL,'la conarderie','','','61570','ALMENECHES',NULL,NULL,'1280121683001',14.000000000,'1953-12-06','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1062,'TOUVIOT','MYRIAM','1937-11-22','02.84.48.31.41','06.37.03.33.28',NULL,'IMPASSE DES 4 VENTS','','','14170','BERVILLE',NULL,NULL,'2371114120001',122.000000000,'1962-08-29','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1063,'CAREL','BEATRICE','1932-09-24','02.86.47.87.22','06.51.33.65.73',NULL,'le mesnil de bavent','','','14320','ST MARTIN DE FONTENAY',NULL,NULL,'2320914062001',17.000000000,'1958-04-02','PREMIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1064,'LEBOSQUAIN','','1945-01-02','02.90.60.08.75','06.95.80.87.16',NULL,'2C CHEMIN DE CAEN','','','14370','ARGENCES',NULL,NULL,'2450114727001',643.000000000,'1968-06-26','GOLD',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1065,'FORET','BERNARD','1940-07-25','02.14.61.35.30','06.56.35.20.08',NULL,'Le Bourg','','','61150','RANES',NULL,NULL,'1400714347001',341.000000000,'1962-01-15','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1066,'RICHARD','ROGER','1939-06-03','02.74.35.03.28',NULL,NULL,'10 RUE DU MUGUET','','','14123','IFS',NULL,NULL,'1390614712001',1072.000000000,'1961-12-26','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1067,'LEGRIX','VERONIQUE','1939-06-01','02.11.32.87.26','06.10.90.85.10',NULL,'9 BD DE L4ESPERANCE','','','14760','BRETTEVILLE SUR ODON',NULL,NULL,'1390614712001',225.000000000,'1968-08-28','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1068,'GUESDON','Jean claude','1943-03-19','02.11.09.47.00','06.11.12.50.14',NULL,'','','','14460','COLOMBELLES',NULL,NULL,'2430314535001',168.000000000,'1964-08-10','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1069,'PICOT','RENEE','1957-11-30','02.70.17.79.86','06.56.28.53.94',NULL,'lieu dit le chau hauterive','','','14270','MEZIDON CANON',NULL,NULL,'2571114369001',30.000000000,'1987-02-14','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1070,'LEROY','','1938-12-28','02.46.63.55.87','06.11.71.92.10',NULL,'42 rue d harmanville','','','14000','CAEN',NULL,NULL,'1381214020001',350.000000000,'1967-09-25','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1071,'GRANGE','MARTHE','1957-02-26','02.31.61.68.61','06.59.21.42.07',NULL,'122 rue du 20 siecle','','','14260','JURQUES',NULL,NULL,'2570250038001',432.000000000,'1983-02-19','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1072,'GODEFROY','JULES','1965-01-24','02.89.30.69.52','06.61.86.71.46',NULL,'LE MESNIL','','','14220','HAMARS',NULL,NULL,'1650114118001',79.000000000,'1986-08-21','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1073,'SURIREY','THERESE','1957-03-20','02.28.96.34.22','06.10.17.60.43',NULL,'47 AVENUE PIERRE LAURENT','','','14123','IFS',NULL,NULL,'2570314257001',4818.000000000,'1979-04-28','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1074,'RIVOGNAC','JEAN PIERRE','1933-10-09','02.60.52.40.59','06.95.47.23.97',NULL,'62 RUE DE LISIEUX','','','14400','SUBLES',NULL,NULL,'2331053115001',38.000000000,'1955-08-07','PREMIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1075,'GOST','GILLES','1933-12-21','02.69.56.23.35','06.78.83.49.06',NULL,'36 RUE DE CONDE','','','14400','BAYEUX',NULL,NULL,'1331279068001',379.000000000,'1954-05-12','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1076,'SURIREY','YANKA','1968-01-14','02.88.67.79.22','06.12.23.19.40',NULL,'','','','14210','STE HONORINE DU FAY',NULL,NULL,'1680114384001',90.000000000,'1994-03-15','PREMIUM',12,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1077,'ROSSIGNOL','VALERIE','1929-01-23','02.59.86.90.77','06.90.86.99.81',NULL,'22 RUE DU PARC','','','14111','LOUVIGNY',NULL,NULL,'2290114277001',194.000000000,'1953-08-15','PREMIUM',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1078,'JOSEPH','MARIE JOSEPH','1925-12-31','02.95.34.36.70','06.81.42.18.64',NULL,'8 AVENUE MARECHAL KOENIG','','','14000','CAEN',NULL,NULL,'1251220199001',160.000000000,'1948-12-20','PREMIUM',22,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1079,'DUTILLEUL','MADELEINE','1934-09-30','02.89.26.47.66','06.61.25.16.36',NULL,'LA COUTURE BOUREL','','','14000','CAEN',NULL,NULL,'1340914416001',983.000000000,'1958-12-19','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1080,'PIERRE','MADELEINE','1963-01-01','02.51.40.49.31','06.58.80.38.60',NULL,'2 IMPASSE DES VOSGES','','','14120','MONDEVILLE',NULL,NULL,'1630114225001',258.000000000,'1985-10-11','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1081,'CORVAISIER','JEAN-LOUIS','1938-05-19','02.46.46.54.41','06.11.39.76.77',NULL,'38 RUE LOUIS LEFEVRE','','','14123','FLEURY SUR ORNE',NULL,NULL,'1380550488001',2047.000000000,'1960-06-08','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1082,'ANDRE','DENISE','1945-01-30','02.16.91.80.60','06.90.77.49.11',NULL,'5 RUE DE LA CARDONNIERE','','','14370','AIRAN',NULL,NULL,'2450176755001',2.000000000,'1973-09-19','GOLD',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1083,'GUERIN','HUBERT','1936-03-06','02.21.64.92.82','06.28.49.98.23',NULL,'11 RUE DU POINT DU JOUR','','','27500','PONT AUDEMER',NULL,NULL,'1360361371001',585.000000000,'1957-02-05','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1084,'DECAEN','ROBERT','1948-01-03','02.58.30.21.22','06.33.31.77.17',NULL,'25 av de verdun','','','14123','IFS',NULL,NULL,'1480121013001',25.000000000,'1972-04-17','GOLD',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1085,'POUPINEL','CLAUDE','1929-09-16','02.92.61.78.17','06.47.89.52.06',NULL,'15 RUE ARISTIDE BRIAND','','','14000','CAEN',NULL,NULL,'1290914327001',519.000000000,'1950-11-10','PLATINIUM',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1086,'LEMIERE','MONIQUE','1945-04-24','02.82.51.11.15','06.33.59.44.03',NULL,'11 RUE PIERRE CINGAL','','','14370','BELLENGREVILLE',NULL,NULL,'1450475048001',62.000000000,'1971-05-11','GOLD',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1087,'LEFRANC','BRIGITTE','1931-12-08','02.77.82.80.61','06.65.01.16.88',NULL,'41 AV CONSEIL','','','14000','CAEN',NULL,NULL,'1311261331001',39.000000000,'1959-08-01','GOLD',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1088,'SEEGER','SYLVIE','1930-11-02','02.54.08.62.02','06.88.46.56.43',NULL,'14 AV CONSEIL','','','14120','MONDEVILLE',NULL,NULL,'2301114704001',806.000000000,'1957-09-26','PREMIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1089,'MESNIL','JEAN-CLAUDE',NULL,'02.11.42.94.70','06.76.43.37.72',NULL,'10 AVENUE DOCT MAURICE COLLIN AP','PT 18','','14320','FONTENAY LE MARMION',NULL,NULL,'2650814305001',223.000000000,'2008-02-02','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1090,'HAREL','ANNICK','1965-09-29','02.54.64.69.78','06.10.76.39.50',NULL,'8 RUE DU DR RAYER','','','14850','ESCOVILLE',NULL,NULL,'2650914075001',9.000000000,'1991-10-10','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1091,'COURTIN','LEONCE','1938-02-03','02.52.55.92.73','06.40.86.89.94',NULL,'LA CORDERIE','','','14270','PERCY EN AUGE',NULL,NULL,'2380214275001',24.000000000,'1961-01-05','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1092,'LEMOINE','BERNARD','1955-03-23','02.11.70.93.63','06.11.05.21.33',NULL,'8 AVENUE MARECHAL KOENIG','','','14000','CAEN',NULL,NULL,'1550350072001',352.000000000,'1982-02-06','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1093,'LEMOINE','RENE','1919-12-08','02.24.48.01.77','06.10.53.58.01',NULL,'10 RUE DE SULLY','','','61200','ARGENTAN',NULL,NULL,'2191232196001',17.000000000,'1941-12-01','GOLD',23,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1094,'ANQUETIL','RENE','1946-08-27','02.86.53.38.45','06.10.88.75.54',NULL,'9 c RUE CHAPRON','','','14220','MOULINES',NULL,NULL,'2460814248001',49.000000000,'1969-05-31','GOLD',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1095,'LEMAROIS','ANDRE','1940-01-03','02.89.83.49.45','06.66.00.10.18',NULL,'6 RUE GEORGES SAND','','','14540','ST AIGNAN DE CRAMESNIL',NULL,NULL,'1400114434001',206.000000000,'1964-11-05','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1096,'BAZIRE','JEANNINE','1939-11-17','02.49.58.95.74',NULL,NULL,'62 RUE DE LA SEINE','','','14000','CAEN',NULL,NULL,'1391114420001',52.000000000,'1969-12-09','SILVER',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1097,'FESTOC','GENEVIEVE','1936-07-15','02.11.13.15.75','06.44.27.35.05',NULL,'11 RUE DES FONTAINES FONTENAY LE',' PESNEL','','14440','DOUVRES LA DELIVRANDE',NULL,NULL,'1360750024001',16.000000000,'1957-06-06','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1098,'CARBON','ODETTE','1942-06-27','02.65.69.41.36','06.84.00.84.54',NULL,'1 rue du bout roulant','','','14370','MERY CORBON',NULL,NULL,'2420614590001',75.000000000,'1971-11-16','SILVER',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1099,'LEMOIGNE','ETIENNE','1935-10-05','02.64.18.90.78','06.47.88.17.72',NULL,'10 PLACE DE LA JUSTICE FOYER D','E LA GUERINIERE','','14000','CAEN',NULL,NULL,'1351014538001',296.000000000,'1959-12-25','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1100,'PERRELLE','EMMANUEL','1936-11-02','02.45.45.19.46','06.79.21.83.77',NULL,'6 RUE MICHEL JEAN','','','14000','CAEN',NULL,NULL,'2361176485001',288.000000000,'1959-06-27','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1101,'DROST','CHRISTOPHE','1935-11-19','02.30.91.41.70','06.78.22.59.70',NULL,'LE HAMEAU BOEUF','','','14000','CAEN',NULL,NULL,'1351161289001',42.000000000,'1961-01-14','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1102,'PERREE','GERARD','1961-03-10','02.10.74.80.12',NULL,NULL,'5 RUE DE MOUEN','','','14000','CAEN',NULL,NULL,'2610378419001',2012.000000000,'1983-12-31','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1103,'HAMELIN','MARTHE','1964-02-27','02.91.20.44.50','06.98.09.04.44',NULL,'40 RUE ALBERT CAMUS','','','14000','CAEN',NULL,NULL,'2640214186001',40.000000000,'1991-09-13','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1104,'PITEL','GEORGES','1954-01-02','02.22.62.83.37','06.50.22.07.20',NULL,'1 RUE DE COURSEULLES','','','14370','ARGENCES',NULL,NULL,'2540161314001',1275.000000000,'1975-03-03','PREMIUM',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1105,'DEBAEREMAKER','MARIE LOUISE','1948-03-25','02.62.39.60.47','06.80.60.90.57',NULL,'7 RUE GASTON MONNERVILLE','','','14320','FONTENAY LE MARMION',NULL,NULL,'2480361480001',154.000000000,'1974-03-15','GOLD',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1106,'BASTARD','THIERRY','1933-04-25','02.32.50.92.38','06.98.77.25.77',NULL,'30 RUE YVES BERNARD','','','50400','GRANVILLE',NULL,NULL,'1330450301001',470.000000000,'1958-06-08','PREMIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1107,'LAMOTTE','MICHELLE','1937-07-29','02.54.43.03.00','06.90.32.10.36',NULL,'5 rue charles coulomb','','','14000','CAEN',NULL,NULL,'1370750641001',205.000000000,'1963-06-19','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1108,'DUPLEX','IRENE','1929-01-19','02.17.72.97.96','06.10.56.32.67',NULL,'164 rue de falaise','','','14120','MONDEVILLE',NULL,NULL,'1290114750001',26.000000000,'1954-11-01','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1109,'TERRY','JACQUES','1941-03-02','02.84.77.45.64','06.90.52.70.68',NULL,'16 rue de verdun','','','14320','CLINCHAMPS SUR ORNE',NULL,NULL,'2410314362001',11.000000000,'1963-08-26','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1110,'CHARDIN','MICHEL','1930-03-11','02.36.41.18.18','06.30.21.30.84',NULL,'COTE DE FIERVILLE','','','14880','HERMANVILLE SUR MER',NULL,NULL,'2300314057001',191.000000000,'1951-01-22','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1111,'HUE','CAROLE','1936-05-31','02.28.12.72.27','06.35.44.56.84',NULL,'48 RUE D''ALENCON','','','14000','CAEN',NULL,NULL,'1360514437001',604.000000000,'1957-10-31','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1112,'LE HELLEY','MARIE','1935-03-01','02.51.98.79.54','06.26.88.70.96',NULL,'29 RUE DE CHICHEBOVILLE','','','14150','OUISTREHAM',NULL,NULL,'1350361282001',56.000000000,'1956-06-11','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1113,'LAMORLETTE','CLAUDETTE','1949-01-28','02.27.57.41.19','06.48.86.95.33',NULL,'7 RUE DU QUEBEC','','',NULL,NULL,NULL,NULL,'2490114536001',342.000000000,'1974-02-23','PREMIUM',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1114,'GUILLAUME','GABRIELLE','1941-06-10','02.30.31.64.38','06.80.00.05.10',NULL,'6 ALLEE DU CLOS DE LA PRAIRIE','','','14540','SOLIERS',NULL,NULL,'2410650121001',32.000000000,'1962-11-29','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1115,'THOREL','BRIGITTE','1955-01-21','02.15.02.55.02','06.22.75.27.48',NULL,'26 rue des aubiers','','','14310','EPINAY SUR ODON',NULL,NULL,'2550114679001',358.000000000,'1985-02-09','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1116,'CHAUVIN','GISELE','1934-06-16','02.61.83.85.63','06.61.37.30.54',NULL,'','','','14000','CAEN',NULL,NULL,'1340676594001',61.000000000,'1964-09-06','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1117,'EPINETTE','MARIE THERESE','1948-12-24','02.26.23.83.00','06.44.11.31.89',NULL,'4 RUE DANIEL TISON','','','14000','CAEN',NULL,NULL,'2481214013001',16.000000000,'1970-04-16','GOLD',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1118,'FERGANT','MARIE CLAIRE','1937-09-09','02.97.24.31.16','06.58.35.82.82',NULL,'1 rue du muguet','','','14860','AMFREVILLE',NULL,NULL,'1370914749001',431.000000000,'1959-06-26','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1119,'BOULLAND','JEAN PIERRE','1940-12-25','02.66.50.67.14','06.67.13.88.76',NULL,'18 AVENUE DE VERDUN','','','14210','EVRECY',NULL,NULL,'2401214433001',24.000000000,'1967-09-13','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1120,'LABASTRIES','MONIQUE','1929-01-14','02.25.42.54.73','06.10.72.60.57',NULL,'27 RUE DE L''ARQUETTE','','','14370','ARGENCES',NULL,NULL,'1290161490001',737.000000000,'1956-02-18','PREMIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1121,'EL DJADID','JEAN','1928-05-23','02.90.67.59.06','06.59.85.93.08',NULL,'80 rue des roches','','','14680','FRESNEY LE PUCEUX',NULL,NULL,'2280514413001',2090.000000000,'1951-09-26','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1122,'CARDIN','FRANCOISE','1930-05-29','02.48.59.91.32','06.77.76.68.95',NULL,'17 RUE DE LA DEMI LUNE','','','14400','BAYEUX',NULL,NULL,'1300514125001',1304.000000000,'1959-02-08','GOLD',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1123,'BAYET','CLAUDE','1928-03-26','02.50.90.66.36','06.48.32.79.69',NULL,'13 rue jacque prevert','','','14000','CAEN',NULL,NULL,'2280314105001',38.000000000,'1949-04-03','PREMIUM',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1124,'POTTIER','MARGUERITE','1929-09-09','02.65.24.66.32','06.35.77.88.23',NULL,'40 BIS ROUTE D''HARCOURT','','',NULL,NULL,NULL,NULL,'1290914658001',2.000000000,'1956-03-28','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1125,'ORIN','RENE','1930-10-05','02.56.30.03.63','06.49.32.27.99',NULL,'98 RUE DE BRANVILLE','','','14860','BAVENT',NULL,NULL,'2301014187001',348.000000000,'1953-05-27','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1126,'AUBIN','RENE','1950-01-12','02.65.38.28.22','06.45.20.86.96',NULL,'56 ALLEE DES POMMIERS DOMAINE DU',' HAUT BOIS','','14190','GRAINVILLE LANGANNERIE',NULL,NULL,'2500161166001',7.000000000,'1977-09-22','PREMIUM',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1127,'DERENEMESNIL','JEAN','1937-02-10','02.59.53.02.70','06.38.18.42.88',NULL,'8-3 ALLEE DES CAMPANULES','','','14123','FLEURY SUR ORNE',NULL,NULL,'1370214763001',1723.000000000,'1958-08-28','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1128,'ROUGET','MICHEL','1961-09-05','02.74.45.05.61',NULL,NULL,'101 RUE DU CHEMIN VERT','','','14250','BROUAY',NULL,NULL,'1610937071001',129.000000000,'1984-09-10','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1129,'LECARDRONNEL','JACQUELINE','1938-12-17','02.11.95.32.59','06.96.46.55.12',NULL,'5 rue de la poste','','','14460','COLOMBELLES',NULL,NULL,'2381214513001',35.000000000,'1959-08-09','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1130,'PRIEUR','NELLY','1932-06-27','02.38.63.72.29','06.68.95.56.36',NULL,'14 rue marthe gibrat','','','14000','CAEN',NULL,NULL,'1320699397001',428.000000000,'1955-10-22','PREMIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1131,'LENORMAND','','1932-06-28','02.44.17.87.06','06.12.46.42.23',NULL,'5 CHEMIN DU MOULIN','','','14210','ESQUAY NOTRE DAME',NULL,NULL,'1320699397001',2412.000000000,'1953-11-30','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1132,'AMAND','MONIQUE','1969-07-13','02.87.91.86.48','06.20.74.20.76',NULL,'71 rue de bretagne','','','14840','DEMOUVILLE',NULL,NULL,'1690714109001',50.000000000,'1998-04-20','PREMIUM',12,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1133,'CONNAULT','claude','1937-05-29','02.11.81.39.57','06.87.79.75.70',NULL,'154 BD LEROY','','','50480','STE MARIE DU MONT',NULL,NULL,'1370550405001',534.000000000,'1964-08-01','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1134,'LEREBOURG','JACQUES','1934-05-11','02.90.22.73.29','00 33 6.51.25.07.39',NULL,'38 rue eugenie','','','50260','BRICQUEBEC',NULL,NULL,'2340561177001',107.000000000,'1959-10-15','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1135,'THOMAS','edgar','1919-10-09','02.56.88.75.88','06.98.67.13.14',NULL,'ROUTE DE ST PIERRE S/ DIVES','','','14700','FALAISE',NULL,NULL,'1191061464001',424.000000000,'1943-07-06','GOLD',23,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1136,'RICHARD','ELISABETH',NULL,'02.56.41.50.65','06.40.31.09.59',NULL,'11 RUE HOTEL AU BOSQ','','','14000','CAEN',NULL,NULL,'2450228263001',24.000000000,'2013-08-25','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1137,'JAMES','ANNICK','1936-08-24','02.12.69.82.77','06.32.91.53.92',NULL,'15 RUE DE BOURGOGNE','','','14920','MATHIEU',NULL,NULL,'1360829072001',85.000000000,'1962-03-30','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1138,'HUYGHE','JEANNINE','1939-10-09','02.48.74.68.70',NULL,NULL,'9 RUE DU DR PAUL ENOUF','','','14370','MOULT',NULL,NULL,'2391014417001',39.000000000,'1966-06-05','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1139,'LE NAOUR','stephane','1964-05-03','02.77.23.49.08','06.47.99.38.44',NULL,'3 RUE JEAN CABY','','','14400','BAYEUX',NULL,NULL,'2640514730001',343.000000000,'1990-03-27','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1140,'MAINCENT','SIMONE','1937-08-14','02.87.88.15.41','06.13.23.86.67',NULL,'131 av guynemer','','','14123','CORMELLES LE ROYAL',NULL,NULL,'2370814505001',2278.000000000,'1966-02-25','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1141,'MESNIL','NICOLE','1931-05-31','02.15.67.10.64','06.41.11.34.07',NULL,'6 RUE CARDINAL LAVIGERIE','','','14210','EVRECY',NULL,NULL,'1310514525001',808.000000000,'1957-07-27','PREMIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1142,'CHARDIN','MADELY','1936-04-27','02.19.76.98.92','06.11.23.92.66',NULL,'27 RUE DE LA ROSERAIE','','','14150','OUISTREHAM',NULL,NULL,'1360414657001',104.000000000,'1966-05-23','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1143,'MOREL','JACQUELINE','1936-12-03','02.58.28.94.06','06.11.18.71.89',NULL,'48 BD RAYMOND POINCARE','','','50700','VALOGNES',NULL,NULL,'2361214319001',146.000000000,'1958-08-11','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1144,'AUBIN','MARTINE','1943-01-07','02.10.89.59.93','06.83.74.77.92',NULL,'16 CITE DES CASTORS','','','14540','CONTEVILLE',NULL,NULL,'1430114090001',383.000000000,'1964-07-12','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1145,'GUERET','JANINE','1929-01-14','02.12.15.58.36','06.11.51.17.50',NULL,'12 rue de la grace de dieu','','','14490','ST PAUL DU VERNAY',NULL,NULL,'2290114408001',232.000000000,'1952-06-15','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1146,'JEANNE','MAURICE','1937-08-04','02.49.43.67.46','06.45.02.75.07',NULL,'115 rue des acacias','','','14670','TROARN',NULL,NULL,'2370817306001',142.000000000,'1958-05-01','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1147,'ROYER','ROLAND','1940-07-26','02.12.33.22.94','06.76.02.36.88',NULL,'19 place des drakkars','','','14400','ST VIGOR LE GRAND',NULL,NULL,'2400717328001',39.000000000,'1963-04-20','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1148,'LEMANISSIER','GUY','1937-04-28','02.98.91.50.51','06.97.37.97.74',NULL,'40 RUE DU 16 AOUT 1944','','','14470','COURSEULLES SUR MER',NULL,NULL,'2370414711001',92.000000000,'1959-09-02','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1149,'VERHAEGHE','ROGER','1931-02-27','02.44.82.55.55','06.25.23.54.79',NULL,'CHEMIN DIT AUX MALADES','','','14000','CAEN',NULL,NULL,'2310250356001',105.000000000,'1953-02-15','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1150,'MAUCORPS','LILIANE','1948-01-23','02.90.37.30.71','06.10.03.99.02',NULL,'7 rue de la marre','','','14220','CESNY BOIS HALBOUT',NULL,NULL,'1480114635001',1825.000000000,'1970-05-17','GOLD',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1151,'NICOLLE','JEAN','1958-03-08','02.82.46.74.17',NULL,NULL,'RUE MAC MAHON','','','14750','ST AUBIN SUR MER',NULL,NULL,'1580350247001',38.000000000,'1986-07-19','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1152,'NICOLLE','BRIGITTE','1934-02-24','02.22.15.63.93','06.76.95.59.01',NULL,'7 RUE DE L EGLISE','','','14000','CAEN',NULL,NULL,'1340214044001',153.000000000,'1961-03-30','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1153,'VOISIN','JEANINE','1934-06-21','02.22.75.44.77','06.44.08.27.17',NULL,'14 avenue du 18 aout 1944','','','14123','FLEURY SUR ORNE',NULL,NULL,'1340614262001',30.000000000,'1961-06-20','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1154,'FERAY','THIERRY','1956-05-25','02.66.56.90.93','06.86.17.64.13',NULL,'101 rue de branville','','','14390','CABOURG',NULL,NULL,'1560561208001',104.000000000,'1981-11-15','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1155,'BLESTEL','PAUL','1936-03-15','02.73.20.85.37','06.44.75.93.98',NULL,'5 RUE VICTOR HUGO','','','14460','COLOMBELLES',NULL,NULL,'2360314437001',795.000000000,'1959-11-09','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1156,'CERE','FERNANDE','1945-07-31','02.25.72.78.66','06.61.90.10.36',NULL,'159 rue haute','','','14123','IFS',NULL,NULL,'1450714610001',1859.000000000,'1974-03-21','GOLD',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1157,'GOUGEON','CATHERINE','1935-12-22',NULL,NULL,NULL,'24 rue spontini','','','14260','AUNAY SUR ODON',NULL,NULL,'2351214470001',868.000000000,'1960-03-13','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1158,'LECARDONNEL','JANIQUE','1932-06-09','02.11.20.08.22','06.39.32.30.88',NULL,'8 impasse des bleuet','','','14000','CAEN',NULL,NULL,'2320622256001',166.000000000,'1956-09-09','PREMIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1159,'JULIENNE','RAYMOND','1947-01-16','02.76.84.63.80','06.37.88.61.79',NULL,'22-8 grande rue','','','14120','MONDEVILLE',NULL,NULL,'1470172299001',2762.000000000,'1970-03-18','GOLD',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1160,'CHABANNE','NICOLE','1937-06-25','02.14.15.93.87','06.91.25.03.02',NULL,'12 RUE DE LA ROUVRE','','','14630','CAGNY',NULL,NULL,'1370676466001',5274.000000000,'1964-01-07','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1161,'LEGRIX','SERGE','1929-07-02','02.19.69.00.67','06.10.21.23.03',NULL,'7 rue marie france','','','61150','ECOUCHE',NULL,NULL,'1290714581001',15.000000000,'1955-07-10','PREMIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1162,'LE BUAN','ISABELLE','1940-08-09','02.55.69.62.52','06.17.49.05.05',NULL,'1 route de Paris','','','14540','ST AIGNAN DE CRAMESNIL',NULL,NULL,'2400814125001',655.000000000,'1970-11-20','SILVER',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1163,'RECOURSE','MICHEL','1948-12-10','02.34.01.50.65','06.19.70.01.97',NULL,'69 RUE PASTEUR','','','14200','HEROUVILLE ST CLAIR',NULL,NULL,'1481214306001',35.000000000,'1978-06-29','GOLD',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1164,'GUICHARD','CLAUDIE','1953-04-10','02.11.17.28.42','06.43.57.35.97',NULL,'1 ROUTE DE CORDEY','','','14810','MERVILLE FRANCEVILLE PLAGE',NULL,NULL,'1530414493001',181.000000000,'1977-10-04','PREMIUM',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1165,'LE POAIZARD','JANINE','1933-04-05','02.60.41.96.40','06.57.00.35.77',NULL,'19 ROUTE DE LA GUERINIERE','','','14410','BERNIERES LE PATRY',NULL,NULL,'2330414118001',365.000000000,'1957-08-23','PREMIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1166,'TOUPIN','MARIE','1937-01-15','02.76.45.20.66','06.78.12.82.16',NULL,'19 rue paul claudel','','','14000','CAEN',NULL,NULL,'2370160260001',226.000000000,'1961-01-03','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1167,'PIERRE','THERESE','1938-03-01','02.41.55.58.70','06.64.69.55.51',NULL,'4 RUE DES BRUYERES','','','14570','ST REMY',NULL,NULL,'1380350483001',141.000000000,'1960-04-25','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1168,'CHATELLIER','FRANCK','1933-05-23','02.46.64.52.21','06.10.43.73.54',NULL,'8 RUE DES LONGS JOUHAUX','','','14000','CAEN',NULL,NULL,'1330527630001',38.000000000,'1954-12-22','PREMIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1169,'LAMULLE','LUCETTE','1955-05-01','02.11.69.80.05','06.71.41.55.48',NULL,'74 RUE BEAULUE','','','14120','MONDEVILLE',NULL,NULL,'1550514548001',299.000000000,'1981-06-22','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1170,'GAYET','DOMINIQUE','1931-01-19','02.10.88.80.81','06.44.68.30.10',NULL,'45 rue ernest renan','','','14000','CAEN',NULL,NULL,'2310150415001',454.000000000,'1957-02-28','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1171,'GUILLOREAU','ROGER','1930-08-08','02.76.51.58.43','06.76.54.19.35',NULL,'2 CITE DES JARDINS','','','14000','CAEN',NULL,NULL,'2300850526001',1.000000000,'1955-03-05','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1172,'QUIGNETTE','JANINE','1966-05-01','02.40.19.99.57','06.73.28.80.15',NULL,'2 BIS RUE DE FORT MIGNY','','','14620','BAROU EN AUGE',NULL,NULL,'2660576137001',51.000000000,'1993-08-24','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1173,'BASLEY','JEANINE','1939-04-19','02.67.71.21.26','06.35.35.99.75',NULL,'25 RUE MONGOLFIER','','','14670','JANVILLE',NULL,NULL,'2390450032001',389.000000000,'1963-01-20','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1174,'BOISSARD','MARTINE','1928-12-09','02.91.21.08.41','06.51.60.62.45',NULL,'rue de la liberation','','','14540','GARCELLES SECQUEVILLE',NULL,NULL,'1281214251001',6.000000000,'1949-12-08','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1175,'LE COMTE','','1930-01-03','02.92.31.43.13','06.19.12.65.09',NULL,'14 RESIDENCE OLYMPA','','','14730','GIBERVILLE',NULL,NULL,'2300150436001',174.000000000,'1951-09-01','PREMIUM',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1176,'LERENARD','MICHEL',NULL,'02.63.22.94.19','06.64.12.13.12',NULL,'','','','14220','MOULINES',NULL,NULL,'1914123780001',95.000000000,'2010-02-14','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1177,'RENOUF','GENEVIEVE','1935-01-19','02.67.86.36.83','06.58.27.60.05',NULL,'12 RUE DE LA RESISTANCE','','','14123','IFS',NULL,NULL,'1350114030001',756.000000000,'1957-07-04','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1178,'JAMARD','GILBERT','1951-01-27','02.25.56.19.31','06.38.93.82.38',NULL,'21 rue des mimosas','','','14000','CAEN',NULL,NULL,'2510150085001',911.000000000,'1979-08-08','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1179,'MACE','DANIEL','1932-11-26','02.10.35.49.24','06.23.23.40.68',NULL,'4 RUE XAVIER DANCELME','','','14400','BAYEUX',NULL,NULL,'2321129191001',41.000000000,'1961-08-31','PREMIUM',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1180,'MONTIGNY','MARIE ROSE','1958-10-21','02.55.28.29.91','06.41.78.77.39',NULL,'19 imp des roses','','','14000','CAEN',NULL,NULL,'2581014149001',424.000000000,'1982-04-09','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1181,'DUMONT','STEPHANIE','1961-03-30','02.68.88.37.56','06.10.40.19.34',NULL,'RUE ERNEST RENAN   N.19','','','14270','MEZIDON CANON',NULL,NULL,'1610314435001',35.000000000,'1985-06-29','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1182,'MALLET','PAUL','1968-01-26','02.70.04.23.71','06.10.64.13.03',NULL,'1 IMPASSE REINE MATHILDE','','','14000','CAEN',NULL,NULL,'1680153166001',17.000000000,'1989-04-02','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1183,'AUBRY','PASCAL','1956-02-15','02.52.77.73.29','06.47.00.20.90',NULL,'13 RUE DE VERDUN','','','14280','ST CONTEST',NULL,NULL,'1560214341001',307.000000000,'1978-03-17','PREMIUM',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1184,'ZIMMERMANN','GERARD','1956-01-27','02.47.38.66.96','06.11.93.93.51',NULL,'2 RUE DU CENTRE','','','14170','HIEVILLE',NULL,NULL,'1560133227001',70.000000000,'1980-08-31','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1185,'LENORMAND','YVETTE','1946-02-12','02.87.29.88.98','06.23.65.03.42',NULL,'17 RUE DE LA GUERINIERE','','','14670','ST PAIR',NULL,NULL,'2460214244001',380.000000000,'1969-10-28','GOLD',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1186,'DURAND','MARIE','1936-06-03','02.50.98.09.02','06.68.06.10.59',NULL,'7 RUE EDOUARD VAILLANT','','','50310','LE HAM',NULL,NULL,'1360614123001',53.000000000,'1963-04-25','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1187,'OLIVIER','MARIE THERESE','1928-07-02','02.50.29.75.38','06.35.44.84.12',NULL,'26 ave de rouen','','','14370','CHICHEBOVILLE',NULL,NULL,'1280735065001',7.000000000,'1951-12-18','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1188,'FONTAINE','RENE','1933-06-21','02.12.34.40.00','06.69.27.07.80',NULL,'1 rue pierre le pretre','','','14000','CAEN',NULL,NULL,'1330614666001',177.000000000,'1960-10-14','GOLD',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1189,'GODEAU','BERNARD',NULL,'02.59.95.36.58','06.50.53.37.47',NULL,'9 RUE JACQUES BREL','','','14860','BAVENT',NULL,NULL,'2350914165001',132.000000000,'2009-08-06','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1190,'BELLIARD','RAYMOND','1963-01-10','02.60.48.38.15','06.52.77.12.31',NULL,'34 BD FONTAINE COUVERTE','','','14120','MONDEVILLE',NULL,NULL,'1630114327001',549.000000000,'1990-02-23','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1191,'LELIEVRE','CZESLAW','1964-11-10','02.85.51.01.24','06.44.78.40.08',NULL,'2 IMPASSE DES ECOLES','','','14123','CORMELLES LE ROYAL',NULL,NULL,'1641114118001',49.000000000,'1990-07-02','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1192,'RENEE','RENE','1929-11-18','02.65.50.57.69','06.72.62.61.80',NULL,'18 RUE ARISTIDE HIMBAUT','','','14370','CANTELOUP',NULL,NULL,'1291114757001',84.000000000,'1950-10-12','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1193,'LECONTE','NELLY','1929-10-25','02.46.03.38.33','06.62.41.54.23',NULL,'30 ROUTE DE PARIS','','','14370','MOULT',NULL,NULL,'1291014665001',29.000000000,'1954-03-06','PREMIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1194,'LEDENTU','RACHEL','1929-10-06','02.47.23.06.21','06.74.89.27.24',NULL,'160 COUR NORMANDE','','','14200','HEROUVILLE ST CLAIR',NULL,NULL,'1291014665001',132.000000000,'1950-03-23','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1195,'CARABY','vadim','1938-05-15','02.46.49.28.28','06.41.84.85.81',NULL,'15 rue pasteur','','','14460','COLOMBELLES',NULL,NULL,'1380514713001',200.000000000,'1959-07-18','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1196,'','J GEORGES','1928-11-06','02.11.18.47.68','06.66.68.97.74',NULL,'2 RUE DU MONT DU SAULE','','','14000','CAEN',NULL,NULL,'1281114310001',2385.000000000,'1952-05-29','PLATINIUM',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1197,'REVEL','LAETITIA','1931-05-23','02.56.27.83.41','06.60.24.53.17',NULL,'15 rue des mesanges','','','14100','LISIEUX',NULL,NULL,'2310514377001',1795.000000000,'1953-03-31','PREMIUM',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1198,'NEAUD','BRUNO','1915-03-01','02.54.89.10.73','06.17.14.15.55',NULL,'Z1 ROUTE DE CAEN','','','14270','CONDE SUR IFS',NULL,NULL,'2150303294001',80.000000000,'1941-07-25','GOLD',23,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1199,'LE PREVOST DE LA MOISSONIERE','MICHEL','1946-05-31','02.26.57.00.47','06.40.27.61.44',NULL,'38 RUE ST MICHEL','','','14550','BLAINVILLE SUR ORNE',NULL,NULL,'1460514550001',589.000000000,'1973-03-16','GOLD',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1200,'CHAMBET','ROLAND','1956-03-30','02.18.23.30.99','06.31.17.75.06',NULL,'21 RUE DU FOUR A CHAUX','','','14460','COLOMBELLES',NULL,NULL,'2560314119001',57.000000000,'1979-03-28','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1201,'HOUEL','YVES','1955-01-17','02.15.35.53.66','06.11.03.22.11',NULL,'','','','14320','MAY SUR ORNE',NULL,NULL,'2550161269001',36.000000000,'1979-06-29','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1202,'GERVAIS','JEAN CLAUDE','1963-11-06','02.49.02.60.89','06.38.98.11.86',NULL,'19 rue du stade','','','14460','COLOMBELLES',NULL,NULL,'2631114118001',82.000000000,'1992-12-02','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1203,'ROUSSEL','MARCELLE','1951-06-05','02.10.34.48.79','06.57.77.15.29',NULL,'','','','61240','NONANT LE PIN',NULL,NULL,'2510614118001',114.000000000,'1976-06-23','PREMIUM',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1204,'HOUSSIN','YVES','1927-10-07','02.85.10.24.28','06.19.85.88.55',NULL,'24 pl du marche','','','14120','MONDEVILLE',NULL,NULL,'2271039320001',197.000000000,'1952-12-06','PREMIUM',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1205,'BERTOLI','PATRICIA','1963-03-06','02.43.20.15.83','06.22.09.54.03',NULL,'11 RUE DU PETIT SEMILLON','','','14000','CAEN',NULL,NULL,'1630314507001',30.000000000,'1992-03-30','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1206,'VIVIEN','MAURICE','1939-08-26','02.92.97.45.35','06.72.84.92.34',NULL,'','','','14320','MAY SUR ORNE',NULL,NULL,'1390878314001',181.000000000,'1961-04-27','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1207,'DELAHAYE','CHRISTOPHE','1965-10-13','02.12.17.79.45','06.10.37.59.05',NULL,'1110RUE DU BOIS','','','14123','IFS',NULL,NULL,'2651014761001',823.000000000,'1993-10-09','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1208,'ANDRE','SYLVIE','1939-11-03','02.57.15.08.68','06.12.04.05.34',NULL,'5 RUE DES EQUIPES D URGENCES','','','14550','BLAINVILLE SUR ORNE',NULL,NULL,'2391114370001',57.000000000,'1962-10-17','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1209,'COBBAERT','BERNADETTE','1930-05-03','02.52.81.47.99','06.31.30.82.54',NULL,'16 RUE AUX PIERROTS','','','14980','ROTS',NULL,NULL,'1300514033001',725.000000000,'1956-04-24','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1210,'RUEL','GISELE','1929-09-26','02.74.69.04.47',NULL,NULL,'25 ALLEE GUILLAUME LE CONQUERANT','','','14370','BELLENGREVILLE',NULL,NULL,'2290914588001',541.000000000,'1953-05-03','PREMIUM',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1211,'KLAINE','PIERRE','1940-08-08','02.26.49.97.57','06.37.86.17.81',NULL,'8 RUE DU DAUPHINE','','','14320','MAY SUR ORNE',NULL,NULL,'2400814673001',288.000000000,'1966-06-21','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1212,'LEVRARD','FERNAND','1931-11-23','02.30.56.66.91','06.38.80.59.98',NULL,'13 RUE DE VERDUN','','','14140','LE MESNIL DURAND',NULL,NULL,'2311114044001',93.000000000,'1956-06-13','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1213,'TALVAST','BERNARD','1935-03-14','02.38.88.57.76','06.26.24.64.78',NULL,'153 RUE DE BEAULUE','','','14000','CAEN',NULL,NULL,'2350314478001',27.000000000,'1957-05-19','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1214,'SONNET','CATHERINE','1949-04-13','02.56.09.51.21','06.60.51.24.08',NULL,'3 SQUARE ANDRE GID','','','14270','ECAJEUL',NULL,NULL,'2490414757001',25.000000000,'1970-01-22','PREMIUM',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1215,'MARIE','JACKY','1956-01-13','02.41.18.65.78','06.10.38.20.70',NULL,'22 RUE A BRIAND','','','14000','CAEN',NULL,NULL,'1560114088001',303.000000000,'1979-03-05','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1216,'LESNIK','ROGER','1943-05-28','02.16.50.22.87','06.79.40.14.00',NULL,'9 rue porte millet','','','14000','CAEN',NULL,NULL,'2430527614001',2804.000000000,'1973-05-30','SILVER',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1217,'ALLO','FERNANDE','1931-08-08','02.39.25.11.05','06.67.64.31.99',NULL,'14 rue du val','','','14270','MAGNY LE FREULE',NULL,NULL,'1310814024001',4.000000000,'1952-12-17','PREMIUM',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1218,'LECUIROT','JACQUES','1932-12-12','02.28.07.01.95','06.49.88.45.80',NULL,'LA ROCHE FONTAINE','','','14740','BRETTEVILLE L''ORGUEILLEUSE',NULL,NULL,'2321214659001',3631.000000000,'1954-10-14','PREMIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1219,'DUBOIS','EVELINE','1933-05-11','02.70.86.09.43','06.69.45.93.62',NULL,'15 route de la gurinire','','','14150','OUISTREHAM',NULL,NULL,'2330527118001',3845.000000000,'1958-06-25','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1220,'BARBEY','YOLANDE','1936-11-17','02.59.94.00.12','06.90.56.61.43',NULL,'10 BD NICOLAS ORESNE','','','14370','ARGENCES',NULL,NULL,'2361161306001',118.000000000,'1961-08-30','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1221,'FRANCISOT','JEAN CLAUDE','1929-03-20','02.41.26.50.96','06.22.84.07.09',NULL,'route de rouen','','','14120','MONDEVILLE',NULL,NULL,'1290314636001',548.000000000,'1953-09-03','PREMIUM',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1222,'HUSSEINOVA','PAUL','1931-12-25','02.11.82.66.71','06.82.60.06.05',NULL,'65 RUE DU GAL DE GAULLE','','','61200','ARGENTAN',NULL,NULL,'2311250266001',1371.000000000,'1952-03-21','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1223,'MARIE','GISELE','1954-01-16','02.52.81.18.46','06.53.94.46.89',NULL,'9 RUE CHAPRON','','','14190','ST SYLVAIN',NULL,NULL,'2540114219001',11.000000000,'1981-09-18','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1224,'GUILLON','JOSETTE','1930-12-25','02.89.27.68.55','06.25.67.01.23',NULL,'9 RUE GANDHI','','','14850','ESCOVILLE',NULL,NULL,'2301278531001',1092.000000000,'1953-05-07','PREMIUM',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1225,'ALLAIN','ANDRE','1940-02-27','02.10.29.28.47','06.61.21.09.65',NULL,'ROUTE DE CAMPIGNY','','','14530','LUC SUR MER',NULL,NULL,'2400214005001',106.000000000,'1963-03-15','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1226,'LECARDONNEL','EMILIENNE','1934-09-07','02.72.01.91.69','06.37.79.73.20',NULL,'RUE DU GENERAL DE GAULLE','','','14740','BRETTEVILLE L''ORGUEILLEUSE',NULL,NULL,'1340914438001',70.000000000,'1955-01-06','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1227,'WOJCIK','DENISE','1944-03-26','02.17.06.17.46','06.39.59.85.16',NULL,'108 RUE DE FALAISE','','','14570','ST REMY',NULL,NULL,'1440314383001',107.000000000,'1968-09-09','GOLD',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1228,'GRANDMOUGIN','CHANTAL','1935-12-03','02.43.88.49.02','06.26.54.49.49',NULL,'14 ROUTE DES LACS','','','14000','CAEN',NULL,NULL,'1351214216001',106.000000000,'1957-05-14','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1229,'DERRIEN','RAYMOND','1940-01-11','02.45.60.09.51','06.60.85.58.67',NULL,'','','','14670','TROARN',NULL,NULL,'1400114438001',34.000000000,'1970-10-25','SILVER',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1230,'FEREY','ANNETTE','1943-01-07','02.61.33.96.49','06.28.39.85.52',NULL,'10 RUE DES SPORTS','','','14000','CAEN',NULL,NULL,'1430150178001',206.000000000,'1967-10-14','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1231,'LUNEL','JULIETTE','1957-01-27','02.85.17.09.17','06.57.62.22.51',NULL,'6 RUE DR ZAJEWSKI','','','14570','ST REMY',NULL,NULL,'1570114407001',40.000000000,'1979-07-24','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1232,'CLEMENT','SIMONE','1939-03-19','02.53.89.03.38','06.10.19.49.70',NULL,'7 BIS BD DE LA LIBERATION','','','14123','IFS',NULL,NULL,'2390314316001',567.000000000,'1962-07-29','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1233,'HINGAND','JEANINE','1928-01-02','02.10.49.57.71','06.60.62.47.88',NULL,'20 RUE DE LA MOINERIE','','','14210','AMAYE SUR ORNE',NULL,NULL,'2280114274001',172.000000000,'1950-10-10','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1234,'HARTEL','JACQUELINE','1934-05-31','02.33.31.69.05','06.12.28.03.55',NULL,'3 RUE SIKORSKI','','','14120','MONDEVILLE',NULL,NULL,'2340514400001',98.000000000,'1957-05-17','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1235,'HOULETTE','GERARD','1935-11-03','02.53.30.28.10','06.78.23.56.34',NULL,'1 RUE DE LA LUSERNE','','','14630','EMIEVILLE',NULL,NULL,'1351114558001',518.000000000,'1958-11-04','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1236,'BAROCHE','GISELE','1928-12-12','02.85.56.25.77','06.11.57.75.26',NULL,'8 IMPASSE DU VILLAGE','','','14220','ACQUEVILLE',NULL,NULL,'2281214537001',194.000000000,'1957-09-09','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1237,'MOREL','GENEVIEVE','1949-03-09','02.92.40.77.32','06.26.63.79.61',NULL,'13 RUE FORMIGNY','','','14120','MONDEVILLE',NULL,NULL,'2490350620001',3.000000000,'1971-10-03','PREMIUM',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1238,'ANGOT','raymond','1939-03-22','02.16.61.31.16','06.11.53.81.34',NULL,'LA VALETTE','','','14000','CAEN',NULL,NULL,'1390314629001',95.000000000,'1966-09-02','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1239,'','YVETTE','1939-03-03','02.96.79.61.54','06.16.04.67.05',NULL,'LIEU DIT"LE DOMAINE"','','','50300','AVRANCHES',NULL,NULL,'1390314629001',97.000000000,'1966-12-01','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1240,'LECONTE','MAURICE','1964-12-29','02.33.12.13.81','06.53.21.02.33',NULL,'RUE RABELAIS','','','14540','BOURGUEBUS',NULL,NULL,'2641214145001',254.000000000,'1993-08-05','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1241,'PONTAIS','DENISE','1937-07-10','02.56.90.47.90','06.92.16.24.57',NULL,'','','','14380','LANDELLES ET COUPIGNY',NULL,NULL,'2370714204001',205.000000000,'1966-10-26','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1242,'LABEY','ELISE','1935-02-02','02.32.46.83.32','06.70.67.52.68',NULL,'75 rue eustache restoux','','','13011','MARSEILLE 11',NULL,NULL,'2350214379001',3510.000000000,'1965-04-18','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1243,'DUDOUIT','LOUIS','1963-12-13','02.31.58.92.55','06.58.08.96.60',NULL,'5 RUE KALIGRENKO','','','14540','BOURGUEBUS',NULL,NULL,'1631299253001',550.000000000,'1993-03-01','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1244,'POMIKAL','CLAUDE','1933-02-26','02.39.37.08.92','06.88.44.02.78',NULL,'6 RUE DE LA CLE DES CHAMPS','','','27530','EZY SUR EURE',NULL,NULL,'2330249202001',56.000000000,'1957-02-12','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1245,'BRIDOT','ROZELINE','1933-06-11','02.75.85.27.58','06.60.02.24.82',NULL,'5 RUE AUGUSTE LANGLOIS','','','14123','IFS',NULL,NULL,'2330661477001',123.000000000,'1956-11-03','PREMIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1246,'LANGLOIS','JACQUES','1939-11-13','02.24.90.55.30','06.50.61.20.81',NULL,'9 RUE MOZART','','','14490','CASTILLON',NULL,NULL,'1391122204001',413.000000000,'1966-01-31','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1247,'LEPETIT','FRANCOISE','1962-01-03','02.46.21.45.05','06.47.77.12.38',NULL,'CHEMIN DE LA CROIX AUX NOBLES','','','14430','BEUVRON EN AUGE',NULL,NULL,'1620114020001',663.000000000,'1988-05-12','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1248,'RAULINE','ANDRE','1962-12-27','02.37.42.69.59','06.42.32.89.60',NULL,'','','','14780','LION SUR MER',NULL,NULL,'2621214690001',691.000000000,'1984-07-02','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1249,'CASTEL','MONIQUE','1934-10-13','02.53.33.95.60','06.87.40.89.08',NULL,'2 PLACE GENDARMERIE MOBILE','','','14630','FRENOUVILLE',NULL,NULL,'1341014482001',15.000000000,'1958-05-09','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1250,'LEREBOURG','CZESLAW','1929-01-16','02.17.52.89.87','06.64.54.36.05',NULL,'18 rue saint andre','','','61370','ECHAUFFOUR',NULL,NULL,'2290114622001',326.000000000,'1951-06-09','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1251,'PRECOURT','RENE','1956-02-26','02.45.32.73.09','06.42.19.76.71',NULL,'LA VACQUERIE','','','14400','BAYEUX',NULL,NULL,'1560214114001',193.000000000,'1977-04-11','PREMIUM',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1252,'PESNEL','YVETTE','1933-05-10','02.11.36.90.21','06.50.98.42.96',NULL,'5 rue jean philippe rameau','','','14210','CHEUX',NULL,NULL,'1330527119001',105.000000000,'1954-04-15','PREMIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1253,'LAMY','JEAN','1959-02-14','02.88.77.84.92','06.79.63.64.16',NULL,'15 RUE DE BRETAGNE','','','14000','CAEN',NULL,NULL,'1590227513001',410.000000000,'1982-08-12','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1254,'TROHEL','MARCEL','1934-10-05','02.93.67.48.52','06.83.17.57.10',NULL,'4 rue du  pere jules','','','14000','CAEN',NULL,NULL,'2341014424001',1592.000000000,'1960-12-08','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1255,'TRAVIGNET','CHARLES','1938-08-21','02.11.33.68.37','06.84.64.79.02',NULL,'IMPASSE ROGER SALENGRO','','','14123','IFS',NULL,NULL,'2380850149001',270.000000000,'1962-10-13','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1256,'DESCHIENS','MARC','1937-02-15','02.10.55.95.54','06.95.68.55.40',NULL,'LA GARDERIE','','','14320','ST MARTIN DE FONTENAY',NULL,NULL,'1370214271001',27.000000000,'1966-10-19','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1257,'ANDRE','MARGUERITE','1935-03-05','02.39.71.30.46','06.76.42.50.75',NULL,'10 RUE DE LA VALLEE','','','14000','CAEN',NULL,NULL,'2350376620001',68.000000000,'1956-04-28','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1258,'CHANCOIGNE','SIMONE','1924-12-11','02.17.62.60.81','06.70.06.53.99',NULL,'RUE DE LA SARRIETTE','','','14240','CAHAGNES',NULL,NULL,'2241277013001',829.000000000,'1947-04-14','GOLD',22,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1259,'BOUVIER','LOUIS','1940-03-24','02.30.97.41.29','06.78.52.55.28',NULL,'11 rue du tour de ville','','','14290','MEULLES',NULL,NULL,'2400314206001',34.000000000,'1967-03-10','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1260,'DELMAS','GERARD','1968-01-06','02.64.94.68.51','06.64.81.81.21',NULL,'13 LE BOURG DE CRENNES','','','14330','LE MOLAY LITTRY',NULL,NULL,'1680153166001',780.000000000,'1992-06-20','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1261,'HETET','YVES','1930-06-21','02.53.91.37.03','06.23.40.78.86',NULL,'26 rue georges gaillard','','','14220','HAMARS',NULL,NULL,'1300661397001',1404.000000000,'1952-03-04','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1262,'MOREAU','THIERRY','1955-01-09','02.23.86.55.72','06.49.00.19.77',NULL,'1 RUE DU DOCTEUR LECHARPENTIER','','','14130','BONNEVILLE LA LOUVET',NULL,NULL,'1550150221001',86.000000000,'1981-05-04','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1263,'LAIR','SYLVIANNE','1940-02-24','02.41.21.58.82','06.65.24.45.82',NULL,'1 rue des pervenches','','','50700','VALOGNES',NULL,NULL,'2400214112001',66.000000000,'1962-11-19','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1264,'PARIS','JEANINE','1942-12-07','02.58.64.45.14','06.79.93.70.72',NULL,'26 RUE DANIEL DANJON','','','14270','BIEVILLE QUETIEVILLE',NULL,NULL,'1421297202001',61.000000000,'1969-03-14','SILVER',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1265,'HEBERT','HUBERT','1936-01-26','02.18.17.46.04','06.50.85.65.04',NULL,'','','','14670','TROARN',NULL,NULL,'2360114181001',3011.000000000,'1959-07-11','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1266,'MARIE','CHARLES','1932-02-17','02.29.60.07.40','06.52.40.36.17',NULL,'8 RUE DU CHATEL','','','61500','SEES',NULL,NULL,'1320222118001',196.000000000,'1962-11-18','PREMIUM',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1267,'FOUQUES','FRANCIS','1956-06-15','02.10.15.76.62','06.57.42.53.94',NULL,'18 LE PETIT PLAIN','','','14000','CAEN',NULL,NULL,'1560614145001',366.000000000,'1982-10-09','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1268,'GUESNON','LIONEL','1938-04-02','02.24.87.40.53','06.68.48.49.22',NULL,'13 RUE ST EXUPERY','','','14000','CAEN',NULL,NULL,'1380414520001',105.000000000,'1967-07-09','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1269,'LEBARBIER','MICHEL','1932-04-24','02.11.82.37.34','06.81.56.76.46',NULL,'17 RUE LEBAUDY','','','14200','HEROUVILLE ST CLAIR',NULL,NULL,'2320414170001',186.000000000,'1961-10-20','GOLD',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1270,'BARBANCHON','LOUIS','1936-05-22','02.61.04.86.64','06.96.87.38.52',NULL,'8 rue st loup','','','14000','CAEN',NULL,NULL,'1360561073001',157.000000000,'1960-12-30','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1271,'NEDELEC','ANDREE','1938-07-13','02.11.65.00.46','06.58.94.89.65',NULL,'12 ALLEE DES OFEVRES','','','14370','MOULT',NULL,NULL,'1380714482001',2.000000000,'1959-12-12','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1272,'BLOND','GABRIELLE','1937-01-09','02.11.89.24.43','06.10.67.07.60',NULL,'8 RUE DE L EGALITE','','','14000','CAEN',NULL,NULL,'1370114103001',2.000000000,'1962-04-24','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1273,'CAILLON','YOLANDE','1921-04-30','02.53.32.70.85','06.78.73.53.48',NULL,'5 LONGUE DU THEATRE','','','14320','FONTENAY LE MARMION',NULL,NULL,'2210414739001',1923.000000000,'1946-10-28','PREMIUM',22,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1274,'MARIE','COLETTE','1956-12-06','02.64.28.10.40','06.61.32.40.14',NULL,'25 RUE DES CORMORANS','','','14270','MEZIDON CANON',NULL,NULL,'2561214314001',529.000000000,'1979-02-28','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1275,'ALLIX','BERNARD','1936-10-12','02.90.37.78.51','06.50.37.70.25',NULL,'3 ROUTE D''ARGENTAN','','','14210','LE LOCHEUR',NULL,NULL,'2361014715001',966.000000000,'1961-06-03','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1276,'DELANNEE','ROLAND','1929-12-05','02.74.07.40.24',NULL,NULL,'LIEU DIT AUBIGNY','','','14240','CAUMONT L''EVENTE',NULL,NULL,'2291214552001',4372.000000000,'1951-10-31','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1277,'GALLOT','ALBERT','1955-04-30','02.36.27.64.74',NULL,NULL,'13 rue des canadiens','','','14860','BAVENT',NULL,NULL,'2550461354001',42.000000000,'1976-02-02','PREMIUM',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1278,'VIVIEN','JACQUELINE','1942-12-20','02.89.74.98.77',NULL,NULL,'6 RUE CHRESTIEN DE TROYES','','','14320','CLINCHAMPS SUR ORNE',NULL,NULL,'1421297202001',102.000000000,'1966-01-05','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1279,'KROB','MAURICE','1940-10-02','02.36.78.75.87','06.74.72.45.40',NULL,'13 RUE DES PINSONS','','','14540','POUSSY LA CAMPAGNE',NULL,NULL,'1401050523001',40.000000000,'1968-01-05','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1280,'DROST','MICHEL','1936-10-31','02.11.73.82.89','06.40.91.43.45',NULL,'','','','14670','TROARN',NULL,NULL,'1361014390001',81.000000000,'1965-09-23','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1281,'HINGAND','JEAN','1958-01-29','02.18.61.28.51','06.58.51.05.51',NULL,'CHEMIN DE LINFIRMERIE','','','14000','CAEN',NULL,NULL,'2580176390001',348.000000000,'1984-07-02','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1282,'CAILLON','CHRISTIANE','1935-02-06','02.28.70.94.60','06.71.03.54.28',NULL,'3 IMP BARRASSINS','','',NULL,NULL,NULL,NULL,'1350276021001',69.000000000,'1965-10-19','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1283,'HUBERT','JACQUES','1930-11-19','02.33.35.95.48','06.89.76.28.66',NULL,'16 RUE FRANCOIS MANSARD','','','61250','HAUTERIVE',NULL,NULL,'2301114160001',36.000000000,'1952-11-23','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1284,'CAPRON','GISELE','1935-05-12','02.46.80.66.12','06.68.40.48.11',NULL,'12 RUE EMILE ORY','','','14170','HIEVILLE',NULL,NULL,'1350514345001',40.000000000,'1958-01-30','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1285,'MALLET','GEORGES','1932-05-13','02.87.53.58.17','06.70.26.41.50',NULL,'LOTISSEMENT DES TILLEULS','','','14730','GIBERVILLE',NULL,NULL,'2320561145001',3.000000000,'1962-03-02','GOLD',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1286,'MITAINE','KLEBER','1937-05-17','02.40.21.00.04','06.36.43.63.57',NULL,'13 RUE DES CHARMILLES','','','14220','TOURNEBU',NULL,NULL,'1370514712001',63.000000000,'1963-12-21','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1287,'GODDERIDGE','GERARD','1928-05-23','02.26.02.64.60','06.99.17.24.39',NULL,'','','','14000','CAEN',NULL,NULL,'2280514525001',1109.000000000,'1951-09-24','PLATINIUM',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1288,'MAUGER','GERARD','1934-03-22',NULL,NULL,NULL,'120 JACQUES GEROULT','','','14370','CHICHEBOVILLE',NULL,NULL,'1340350509001',1884.000000000,'1964-09-13','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1289,'DESLANDES','ODETTE','1959-10-18','02.52.54.56.28','06.91.78.96.59',NULL,'4 ROUTE D''HARCOURT','','','61120','VIMOUTIERS',NULL,NULL,'2591014116001',4.000000000,'1980-11-11','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1290,'BUDOC','SIMONE','1948-02-04','02.33.45.89.10','06.57.82.59.29',NULL,'81 RUE DE BRETAGNE','','','14000','CAEN',NULL,NULL,'2480214416001',52.000000000,'1972-06-20','GOLD',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1291,'PHILIPPE','DANIEL','1930-05-28','02.83.83.60.23','06.44.10.69.85',NULL,'3/2 AVENUE DU POINT DU JOUR','','','14120','MONDEVILLE',NULL,NULL,'1300514024001',14.000000000,'1960-10-12','PREMIUM',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1292,'JENVRIN','eric','1932-09-04','02.35.59.18.70','06.12.05.95.98',NULL,'2 RUE EUGENE BOUDIN','','','14220','BOULON',NULL,NULL,'2320961166001',621.000000000,'1953-10-28','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1293,'LEROY','CHRISTIANE','1939-01-22','02.62.59.12.61','06.10.01.74.81',NULL,'10 rue st vincent de paul','','','14860','BAVENT',NULL,NULL,'2390161179001',97.000000000,'1968-07-18','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1294,'PECQUET','HENRI','1938-11-14','02.80.17.48.18','06.75.63.51.10',NULL,'1 rue de l eglise','','','14940','SANNERVILLE',NULL,NULL,'1381114408001',50.000000000,'1960-07-07','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1295,'CARABY','DANIEL','1929-01-19','02.85.86.97.95','06.82.30.58.05',NULL,'222 RUE CAPONIERE','','','14270','BIEVILLE QUETIEVILLE',NULL,NULL,'1290114750001',434.000000000,'1957-01-28','PREMIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1296,'MARIE','NATHALIE','1939-07-12','02.26.83.28.57','06.11.42.02.05',NULL,'11 RUE ERNEST RENAN','','','14200','HEROUVILLE ST CLAIR',NULL,NULL,'1390776219001',212.000000000,'1960-07-21','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1297,'PONTES','JOSSELINE','1930-06-12','02.72.18.90.16','06.37.83.59.93',NULL,'25 RUE DU MOULIN A VOIDE','','','14000','CAEN',NULL,NULL,'1300650378001',18.000000000,'1957-07-26','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1298,'OZANNE','MARIE DANIELLE','1929-02-27','02.87.74.06.41',NULL,NULL,'4 ROUTE D''ECOUVER','','','14000','CAEN',NULL,NULL,'1290214373001',481.000000000,'1953-03-20','PREMIUM',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1299,'MARIE','GILBERT','1939-03-11','02.79.05.30.74',NULL,NULL,'29 RUE DAMOZANE','','','14320','FONTENAY LE MARMION',NULL,NULL,'1390350263001',43.000000000,'1961-03-01','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1300,'LEMASLE','MONIQUE','1933-03-04','02.89.62.39.59','06.68.48.91.52',NULL,'2 rue guy de maupassant','','','14120','MONDEVILLE',NULL,NULL,'2330314577001',613.000000000,'1955-07-03','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1301,'ZIMMERMANN','BERNADETTE','1963-01-07','02.30.94.41.17','06.12.07.39.11',NULL,'27 RUE D IFS','','','14400','BAYEUX',NULL,NULL,'2630114287001',28.000000000,'1988-10-27','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1302,'LEREVEREND','CLAUDE','1939-12-21','02.11.77.85.49','06.28.13.13.45',NULL,'52 BIS ROUTE DE PARIS','','','14160','DIVES SUR MER',NULL,NULL,'1391250356001',780.000000000,'1966-08-12','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1303,'BOUCHARD','YVETTE','1935-04-23','02.72.32.24.47','06.87.02.14.87',NULL,'20 RUE JACQUES BREL','','','14120','MONDEVILLE',NULL,NULL,'2350414117001',22.000000000,'1964-12-24','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1304,'CLEMENT','YVETTE','1932-05-20','02.41.22.28.87','06.60.36.38.76',NULL,'4 RUE DE LA COMMUNE','','','14000','CAEN',NULL,NULL,'2320514251001',72.000000000,'1960-10-04','GOLD',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1305,'HAMELIN','JEAN JACQUES','1930-10-27','02.61.05.72.51','06.55.00.98.42',NULL,'5 RUE DES MOULINS','','','14490','LE TRONQUAY',NULL,NULL,'1301014318001',2991.000000000,'1956-07-04','PREMIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1306,'HUET','RENEE','1930-11-29','02.43.14.78.07','06.11.69.77.53',NULL,'4 ALLEE DU BUCQUET','','','14350','LE BENY BOCAGE',NULL,NULL,'1301161167001',99.000000000,'1956-01-14','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1307,'GERMAIN','RENEE','1941-03-01','02.33.32.20.33','06.83.31.61.21',NULL,'19 RUE DES FRESNETS','','','14000','CAEN',NULL,NULL,'2410314669001',39.000000000,'1965-06-24','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1308,'HENRION','ROGER','1961-01-04','02.54.12.56.72','06.13.79.48.34',NULL,'CHEMIN DES PRES','','','15270','CHAMPS SUR TARENTAINE MARCHAL',NULL,NULL,'2610114738001',17.000000000,'1991-01-25','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1309,'LOSTANLEN','Jean Pierre','1944-02-09','02.15.86.63.09','06.50.57.21.74',NULL,'9 rue de la chardonnrette','','',NULL,NULL,NULL,NULL,'1440227332001',766.000000000,'1973-12-19','GOLD',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1310,'VAUCLAIR','JEANNINE','1950-07-22','02.27.70.51.09','06.12.01.38.36',NULL,'6 RUE PAUL LANGEVIN','','','14460','COLOMBELLES',NULL,NULL,'2500750398001',242.000000000,'1975-06-08','PREMIUM',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1311,'','JEAN','1950-04-14','02.39.22.59.36','06.77.31.01.23',NULL,'31 residence la chapelle','','','14430','HOTOT EN AUGE',NULL,NULL,'2500414538001',23.000000000,'1974-10-27','PREMIUM',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1312,'FORTIN','Nathalie','1959-04-30','02.33.45.53.90','06.11.31.77.48',NULL,'17 RUE DES CERISIERS','','','14000','CAEN',NULL,NULL,'1590414018001',67.000000000,'1987-01-31','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1313,'LEPLEY','ROGER','1938-02-05','02.53.30.03.12','06.74.97.88.15',NULL,'5 RUE FARADAY','','','14000','CAEN',NULL,NULL,'2380250111001',290.000000000,'1961-06-14','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1314,'HARDY','EMILE','1938-11-09','02.15.39.79.96','06.59.94.11.35',NULL,'67 ROUTE DE PARIS','','','14740','BRETTEVILLE L''ORGUEILLEUSE',NULL,NULL,'1381114629001',186.000000000,'1965-11-18','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1315,'HARDY','RAYMONDE','1949-05-16','02.37.82.53.18','06.39.68.08.98',NULL,'VILLAGE LES HOULLES','','','14000','CAEN',NULL,NULL,'1490514432001',398.000000000,'1977-01-06','PREMIUM',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1316,'SANDEAU','NATHALIE','1968-01-19','02.28.11.14.91','06.46.07.69.57',NULL,'4/3 alle des capucines','','','14970','ST AUBIN D''ARQUENAY',NULL,NULL,'2680114327001',515.000000000,'1989-01-21','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1317,'BOUSQUET','JOEL','1964-03-13','02.62.70.83.87','06.97.29.95.93',NULL,'16 route du puit','','','14123','CORMELLES LE ROYAL',NULL,NULL,'2640314158001',37.000000000,'1986-04-06','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1318,'PAWLENKO','SOTHEAVY','1928-08-30','02.81.24.27.35','06.67.18.15.47',NULL,'RUE MALHERBE','','','14260','MONTAMY',NULL,NULL,'2280878127001',83.000000000,'1950-07-17','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1319,'CHAMPION','GERARD','1932-03-09','02.83.04.89.76','06.39.09.17.11',NULL,'7 RUE SAINT PAIX','','','14190','OUILLY LE TESSON',NULL,NULL,'2320350507001',19.000000000,'1955-03-07','PLATINIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1320,'VIGET','CATHERINE','1960-04-20','02.94.03.56.97','06.15.77.90.74',NULL,'52 RUE BELLE VU','','',NULL,NULL,NULL,NULL,'2600461408001',356.000000000,'1981-08-24','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1321,'PECHER','BRUNO','1934-03-21','02.11.76.08.94','06.45.36.35.34',NULL,'5 allee des pains gris','','','14200','HEROUVILLE ST CLAIR',NULL,NULL,'2340314301001',42.000000000,'1959-04-26','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1322,'LAIDET','PIERRE','1953-04-01','02.81.74.31.46',NULL,NULL,'4 rue Jean Moulin','','','14630','FRENOUVILLE',NULL,NULL,'1530461166001',40.000000000,'1980-03-03','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1323,'LE BUAN','MARIA','1930-09-02','02.83.46.05.19','06.27.43.02.29',NULL,'2 COUR TURQUETIL','','','14390','CABOURG',NULL,NULL,'2300950391001',810.000000000,'1953-12-16','PREMIUM',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1324,'BUSNOT','ANDREE','1939-07-16','02.10.14.38.84','06.29.95.60.43',NULL,'56 av guynemer','','','14000','CAEN',NULL,NULL,'2390714411001',41.000000000,'1963-08-10','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1325,'MOULIN','JOCELYNE','1937-11-23','02.89.01.96.12','06.32.16.49.88',NULL,'8 rue du lieu vautier','','','14220','CROISILLES',NULL,NULL,'1371114480001',55.000000000,'1967-01-11','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1326,'REHE','LUCIEN','1928-10-27','02.71.25.85.57','06.22.32.51.79',NULL,'LA BUTTE ROSSIGNOL','','','14220','GRIMBOSQ',NULL,NULL,'1281059075001',251.000000000,'1949-09-30','PLATINIUM',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1327,'LESELLIER','MICHEL','1964-03-11','02.41.23.39.58','06.55.81.73.98',NULL,'42AV LEON BLOUM','','','14000','CAEN',NULL,NULL,'2640361376001',27.000000000,'1989-06-15','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1328,'TAUPIN','JACQUELINE','1931-02-21','02.86.21.49.93','06.68.83.19.41',NULL,'13 RUE DE BRETAGNE','','','14190','URVILLE',NULL,NULL,'2310250087001',3.000000000,'1956-11-17','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1329,'LANGLOIS','ROGER','1938-11-30','02.78.43.69.10','06.37.19.11.14',NULL,'11 RUE DE L ABBAYE','','','14630','CAGNY',NULL,NULL,'1381114207001',2.000000000,'1960-07-23','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1330,'MERLE','MARIE JEANNE','1961-04-17','02.68.73.26.55','06.14.22.62.21',NULL,'45 rue de bretteville','','','14123','IFS',NULL,NULL,'1610414675001',2628.000000000,'1982-11-14','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1331,'MALINE','ANDRE','1929-04-09','02.35.89.62.59','06.11.46.80.33',NULL,'2 RUE DE LA PAIX','','','14370','AIRAN',NULL,NULL,'2290461221001',187.000000000,'1951-09-10','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1332,'L HOSTIS','JEAN CLAUDE','1945-06-09','02.64.11.40.45','06.40.30.56.16',NULL,'8 RUE HAUTE FEUILLE','','','14400','BAYEUX',NULL,NULL,'2450614576001',108.000000000,'1970-12-27','GOLD',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1333,'PINCON','MARCELLE','1935-11-04','02.87.21.02.29','06.39.16.05.20',NULL,'11 CHEMIN DU BREUIL','','','14130','SURVILLE',NULL,NULL,'1351114564001',32.000000000,'1964-05-05','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1334,'PEUDECOEUR','DANIEL','1939-10-18','02.87.62.82.19','06.11.58.47.59',NULL,'16 HAMEAU DE NEUF MER','','','14760','BRETTEVILLE SUR ODON',NULL,NULL,'2391035360001',1417.000000000,'1968-06-25','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1335,'HAMEL','CLAUDE','1935-12-21','02.61.88.86.93','06.29.61.09.81',NULL,'2 RUE DE LA  PAGNOLEE','','','14680','FRESNEY LE PUCEUX',NULL,NULL,'2351214014001',371.000000000,'1956-04-11','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1336,'FERREIRA','','1949-01-19','02.34.66.25.38','06.17.60.34.91',NULL,'2 RUE JEANZAY','','','14190','ST SYLVAIN',NULL,NULL,'2490114037001',54.000000000,'1970-02-25','PREMIUM',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1337,'LAHAYE','ERIC',NULL,'02.39.00.24.02','06.58.52.11.53',NULL,'21 RUE DE STOCKLOM','','','14500','ST GERMAIN DE TALLEVENDE',NULL,NULL,'1410114662001',264.000000000,'2009-05-15','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1338,'FLOTTE','GENEVIEVE','1938-07-26','02.45.46.06.16','06.55.99.41.11',NULL,'3 RUE DU MARECHAL JOFFRE','','','14670','TROARN',NULL,NULL,'1380750491001',47.000000000,'1961-08-01','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1339,'PAGNY','EDMOND','1937-06-16','02.98.45.16.87','06.60.76.14.49',NULL,'34 RUE ANATOLE FRANCE','','','14000','CAEN',NULL,NULL,'1370650095001',666.000000000,'1959-10-08','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1340,'DOCQUIER','BERNARD','1933-12-13','02.68.08.02.86','06.10.11.65.78',NULL,'17 rte de barbery','','','14120','MONDEVILLE',NULL,NULL,'1331214727001',66.000000000,'1955-12-25','PREMIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1341,'STAEL','CLAUDE','1936-08-27','02.45.61.92.98','06.11.57.61.73',NULL,'237 RUE GODET','','','14123','IFS',NULL,NULL,'1360814205001',17.000000000,'1957-10-19','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1342,'ROUSSELLE','JACQUELINE','1928-05-11','02.88.36.03.20','06.76.04.57.03',NULL,'CHEMIN DE CHAMBRAY','','','14000','CAEN',NULL,NULL,'1280514220001',363.000000000,'1951-10-09','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1343,'PIERRE DESIRE','RENE','1938-12-31','02.12.33.82.12','06.11.33.94.67',NULL,' 5 rue lemaitre','','','14250','TILLY SUR SEULLES',NULL,NULL,'2381214166001',88.000000000,'1962-08-14','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1344,'PIERRE DESIRE','DANIEL','1929-08-12','02.38.26.51.76','06.97.99.66.73',NULL,'3 ROUTE DE FOUR','','','14940','TOUFFREVILLE',NULL,NULL,'2290859604001',401.000000000,'1950-09-28','PREMIUM',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1345,'MARGUERITE','DELPHINE','1938-10-16','02.10.63.28.23','06.86.79.37.17',NULL,'1 rue de l europe','','','14000','CAEN',NULL,NULL,'1381050083001',64.000000000,'1966-11-28','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1346,'TIREL','RAYMOND','1966-01-03','02.58.37.44.55','06.96.82.80.90',NULL,'25 boulevard de l''esperance','','','14220','CESNY BOIS HALBOUT',NULL,NULL,'1660150615001',103.000000000,'1987-11-21','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1347,'TIREL','MADELEINE','1965-08-29','02.42.32.12.81','06.90.88.97.24',NULL,'FERME DU LOGIS','','','14690','PIERREFITTE EN CINGLAIS',NULL,NULL,'1650814033001',42.000000000,'1993-03-29','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1348,'RUAULT','LUCIENNE','1939-09-04','02.26.32.27.63','06.74.14.12.03',NULL,'48 bvd raymond poincare','','','14740','ST MANVIEU NORREY',NULL,NULL,'1390914283001',48.000000000,'1968-06-11','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1349,'RUAUX','DANIEL','1930-08-26',NULL,NULL,NULL,'3 PLACE ROTTENDORF','','','14730','GIBERVILLE',NULL,NULL,'2300849233001',427.000000000,'1951-01-08','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1350,'FISCHER','GILBERT','1937-06-05','02.87.86.94.34','06.52.45.48.15',NULL,'6 allee des vignons','','','14480','VILLIERS LE SEC',NULL,NULL,'1370614282001',152.000000000,'1961-03-09','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1351,'DEPARDIEU','HYACINTHE','1933-02-08','02.85.16.52.77','06.75.66.03.01',NULL,'35 RUE DU VAL D''ODON','','','14530','LUC SUR MER',NULL,NULL,'2330250292001',223.000000000,'1963-04-29','PREMIUM',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1352,'JOUANNEAU','MAURICE','1949-05-20','02.70.35.16.07','06.19.70.04.07',NULL,'65 route de coleville','','','14170','ST PIERRE SUR DIVES',NULL,NULL,'1490561478001',1183.000000000,'1972-03-01','PREMIUM',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1353,'CHARLES','FRANCOISE','1956-05-16','02.90.74.28.78',NULL,NULL,'88 ROUTE D IFS','','','14220','THURY HARCOURT',NULL,NULL,'1560514720001',655.000000000,'1985-06-19','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1354,'JEHANNE','MONIQUE','1935-02-27','02.11.95.17.99','06.58.91.87.11',NULL,'17 RUE GENERAL DE GAULLE','','',NULL,NULL,NULL,NULL,'2350214488001',68.000000000,'1958-10-02','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1355,'KACZMAREK','JEAN-LOUIS','1931-05-12',NULL,NULL,NULL,'28 rue des quesnots','','','14123','IFS',NULL,NULL,'1310514309001',48.000000000,'1952-04-01','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1356,'TAUPIN','JEANNINE','1945-08-27','02.10.96.31.42','06.68.23.84.26',NULL,'15 RUE SIRE DE CREULLY','','','14220','THURY HARCOURT',NULL,NULL,'1450814099001',121.000000000,'1974-04-12','GOLD',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1357,'BAZIN','NORBERT','1936-01-03','02.45.51.29.45','06.28.70.26.19',NULL,'7 RUE JEAN PHILIPPE RAMEAU','','','14220','THURY HARCOURT',NULL,NULL,'1360114113001',105.000000000,'1959-02-08','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1358,'HAMONIAUX','LOUIS','1951-02-25','02.60.25.02.25','06.60.00.05.72',NULL,'4 RUE COUCOU','','','14000','CAEN',NULL,NULL,'2510250486001',692.000000000,'1973-12-04','PREMIUM',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1359,'HAMEL','PIERRE','1968-04-06','02.75.68.00.56','06.43.28.89.16',NULL,'1 RUE HAMEAU PAISIBLE','','','14320','FEUGUEROLLES BULLY',NULL,NULL,'2680414118001',21.000000000,'1995-06-13','PREMIUM',12,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1360,'LE GOVIC','PAUL','1951-02-16','02.87.89.40.36','06.87.57.40.62',NULL,'AVENUE DES GABIONS','','','14370','MERY CORBON',NULL,NULL,'2510250486001',461.000000000,'1977-09-08','PREMIUM',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1361,'PELLOUIN','JEAN','1931-08-22','02.10.51.66.64','06.24.41.46.33',NULL,'LA TOURETTE','','','14000','CAEN',NULL,NULL,'1310861006001',29.000000000,'1956-03-14','PREMIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1362,'ELISABETH','VITAL','1968-06-01','02.27.34.34.06','06.58.30.21.57',NULL,'4 PLACE GAL LECLERC','','','14000','CAEN',NULL,NULL,'1680614005001',189.000000000,'1991-05-26','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1363,'BELLOU','EDMOND','1955-03-06','02.26.68.11.93','06.84.51.79.36',NULL,'15 RUE LAPLACE','','','14620','MORTEAUX COULIBOEUF',NULL,NULL,'1550314483001',2576.000000000,'1985-09-13','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1364,'VIOLLET','GILBERT','1940-04-20','02.69.45.18.98','06.15.68.64.67',NULL,'2 rue paul langevin','','','50880','PONT HEBERT',NULL,NULL,'2400461054001',223.000000000,'1970-07-29','SILVER',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1365,'JOUSSET','EMILE','1940-03-24','02.89.89.01.67','06.19.94.68.41',NULL,'1 rue de l''ile de france','','','14000','CAEN',NULL,NULL,'2400314181001',1399.000000000,'1962-11-28','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1366,'WAGNER','SOLANGE','1931-11-07','02.80.48.25.44','00 33 6.76.61.18.60',NULL,'15 RUE DU MARE','','','14190','ST SYLVAIN',NULL,NULL,'2311114709001',95.000000000,'1955-04-12','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1367,'ROBERT','ANDRE','1969-07-24','02.17.70.39.06','06.49.30.69.47',NULL,'23 ALLEE DE BRUXELLE','','','14310','VILLERS BOCAGE',NULL,NULL,'1690759183001',19.000000000,'1994-10-28','PREMIUM',12,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1368,'BONNEAU','DANIEL','1928-10-07','02.52.31.68.98','06.79.36.73.81',NULL,'7 ALLEE DES FAUVETTES','','','14000','CAEN',NULL,NULL,'2281014328001',2809.000000000,'1958-02-01','PREMIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1369,'PRIN','JACQUES','1939-02-04','02.96.55.35.63','06.44.53.45.10',NULL,'31 CHEMIN DU HAMEL','','','14000','CAEN',NULL,NULL,'2390214346001',6.000000000,'1963-07-15','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1370,'DEBAIZE','BERNADETTE','1929-08-03','02.10.23.90.51','06.18.04.18.50',NULL,'11LE MONT D UROU','','','14117','ARROMANCHES LES BAINS',NULL,NULL,'1290850492001',380.000000000,'1952-12-01','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1371,'GUILLOT','claude','1957-08-17','02.37.33.83.07','06.54.15.39.07',NULL,'95 route de rouen','','','14270','MEZIDON CANON',NULL,NULL,'1570814430001',184.000000000,'1985-10-21','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1372,'JOHN','DENISE','1960-01-01','02.58.37.24.87','06.58.59.14.76',NULL,'23 ALBERT GODARD','','','14123','IFS',NULL,NULL,'1600114581001',721.000000000,'1989-03-23','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1373,'HEBERT','ROBERT','1934-05-15','02.64.59.36.08','06.47.01.93.27',NULL,'10 rue du pere joseph','','','14123','IFS',NULL,NULL,'1340561410001',23.000000000,'1955-10-31','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1374,'VAUVARIN','YVETTE','1939-09-11','02.84.37.24.75','06.88.83.13.09',NULL,'26 rue vaudieres','','','14340','LA HOUBLONNIERE',NULL,NULL,'2390945225001',135.000000000,'1965-03-20','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1375,'LELIEVRE','JULIEN','1930-12-28','02.11.82.48.09','06.10.76.68.97',NULL,'57 rue louis lechatelier','','','14460','COLOMBELLES',NULL,NULL,'1301214229001',42.000000000,'1956-02-23','PREMIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1376,'QUETEL','ANNE MARIE','1937-02-20','02.32.67.57.85','06.45.72.31.21',NULL,'21 RUE DU HAMEAU FOULON','','','14370','ARGENCES',NULL,NULL,'1370250149001',41.000000000,'1967-01-13','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1377,'GUILLOT','THERESE','1932-08-18','02.58.02.90.94','06.66.66.48.52',NULL,'43 RUE DES ACACIAS','','','14270','QUETIEVILLE',NULL,NULL,'2320814372001',1431.000000000,'1953-02-02','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1378,'HUBERT','FRANCOIS','1963-01-24','02.46.80.38.45','06.10.76.41.52',NULL,'62 ROUTE DE PARIS','','','14400','ARGANCHY',NULL,NULL,'1630114355001',1086.000000000,'1986-11-28','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1379,'THOMAS','ROGER','1935-05-06','02.13.67.01.48','06.53.21.85.86',NULL,'19 rue des penses','','',NULL,NULL,NULL,NULL,'1350550483001',627.000000000,'1956-11-02','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1380,'LELAIDIER','M THERESE','1937-11-28','02.77.27.20.77','06.34.86.62.52',NULL,'15 rue de stockholm','','','14190','ESTREES LA CAMPAGNE',NULL,NULL,'2371114120001',4114.000000000,'1958-02-04','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1381,'DERRIEN','CORINNE','1935-05-02','02.12.10.07.27','06.73.68.97.75',NULL,'2 rue therese de la varde','','','14121','SALLENELLES',NULL,NULL,'2350514434001',38.000000000,'1958-10-04','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1382,'ALLIX','CLAUDE','1945-02-11','02.11.93.17.97','06.46.87.55.20',NULL,'14 RUE PAUL LANGEVIN','','','14000','CAEN',NULL,NULL,'1450276279001',103.000000000,'1972-02-24','GOLD',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1383,'SONNET','LUCIENNE','1932-05-01','02.10.58.42.95','06.12.19.40.74',NULL,'2260 route de coutances','','','14540','BOURGUEBUS',NULL,NULL,'1320514034001',100.000000000,'1958-09-27','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1384,'COTTRAIT','MAURICETTE','1933-09-25','02.72.56.51.94','06.86.20.33.50',NULL,'LOTISSEMENT LES COTEAUX','','','14000','CAEN',NULL,NULL,'1330961101001',14.000000000,'1959-10-06','GOLD',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1385,'GUILLEMET','NATAVAN','1959-03-07','02.52.93.67.56','06.11.55.87.51',NULL,'18 RUE DES PRES','','','75116','PARIS',NULL,NULL,'2590314509001',186.000000000,'1982-08-29','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1386,'DETAIS','ODETTE','1963-02-13','02.72.00.57.53','06.19.77.92.56',NULL,'55 RUE PARC DU CHATEAU','','','14850','HEROUVILLETTE',NULL,NULL,'2630214714001',311.000000000,'1992-08-28','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1387,'MASSOT','MADELEINE','1937-04-18','02.37.99.52.02','06.20.59.00.16',NULL,'15 QUAI DE LA LONDE','','','14120','MONDEVILLE',NULL,NULL,'1370461469001',1037.000000000,'1963-11-14','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1388,'DUFOUR','VINCENT','1956-06-24','02.49.98.05.74',NULL,NULL,'8 RUE GEORGES MAUDUIT','','','14000','CAEN',NULL,NULL,'2560614404001',104.000000000,'1979-02-10','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1389,'DUVAL','MICHEL','1939-03-07','02.60.52.02.85','06.10.77.42.51',NULL,'LE BOURG','','','14000','CAEN',NULL,NULL,'1390314745001',105.000000000,'1962-01-21','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1390,'PETITJOUAN','YEZRY','1960-02-20','02.32.53.49.10','06.77.89.71.70',NULL,'4 RUE DU 11 NOVEMBRE','','','14370','MOULT',NULL,NULL,'2600214245001',300.000000000,'1986-09-19','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1391,'FLEURY','ERIC','1938-08-07','02.11.86.46.81','06.10.13.75.86',NULL,'12 RUE DES GRANDES MURAILLES','','','14730','GIBERVILLE',NULL,NULL,'1380814211001',919.000000000,'1968-08-16','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1392,'LANDEAU','MADELEINE','1958-10-22','02.57.71.36.33','06.78.56.37.86',NULL,'7 RUE RENE VALOGNES CHEZ MME B','ICHARD M.T','','14700','FOURNEAUX LE VAL',NULL,NULL,'2581051598001',700.000000000,'1983-06-26','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1393,'VINGTROIS','DANIEL','1931-08-01','02.22.96.51.60','06.88.22.75.98',NULL,'15 RUE DE LA TESTE DE BUCH','','','14000','CAEN',NULL,NULL,'2310861093001',19.000000000,'1960-07-03','PREMIUM',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1394,'GUINCESTRE','ODETTE','1933-06-08','02.30.42.94.72','06.72.93.10.64',NULL,'10 RUE DE LA REPUBLIQUE','','','14123','IFS',NULL,NULL,'2330614463001',1525.000000000,'1955-06-25','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1395,'RAULT','ELISABETH','1947-02-17','02.92.20.54.96','06.67.77.79.95',NULL,'3 RUE DE L''AVIATION','','','14670','TROARN',NULL,NULL,'2470250491001',39.000000000,'1969-01-23','GOLD',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1396,'CREMA','MAURICE','1964-01-25','02.64.01.67.01','06.14.88.79.01',NULL,'5/3 ALLEE DES CHEVREFEUILLES','','','14460','COLOMBELLES',NULL,NULL,'1640114734001',88.000000000,'1994-07-29','PREMIUM',12,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1397,'WETZSTEIN','CHRISTIANE','1948-04-23','02.12.67.40.52','06.16.67.00.54',NULL,'3 RUE CHARLOTTE CORDAY','','','14200','HEROUVILLE ST CLAIR',NULL,NULL,'2480414444001',931.000000000,'1971-08-19','GOLD',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1398,'BEAUGEARD','MARIE THERESE','1965-05-30','02.17.44.06.77','06.48.68.57.79',NULL,'28 RUE ALFRED DE MUSSET','','','14120','MONDEVILLE',NULL,NULL,'1650514119001',12.000000000,'1990-01-11','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1399,'HEBERT','PHILIPPE','1933-08-11','02.21.30.33.72','06.44.20.82.25',NULL,'1 3 allee du romarin','','','14940','SANNERVILLE',NULL,NULL,'1330814685001',36.000000000,'1957-01-26','PREMIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1400,'GUERET','YVETTE','1928-03-20','02.57.43.01.84','06.25.49.59.41',NULL,'21 RUE PIERRE DE COUBERTIN','','','61570','ALMENECHES',NULL,NULL,'2280314724001',745.000000000,'1958-10-04','PREMIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1401,'VALENTE','','1937-08-31','02.59.45.40.84','06.36.94.85.16',NULL,'25 rue henri philippe','','','14540','ST AIGNAN DE CRAMESNIL',NULL,NULL,'1370814351001',130.000000000,'1967-05-29','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1402,'MARGUERITE','MODESTO','1969-07-02','02.84.35.79.46','06.71.12.75.95',NULL,'6 ALLEE DU FELIER','','','14480','LANTHEUIL',NULL,NULL,'1690714109001',44.000000000,'1992-02-27','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1403,'SIMEON','RACHELLE','1932-09-28','02.83.29.09.80','06.67.07.20.96',NULL,'5 PLACE GEORGES CLEMENCEAU','','','14150','OUISTREHAM',NULL,NULL,'2320925493001',1919.000000000,'1959-12-31','PREMIUM',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1404,'LAFOSSE','JEAN PIERRE','1930-01-21','02.87.38.58.11','06.74.14.64.69',NULL,'78 RUE ST ANNE','','','14000','CAEN',NULL,NULL,'1300114241001',1089.000000000,'1959-09-22','GOLD',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1405,'','JEAN PIERRE','1939-12-04','02.38.63.67.08','06.59.90.78.61',NULL,'32 BIS AVENUE DE LA PAIX','','','14960','ASNELLES',NULL,NULL,'1391214212001',163.000000000,'1965-10-09','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1406,'HIE','gerard','1933-06-07','02.66.64.38.73','06.13.80.20.00',NULL,'41 AVEBUE ROBERT SCHUMAN','','','14670','TROARN',NULL,NULL,'2330661078001',2518.000000000,'1954-03-08','PREMIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1407,'REBACZ','DIDIER','1940-06-05','02.35.77.37.27','06.72.05.04.16',NULL,'4 ALLEE ALFRED JARRY','','','50120','EQUEURDREVILLE HAINNEVILLE',NULL,NULL,'2400662024001',10.000000000,'1964-01-27','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1408,'BIREE','SIMONE','1936-04-21','02.73.89.10.52','06.70.11.15.85',NULL,'75 rue eustache restoux','','','14370','BELLENGREVILLE',NULL,NULL,'1360414456001',612.000000000,'1960-06-17','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1409,'ALBRECHT','ANDREE','1966-01-24','02.11.40.22.29','06.11.69.48.34',NULL,'6 AVENUE DU 19 MARS 1962','','','14370','MOULT',NULL,NULL,'1660162557001',1.000000000,'1989-03-19','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1410,'MORIN','MARIE','1935-04-29','02.40.44.04.66','06.63.50.18.07',NULL,'27 RUE FROIDE','','','14730','GIBERVILLE',NULL,NULL,'1350414027001',357.000000000,'1956-01-22','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1411,'LEMOINE','SANDRINE','1945-01-01','02.10.07.55.03','06.71.72.20.73',NULL,'7 RUE DES LILAS','','','14000','CAEN',NULL,NULL,'2450176312001',1026.000000000,'1975-07-06','GOLD',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1412,'DESGUET','MARGUERITE',NULL,'02.31.67.69.60','06.90.88.72.03',NULL,'36 RUE DE CHAMPAGNE','','','14270','MEZIDON CANON',NULL,NULL,'2400922034001',56.000000000,'2010-05-11','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1413,'DUVAL','GEORGETTE','1930-03-10','02.89.69.74.04',NULL,NULL,'9 RUE DE LA PETITE LONDE','','','14000','CAEN',NULL,NULL,'2300314692001',210.000000000,'1956-01-11','PREMIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1414,'ROUSSEAU','MICHEL','1932-03-19','02.89.80.82.85','06.28.76.03.56',NULL,'10 RUE BEAU SEJOUR','','','14320','ST MARTIN DE FONTENAY',NULL,NULL,'1320314146001',9.000000000,'1958-12-10','PREMIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1415,'GESTIN','DANIEL','1938-07-21','02.10.77.67.05','06.52.34.91.36',NULL,'LE LONDAIN','','','14630','CAGNY',NULL,NULL,'1380750491001',208.000000000,'1962-11-20','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1416,'GAUTIER','','1963-11-23','02.99.64.13.87','06.39.82.66.84',NULL,'17 RUE GENERAL DE GAULLE','','','14160','DIVES SUR MER',NULL,NULL,'2631114118001',205.000000000,'1984-07-06','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1417,'CHEMIN','THERESE','1938-10-11','02.56.75.59.83','06.62.02.36.00',NULL,'6 RUE DE L''ILE DE FRANCE','','','14120','MONDEVILLE',NULL,NULL,'1381050062001',1197.000000000,'1961-03-30','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1418,'LAMOTTE','CHRISTIAN','1956-02-13','02.51.37.35.46','06.19.43.64.33',NULL,'40 RUE DE LA FRENAYE','','','50160','TORIGNI SUR VIRE',NULL,NULL,'2560214247001',3.000000000,'1977-09-15','PREMIUM',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1419,'GABRIEL','LIONEL','1928-03-14','02.10.03.08.20','06.58.61.60.70',NULL,'8 PLACE DE LA PETITE BRUYERE','','','14000','CAEN',NULL,NULL,'1280314548001',685.000000000,'1956-08-23','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1420,'LEMAITRE','BERNARD','1939-01-11','02.84.02.87.99','06.14.21.32.11',NULL,'196 RUE DE LA DIME','','','14100','LISIEUX',NULL,NULL,'2390114128001',242.000000000,'1963-10-25','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1421,'PIQUET','ANNIC','1939-09-06','02.60.63.62.17','06.79.35.09.64',NULL,'3 RUE DE COLOMBELLES','','','14000','CAEN',NULL,NULL,'1390914283001',3755.000000000,'1962-02-10','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1422,'MEZERETTE','SOPHIE','1933-11-30','02.12.23.98.64','06.61.21.92.93',NULL,'route de la bagotiere','','','14400','BAYEUX',NULL,NULL,'2331114038001',170.000000000,'1963-01-18','GOLD',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1423,'BOUGAULT','RAYMONDE','1936-09-22','02.25.75.19.22','06.68.80.42.05',NULL,'LE MESNIL','','','14460','COLOMBELLES',NULL,NULL,'2360914480001',39.000000000,'1962-09-12','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1424,'BINET','MICHEL','1944-06-19','02.53.66.63.05','06.67.96.37.90',NULL,'LE BOURG','','','14000','CAEN',NULL,NULL,'2440614196001',39.000000000,'1965-10-27','GOLD',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1425,'GRANDRIE','JEAN LUC','1937-01-09','02.59.61.71.85','06.18.90.88.77',NULL,'7 rue des chasses','','','14360','TROUVILLE SUR MER',NULL,NULL,'1370114164001',2597.000000000,'1959-02-10','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1426,'DUCHEMIN','GERARD','1937-01-28','02.10.18.98.37','06.76.07.61.37',NULL,'18 GRANDE RUE','','','14280','ST CONTEST',NULL,NULL,'1370114164001',1344.000000000,'1959-09-23','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1427,'NOYER','GERARD','1939-11-18','02.88.75.56.60','06.11.92.39.93',NULL,'6 BIS RUE DES ROCHES','','','14320','ST MARTIN DE FONTENAY',NULL,NULL,'1391189287001',36.000000000,'1960-09-20','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1428,'TURBAN','GENEVIEVE','1937-05-21','02.10.20.14.32','06.12.09.87.17',NULL,'20 rue anatole france','','','14700','AUBIGNY',NULL,NULL,'2370550099001',1916.000000000,'1958-05-12','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1429,'REMY','SOLANGE','1953-05-22','02.62.47.04.58','06.71.26.96.80',NULL,'9 RUE RICHARD LENOIR','','','14123','FLEURY SUR ORNE',NULL,NULL,'2530527523001',24.000000000,'1975-05-14','PREMIUM',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1430,'LE DUC','MICHEL','1943-03-01','02.21.26.66.07','06.10.58.04.37',NULL,'4 rue p langevin','','','14000','CAEN',NULL,NULL,'1430327364001',766.000000000,'1964-03-09','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1431,'SALERNE','MICHELINE','1938-01-08','02.69.53.34.58','06.32.26.72.14',NULL,'8-3 ALLEE DES CAMPANULES','','','14000','CAEN',NULL,NULL,'2380114327001',30.000000000,'1966-10-22','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1432,'ADAMCIK','FERNAND','1934-02-23','02.82.67.33.04','06.72.03.17.67',NULL,'16 RUE DES SURETS','','','14120','MONDEVILLE',NULL,NULL,'1340214651001',48.000000000,'1963-06-28','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1433,'CASSIGNEUL','MARIE NOELLE','1942-01-23','02.29.07.48.81','06.72.39.61.14',NULL,'1 CHEMIN DES CALYMENES','','','14370','ARGENCES',NULL,NULL,'2420150038001',19.000000000,'1965-07-13','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1434,'PITOIS','CLAUDIA','1928-09-18','02.40.15.19.63','06.25.59.20.42',NULL,'RESIDENCE ALBATROS BD BOIVIN CH','AMPEAUX','','14320','FONTENAY LE MARMION',NULL,NULL,'1280914669001',2.000000000,'1953-11-12','PREMIUM',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1435,'MADELINE','GERARD','1933-05-15',NULL,NULL,NULL,'7 RUE STE PAIX PORTE B','','','14123','FLEURY SUR ORNE',NULL,NULL,'2330514134001',429.000000000,'1954-10-11','PREMIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1436,'LEGRAND','PATRICK','1929-06-26','02.97.65.63.41','06.22.21.37.83',NULL,'15 rue v lepine','','','14000','CAEN',NULL,NULL,'1290650559001',78.000000000,'1959-05-29','GOLD',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1437,'LEBRUN','JACQUELINE','1929-06-24','02.12.29.96.72','06.92.01.37.53',NULL,'rue du parc','','','14800','TOUQUES',NULL,NULL,'1290650559001',130.000000000,'1952-01-08','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1438,'SAVARY','SOPHIE','1948-03-10','02.56.15.07.29','06.16.57.76.52',NULL,'8 RUE DES CARMES','','','14730','GIBERVILLE',NULL,NULL,'1480314729001',27.000000000,'1978-08-11','GOLD',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1439,'QUESLIER','RAYMONDE','1937-11-28','02.12.12.86.56','06.70.14.37.65',NULL,'2 ET 4 AVENUE DE PARIS','','','14000','CAEN',NULL,NULL,'1371150577001',37.000000000,'1965-01-09','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1440,'CORBIN','ROGER','1935-01-07','02.77.41.81.89','06.71.45.88.65',NULL,'2 RUE BOUTROIS','','','14210','STE HONORINE DU FAY',NULL,NULL,'2350114208001',141.000000000,'1959-07-28','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1441,'LASSEUR','MICHEL','1958-02-20','02.23.67.04.73','06.56.19.83.89',NULL,'8,rue saint norbert','','','14670','BURES SUR DIVES',NULL,NULL,'2580214315001',253.000000000,'1983-07-09','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1442,'DRION','JOCELYNE','1936-05-14','02.11.34.53.77','06.11.03.27.88',NULL,'8,rue saint norbert','','','14630','FRENOUVILLE',NULL,NULL,'1360514437001',376.000000000,'1960-09-02','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1443,'RAVIDAT','BRUNO','1960-03-17','02.39.00.17.51','06.51.93.04.32',NULL,'9 bd de l esperance','','','14000','CAEN',NULL,NULL,'2600314478001',333.000000000,'1989-01-25','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1444,'LANDAIS','PHILIPPE','1960-03-01','02.22.20.18.89','06.12.34.80.32',NULL,'2-1 ALLEE SERPENTINE','','','14730','GIBERVILLE',NULL,NULL,'2600314274001',792.000000000,'1987-06-28','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1445,'DERAINE','SOLANGE','1934-10-13','02.51.68.89.82','06.45.49.72.19',NULL,'22 RUE D ARMOR','','','14700','FALAISE',NULL,NULL,'2341014708001',53.000000000,'1956-02-23','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1446,'NICOLLE','JEAN',NULL,'02.79.53.65.44','06.83.16.36.75',NULL,'13 RUE DE GOURNAY','','','14190','URVILLE',NULL,NULL,'2320561489001',123.000000000,'2008-03-12','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1447,'MARIE','JACQUELINE',NULL,'02.81.03.39.75','06.30.42.24.22',NULL,'38 BIS ROUTE D''HARCOURT','','','14120','MONDEVILLE',NULL,NULL,'2401253201001',37.000000000,'2011-03-01','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1448,'GROSSE','MAURICE','1943-02-04','02.10.13.75.77','06.16.46.86.78',NULL,'21 RUE DES MARRONNIERS','','','14990','BERNIERES SUR MER',NULL,NULL,'1430214717001',17.000000000,'1966-04-26','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1449,'BREANT','ROGER','1940-12-13','02.98.30.05.52','06.10.57.36.97',NULL,'7 rue notre dame des champs','','','14540','GRENTHEVILLE',NULL,NULL,'2401250007001',2443.000000000,'1966-05-26','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1450,'SANGALLI','GILBERT','1927-03-15','02.67.42.50.95','06.73.14.23.91',NULL,'133 RUE HAUTE','','','14120','MONDEVILLE',NULL,NULL,'2270397103001',4000.000000000,'1951-07-25','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1451,'LETENNEUR','CHANTAL','1937-07-14','02.39.42.82.31','06.62.73.58.34',NULL,'6 RUE DES JONQUILLES','','','14000','CAEN',NULL,NULL,'2370714516001',43.000000000,'1961-05-27','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1452,'DE FERRIERE LE VAYER','ROGER','1957-01-26','02.35.25.90.73','06.77.33.75.90',NULL,'74 rue ernest ronand','','','14630','CAGNY',NULL,NULL,'2570114034001',798.000000000,'1986-03-09','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1453,'N''GUENOR','ROGER','1944-12-10','02.93.24.05.86','06.49.95.41.23',NULL,'9 rue paul samson','','','14123','FLEURY SUR ORNE',NULL,NULL,'2441214237001',29.000000000,'1968-04-22','GOLD',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1454,'BARBE','EMILE','1931-03-16','02.11.92.28.87','06.66.99.88.48',NULL,'41 RUE AUGUSTE LECHESNE','','','14123','CORMELLES LE ROYAL',NULL,NULL,'1310376254001',89.000000000,'1952-08-05','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1455,'ROUAULT DE COLIGNY','REMY','1934-05-24','02.92.82.09.55','06.62.36.83.66',NULL,'21 bis rue reg de maisonneuve','','','14123','CORMELLES LE ROYAL',NULL,NULL,'1340514073001',258.000000000,'1958-12-09','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1456,'LE DUC','GENEVIEVE','1931-12-29','02.12.59.57.01','06.39.82.13.35',NULL,'1102 haute folie','','','14190','OUILLY LE TESSON',NULL,NULL,'1311227333001',951.000000000,'1961-05-05','PLATINIUM',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1457,'LECONTE','JOELLE','1929-09-09','02.29.43.62.86','06.20.82.58.63',NULL,'98 rue de branville bat c','','','14670','TROARN',NULL,NULL,'1290914658001',10.000000000,'1951-10-01','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1458,'ROUSSEL','ROBERT','1940-04-14','02.88.06.41.81','06.91.97.03.71',NULL,'4 rue soulie','','','14860','BAVENT',NULL,NULL,'2400450235001',184.000000000,'1970-08-21','SILVER',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1459,'CHEMIN','ERIC','1942-01-30','02.31.55.39.99','06.97.90.07.29',NULL,'9 RUE DE LA HACHE RESIDENCE LES','DELICES','','14610','CAIRON',NULL,NULL,'1420114130001',27.000000000,'1967-12-15','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1460,'DARTY','GILBERT','1958-01-26','02.32.06.65.36','06.51.84.48.91',NULL,'RESIDENCE DE L''EGLISE BAT B2','','','14940','TOUFFREVILLE',NULL,NULL,'2580114196001',311.000000000,'1979-06-17','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1461,'LEVAVASSEUR','LYDIE','1935-12-09','02.58.66.43.09','06.29.64.12.11',NULL,'53 RUE SAINT ANDRE','','','14810','MERVILLE FRANCEVILLE PLAGE',NULL,NULL,'2351276034001',57.000000000,'1960-06-19','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1462,'','ANNETTE','1966-02-04','02.31.48.66.33','06.40.27.75.50',NULL,'18 RUE ST ANDRE APPT 27','','','14000','CAEN',NULL,NULL,'1660277331001',1319.000000000,'1990-10-27','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1463,'LAHAYE','JEANNINE',NULL,'02.66.70.80.43','06.39.03.88.36',NULL,'43 RUE C BLAISOT','','','14440','DOUVRES LA DELIVRANDE',NULL,NULL,'1280414529001',2071.000000000,'2010-06-24','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1464,'BRIDET','FATIMA','1935-04-09','02.67.92.76.65','06.67.53.65.71',NULL,'25 RUE DE LA FONTAINE','','','14670','JANVILLE',NULL,NULL,'2350461466001',24.000000000,'1959-08-08','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1465,'CHOUQUARD','YVES','1939-10-26','02.42.28.45.78','06.56.08.97.55',NULL,'12 RUE PAUL DE COUBERTIN','','','95320','ST LEU LA FORET',NULL,NULL,'2391014127001',282.000000000,'1965-10-29','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1466,'FRAPPIER','DIDIER','1928-05-10','02.63.41.93.82','06.62.59.59.08',NULL,'','','','14160','DIVES SUR MER',NULL,NULL,'1280514220001',12.000000000,'1955-11-02','PREMIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1467,'JOUAN','JEANNE','1939-10-08','02.80.74.53.63',NULL,NULL,'19 ROUTE DE TINCHEBRAY','','','14320','ST MARTIN DE FONTENAY',NULL,NULL,'1391050370001',15.000000000,'1966-08-03','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1468,'SOYER','GEORGES','1946-03-20','02.58.01.30.25','06.50.14.39.68',NULL,'LOYSEL','','','14460','COLOMBELLES',NULL,NULL,'1460350299001',6.000000000,'1972-07-15','GOLD',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1469,'FIANT','PIERRETTE','1960-07-21','02.23.97.38.45','06.48.15.59.85',NULL,'4 ALLEE DES FAUSETTES','','','27210','CONTEVILLE',NULL,NULL,'1600714246001',742.000000000,'1988-12-10','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1470,'BUNEL','JACQUELINE','1927-08-14','02.90.91.86.20','06.23.65.38.60',NULL,'4 RUE DE LA DIVE','','','14123','CORMELLES LE ROYAL',NULL,NULL,'2270814008001',642.000000000,'1955-04-11','PREMIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1471,'VAUVRECY','MICHEL','1939-02-06','02.51.25.47.43','06.26.78.32.60',NULL,'27 RUE BOUILLON','','','14400','ST MARTIN DES ENTREES',NULL,NULL,'2390214628001',14.000000000,'1961-12-23','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1472,'AUMOND','EVELINE','1941-05-23','02.65.83.63.12','06.85.00.89.05',NULL,'36 RUE CLEMENCEAU','','','14440','DOUVRES LA DELIVRANDE',NULL,NULL,'1410514134001',930.000000000,'1965-04-15','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1473,'TURQUET','EMILE','1932-10-10','02.82.93.67.76','06.67.47.99.26',NULL,'75 rue eustache restoux','','','61200','ARGENTAN',NULL,NULL,'1321014479001',208.000000000,'1959-05-22','PREMIUM',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1474,'BECQUET','CLAUDE','1959-07-08','02.37.31.48.95','06.48.04.66.63',NULL,'5 rue kalinigrenko','','','14000','CAEN',NULL,NULL,'1590714114001',470.000000000,'1980-12-16','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1475,'HARIVEL','JEAN','1962-01-16','02.71.23.98.16','06.25.91.73.71',NULL,'1 rue des ecoles','','','14190','ST SYLVAIN',NULL,NULL,'1620114168001',138.000000000,'1983-08-28','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1476,'HENRY','FRANCOISE','1967-05-24','02.65.95.32.53','06.27.31.27.29',NULL,'43 quai de juillet','','','14670','TROARN',NULL,NULL,'2670514158001',187.000000000,'1990-07-06','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1477,'CHERUETTE','MAURICE','1928-08-24','02.75.68.58.79','06.39.44.13.72',NULL,'60 rue des accacias','','','14000','CAEN',NULL,NULL,'2280878127001',555.000000000,'1951-02-22','PREMIUM',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1478,'CALBRY','ANNE-MARIE','1943-06-27','02.58.57.13.89','06.30.45.41.32',NULL,'23 route de paris','','',NULL,NULL,NULL,NULL,'1430614218001',68.000000000,'1964-06-10','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1479,'LECLERC','CLAUDINE','1939-08-22','02.65.87.20.35','06.70.87.93.08',NULL,'98 rue bronville','','','14320','ST MARTIN DE FONTENAY',NULL,NULL,'1390814734001',2802.000000000,'1968-01-04','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1480,'PERREAU','ROLANDE','1931-08-08','02.50.75.25.80','06.11.85.18.32',NULL,'9 rue gabrielle renou','','','14000','CAEN',NULL,NULL,'2310814437001',342.000000000,'1956-04-02','PREMIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1481,'','SOPHIE','1932-11-27','02.12.06.39.05','06.34.11.91.45',NULL,'7 RUE DU STADE','','','14000','CAEN',NULL,NULL,'2321114074001',37.000000000,'1960-02-12','GOLD',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1482,'ROYER','','1953-03-13','02.21.71.24.91','06.11.23.70.84',NULL,'69 ROUTE NATIONALE','','','50460','TONNEVILLE',NULL,NULL,'2530362071001',2983.000000000,'1975-06-24','PREMIUM',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1483,'HAMEL','YVES','1963-12-22','02.63.69.64.71','06.70.87.79.43',NULL,'2 RUE DE SECQUEVILLE','','','14000','CAEN',NULL,NULL,'1631299253001',0.000000000,'1985-04-24','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1484,'BESNIER','PAUL','1939-06-20','02.50.60.80.67','06.53.36.26.12',NULL,'26 CLOS ST MARTIN','','',NULL,NULL,NULL,NULL,'1390627469001',395.000000000,'1963-01-15','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1485,'CAGET','CATHERINE','1929-10-18','02.85.87.74.99',NULL,NULL,'LE BOURG','','','14270','MEZIDON CANON',NULL,NULL,'1291002071001',346.000000000,'1954-09-16','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1486,'LEROUX','RAYMOND','1967-01-14','02.26.19.82.01','06.10.42.66.19',NULL,'16 rue du sentier','','','14840','DEMOUVILLE',NULL,NULL,'2670175022001',32.000000000,'1988-12-29','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1487,'MALASSIGNE','COLETTE','1940-05-06','02.83.18.93.65','06.77.37.08.91',NULL,'5 rue jean baptiste jaillet','','','14480','LANTHEUIL',NULL,NULL,'1400514501001',21.000000000,'1961-12-20','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1488,'LELIEVRE','MARIE THERESE','1969-10-02','02.73.67.58.89','06.13.21.80.86',NULL,'LE BOURG','','','14320','FONTENAY LE MARMION',NULL,NULL,'2691042187001',155.000000000,'1994-09-27','PREMIUM',12,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1489,'LEMONNIER','JEAN PAUL','1943-03-14','02.39.36.39.77','06.16.38.26.14',NULL,'3 RUE LENOTRE','','','14670','TROARN',NULL,NULL,'2430341273001',11.000000000,'1973-10-11','SILVER',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1490,'GURY','NICOLE','1929-12-09','02.81.48.03.48','06.95.49.85.77',NULL,'','','','61570','ALMENECHES',NULL,NULL,'2291214268001',63.000000000,'1957-12-30','PREMIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1491,'POREY','AHMED','1929-12-08','02.11.58.76.15','06.43.45.91.66',NULL,'73 BIS RUE DU TOUR DE VILLE','','','14123','IFS',NULL,NULL,'2291214268001',319.000000000,'1955-07-18','PREMIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1492,'BEDIER','LAURENCE','1947-02-23','02.76.55.93.69','06.10.01.77.71',NULL,'20 RUE ROBERT LE MAGNIFIQUE','','','14420','POTIGNY',NULL,NULL,'1470214623001',52.000000000,'1974-01-16','GOLD',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1493,'POUSSIN','LILIANE','1928-03-07','02.38.53.20.07','06.10.44.40.22',NULL,'5 RUE ALBERT CAMUS','','','14000','CAEN',NULL,NULL,'2280314747001',32.000000000,'1955-03-21','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1494,'GUILLOTIN','HUGUETTE','1960-02-12','02.27.59.76.77','06.82.10.25.06',NULL,'9 RUE DES DUNES','','','14670','TROARN',NULL,NULL,'1600214667001',142.000000000,'1986-02-06','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1495,'QUIQUEMELLE','JACK','1928-10-05','02.47.62.43.91','06.78.69.46.89',NULL,'54 RUE DE BREST','','','14000','CAEN',NULL,NULL,'1281014316001',3070.000000000,'1949-11-07','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1496,'QUENTIN','JACQUELINE','1938-09-17','02.75.68.06.41','06.68.15.92.58',NULL,'17 rue des tilleuls','','','14270','MEZIDON CANON',NULL,NULL,'1380914717001',1885.000000000,'1960-04-29','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1497,'COUTANCE','ROBERT','1948-01-29','02.10.96.31.70','06.11.83.07.34',NULL,'55 route d''ifs','','','14370','MOULT',NULL,NULL,'2480114234001',193.000000000,'1969-09-19','GOLD',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1498,'SUZANNE','MICHEL','1959-01-06','02.29.84.67.78','06.32.32.17.45',NULL,'42 RUE DU CHANT DES OISEAUX','','','14400','BAYEUX',NULL,NULL,'2590114258001',52.000000000,'1981-11-14','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1499,'GUERIN','NICOLE','1963-04-03','02.89.94.82.97','06.12.04.29.71',NULL,'32 RUE DE BRUXELLES','','','14630','CAGNY',NULL,NULL,'2630414257001',24.000000000,'1993-09-23','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1500,'LOREL','THERESE','1928-01-10','02.47.11.41.15','06.85.23.01.88',NULL,'12 CHEMIN DES POISSONNIERS','','','14170','ST PIERRE SUR DIVES',NULL,NULL,'1280178360001',388.000000000,'1949-06-19','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1501,'EVRARD','JEAN','1963-05-03','02.69.02.75.54','06.16.16.68.85',NULL,'2 rue des balcons','','','14730','GIBERVILLE',NULL,NULL,'1630508480001',1006.000000000,'1992-04-08','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1502,'NIRO','JACQUELINE','1964-05-18','02.58.76.74.38',NULL,NULL,'3 RUE ALBERT BAYET','','','14000','CAEN',NULL,NULL,'2640550181001',69.000000000,'1994-07-05','PREMIUM',12,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1503,'BOURLIER','PAULETTE','1936-06-27','02.54.20.30.82','06.25.02.10.17',NULL,'HAMEAU DE JACOB MESNIL','','','14840','DEMOUVILLE',NULL,NULL,'2360653230001',192.000000000,'1960-08-20','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1504,'MARION','PIERRE','1945-06-03','02.63.41.12.91','06.48.51.78.93',NULL,'7 IMPASSE DES PENSEES','','','14112','BIEVILLE BEUVILLE',NULL,NULL,'2450661505001',64.000000000,'1969-11-26','GOLD',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1505,'BRETONNIER','jacques','1929-01-06','02.71.66.82.03','06.16.71.73.45',NULL,'LE BOURG','','','14123','IFS',NULL,NULL,'1290127006001',753.000000000,'1951-11-26','PREMIUM',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1506,'PERRIN','MICHEL','1930-06-25','02.28.24.42.86','06.51.28.88.01',NULL,'145 RESIDENCE DES TAMARIS','','','50460','QUERQUEVILLE',NULL,NULL,'1300614602001',42.000000000,'1954-05-04','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1507,'ROSIER','YVES','1933-03-24','02.23.70.64.90','06.14.67.19.19',NULL,'ROUTE D''ORBEC','','','14200','HEROUVILLE ST CLAIR',NULL,NULL,'1330314716001',228.000000000,'1962-11-21','GOLD',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1508,'HEURTEBISE','GUY','1962-02-10','02.75.69.05.29','06.35.09.21.80',NULL,'801 QUARTIER DU VAL','','','14400','BAYEUX',NULL,NULL,'2620214248001',4164.000000000,'1988-08-25','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1509,'GUERARD','SOLANGE','1960-02-25','02.63.67.60.87','06.79.98.67.71',NULL,'LOT LES BELEMNITES','','','14123','IFS',NULL,NULL,'1600272323001',29.000000000,'1986-05-09','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1510,'DANJOU','RICHARD','1932-04-01','02.11.77.02.74',NULL,NULL,'64 RUE DE CONDE','','','14000','CAEN',NULL,NULL,'1320450170001',402.000000000,'1955-05-09','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1511,'GAUDIN','armelle','1934-02-17','02.47.64.60.51','06.81.18.41.38',NULL,'19 rue du bois','','','14120','MONDEVILLE',NULL,NULL,'2340261094001',5.000000000,'1958-10-24','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1512,'TORCHIO','charles','1944-04-20','02.33.75.70.14','06.33.45.12.94',NULL,'1 RUE VILAINE','','','61160','MONTABARD',NULL,NULL,'1440431457001',537.000000000,'1974-07-16','GOLD',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1513,'GAYET','Joseph','1935-10-24','02.64.08.21.00','06.16.78.11.77',NULL,'6 RUE DU PETIT BONHEUR','','','14000','CAEN',NULL,NULL,'2351014157001',961.000000000,'1962-10-21','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1514,'EVRARD','JACQUELINE','1942-04-26','02.12.03.70.87','06.80.69.69.50',NULL,'les epinettes','','','14100','LISIEUX',NULL,NULL,'2420462702001',60.000000000,'1965-07-18','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1515,'MARTIN','YVETTE','1937-10-13','02.98.81.38.06','06.68.56.96.02',NULL,'5 VILLAGE LA ROCQUE','','','14000','CAEN',NULL,NULL,'2371014408001',315.000000000,'1967-01-13','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1516,'HARACHE','GEORGETTE','1939-01-10','02.32.97.99.56','06.79.24.38.68',NULL,'8 RUE DR BOUTROIS','','','50580','ST REMY DES LANDES',NULL,NULL,'1390114452001',102.000000000,'1963-12-23','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1517,'BUNEL','BERNARD','1932-06-20','02.11.71.85.80','06.31.94.39.41',NULL,'8 RUE DU DR BOUTROIS','','','14380','LANDELLES ET COUPIGNY',NULL,NULL,'2320614118001',7.000000000,'1962-07-02','GOLD',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1518,'HUCHET','REMI','1934-10-19','02.26.93.43.18','06.92.08.22.35',NULL,'14 BIS RUE DE BRAS','','','14440','DOUVRES LA DELIVRANDE',NULL,NULL,'1341035025001',1496.000000000,'1956-01-02','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1519,'LEQUESNE','PIERRE','1934-08-22','02.38.03.14.73','06.31.81.19.69',NULL,'12 rue marechal foch','','',NULL,NULL,NULL,NULL,'2340850110001',133.000000000,'1958-03-06','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1520,'LOPEZ','','1936-08-18','02.95.98.06.21','06.63.72.99.38',NULL,'','','','14000','CAEN',NULL,NULL,'2360814100001',557.000000000,'1960-07-10','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1521,'ASSELINE','MARTINE','1937-01-05','02.30.83.77.97','06.86.42.89.48',NULL,'','','','14120','MONDEVILLE',NULL,NULL,'1370114733001',257.000000000,'1960-05-21','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1522,'BOULENT','SERGE','1936-12-09','02.35.92.13.26','06.20.41.54.57',NULL,'11 RESIDENCE JEAN RACINE','','','14540','SOLIERS',NULL,NULL,'1361214221001',37.000000000,'1958-06-19','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1523,'GRANGERE','DIDIER','1934-08-05','02.83.64.59.44','06.10.66.44.54',NULL,'LIEU DIT"RATPRUNE"','','','14530','LUC SUR MER',NULL,NULL,'2340814301001',24.000000000,'1955-02-14','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1524,'HEBERT','DANIELLE','1944-05-14','02.17.71.72.05','06.50.41.73.06',NULL,'ouffieres','','','14370','MOULT',NULL,NULL,'1440577311001',23.000000000,'1966-02-05','GOLD',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1525,'QUEUDEVILLE LE BOEUF','MADELEINE','1937-05-23','02.10.32.24.23','06.88.98.25.07',NULL,'17 allee laperouse','','','14680','BRETTEVILLE SUR LAIZE',NULL,NULL,'2370514720001',299.000000000,'1963-09-28','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1526,'ENAULT','JULES','1944-03-02','02.27.61.51.19','06.55.38.47.69',NULL,'3 RUE DES MINEURS','','','61500','CHAILLOUE',NULL,NULL,'1440314063001',164.000000000,'1965-10-29','GOLD',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1527,'HELIE','HENRI','1945-03-27','02.12.30.63.50','06.50.65.58.62',NULL,'18 rue hinbaut','','','61200','ARGENTAN',NULL,NULL,'2450314172001',167.000000000,'1973-08-25','GOLD',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1528,'JAMME','GEORGES','1932-08-16','02.10.79.08.69','06.11.25.96.10',NULL,'7 PLACE CLAUDE DEBUSSY','','','14000','CAEN',NULL,NULL,'1320886120001',39.000000000,'1956-08-16','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1529,'JACQUELINE','GASTON','1936-02-22','02.42.14.59.45','06.18.52.15.28',NULL,'1 RUE DES JONQUILLES','','','14240','CAUMONT L''EVENTE',NULL,NULL,'1360214114001',704.000000000,'1959-08-07','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1530,'LESOMPTIER','EVELYNE','1942-01-06','02.42.15.81.71','06.55.11.09.68',NULL,'11 RUE DU 8 JUIN','','','61200','UROU ET CRENNES',NULL,NULL,'2420114266001',1930.000000000,'1967-05-31','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1531,'GARNIER','FRANCOIS','1950-10-09',NULL,NULL,NULL,'15 RUE DU CLOS NEUF','','','14000','CAEN',NULL,NULL,'1501014018001',18.000000000,'1978-06-09','PREMIUM',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1532,'LUNEL','MARIE-THERESE','1930-11-10','02.90.03.05.94','06.28.59.46.14',NULL,'2 rue du rservoire','','','14600','HONFLEUR',NULL,NULL,'2301114012001',2.000000000,'1958-04-06','PREMIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1533,'BERTRAND','CLAUDE','1940-05-11','02.19.24.76.70','06.81.51.67.57',NULL,'25 CHEMIN DES VIGNES','','','14370','MOULT',NULL,NULL,'2400514603001',329.000000000,'1963-10-06','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1534,'PERRIN','VIVIANE','1965-01-26','02.82.34.26.01','06.27.88.38.11',NULL,'5 rue eustache pilon','','','14330','LE MOLAY LITTRY',NULL,NULL,'1650114471001',297.000000000,'1989-10-16','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1535,'LEMAINE','YVETTE','1949-01-31','02.71.41.77.63','06.10.50.89.22',NULL,'9 RUE DES COSTILS','','','14120','MONDEVILLE',NULL,NULL,'2490114060001',303.000000000,'1977-10-03','PREMIUM',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1536,'GOUWY','JEAN MARIE','1942-04-02','02.69.99.41.76','06.82.69.67.32',NULL,'2 BIS RUE PRESSENCE','','','14000','CAEN',NULL,NULL,'2420427074001',162.000000000,'1965-08-28','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1537,'CARIOT','GERARD','1931-09-13','02.11.41.10.33','06.27.31.35.91',NULL,'le chateau','','','14370','MOULT',NULL,NULL,'1310914370001',1550.000000000,'1953-12-08','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1538,'LAVENU','JEAN CLAUDE','1936-02-02','02.15.84.06.21','06.30.45.69.99',NULL,'7 RUE DU ROND POINT','','','14210','MAIZET',NULL,NULL,'1360214103001',88.000000000,'1958-10-27','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1539,'ROUSSELET','LUCIENNE','1969-10-02','02.10.26.37.35','06.25.70.91.30',NULL,'29 RUE EMILE MOUGINS','','','61410','COUTERNE',NULL,NULL,'2691014566001',2643.000000000,'1992-01-27','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1540,'PIQUOT','JACQUELINE','1954-01-22','02.99.16.20.79','06.55.86.51.00',NULL,'LA GROSDAIE','','','14370','BELLENGREVILLE',NULL,NULL,'2540161314001',731.000000000,'1984-06-09','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1541,'BESSELIEVRE','MIREILLE','1936-01-13','02.81.28.80.82','06.10.08.30.46',NULL,'8 RUE DU PIN','','','14540','SOLIERS',NULL,NULL,'2360149038001',1957.000000000,'1966-11-07','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1542,'LECLERC','JEAN-LOUIS','1940-01-06','02.49.67.69.97','06.81.35.26.21',NULL,'62 ROUTE DE GOUVIX','','','14000','CAEN',NULL,NULL,'2400161431001',66.000000000,'1968-06-17','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1543,'LEPOITTEVIN','JEAN LOUIS','1959-04-26','02.75.57.27.97','06.14.12.77.82',NULL,'15 rue marie curie','','','14540','SOLIERS',NULL,NULL,'2590414396001',21.000000000,'1982-06-01','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1544,'DUFOUR','ELISE','1934-04-11','02.95.15.42.92','06.11.30.60.73',NULL,'18 rue nicolas copernic','','',NULL,NULL,NULL,NULL,'2340414510001',54.000000000,'1962-06-27','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1545,'DUCLOS','YVONNE','1939-09-22','02.41.86.20.36','06.59.60.00.83',NULL,'LE HAMEL','','','14540','GRENTHEVILLE',NULL,NULL,'2390914543001',131.000000000,'1962-06-26','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1546,'DUCLOS','DIDIER','1952-04-09','02.96.03.91.72','06.72.83.52.81',NULL,'1 RUE DE L''OCEAN','','','14670','TROARN',NULL,NULL,'2520461474001',61.000000000,'1982-04-28','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1547,'FLEURENCE','MAURICETTE','1939-05-21','02.60.76.77.64','06.68.38.59.72',NULL,'8 RUE COLOMBELLES','','','14000','CAEN',NULL,NULL,'1390514411001',1818.000000000,'1962-04-15','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1548,'BAJARD','MADELEINE','1918-02-16','02.34.65.06.46','06.74.14.55.77',NULL,'53 rue du conte','','','14730','GIBERVILLE',NULL,NULL,'1180273085001',61.000000000,'1940-06-01','GOLD',23,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1549,'MARIENNE','BERNARD','1930-08-17','02.41.19.02.32','06.90.31.19.57',NULL,'5 RUE DES EQUIPES D''URGENCE','','','14340','ST LOUP DE FRIBOIS',NULL,NULL,'2300850406001',9.000000000,'1958-02-20','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1550,'BUNEL','RAYMOND','1931-10-30','02.11.61.05.80','06.15.38.04.88',NULL,'47 RUE ALFRED DE MUSSET','','','14000','CAEN',NULL,NULL,'2311061349001',368.000000000,'1960-04-12','PREMIUM',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1551,'ZIMMERMANN','LUCETTE','1939-10-09','02.52.92.91.22','06.58.70.35.02',NULL,'6 RUE BOUAKE','','','14760','BRETTEVILLE SUR ODON',NULL,NULL,'2391014150001',1047.000000000,'1961-01-13','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1552,'LEPETIT','ANNIE GHISLAINE','1956-04-21','02.29.30.52.48','06.25.26.02.86',NULL,'AVENUE DE LA PLAGE','','','14130','BLANGY LE CHATEAU',NULL,NULL,'2560414640001',65.000000000,'1980-07-07','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1553,'POULAIN','GEORGES','1929-09-10','02.30.45.87.49','06.94.06.27.16',NULL,'29 RUE DU FOURCHI','','','14460','COLOMBELLES',NULL,NULL,'1290961472001',35.000000000,'1951-03-22','PLATINIUM',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1554,'BRUNET','ALAIN',NULL,'02.60.98.92.91','06.17.34.35.00',NULL,'24 RUE DU CERISIER','','','14220','FRESNEY LE VIEUX',NULL,NULL,'2400950181001',383.000000000,'2011-06-06','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1555,'BEROT','ANTOINE','1936-08-08','02.11.18.72.44','06.95.35.80.52',NULL,'','','','14370','ARGENCES',NULL,NULL,'1360850052001',326.000000000,'1957-12-19','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1556,'ACHER','MICHEL','1938-07-01','02.77.25.76.42','06.34.06.82.60',NULL,'chemin du basfond','','','14440','DOUVRES LA DELIVRANDE',NULL,NULL,'2380714271001',49.000000000,'1961-10-16','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1557,'MARIE','MICHELLE','1932-03-02','02.68.00.11.20','06.12.02.75.66',NULL,'91 AV CHARLEMAGNE','','','14230','ISIGNY SUR MER',NULL,NULL,'1320314140001',13.000000000,'1961-09-24','PREMIUM',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1558,'MARIE','CHRISTIANE','1939-05-01','02.47.73.47.52','06.29.73.06.86',NULL,'15 RUE APOLLON 11','','','14111','LOUVIGNY',NULL,NULL,'1390514302001',1793.000000000,'1962-12-24','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1559,'DOGUET','RAYMONDE','1938-02-11','02.52.60.57.69','06.53.20.83.37',NULL,'31 RUE DE LA GARE','','','61400','ST LANGIS LES MORTAGNE',NULL,NULL,'2380214121001',28.000000000,'1967-09-30','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1560,'AUVRAY','GINETTE','1930-11-06','02.98.25.08.87','06.36.48.35.95',NULL,'','','','14740','LASSON',NULL,NULL,'1301161167001',853.000000000,'1954-05-06','PLATINIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1561,'MICHEL','ANDRE','1936-03-04','02.18.43.42.57','06.52.37.74.99',NULL,'38 rue principale','','','14123','CORMELLES LE ROYAL',NULL,NULL,'1360314666001',647.000000000,'1961-10-30','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1562,'NEUVILLE','DANIEL','1935-02-26','02.15.73.79.64','06.39.09.99.81',NULL,'7 RUE DE L''AVENIR','','','14400','BAYEUX',NULL,NULL,'1350214659001',402.000000000,'1960-06-30','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1563,'MARIE','GAEL','1935-12-28','02.10.43.63.91','06.22.60.15.40',NULL,'ferme du lieu d agneau','','','14000','CAEN',NULL,NULL,'2351214298001',61.000000000,'1961-02-06','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1564,'MORISSET','MARTIAL','1929-06-14','02.63.85.58.54','06.30.91.09.44',NULL,'LIEU ST GERMAIN','','','14000','CAEN',NULL,NULL,'2290614677001',3346.000000000,'1950-10-13','PREMIUM',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1565,'MADELINE','RENE','1935-11-22','02.18.53.20.91','06.83.55.33.08',NULL,'5 RUE DAMOZANNE','','','14111','LOUVIGNY',NULL,NULL,'2351114005001',277.000000000,'1960-06-14','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1566,'VIVIEN','JACQUES','1962-05-05','02.26.15.94.25','06.70.50.06.10',NULL,'6 rue du luxembourg','','','14000','CAEN',NULL,NULL,'2620527192001',1374.000000000,'1992-01-24','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1567,'LETOUZEY','','1938-03-09','02.84.11.22.17','06.12.38.18.24',NULL,'5 rue des marches','','','61570','MORTREE',NULL,NULL,'1380350356001',34.000000000,'1967-01-17','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1568,'PERRINE','NICOLAS','1962-01-18','02.34.36.47.72','06.71.29.91.60',NULL,'86 bis rue de brancille','','','14240','CAHAGNES',NULL,NULL,'1620114692001',510.000000000,'1992-05-04','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1569,'DUBREUIL','BERNARD','1934-01-16','02.88.01.79.59','06.28.62.39.12',NULL,'48 rue du paty','','','14540','SOLIERS',NULL,NULL,'1340114449001',211.000000000,'1955-12-26','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1570,'LEJEUNE','CLAUDINE','1935-10-22','02.31.85.28.42','06.45.63.26.25',NULL,'60 rue des acassias','','','14000','CAEN',NULL,NULL,'2351014570001',177.000000000,'1958-02-24','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1571,'LORAULT','CLAUDINE','1938-11-30','02.61.06.37.04','06.52.39.58.71',NULL,'3 RUE DU 9 JUILLET','','','14111','LOUVIGNY',NULL,NULL,'1381114321001',23.000000000,'1961-07-01','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1572,'HEBERT','ODETTE','1940-07-10','02.10.13.95.59','06.84.25.68.63',NULL,'place de la mairie','','',NULL,NULL,NULL,NULL,'1400714076001',37.000000000,'1966-04-14','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1573,'GROULT','CATHERINE','1931-06-24','02.44.73.02.43','06.11.55.03.63',NULL,'','','','14670','ST PAIR',NULL,NULL,'1310676754001',1239.000000000,'1961-03-04','GOLD',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1574,'LALISSE','JEANNINE','1930-07-08','02.20.77.18.66','06.13.60.20.19',NULL,'12RUE GEORGES FRANCOIS','','','14210','AMAYE SUR ORNE',NULL,NULL,'2300714158001',75.000000000,'1952-01-22','PREMIUM',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1575,'DODEMAN','NICOLE','1966-06-16','02.60.59.39.95','06.71.25.43.62',NULL,'4 de la dive','','','14112','BIEVILLE BEUVILLE',NULL,NULL,'1660614288001',818.000000000,'1996-11-06','PREMIUM',12,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1576,'HUGUET','JEAN','1942-01-25','02.26.82.43.85','06.12.02.59.09',NULL,'6 Chemin du Home','','','14370','MOULT',NULL,NULL,'2420114063001',50.000000000,'1963-02-02','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1577,'CHESNE','ALINE','1932-09-26','02.50.73.79.41','06.26.21.04.94',NULL,'12 RUE DE VASSY','','','14740','ST MANVIEU NORREY',NULL,NULL,'1320936046001',2967.000000000,'1955-08-27','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1578,'RICHER','GILBERT','1959-01-15','02.81.62.91.13','06.67.90.65.44',NULL,'16 RUE LOUIS LACHENAL','','','14860','BAVENT',NULL,NULL,'1590127367001',43.000000000,'1980-08-10','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1579,'VAN LAEYS','DENIS','1961-04-10','02.16.86.76.25','06.10.20.29.98',NULL,'LA CATHIOLE RD 513','','','14150','OUISTREHAM',NULL,NULL,'1610414145001',13.000000000,'1987-08-15','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1580,'LEPLANQUOIS','Marie francoise','1937-09-14','02.52.43.32.05','06.29.09.72.22',NULL,'26 RUE DANIEL DANJON','','','14630','CAGNY',NULL,NULL,'1370914268001',136.000000000,'1965-02-22','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1581,'HAREL','ANDRE','1933-04-26','02.97.76.16.16','06.12.12.60.23',NULL,'7 RUE DU CALVAIRE','','','14700','FALAISE',NULL,NULL,'1330450257001',1521.000000000,'1956-06-24','PREMIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1582,'REVERT','THERESE','1932-08-30','02.15.58.72.56','06.25.82.75.25',NULL,'43 rue de lisbonne','','','14630','CAGNY',NULL,NULL,'1320886120001',632.000000000,'1957-07-10','PREMIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1583,'BEN MERZOUG','PATRICIA','1937-12-15','02.73.41.12.72','06.83.87.71.74',NULL,'2 rue marechal joffre','','','14460','COLOMBELLES',NULL,NULL,'1371214506001',27.000000000,'1966-01-31','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1584,'BEN MERZOUG','NATHALIE','1934-08-29','02.51.46.34.47','06.19.46.41.76',NULL,'44 rue maurice fouques','','','14370','MOULT',NULL,NULL,'2340814677001',589.000000000,'1957-11-06','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1585,'ALEXANDRE','MARGUERITE','1936-03-28','02.55.08.87.07','06.56.94.58.48',NULL,'44 rue maurice fouques','','','14810','MERVILLE FRANCEVILLE PLAGE',NULL,NULL,'2360350583001',64.000000000,'1958-08-24','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1586,'MAUGER','MARCEL','1969-11-07','02.61.30.94.38','06.34.14.13.36',NULL,'','','','14790','VERSON',NULL,NULL,'1691199256001',458.000000000,'1993-12-04','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1587,'','ROGER','1947-01-08','02.29.89.78.98','06.44.51.19.64',NULL,'216 RUE DU CHEMIN VERT','','','14940','SANNERVILLE',NULL,NULL,'1470175114001',3349.000000000,'1970-09-11','GOLD',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1588,'RENIER','HENRIETTE','1976-06-05','02.30.37.17.40','06.33.62.25.59',NULL,'8 RUE DU CALVAIRE','','','14111','LOUVIGNY',NULL,NULL,'2760699238001',42.000000000,'1999-02-19','PREMIUM',11,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1589,'ACHARD','JEAN CLAUD','1960-05-31','02.77.87.54.88','06.63.60.72.44',NULL,'rue juno residence la chenaie','','','14400','BAYEUX',NULL,NULL,'1600599352001',12.000000000,'1981-05-03','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1590,'CASTEL','PASCAL','1937-07-10','02.12.06.51.03','06.43.98.73.65',NULL,'3 RUE LEO DELIBES','','','14130','PONT L''EVEQUE',NULL,NULL,'1370714325001',57.000000000,'1958-02-17','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1591,'GUIBOUT','REGINE','1928-09-30','02.65.16.35.85','06.89.64.33.26',NULL,'5 RUE DU LUCET','','','14123','FLEURY SUR ORNE',NULL,NULL,'1280927485001',2.000000000,'1950-05-11','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1592,'LE GUERN','MARCEL','1928-09-21','02.63.01.63.08','06.71.07.54.95',NULL,'LE BOURG','','',NULL,NULL,NULL,NULL,'1280914409001',1.000000000,'1949-05-26','PLATINIUM',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1593,'LE ROUZES','STEPHANIE','1938-04-19','02.39.73.98.01','06.75.22.40.14',NULL,'7 ALLEE WINNIPEG','','','14370','BELLENGREVILLE',NULL,NULL,'1380414348001',84.000000000,'1959-04-22','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1594,'SONNET','Therese','1913-04-15','02.60.21.40.05','06.91.56.47.78',NULL,'1 allee louis edouard garrido','','',NULL,NULL,NULL,NULL,'2130465025001',41.000000000,'1943-09-08','GOLD',23,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1595,'VALLEREND','JEAN PIERRE','1938-07-22','02.83.13.60.19','06.79.00.23.06',NULL,'29 RUE DU PARC','','','50300','AVRANCHES',NULL,NULL,'1380750570001',3457.000000000,'1964-07-09','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1596,'CUSSY','GERARD','1959-02-09','02.63.40.03.92','06.81.69.39.96',NULL,'53 bd de retel','','',NULL,NULL,NULL,NULL,'1590214544001',2385.000000000,'1988-06-29','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1597,'LETONDEUR','FERNANDE','1936-07-25','02.73.45.68.18','06.98.47.27.87',NULL,'111 RUE DES RELIGIEUSES','','','14540','SOLIERS',NULL,NULL,'1360714437001',29.000000000,'1960-04-17','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1598,'BISSON','MAURICE','1931-03-04','02.35.09.73.44','06.56.53.12.40',NULL,'21 rue de la cavee','','','14320','ST MARTIN DE FONTENAY',NULL,NULL,'2310314760001',539.000000000,'1952-02-28','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1599,'LETELLIER','FRANCINE','1935-06-21','02.32.08.80.67','06.82.39.26.85',NULL,'hameau du puis','','','14123','IFS',NULL,NULL,'2350614218001',506.000000000,'1960-01-23','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1600,'DEMONT','MICHEL','1934-02-10','02.38.61.26.91','06.78.09.36.02',NULL,'CHEMIN DU MANOIR','','','14730','GIBERVILLE',NULL,NULL,'1340214553001',233.000000000,'1962-09-26','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1601,'DESETABLE','THIERRY','1962-01-10','02.67.15.52.03','06.58.02.43.41',NULL,'LE BOURG','','','14000','CAEN',NULL,NULL,'1620114020001',22.000000000,'1983-02-19','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1602,'SAMSON','GUY','1934-05-16','02.67.32.23.66','06.51.51.81.71',NULL,'fromentel','','','14000','CAEN',NULL,NULL,'2340514508001',139.000000000,'1956-10-11','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1603,'','HUGUETTE','1940-12-08','02.19.09.96.92','06.69.67.96.07',NULL,'16 ruest andre','','','14320','ST ANDRE SUR ORNE',NULL,NULL,'1401214456001',68.000000000,'1965-03-06','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1604,'BRIZARD','DENISE','1939-04-11','02.77.15.68.79','06.29.33.07.36',NULL,'2 BIS RUE DE PRESSENCE','','','14000','CAEN',NULL,NULL,'1390450198001',68.000000000,'1962-12-18','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1605,'LEBRETON','SUZANNE','1967-04-15','02.17.65.29.72','06.68.68.59.82',NULL,'3 rue de la plaine','','','14120','MONDEVILLE',NULL,NULL,'2670414356001',51.000000000,'1992-06-10','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1606,'PILON','CHARLOTTE',NULL,'02.73.50.37.62','06.55.14.45.63',NULL,'6 village lallemand','','','14320','FEUGUEROLLES BULLY',NULL,NULL,'2390550554001',743.000000000,'2009-09-05','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1607,'LEPRAT','HELENE','1940-09-30','02.88.90.44.85','06.79.28.01.33',NULL,'15 ROUTE DE CAMBRAI','','','61570','MORTREE',NULL,NULL,'2400914117001',15.000000000,'1963-09-04','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1608,'DENOUETTE','JEAN-FRANCOIS','1930-11-05','02.83.84.59.13','06.23.24.26.47',NULL,'16 CHEMIN DU SOL ROC','','','14000','CAEN',NULL,NULL,'1301161387001',69.000000000,'1952-08-06','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1609,'DENOUETTE','MADELEINE','1939-07-02','02.57.58.79.37','06.52.81.98.56',NULL,'2 BIS DE LA COOPERATIVE','','','14540','ROCQUANCOURT',NULL,NULL,'2390714566001',38.000000000,'1960-02-19','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1610,'LETURCQ','LILIANE','1940-09-10','02.85.18.15.55','06.19.68.96.89',NULL,'3 RUE DES LAURIERS','','','14430','GOUSTRANVILLE',NULL,NULL,'1400914391001',3742.000000000,'1963-11-09','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1611,'FLOCH','FRANCINE','1938-08-12','02.48.11.33.14','06.30.22.99.28',NULL,'20 RUE LUCIEN MANGEMATIN','','','14540','ST AIGNAN DE CRAMESNIL',NULL,NULL,'1380814357001',161.000000000,'1968-09-30','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1612,'HIS','HENRIETTE','1936-02-12','02.11.00.26.99','06.34.71.54.95',NULL,'2 RESIDENCE DU CHARDONNERET','','','50680','ST CLAIR SUR L''ELLE',NULL,NULL,'2360214606001',295.000000000,'1966-02-20','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1613,'BROSSARD','BERNARD','1937-02-10','02.87.86.02.67','06.76.81.16.31',NULL,'LA HOUARDIERE','','','14100','LISIEUX',NULL,NULL,'1370227251001',28.000000000,'1960-09-21','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1614,'HENRY','LUCIEN','1920-07-27','02.42.53.39.24','06.70.39.12.53',NULL,'la pilliere','','','14190','URVILLE',NULL,NULL,'1200744184001',96.000000000,'1943-10-02','GOLD',23,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1615,'THOMAS','BERNARD','1935-09-20','02.83.04.00.76','06.24.10.69.49',NULL,'75 RUE DU CENTRE','','','14330','LE MOLAY LITTRY',NULL,NULL,'1350914119001',1883.000000000,'1963-09-09','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1616,'DELILLE','MARIE','1942-06-21','02.81.07.11.77','06.68.97.30.18',NULL,'le pillieres','','','14640','VILLERS SUR MER',NULL,NULL,'1420614458001',28.000000000,'1971-06-03','SILVER',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1617,'PONTES','ANDREE','1931-02-03','02.14.66.19.96','06.50.91.67.88',NULL,'12 rue arsene richard','','','50250','LITHAIRE',NULL,NULL,'1310214734001',772.000000000,'1960-01-28','PREMIUM',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1618,'DURAND','CHARLOTTE','1928-04-24','02.48.15.68.21','06.58.34.91.26',NULL,'19 rue goujarde','','','61100','FLERS',NULL,NULL,'1280461370001',87.000000000,'1952-01-26','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1619,'SONNET','SOLANGE','1935-05-11','02.45.08.67.82','06.57.20.36.49',NULL,'3 res du beau site','','','14000','CAEN',NULL,NULL,'1350553183001',39.000000000,'1964-02-07','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1620,'FOUQUES','MAURICE','1949-02-07','02.71.07.90.74',NULL,NULL,'154 rue de falaise','','','14000','CAEN',NULL,NULL,'1490214530001',41.000000000,'1974-11-03','PREMIUM',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1621,'MADELEINE','HENRIETTE','1932-05-27','02.32.62.35.46','06.48.28.79.86',NULL,'14 RUE FRANCOIS MITTERRAND','','','14123','IFS',NULL,NULL,'1320514509001',34.000000000,'1956-04-25','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1622,'FAINS','SYLVIE','1934-06-06','02.80.00.84.02','06.64.09.00.07',NULL,'HAMEAU DES ORMES','','','14000','CAEN',NULL,NULL,'2340614197001',102.000000000,'1957-11-12','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1623,'SUARD','GISELE','1935-09-02','02.61.74.40.88',NULL,NULL,'2 RUE DES AUNES','','','14630','CAGNY',NULL,NULL,'1350950377001',162.000000000,'1956-04-06','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1624,'THOMAS','GUY','1949-01-28','02.59.84.03.91','06.86.67.77.64',NULL,'coupigny','','','14310','MONTS EN BESSIN',NULL,NULL,'2490144200001',4944.000000000,'1975-04-05','PREMIUM',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1625,'ACHARD DE LELUARDIERE','THIERRY','1967-04-19','02.94.27.83.00','06.38.63.51.54',NULL,'3 ALL2E DES POETES','','','14120','MONDEVILLE',NULL,NULL,'2670414356001',313.000000000,'1990-07-14','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1626,'DEVIC','DENIS','1965-06-21','02.51.05.19.80','06.72.81.48.51',NULL,'1 rue des hameaux','','','14270','MAGNY LA CAMPAGNE',NULL,NULL,'1650614044001',72.000000000,'1988-03-14','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1627,'MARVIN','LUCIENNE','1982-03-03','02.44.19.15.72','06.98.92.32.11',NULL,'8 rue alfred nobel','','','14150','OUISTREHAM',NULL,NULL,'2820399234001',21.000000000,'2010-03-25','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1628,'GUERIN','didier','1944-03-25','02.12.25.99.02','06.42.31.19.48',NULL,'86 bis rue basse','','','14000','CAEN',NULL,NULL,'1440314150001',363.000000000,'1973-03-01','GOLD',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1629,'HECTOR','FERNAND','1964-02-27','02.90.07.17.19','06.78.92.43.93',NULL,'LA CORBELLIERE','','','14000','CAEN',NULL,NULL,'2640214658001',177.000000000,'1994-03-21','PREMIUM',12,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1630,'MOREL','ANDRE','1959-09-03','02.91.17.02.33','06.20.51.13.53',NULL,'8 IMPASSE DU MANOIR LE HAUT MESN','IL','','14860','RANVILLE',NULL,NULL,'1590914075001',282.000000000,'1980-06-06','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1631,'MORIN','MARGUERITE','1935-01-29','02.89.26.19.13','06.20.00.15.89',NULL,'7 ALLEE WINIPEG','','','14160','DIVES SUR MER',NULL,NULL,'1350114319001',732.000000000,'1957-07-13','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1632,'LIBOIS','MARY','1929-04-14','02.40.90.62.02','06.44.58.62.74',NULL,'LA RENARDIERE','','','14123','IFS',NULL,NULL,'2290450202001',865.000000000,'1952-05-21','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1633,'GOUBERT','ROGER','1961-03-27','02.61.88.32.99','06.81.31.89.13',NULL,'8 RUE DES CHARMILLES','','','14123','CORMELLES LE ROYAL',NULL,NULL,'1610314308001',2753.000000000,'1984-04-03','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1634,'VALLEE','YOLANDE','1952-02-05','02.60.28.27.17','06.78.41.86.60',NULL,'11 RUE DE BRETTEVILLE','','','61700','DOMFRONT',NULL,NULL,'1520214090001',1305.000000000,'1978-11-26','PREMIUM',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1635,'SIMON','BERNARD','1932-02-02','02.58.47.14.89','06.55.03.65.72',NULL,'15 PLACE DE LA DEMIE LUNE','','','14680','BRETTEVILLE SUR LAIZE',NULL,NULL,'1320214325001',377.000000000,'1954-11-16','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1636,'BOUTELOUP','GUY','1934-01-27','02.30.60.87.52','06.92.00.02.45',NULL,'LA RUE D''AVE','','','14540','SOLIERS',NULL,NULL,'2340129184001',72.000000000,'1955-04-30','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1637,'MICLOT','JACQUELINE','1967-11-12','02.75.33.89.40','06.40.14.32.29',NULL,'7 RUE DU BISSONNET','','','14220','GRIMBOSQ',NULL,NULL,'2671114118001',30.000000000,'1990-02-12','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1638,'LAVENANT','DENIS','1934-09-30','02.83.39.30.26','06.63.93.89.40',NULL,'25 rue du blanc','','','14210','PREAUX BOCAGE',NULL,NULL,'2340914315001',93.000000000,'1958-07-10','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1639,'GOST','OLIVIER','1930-12-03','02.55.61.31.76','06.52.02.57.98',NULL,'37 RUE PASTEUR','','','14330','TOURNIERES',NULL,NULL,'1301214166001',205.000000000,'1960-10-01','GOLD',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1640,'SAMSON','PAULETTE','1959-02-13','02.31.17.50.41','06.78.25.94.96',NULL,'','','','14540','GARCELLES SECQUEVILLE',NULL,NULL,'1590214581001',122.000000000,'1981-11-18','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1641,'MERIENNE','ROLANDE','1932-02-12','02.82.83.36.54','06.26.13.54.63',NULL,'route nationale','','','14120','MONDEVILLE',NULL,NULL,'1320214039001',50.000000000,'1955-07-23','PREMIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1642,'MAISERET','MARIE THERESE','1935-01-09','02.83.31.58.91','06.41.06.40.76',NULL,'33 RUE D''AUTHIE','','','14120','MONDEVILLE',NULL,NULL,'1350114659001',63.000000000,'1959-05-05','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1643,'BENOIT','GINETTE','1929-07-12','02.62.08.22.78','06.41.66.46.98',NULL,'96 BD LYAUTEY','','','14120','MONDEVILLE',NULL,NULL,'2290714266001',41.000000000,'1951-11-15','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1644,'ANNE','FRANCIS','1935-12-09','02.47.42.91.97','06.42.61.96.92',NULL,'22 RUE DE LA GARE','','','14000','CAEN',NULL,NULL,'2351214506001',88.000000000,'1958-06-16','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1645,'GODDERIDGE','hubert','1941-02-09','02.96.85.18.82','06.58.32.63.78',NULL,'4 RUE RAYMOND COSSON','','','14000','CAEN',NULL,NULL,'1410227080001',421.000000000,'1971-05-23','SILVER',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1646,'BATON','GENEVIEVE','1954-01-05','02.98.51.62.28','06.78.68.73.00',NULL,'ANCIEN PRESBYSTERE','','','14370','MOULT',NULL,NULL,'1540161278001',92.000000000,'1978-05-13','PREMIUM',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1647,'BENOITS','pascal','1961-09-20','02.47.48.13.16','06.11.00.47.23',NULL,'CHEMIN DU VEY','','','14320','ST ANDRE SUR ORNE',NULL,NULL,'1610937071001',83.000000000,'1985-08-30','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1648,'CHARLES','DONATIENNE','1936-11-18','02.11.87.12.34','06.23.76.46.20',NULL,'13 AVENUE DE NORMANDIE','','','14370','ARGENCES',NULL,NULL,'2361150438001',14.000000000,'1959-04-06','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1649,'AILLET','ALBERT','1940-09-09','02.26.66.77.36','06.48.79.88.03',NULL,'5 impa fr cassard','','','32100','CONDOM',NULL,NULL,'1400950234001',1034.000000000,'1962-07-28','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1650,'LEVAVASSEUR','','1932-07-18','02.39.86.69.06','06.73.38.01.29',NULL,'GARE DE CROUAY','','','14220','FRESNEY LE VIEUX',NULL,NULL,'1320750581001',97.000000000,'1955-07-02','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1651,'DONNE','BERNARD','1933-09-27','02.82.22.31.89','06.60.71.26.51',NULL,'LE BOURG','','','14220','BOULON',NULL,NULL,'1330914266001',591.000000000,'1956-04-17','PLATINIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1652,'DELIVET','JACQUELINE','1932-11-29','02.41.87.62.30','06.43.98.50.70',NULL,'27 RUE DE L''ARQUETTE','','','14100','GLOS',NULL,NULL,'2321150301001',545.000000000,'1960-09-08','PREMIUM',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1653,'HODIN','LOUIS','1930-09-18','02.16.86.52.62','06.16.03.96.61',NULL,'13 CLOS DU PAVILLON','','','14270','CESNY AUX VIGNES OUEZY',NULL,NULL,'1300914498001',1304.000000000,'1957-12-06','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1654,'MOREL','VALERIE','1940-02-07','02.28.66.94.90','06.85.54.83.59',NULL,'26 rue des talbotieres','','','14540','GRENTHEVILLE',NULL,NULL,'1400250173001',19.000000000,'1970-02-20','SILVER',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1655,'LARVOR','ETIENNE',NULL,'02.65.77.03.91','06.20.75.49.79',NULL,'13 village de l''eglise','','','14540','ROCQUANCOURT',NULL,NULL,'2800629232001',216.000000000,'2007-12-30','PREMIUM',10,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1656,'ALEXANDRE','ARLETTE','1932-10-15','02.74.91.83.98',NULL,NULL,'8 AVENUE MARC DU GARREAU','','','14000','CAEN',NULL,NULL,'1321035095001',3645.000000000,'1953-02-01','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1657,'FOUCHARD','HENRIETTE','1943-02-19','02.74.47.89.21',NULL,NULL,'CHEMIN DE LA TONNELLE','','','61160','MONT ORMEL',NULL,NULL,'2430261459001',41.000000000,'1965-02-19','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1658,'HARANG','GUY','1930-08-30','02.67.37.63.31','06.66.16.17.40',NULL,'','','','14000','CAEN',NULL,NULL,'2300814497001',21.000000000,'1951-04-05','PLATINIUM',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1659,'JUMEL','MICHEL','1943-01-09','02.23.22.84.37','06.79.25.16.26',NULL,'7 rue Edmond Raphal','','','14670','TROARN',NULL,NULL,'1430150032001',42.000000000,'1973-06-05','SILVER',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1660,'BEAUBIGNY','JEAN-CLAUDE','1935-11-22','02.52.22.94.25','06.17.63.79.01',NULL,'1 RUE DES MESANGES','','','14123','CORMELLES LE ROYAL',NULL,NULL,'1351161289001',80.000000000,'1960-03-07','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1661,'PARIS','RAYMOND','1969-05-16','02.87.53.65.26','06.48.37.26.73',NULL,'CHEMIN DE LA CROIX THOY','','','14210','TOURVILLE SUR ODON',NULL,NULL,'2690514271001',684.000000000,'1996-07-29','PREMIUM',12,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1662,'HARDY','WILLY','1960-01-24','02.84.11.55.73','06.63.72.82.39',NULL,'hameau la haye','','','14370','ARGENCES',NULL,NULL,'2600114520001',183.000000000,'1987-10-28','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1663,'LETALLEC','JACQUES','1967-04-15','02.57.07.98.06','06.15.55.06.58',NULL,'13 RUE VICTOR HUGO','','','14120','MONDEVILLE',NULL,NULL,'2670414356001',16.000000000,'1991-09-07','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1664,'DENIS','DANIEL','1930-10-20','02.80.11.63.37','06.19.77.18.08',NULL,'2 RUE THE DEVONSHIRE RT','','','14120','MONDEVILLE',NULL,NULL,'2301061070001',1337.000000000,'1954-07-06','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1665,'LUCAS','YVON','1949-01-04','02.11.51.94.40','06.28.64.16.41',NULL,'','','','14130','BLANGY LE CHATEAU',NULL,NULL,'1490150540001',173.000000000,'1970-10-21','PREMIUM',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1666,'GAUDRY','NICOLE','1947-01-21','02.49.20.37.12','06.73.44.91.87',NULL,'9 CHEMIN DE GARRAINE','','','14123','IFS',NULL,NULL,'1470127335001',1701.000000000,'1970-05-25','GOLD',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1667,'POREY','ODETTE','1927-11-30','02.10.30.97.28','06.65.49.31.59',NULL,'64 BOULEVARD LEROY','','','14000','CAEN',NULL,NULL,'1271133446001',23.000000000,'1948-09-15','GOLD',22,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1668,'BOURGES','daniel','1936-02-13','02.52.70.72.43','06.14.72.77.34',NULL,'2 RUE DES PENSEES','','','14370','BELLENGREVILLE',NULL,NULL,'2360214566001',58.000000000,'1966-06-08','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1669,'DALLIER','SOTHEAVY','1930-01-17','02.10.79.63.96','06.89.53.83.13',NULL,'25 RUE DU COTENTIN','','','14000','CAEN',NULL,NULL,'1300180352001',25.000000000,'1952-01-17','PREMIUM',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1670,'LEMOIGNE','JOELLE','1935-09-23','02.32.01.18.22','06.47.25.03.24',NULL,'14 ALLEE DES ARTS','','','14790','VERSON',NULL,NULL,'2350914055001',338.000000000,'1956-12-26','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1671,'FILOCHE','THERESE','1936-12-03','02.67.94.43.85','06.82.62.42.13',NULL,'LE BOULAY','','','14123','CORMELLES LE ROYAL',NULL,NULL,'2361250224001',185.000000000,'1965-06-15','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1672,'MALABOEUF-CARRE','ANNETTE','1946-01-24','02.86.33.54.00','06.18.68.88.85',NULL,'12 avenue de la liberation','','','14370','MOULT',NULL,NULL,'1460114158001',1996.000000000,'1974-04-01','GOLD',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1673,'COCHEREL','MADELEINE','1933-01-30','02.57.10.14.17','06.10.38.40.56',NULL,'50 AVENUE GUYNEMER','','','14000','CAEN',NULL,NULL,'1330161168001',65.000000000,'1958-02-20','PREMIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1674,'RAULT','GHISLAINE','1933-02-08','02.71.40.63.95','06.82.51.91.63',NULL,'LIEU DIT AUBIGNY','','','14460','COLOMBELLES',NULL,NULL,'2330214432001',38.000000000,'1960-10-27','GOLD',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1675,'MICHEL','MICHEL','1965-01-25','02.11.21.22.11','06.85.58.44.99',NULL,'3 rue louis robillard','','','14370','BELLENGREVILLE',NULL,NULL,'2650114005001',24.000000000,'1986-01-17','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1676,'VALLETTE','FRANCIS',NULL,'02.11.30.93.79','06.34.99.60.04',NULL,'62 avenue charlotte corday','','','14123','FLEURY SUR ORNE',NULL,NULL,'1310214301001',98.000000000,'2013-03-25','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1677,'KUEZMEROWIEZ','JEAN FRANCOIS','1928-09-07','02.86.49.53.31','06.10.46.29.17',NULL,'19 RUE FROIDE','','','50180','AGNEAUX',NULL,NULL,'2280914092001',1360.000000000,'1954-02-01','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1678,'BISSON','EDOUARD','1952-03-04','02.64.96.89.63','06.10.46.76.46',NULL,'18 BD ALSACE LORRAINE','','','14310','PARFOURU SUR ODON',NULL,NULL,'2520330235001',51.000000000,'1981-12-14','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1679,'LANGLINAY','PAULETTE','1932-10-26','02.85.90.65.88','06.24.72.54.23',NULL,'709 BLD DU GRAND PARC','','','14000','CAEN',NULL,NULL,'2321014581001',3748.000000000,'1954-05-31','PREMIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1680,'COTTRAIT','THIERRY','1965-04-07','02.78.19.56.91','06.28.36.53.92',NULL,'14 PLACE SAINT ANNE','','','14630','CAGNY',NULL,NULL,'2650414651001',763.000000000,'1987-12-08','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1681,'QUESNOT','MARIE',NULL,'02.70.97.75.63','06.62.74.19.00',NULL,'9 bd de l esperance','','','14970','BENOUVILLE',NULL,NULL,'1360214301001',20.000000000,'2012-12-10','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1682,'RIBAUD','VICTOR','1928-02-14','02.91.54.37.32','06.26.24.96.03',NULL,'LE DESERTIF','','','14550','BLAINVILLE SUR ORNE',NULL,NULL,'2280261069001',2588.000000000,'1952-01-07','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1683,'PETIT','JEANNE','1949-05-15','02.77.47.05.75','06.26.99.03.79',NULL,'16 RESIDENCE ST JACQUES','','','50190','GORGES',NULL,NULL,'1490561478001',486.000000000,'1971-08-10','PREMIUM',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1684,'FORET','MAURICE','1949-05-04','02.85.86.58.16','06.63.46.81.26',NULL,'4 RUE DES CHEVREFEUILLES','','','14390','CABOURG',NULL,NULL,'1490561478001',4.000000000,'1974-08-12','PREMIUM',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1685,'CHEMIN','ODETTE','1936-09-25','02.27.95.64.55','06.61.43.36.31',NULL,'171 RUE D''AUGE','','','14000','CAEN',NULL,NULL,'1360914098001',185.000000000,'1959-07-28','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1686,'LE BIGOT','THERESE','1959-11-26','02.11.00.21.83','06.32.08.24.17',NULL,'65 rue des roches','','','14123','IFS',NULL,NULL,'1591114729001',80.000000000,'1982-03-05','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1687,'GAZENGEL','JEANNINE','1932-05-20','02.78.57.77.22','06.98.32.29.24',NULL,'2 RUE DE LA MUANCE','','','14000','CAEN',NULL,NULL,'2320550052001',347.000000000,'1956-07-06','PREMIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1688,'LEFLAMBE','LAETITIA',NULL,'02.59.36.22.10','06.69.43.24.11',NULL,'6 RUE DE LA CLE DES CHAMPS','','','14123','FLEURY SUR ORNE',NULL,NULL,'2340114369001',75.000000000,'2009-08-13','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1689,'DUVAL','MARYLINE','1931-07-27','02.74.61.65.60',NULL,NULL,'11 RUE DU 11 NOVEMBRE','','','14000','CAEN',NULL,NULL,'2310714548001',125.000000000,'1956-11-27','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1690,'VAUTIER','JEAN','1969-11-29','02.48.43.69.04','06.11.04.65.37',NULL,'99 RUE DE LA DELIVRANDE','','','14320','FONTENAY LE MARMION',NULL,NULL,'2691114162001',466.000000000,'1992-07-09','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1691,'VARIN','DANIEL','1938-02-24','02.17.85.33.73','06.87.76.32.26',NULL,'10 PARVIS DE NOTRE DAME','','','14000','CAEN',NULL,NULL,'2380265059001',810.000000000,'1966-10-12','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1692,'NEEL','NOEL','1933-04-18','02.36.99.67.11','06.24.68.67.41',NULL,'LA MOISSONNIERE','','','14670','TROARN',NULL,NULL,'2330450406001',116.000000000,'1963-06-26','GOLD',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1693,'KERIMOV','YVONNE','1933-03-31','02.20.08.13.83','06.29.46.93.31',NULL,'15 impasse du peintre','','','14940','SANNERVILLE',NULL,NULL,'1330314305001',2.000000000,'1957-01-15','PREMIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1694,'PINEAU','THERESE','1930-02-09','02.57.78.13.71','06.91.24.46.73',NULL,'13 AVENUE DE NORMANDIE','','','14400','NONANT',NULL,NULL,'1300214186001',126.000000000,'1958-07-21','PREMIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1695,'BOUSSELET','JACQUES','1929-11-16','02.71.71.50.05','06.54.81.52.32',NULL,'6 CHEMIN DU PETIT PARC','','','50880','PONT HEBERT',NULL,NULL,'2291114740001',236.000000000,'1951-10-25','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1696,'LECONTE','DEMBA','1946-01-12','02.46.86.34.23','06.10.40.37.53',NULL,'4 rue jean francois millet','','','14270','MEZIDON CANON',NULL,NULL,'1460114375001',75.000000000,'1969-03-21','GOLD',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1697,'GUALBERT','DOMINIQUE','1934-07-01','02.48.76.53.37','06.77.86.15.67',NULL,'5 RUE D''ANJOU','','','14260','ST GEORGES D''AUNAY',NULL,NULL,'1340714619001',6.000000000,'1958-03-20','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1698,'DELAMOTTE','PATRICE','1936-07-12','02.13.17.08.79','06.65.68.24.31',NULL,'4 RUE DE LA COURTE DELLE','','','14123','CORMELLES LE ROYAL',NULL,NULL,'1360714430001',104.000000000,'1960-05-30','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1699,'BOUFFAY','PAULETTE','1932-11-03','02.19.11.69.78','06.62.84.43.48',NULL,'CAPAR MESNIL','','','14460','COLOMBELLES',NULL,NULL,'2321178551001',21.000000000,'1956-01-13','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1700,'BALOCHE','JEANNE','1938-02-27','02.58.02.66.67','06.13.98.10.16',NULL,'6 ALLEE DES VIGNONS','','','61470','LE BOSC RENOULT',NULL,NULL,'2380214446001',1634.000000000,'1967-12-24','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1701,'ROCQUANCOURT','serge','1931-02-13','02.13.52.87.10','06.10.27.71.67',NULL,'38 avenue de la republique','','','14600','LA RIVIERE ST SAUVEUR',NULL,NULL,'2310237132001',335.000000000,'1955-06-18','PREMIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1702,'FRANCOIS','BERNARD','1939-03-23','02.80.85.69.05','06.67.89.05.33',NULL,'17. rue des rosiers, batG escali','er11','','14680','BRETTEVILLE SUR LAIZE',NULL,NULL,'1390314066001',2069.000000000,'1960-12-11','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1703,'GRATIA','LILIANE','1939-03-03','02.10.96.25.33','06.12.89.75.59',NULL,'19 RUE GEORGES AUGUSTE','','','14730','GIBERVILLE',NULL,NULL,'1390314066001',228.000000000,'1966-03-30','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1704,'BRISSARD','THERESE','1930-02-22','02.38.72.63.06','06.11.78.72.76',NULL,'23 RUE DES ORAILLES','','','14370','ARGENCES',NULL,NULL,'2300214461001',204.000000000,'1958-05-31','PREMIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1705,'LAIGNEL','','1928-11-27','02.21.02.27.86','06.11.65.65.55',NULL,'20. route de bayeux','','','14110','ST GERMAIN DU CRIOULT',NULL,NULL,'2281114570001',183.000000000,'1952-05-04','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1706,'DESMONTS','YVETTE','1959-03-06','02.12.89.34.37','00 33 6.57.99.68.71',NULL,'20. rue vallee d''auge','','','50580','DENNEVILLE',NULL,NULL,'1590350111001',106.000000000,'1980-11-11','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1707,'AHMED','ROGER','1936-03-19','02.49.63.27.61','06.71.72.72.49',NULL,'LE BOURG','','','14840','DEMOUVILLE',NULL,NULL,'2360314610001',85.000000000,'1960-10-02','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1708,'MARIE','GERARD','1950-03-02','02.15.69.34.52','06.36.95.90.04',NULL,'21 RUE DE BRUXELLES','','','14730','GIBERVILLE',NULL,NULL,'2500314029001',275.000000000,'1976-12-27','PREMIUM',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1709,'LETHAN','ROLANDE','1934-03-27','02.86.40.88.73','06.84.96.64.03',NULL,'1 RUE VICTOR HUGO','','','14123','CORMELLES LE ROYAL',NULL,NULL,'1340314048001',21.000000000,'1964-09-07','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1710,'WALCZAK','YVES','1966-12-24','02.67.75.59.80','06.89.03.15.54',NULL,'10 RUE DES ALOUETTES','','','14320','MAY SUR ORNE',NULL,NULL,'2661214523001',1251.000000000,'1987-02-07','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1711,'CARABY','ROGER','1928-01-13','02.90.41.00.91','06.11.61.98.37',NULL,'','','','14840','DEMOUVILLE',NULL,NULL,'1280149150001',2722.000000000,'1949-05-08','PREMIUM',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1712,'DOINARD','GASTON','1932-03-08','02.33.43.50.20','06.26.07.58.82',NULL,'','','','14150','OUISTREHAM',NULL,NULL,'1320314133001',75.000000000,'1959-02-15','GOLD',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1713,'DRIEU','ANDRE','1966-03-07','02.74.25.95.04',NULL,NULL,'31 RUE DU CLOS VOISIN','','','14000','CAEN',NULL,NULL,'2660362119001',45.000000000,'1991-10-14','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1714,'SANTIER','GUY','1938-06-25','02.57.44.06.84','06.87.24.81.21',NULL,'7 RUE CAMILLE GUERIN','','','14160','DIVES SUR MER',NULL,NULL,'2380678233001',33.000000000,'1960-01-27','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1715,'LOUIS','ALICE','1930-05-07','02.48.86.96.51','06.28.76.07.92',NULL,'37 RUE JEAN MERMOZ','','','14540','CONTEVILLE',NULL,NULL,'2300514652001',105.000000000,'1955-01-03','PREMIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1716,'TACCHI','JACQUELINE','1929-07-20','02.52.06.30.05','06.11.40.05.67',NULL,'5 RUE CHRESTIEN DE TROYES','','','14000','CAEN',NULL,NULL,'1290714098001',561.000000000,'1952-05-25','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1717,'JEANNE','EMILE','1928-12-31','02.31.52.61.77','06.47.48.82.29',NULL,'','','','14380','MESNIL CLINCHAMPS',NULL,NULL,'2281214456001',1686.000000000,'1953-08-03','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1718,'RUAULT','SIMONE','1935-11-25','02.76.07.91.91','06.72.27.77.40',NULL,'907 quartier du grand parc','','','14880','COLLEVILLE MONTGOMERY',NULL,NULL,'1351191506001',76.000000000,'1959-02-01','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1719,'VERHAEGHE','CHRISTIANE','1961-01-11','02.12.07.71.08','06.77.82.08.65',NULL,'1 rue fred scamaroni','','','50680','CERISY LA FORET',NULL,NULL,'2610114125001',118.000000000,'1984-10-16','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1720,'RADIGUET','PAULETTE','1937-07-01','02.72.24.81.91','06.30.52.43.47',NULL,'','','','14280','ST GERMAIN LA BLANCHE HERBE',NULL,NULL,'2370714066001',187.000000000,'1959-04-20','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1721,'LEMARIE','MADELAINE','1939-10-03','02.30.82.33.14','06.12.28.87.78',NULL,'HAMEAU BONNEVAL','','','50660','LINGREVILLE',NULL,NULL,'2391014282001',3.000000000,'1963-11-23','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1722,'LOREL','SYLVIE','1938-12-14','02.41.18.06.85','06.32.29.54.89',NULL,'route de corniche chemin du sema','phore','','29270','CARHAIX PLOUGUER',NULL,NULL,'1381228294001',453.000000000,'1964-02-18','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1723,'LEMAITRE','JACQUELINE','1939-10-18','02.57.41.39.31','06.63.54.58.49',NULL,'LE BOIS','','','14850','ESCOVILLE',NULL,NULL,'2391014171001',9.000000000,'1963-07-01','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1724,'SZWAJA','COLETTE','1965-05-20','02.82.46.26.22','06.83.42.64.78',NULL,'4 RUE DES HAUTS JARDIN','','','14000','CAEN',NULL,NULL,'1650514556001',79.000000000,'1995-08-03','PREMIUM',12,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1725,'GAIGNON','FRANCOISE','1959-01-16','02.11.81.67.81','06.10.38.97.41',NULL,'10 RUE DE SULLY','','','61250','DAMIGNY',NULL,NULL,'1590114176001',4123.000000000,'1981-06-15','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1726,'ANSELMETTI','ALICE','1936-09-16','02.67.55.71.19','06.41.02.15.45',NULL,'30 rue du seau du loup','','','14123','FLEURY SUR ORNE',NULL,NULL,'2360914407001',68.000000000,'1959-11-12','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1727,'ZIELINSKI','CHARLOTTE','1937-07-10','02.80.42.78.04','06.71.15.81.43',NULL,'6 chemin la couture','','','14630','CAGNY',NULL,NULL,'1370727030001',571.000000000,'1965-01-23','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1728,'HARE','DANIEL','1935-10-26','02.31.54.01.70','06.58.32.64.26',NULL,'14 RUE DOMREMY','','','14790','VERSON',NULL,NULL,'2351014657001',26.000000000,'1959-12-14','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1729,'SCELLES','JULIEN','1935-10-20',NULL,NULL,NULL,'21 RUE JEAN PHILIPPE RAMEAU','','','14270','MEZIDON CANON',NULL,NULL,'2351014657001',737.000000000,'1956-02-17','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1730,'SALLE','JEAN','1931-01-04','02.68.50.15.90','06.70.88.27.19',NULL,'12 RUE DE L''ECUREUIL','','','14370','AIRAN',NULL,NULL,'1310114027001',336.000000000,'1958-05-29','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1731,'LEGORGEU','NATHALIE','1928-04-07','02.99.98.76.58','06.10.31.21.83',NULL,'','','','14111','LOUVIGNY',NULL,NULL,'2280414245001',94.000000000,'1950-07-13','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1732,'CAPRAIS','BERNARD','1935-05-21','02.19.41.58.27','06.69.41.26.88',NULL,'302 la ramee','','','14850','ESCOVILLE',NULL,NULL,'2350514004001',96.000000000,'1961-02-08','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1733,'LE CLERC','MARIE','1929-09-02','02.65.73.75.57','06.23.03.96.41',NULL,'RUE DES AGRIONS','','','14620','DAMBLAINVILLE',NULL,NULL,'1290914658001',36.000000000,'1950-05-15','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1734,'BLOTTIERE','MARIE','1937-07-02','02.52.27.87.05','06.22.11.59.82',NULL,'28 RUE DE PROVENCE','','','14860','RANVILLE',NULL,NULL,'1370722353001',495.000000000,'1967-06-28','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1735,'QUESNEL','/','1930-10-21',NULL,NULL,NULL,'9 ROUTE DE PERIERS','','','14000','CAEN',NULL,NULL,'2301050395001',25.000000000,'1954-01-19','PLATINIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1736,'MARIE','THERESE','1966-01-11','02.10.78.55.56','06.59.23.37.27',NULL,'1 RUE DES PETITES MARETTES','','','14000','CAEN',NULL,NULL,'1660114341001',471.000000000,'1996-10-20','PREMIUM',12,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1737,'RENOUF','THERESE','1930-05-11','02.11.45.72.29','06.34.69.76.52',NULL,'','','','14000','CAEN',NULL,NULL,'2300576060001',214.000000000,'1952-09-09','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1738,'DUVAL','YVONNE','1933-05-25','02.53.09.43.07','06.79.16.96.67',NULL,'3 rue henri barbusse','','','14790','FONTAINE ETOUPEFOUR',NULL,NULL,'1330514598001',98.000000000,'1963-09-08','GOLD',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1739,'NICOLLE','MIREILLE','1933-02-11','02.90.96.17.44','06.23.86.75.91',NULL,'27 CITE DE CAUDET','','','14123','FLEURY SUR ORNE',NULL,NULL,'2330214594001',15.000000000,'1956-12-21','PREMIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1740,'CRENN','JEANNINE','1930-04-20','02.79.59.73.28','06.98.75.85.97',NULL,'','','','14880','COLLEVILLE MONTGOMERY',NULL,NULL,'1300414251001',2125.000000000,'1957-12-31','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1741,'LEMARIE','JEAN','1929-05-02','02.92.54.15.78','06.47.02.15.22',NULL,'37 AVENUE DE COURSEULLES','','','14123','IFS',NULL,NULL,'1290514556001',14.000000000,'1950-09-10','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1742,'MAHEUT','FRANCOISE','1935-07-01','02.69.98.66.76','06.11.75.16.83',NULL,'2 RUE DU  POITOU','','','14670','JANVILLE',NULL,NULL,'1350714167001',181.000000000,'1957-03-03','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1743,'CHESNEL','JOELLE','1933-09-26','02.55.46.25.04','06.27.54.05.01',NULL,'15 RUE GEORGES CLEMENCEAU','','','14450','GRANDCAMP MAISY',NULL,NULL,'1330950269001',137.000000000,'1960-09-25','PREMIUM',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1744,'THIRON','GEORGETTE',NULL,'02.42.69.49.20','06.12.14.64.41',NULL,'LES RABUSQUETS','','','14000','CAEN',NULL,NULL,'1281214181001',53.000000000,'2013-08-07','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1745,'SIMON','NADINE','1928-01-09','02.77.30.00.02','06.53.12.70.67',NULL,'LE PIED DU BOIS','','','14630','FRENOUVILLE',NULL,NULL,'1280114342001',280.000000000,'1951-08-26','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1746,'MORAINE','','1966-01-14','02.38.22.76.49','06.52.28.47.00',NULL,'19 RUE DE SAINTONGE','','',NULL,NULL,NULL,NULL,'1660114246001',128.000000000,'1996-02-18','PREMIUM',12,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1747,'GERVAIS','MONIQUE','1955-01-03','02.84.03.99.82','06.44.93.89.06',NULL,'2 AVENUE DU VAL','','',NULL,NULL,NULL,NULL,'2550114686001',20.000000000,'1980-07-21','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1748,'LATOUR','BEATRICE',NULL,'02.66.51.98.79','06.38.12.87.07',NULL,'1 RUE DE LA FRENEE','','','14000','CAEN',NULL,NULL,'1600114057001',3778.000000000,'2009-08-28','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1749,'CARABY','MARTINE','1939-04-22','02.24.83.01.57','06.10.38.76.45',NULL,'21 RUE PIERRE DE COUBERTIN','','','61310','SURVIE',NULL,NULL,'1390414047001',39.000000000,'1960-08-22','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1750,'BORDIER','ADRIENNE','1957-01-25','02.88.71.05.64','06.98.57.88.94',NULL,'ROUTE DE MAIZIERES','','','14220','THURY HARCOURT',NULL,NULL,'2570114396001',183.000000000,'1984-02-07','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1751,'PELLIER','JEAN MARIE','1933-08-28','02.54.14.06.34','06.44.23.42.14',NULL,'1 SENTE DE LA CRESSONIERE','','','14000','CAEN',NULL,NULL,'2330853036001',588.000000000,'1954-06-11','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1752,'MOGES','CLAUDE','1935-11-20','02.43.58.83.23','06.69.24.57.73',NULL,'19 RUE DU CLOS NORMAND','','','14190','ST GERMAIN LE VASSON',NULL,NULL,'1351114006001',129.000000000,'1959-05-05','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1753,'GRIMAULT','JEAN','1945-07-30','02.19.40.74.24',NULL,NULL,'10 RUE DU CHEMIN BERNARD','','','14460','COLOMBELLES',NULL,NULL,'1450714483001',24.000000000,'1975-10-24','GOLD',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1754,'VAILLANT','ALICE','1932-05-26','02.62.18.35.60','00 33 6.64.14.43.42',NULL,'17 RUE DE L4ABBATIALE','','','14123','IFS',NULL,NULL,'1320550538001',33.000000000,'1956-04-27','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1755,'VOISIN','HENRIETTE','1935-03-04','02.16.96.48.39','06.35.13.27.00',NULL,'5 RUE DU BOIS','','','14670','TROARN',NULL,NULL,'1350314046001',200.000000000,'1959-07-03','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1756,'BLOT','JACQUES','1932-03-09','02.20.56.51.25','06.43.40.52.87',NULL,'1 rue st andre','','','14123','IFS',NULL,NULL,'1320327207001',10.000000000,'1955-03-27','PREMIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1757,'','BERNADETTE','1940-02-26','02.93.43.61.14','06.95.54.97.51',NULL,'1-2 ALLEE DU PRIEURE','','','14570','ST REMY',NULL,NULL,'1400214076001',257.000000000,'1961-05-11','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1758,'LECOMTE','ANDRE','1937-05-19','02.10.17.87.65','06.85.48.51.20',NULL,'115 LE RUQUET','','','14980','ROTS',NULL,NULL,'1370514338001',147.000000000,'1965-08-19','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1759,'CAILLOT','BERNARD','1969-09-17','02.78.49.87.10','06.12.26.57.03',NULL,'5 RUE DU STADE','','','14670','TROARN',NULL,NULL,'2690914118001',32.000000000,'1992-09-26','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1760,'LEROSIER','ROGER','1929-05-29','02.72.32.21.51','06.25.59.20.49',NULL,'12 RUE DU 19 MARS 1962','','','14120','MONDEVILLE',NULL,NULL,'1290514556001',950.000000000,'1950-02-25','PREMIUM',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1761,'LEBECQ','CHRISTIAN','1938-02-17','02.15.79.61.89','06.28.05.11.98',NULL,'21 RUE DU MANOIR','','','14320','MAY SUR ORNE',NULL,NULL,'1380248123001',8.000000000,'1961-03-29','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1762,'STEPIEN','PIERRE','1933-10-02','02.96.77.61.08','06.16.89.76.17',NULL,'8 chemin duvivier','','','14000','CAEN',NULL,NULL,'1331014130001',38.000000000,'1959-09-10','GOLD',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1763,'MARIE','MARIE THERESE','1939-10-11','02.81.12.96.06','06.85.61.21.25',NULL,'LE BOURG','','','14123','FLEURY SUR ORNE',NULL,NULL,'1391027112001',34.000000000,'1962-12-06','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1764,'LEFEVRE','PATRICIA','1928-04-19','02.10.14.78.69','06.64.60.24.32',NULL,'19 PLACE VERDUN','','','14200','HEROUVILLE ST CLAIR',NULL,NULL,'2280414675001',195.000000000,'1949-07-30','PREMIUM',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1765,'BILLARD','CHANTAL','1962-01-28','02.23.15.14.87','06.88.03.66.66',NULL,'7 RUE STE PAIX PORTE B','','','14000','CAEN',NULL,NULL,'2620114333001',193.000000000,'1989-06-16','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1766,'CANCIAN','JACQUELINE','1940-02-11','02.24.78.27.71','06.65.31.99.21',NULL,'3 RUE LES RIFFARDS','','','14000','CAEN',NULL,NULL,'1400214556001',3.000000000,'1967-08-17','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1767,'JEANBRUN','FRANCOIS','1962-01-03','02.74.96.97.56',NULL,NULL,'ROUTE DE STE HONORINE DU FAY','','','14000','CAEN',NULL,NULL,'1620114020001',1472.000000000,'1986-02-12','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1768,'VIBERT','GEORGES','1935-05-10','02.95.60.04.27','06.60.63.30.88',NULL,'22 BD RAYMOND POINCARE','','','14550','BLAINVILLE SUR ORNE',NULL,NULL,'1350514129001',53.000000000,'1958-07-26','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1769,'BAUDOUIN','MADELEINE','1960-01-23','02.27.20.89.88','06.64.23.28.05',NULL,'5 AVENUE  SAINTE THERESE','','','14123','FLEURY SUR ORNE',NULL,NULL,'2600114191001',718.000000000,'1982-07-09','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1770,'LETIRAND','marcel','1952-01-24','02.35.11.18.92','06.42.07.26.01',NULL,'','','','14000','CAEN',NULL,NULL,'2520114675001',371.000000000,'1980-09-21','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1771,'DOUCHY','GILBERT','1930-09-04','02.12.26.95.02','06.83.45.96.79',NULL,'9 RUE ALEXIS DE TOCQUEVILLE','','','14120','MONDEVILLE',NULL,NULL,'2300914699001',3954.000000000,'1955-05-15','PREMIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1772,'TAVERNEY','NICOLLE',NULL,'02.12.13.62.42','06.48.19.61.46',NULL,'84 ABBE LECORNU','','','14220','ST LAURENT DE CONDEL',NULL,NULL,'2472099337001',83.000000000,'2010-05-27','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1773,'GERME','YVONNE','1963-03-15','02.23.06.73.24','06.48.92.11.98',NULL,'9 rue juno','','','14740','BRETTEVILLE L''ORGUEILLEUSE',NULL,NULL,'2630399253001',47.000000000,'1991-08-22','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1774,'ANNE','NELLY','1940-01-27','02.12.85.20.45','06.14.41.29.61',NULL,'2 RUE DU CLOS CARRE','','','14200','HEROUVILLE ST CLAIR',NULL,NULL,'2400114458001',84.000000000,'1964-11-01','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1775,'BOUET','JEANNINE','1936-06-21','02.28.43.35.03','06.81.88.11.85',NULL,'15 cote du val','','','14000','CAEN',NULL,NULL,'2360650610001',20.000000000,'1964-08-04','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1776,'DELASALLES','EDITH','1946-01-01','02.24.13.75.59','06.97.27.58.24',NULL,'9 PLACE DE MARILLAC','','','14120','MONDEVILLE',NULL,NULL,'1460150323001',10.000000000,'1968-08-04','GOLD',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1777,'DESHAMAUTS','FRANCOIS-MICHEL','1940-10-02','02.73.51.82.80','06.51.21.31.95',NULL,'11 AVENUE DU CALVADOS','','','14240','ST GERMAIN D''ECTOT',NULL,NULL,'1401014370001',34.000000000,'1964-11-17','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1778,'GODEY','LUCIENNE','1947-01-26','02.60.40.76.42','06.52.08.42.01',NULL,'LE BOURG','','','14112','BIEVILLE BEUVILLE',NULL,NULL,'1470114246001',0.000000000,'1968-08-03','GOLD',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1779,'COLLINET','AIME','1966-03-30','02.70.18.01.07','06.36.35.03.93',NULL,'LOTISSEMENT COMMUNAL LA VIOLIER','E','','14840','DEMOUVILLE',NULL,NULL,'1660314453001',139.000000000,'1996-10-27','PREMIUM',12,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1780,'TURBOUST','MICHELLE','1934-03-27','02.11.86.76.66','06.38.74.50.01',NULL,'10 chemin du val','','','14270','MEZIDON CANON',NULL,NULL,'2340322224001',162.000000000,'1955-06-22','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1781,'','GENEVIEVE','1939-11-06','02.80.42.76.79','06.45.24.48.60',NULL,'882 CHEMIN DU VAL','','','14320','MAY SUR ORNE',NULL,NULL,'1391114123001',151.000000000,'1963-01-17','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1782,'JOUBERT','remy','1935-08-27','02.81.32.39.00','06.60.55.34.35',NULL,'','','','14540','ROCQUANCOURT',NULL,NULL,'2350814352001',460.000000000,'1962-04-19','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1783,'RICHER','JANINE','1956-01-10','02.76.48.84.22','06.62.48.43.22',NULL,'3 LES AIGUILLERES','','','14000','CAEN',NULL,NULL,'2560150626001',36.000000000,'1983-11-12','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1784,'HALLIEN','HENRI',NULL,'02.16.42.69.05','06.89.68.26.75',NULL,'2 BIS RUE DE CABOURG','','','14120','MONDEVILLE',NULL,NULL,'1320122105001',64.000000000,'2010-08-12','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1785,'SOYER','MARCEL',NULL,'02.39.56.65.17','06.96.80.35.22',NULL,'','','','14000','CAEN',NULL,NULL,'2360850231001',266.000000000,'2012-04-15','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1786,'THOMASSE','BERNARD','1928-06-12','02.27.01.59.29','06.59.24.60.32',NULL,'','','','50120','EQUEURDREVILLE HAINNEVILLE',NULL,NULL,'2280614126001',1469.000000000,'1951-06-29','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1787,'BIDOT','JACQUES','1965-05-30','02.91.87.14.35','06.53.17.35.86',NULL,'7 rue alfonse et leonard  gilles','','','14120','MONDEVILLE',NULL,NULL,'1650514410001',40.000000000,'1991-11-12','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1788,'','JANINE','1928-12-18','02.35.72.43.26','06.42.04.96.47',NULL,'23 RUE EMMANUEL','','','14270','OUEZY',NULL,NULL,'1281214666001',164.000000000,'1953-01-23','PLATINIUM',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1789,'COLIN','DENISE','1956-12-18','02.30.57.52.13','06.21.41.59.50',NULL,'3 BIS RUE DE LA LIBERATI0N','','','14370','ARGENCES',NULL,NULL,'2561214314001',23.000000000,'1979-08-12','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1790,'LEMARCHAND','GILBERT',NULL,'02.94.41.14.84','06.10.86.77.35',NULL,'13 place de la mairie','','','14740','PUTOT EN BESSIN',NULL,NULL,'1320361331001',385.000000000,'2009-09-09','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1791,'LAVILLE','JEAN','1938-10-20','02.71.88.81.80','06.75.57.12.63',NULL,'','','','14400','ST VIGOR LE GRAND',NULL,NULL,'1381050500001',192.000000000,'1963-01-23','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1792,'CHOUQUARD','ISABELLE','1966-08-29','02.16.52.86.51','06.33.92.56.40',NULL,'LE MESNIL TOUFFRAY','','','14770','LASSY',NULL,NULL,'2660814651001',173.000000000,'1989-02-12','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1793,'LEMATTE','IRENE','1952-01-22','02.52.91.66.99','06.15.34.55.74',NULL,'','','','14000','CAEN',NULL,NULL,'1520114402001',966.000000000,'1982-02-04','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1794,'ANGOT','LOUIS','1932-11-19','02.22.91.53.14','06.62.36.92.20',NULL,'1 rue Marcel Pelluet','','','50500','BREVANDS',NULL,NULL,'2321114271001',638.000000000,'1957-05-07','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1795,'LEDENTU','RENE','1939-07-08','02.22.01.88.41','06.10.05.36.53',NULL,'22 RUE DES TILLEULS','','','14800','DEAUVILLE',NULL,NULL,'2390756054001',46.000000000,'1965-10-29','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1796,'RUGALE','PAUL','1961-03-15','02.10.41.35.61','06.83.58.74.05',NULL,'3 RUE DU 8 MAI','','','14370','AIRAN',NULL,NULL,'1610314435001',21.000000000,'1983-07-02','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1797,'DUBOIS','MADELEINE','1961-03-24','02.38.02.26.70','06.11.00.43.97',NULL,'3 rue saint sernin','','','14120','MONDEVILLE',NULL,NULL,'1610314529001',206.000000000,'1990-04-26','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1798,'LECANU','RENE-PIERRE','1961-11-09','02.46.66.86.93','06.27.19.51.94',NULL,'','','','14540','GRENTHEVILLE',NULL,NULL,'1611114581001',4691.000000000,'1989-08-09','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1799,'MARIE','MONIQUE','1931-11-25','02.73.65.40.67','06.11.19.45.61',NULL,'85 RUE DE FALAISE','','','14000','CAEN',NULL,NULL,'2311161140001',46.000000000,'1961-03-30','PREMIUM',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1800,'LAMY','JEAN','1928-01-20','02.43.01.33.84','06.11.20.30.59',NULL,'35 RUE GAMBETTA','','','14320','CLINCHAMPS SUR ORNE',NULL,NULL,'2280114084001',56.000000000,'1953-04-07','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1801,'LETOURNEUR','ANDRE','1940-06-28','02.24.53.96.36','06.96.18.60.20',NULL,'5 RUE EUGENIE','','','14320','ST MARTIN DE FONTENAY',NULL,NULL,'1400650165001',5.000000000,'1967-01-20','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1802,'GUICHET','GEORGETTE','1965-02-14','02.12.27.27.90','06.41.88.13.05',NULL,'657 GRANDE RUE','','','14860','BAVENT',NULL,NULL,'1650214341001',1761.000000000,'1986-04-01','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1803,'OLIVEAU','DOMINIQUE','1929-09-10','02.50.61.31.36','06.60.33.98.86',NULL,'8 CHEMIN ST GEORGES','','','14630','CAGNY',NULL,NULL,'2290961170001',98.000000000,'1953-12-22','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1804,'MICHEL','DENISE','1944-06-15','02.46.60.05.52','06.74.60.27.62',NULL,'3 RUE DU PLAIN DU ROY','','','61100','LA CHAPELLE AU MOINE',NULL,NULL,'1440661226001',688.000000000,'1974-02-14','GOLD',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1805,'RENOUF','DENISE','1975-02-18','02.11.65.93.37','06.77.17.97.10',NULL,'14 RUE DU LAVOIR','','','14123','IFS',NULL,NULL,'2750250031001',1574.000000000,'1998-08-26','PREMIUM',12,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1806,'CATHERINE','paul','1946-01-21','02.17.30.13.21','06.55.04.31.13',NULL,'6 IMP MATIGNON','','','14123','IFS',NULL,NULL,'2460114461001',456.000000000,'1976-08-21','GOLD',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1807,'KOMPAORE','THIERRY','1945-02-15','02.10.13.20.29','06.11.47.79.42',NULL,'1 rue des erables','','','14930','ETERVILLE',NULL,NULL,'1450231137001',1227.000000000,'1969-09-26','GOLD',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1808,'FRIANT','JEAN','1939-03-18','02.41.59.83.56','06.20.76.85.96',NULL,'4 RUE DE STOCKHOLM','','','14120','MONDEVILLE',NULL,NULL,'2390314341001',94.000000000,'1961-05-10','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1809,'BRUNET','PIERRE','1931-10-09','02.93.22.65.73','06.34.72.62.96',NULL,'33 RUE DES PAVILLONS','','','14000','CAEN',NULL,NULL,'2311014020001',157.000000000,'1956-04-29','PREMIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1810,'LONGPRE','GILLES','1934-03-05','02.15.22.25.44','06.57.24.76.35',NULL,'15 rue bellevue','','','14460','COLOMBELLES',NULL,NULL,'1340314653001',19.000000000,'1964-01-01','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1811,'QUESNEL','GINETTE','1940-05-07','02.85.29.83.74',NULL,NULL,'27 RUE GALANTE','','','14120','MONDEVILLE',NULL,NULL,'2400514506001',15.000000000,'1965-08-09','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1812,'LESAGE','JOSEPH','1956-05-24','02.87.77.76.88','06.81.66.57.67',NULL,'325 RUE DE FALAISE','','','14680','BRETTEVILLE SUR LAIZE',NULL,NULL,'2560514560001',118.000000000,'1978-08-07','PREMIUM',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1813,'BLONDEL','SIMONE','1936-04-05','02.10.66.36.31','06.25.32.66.21',NULL,'1 RUE GEORGES CAZIN','','','14123','IFS',NULL,NULL,'1360414543001',479.000000000,'1966-06-17','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1814,'LEMAIRE','MARCEL','1937-01-16','02.11.29.86.13','06.12.43.32.42',NULL,'75 RUE BRANVILLE','','','14570','ST LAMBERT',NULL,NULL,'1370114164001',45.000000000,'1959-11-12','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1815,'FESTOC','PAULETTE','1938-07-29','02.16.35.75.78','06.24.23.34.71',NULL,'25 rue leclerc','','','14880','HERMANVILLE SUR MER',NULL,NULL,'1380714695001',1022.000000000,'1964-11-19','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1816,'QUINQUENEL','THERESE','1947-01-31','02.53.86.33.20','06.56.75.50.98',NULL,'LE MONTMIREL','','','27270','LA CHAPELLE GAUTHIER',NULL,NULL,'1470161177001',83.000000000,'1971-11-29','GOLD',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1817,'ADAM','RAYMONDE','1930-01-11','02.30.82.35.61','06.43.78.97.43',NULL,'11 rue de l''europe','','','14200','HEROUVILLE ST CLAIR',NULL,NULL,'1300114301001',1493.000000000,'1952-02-10','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1818,'LAIR','SOLANGE','1936-03-28','02.49.19.77.55','06.10.18.97.54',NULL,'Pillou','','','14320','MAY SUR ORNE',NULL,NULL,'2360314304001',59.000000000,'1966-06-25','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1819,'LE MARQUAND','RAYMONDE','1970-03-06','02.41.80.98.84','06.61.11.03.31',NULL,'43 rue des roches','','','14220','THURY HARCOURT',NULL,NULL,'1700314118001',1271.000000000,'1999-11-11','PREMIUM',11,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1820,'FERAY','MARYLINE','1963-01-15','02.38.37.60.94','06.57.89.88.95',NULL,'14. rue richard lenoir','','','14670','TROARN',NULL,NULL,'2630114062001',212.000000000,'1990-10-13','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1821,'LEFEVRE','PHILIPPE','1939-10-04','02.42.48.16.36','06.74.72.42.23',NULL,'11 rue de rochechoire','','','14190','ST SYLVAIN',NULL,NULL,'1391014277001',92.000000000,'1961-12-28','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1822,'HERAULT','CHRISTINE','1946-02-27',NULL,NULL,NULL,'7 RUE ANTOINE GALLAND','','','14150','OUISTREHAM',NULL,NULL,'1460214438001',92.000000000,'1976-07-27','GOLD',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1823,'BEN JENEC','ERIC','1950-02-14','02.69.52.63.99','06.98.48.25.27',NULL,'1 RUE BASSE','','','61240','LE MERLERAULT',NULL,NULL,'2500250054001',11.000000000,'1975-11-18','PREMIUM',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1824,'GUERIN','XAVIER','1936-04-19','02.12.25.32.82','06.10.22.66.27',NULL,'6 RUE DE LA PAIX','','','50340','HEAUVILLE',NULL,NULL,'2360414475001',620.000000000,'1957-09-21','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1825,'WAJDA','JOELLE','1931-09-30','02.72.51.63.89','06.64.59.54.40',NULL,'10 allee g bizet','','','14450','GRANDCAMP MAISY',NULL,NULL,'2310914579001',169.000000000,'1956-05-11','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1826,'BRIDON','GERARD','1937-04-19','02.98.46.36.76','06.71.16.54.65',NULL,'5 rue du raquet','','','14220','CROISILLES',NULL,NULL,'1370461344001',199.000000000,'1967-09-11','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1827,'HARIVEL','REMY','1942-03-30','02.72.30.55.06','06.58.29.81.79',NULL,'61 RUE DE LA FONTENELLE','','','14730','GIBERVILLE',NULL,NULL,'1420314309001',4985.000000000,'1972-07-17','SILVER',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1828,'CASTEL','CHRISTOPHE','1934-12-08','02.33.88.39.82','06.34.28.33.86',NULL,'2 ALLEE DE LA MARE','','','14220','CROISILLES',NULL,NULL,'2341261040001',3.000000000,'1956-03-20','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1829,'HUET','ROGER','1935-02-03','02.49.34.08.45','06.93.93.41.94',NULL,'','','','14270','MEZIDON CANON',NULL,NULL,'2350214271001',4.000000000,'1956-01-23','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1830,'HALLEY','DOMINIQUE','1934-11-07','02.48.57.25.30','06.83.43.62.56',NULL,'29 RUE DAMOZANNE','','','14370','AIRAN',NULL,NULL,'2341114281001',26.000000000,'1959-06-06','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1831,'THOMASSE','JACQUES','1930-05-15','02.10.15.56.37','06.90.20.69.61',NULL,'ALLEE DU PORTIQUE LE MONT ST LE','GER','','14570','CLECY',NULL,NULL,'2300576060001',35.000000000,'1960-08-16','GOLD',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1832,'PICAN','RENEE','1932-01-24','02.59.50.42.22','06.45.09.28.78',NULL,'36 RUE DE LA HAIE','','','14170','ST PIERRE SUR DIVES',NULL,NULL,'1320122105001',58.000000000,'1959-01-15','GOLD',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1833,'','FRANCOISE','1931-02-16','02.30.58.69.06','06.38.61.82.95',NULL,'55 RUE DE CAEN','','','14123','FLEURY SUR ORNE',NULL,NULL,'2310250356001',290.000000000,'1953-09-13','PLATINIUM',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1834,'ORY','RENE','1956-01-06','02.65.02.83.80','06.47.13.41.50',NULL,'6 RUE DE LION','','','14490','CAMPIGNY',NULL,NULL,'2560114610001',850.000000000,'1982-08-20','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1835,'MAILLAR','PHILIPPE','1936-09-27','02.73.07.35.53','06.57.56.48.81',NULL,'8 RUE DES LABOUREURS','','','14123','FLEURY SUR ORNE',NULL,NULL,'1360914431001',180.000000000,'1958-09-15','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1836,'MARIE','YVONNE','1930-03-24','02.89.57.46.94','06.10.87.16.38',NULL,'4 IMPASSE DES BLEUETS','','','14730','GIBERVILLE',NULL,NULL,'2300350148001',771.000000000,'1959-10-08','GOLD',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1837,'MALLET','francoise','1933-02-12','02.84.63.94.78','06.34.72.97.62',NULL,'17 RUE LUCIEN MANGEMATIN','','','14710','ST LAURENT SUR MER',NULL,NULL,'1330214655001',82.000000000,'1955-04-21','PREMIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1838,'JEANNE','EDITH','1950-02-06','02.29.13.06.16','06.10.37.15.09',NULL,'38 rue de l''esprance','','','14230','ISIGNY SUR MER',NULL,NULL,'2500214275001',79.000000000,'1976-04-23','PREMIUM',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1839,'MORISSET','GUY','1935-07-21','02.10.45.86.04','06.68.01.95.09',NULL,'le fey','','','14540','SOLIERS',NULL,NULL,'1350714566001',177.000000000,'1965-12-22','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1840,'GUIGNANS','CHARLES','1929-10-05','02.32.74.67.72',NULL,NULL,'5 rue de la garenne','','','14190','ST SYLVAIN',NULL,NULL,'2291014458001',2121.000000000,'1958-09-07','PLATINIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1841,'CLANCHE','YVONNE','1937-05-06','02.21.54.16.25','06.11.23.73.27',NULL,'6 RUE BOUTROIS','','','14000','CAEN',NULL,NULL,'2370514251001',762.000000000,'1962-10-13','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1842,'CHAPRON','ANNE MARIE','1949-08-09','02.62.88.77.46','06.11.57.49.87',NULL,'86 route d''harcourt','','','14000','CAEN',NULL,NULL,'1490814089001',126.000000000,'1971-05-29','PREMIUM',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1843,'BLERY','HUBERT','1982-03-06','02.56.27.18.77','06.19.00.13.81',NULL,'29 ROUTE DE COURSEULLES','','','14000','CAEN',NULL,NULL,'2820399234001',1687.000000000,'2004-05-03','PREMIUM',10,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1844,'DAVID','LOUIS','1918-03-18','02.37.93.39.67','06.46.43.55.42',NULL,'MAISON DE RETRAITE  88 ROUTE DE','ROUEN','','14150','OUISTREHAM',NULL,NULL,'2180371148001',26.000000000,'1940-09-09','PREMIUM',23,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1845,'VANDON','JEANINE','1939-04-21','02.10.65.99.42','06.83.81.16.94',NULL,'2 RUE GOUJARDE','','','14000','CAEN',NULL,NULL,'1390414521001',317.000000000,'1963-07-25','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1846,'VAIDIS','ROBERT','1958-02-26','02.83.06.09.16','06.23.48.61.14',NULL,'','','','14000','CAEN',NULL,NULL,'1580214245001',371.000000000,'1985-05-20','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1847,'GORAL','RENEE','1946-01-03','02.11.86.03.36','06.58.42.60.51',NULL,'3 RUE DES ECOLIERS','','','14320','FONTENAY LE MARMION',NULL,NULL,'2460114183001',37.000000000,'1967-04-30','GOLD',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1848,'VAUDREVILLE','CLAUDE','1968-09-28','02.33.49.61.44','06.59.15.87.84',NULL,'NEUVILLETTE','','','14390','PETIVILLE',NULL,NULL,'2680950619001',1012.000000000,'1996-04-25','PREMIUM',12,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1849,'DERVILLERS','SOLANGE','1929-12-31','02.30.35.48.53','06.10.00.46.22',NULL,'4 RUE DU ROCHER','','','14000','CAEN',NULL,NULL,'2291214167001',9.000000000,'1952-09-09','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1850,'VALLY','ELISABETH','1933-12-19','02.91.12.48.60','06.82.25.76.37',NULL,'41 ave du 6 juin','','','14320','ST ANDRE SUR ORNE',NULL,NULL,'1331272255001',306.000000000,'1955-02-04','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1851,'MAINIER','MICHEL','1940-07-23','02.68.67.14.25','06.33.56.70.12',NULL,'6 RUE CARDINAL LAVIGERIE','','','14000','CAEN',NULL,NULL,'1400752083001',44.000000000,'1964-11-13','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1852,'BENARD','LAURENCE','1956-08-30','02.61.45.62.47','06.74.34.93.93',NULL,'29 RUE EMILE MOUGINS','','','14000','CAEN',NULL,NULL,'2560872082001',44.000000000,'1985-04-21','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1853,'BRIARD','NOELLE','1958-11-03','02.78.25.39.46','06.81.04.49.32',NULL,'3 chemin du long bois','','','14000','CAEN',NULL,NULL,'1581114112001',1663.000000000,'1987-11-08','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1854,'BELLAMY','JEAN YVES','1955-03-08','02.79.37.78.67','06.18.35.75.26',NULL,'11 RUE DU POITOU','','','14000','CAEN',NULL,NULL,'1550314524001',139.000000000,'1985-01-30','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1855,'MELINOU','BERNARD','1961-04-20','02.54.29.89.32','06.11.58.07.12',NULL,'cao 4 rue guilbert','','','14640','AUBERVILLE',NULL,NULL,'1610414675001',776.000000000,'1991-03-05','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1856,'LANTRAIN','dominique',NULL,'02.29.62.42.39','06.12.12.51.13',NULL,'10 rue les bleuets','','','14000','CAEN',NULL,NULL,'2430214349001',1250.000000000,'2008-05-10','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1857,'APERRY','GEORGES','1937-11-18','02.10.61.45.95','06.18.03.69.67',NULL,'HAMEAU LES MARCHANDS','','','14730','GIBERVILLE',NULL,NULL,'1371114743001',75.000000000,'1961-01-21','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1858,'DELIVET','PHILIPPE','1929-06-24','02.38.94.38.30','06.72.96.70.12',NULL,'17 RUE DE L ABCIALE','','','14120','MONDEVILLE',NULL,NULL,'2290614554001',86.000000000,'1951-12-23','PREMIUM',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1859,'LEMESLE','PATRICK','1929-03-16','02.77.65.12.75','06.55.05.84.27',NULL,'MAISON BOCAINE','','','14120','MONDEVILLE',NULL,NULL,'1290314670001',1194.000000000,'1951-08-15','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1860,'LE FEIVRE','JEAN-CHRISTOPHE','1940-09-10','02.37.41.11.80','06.31.79.51.35',NULL,'55 RESIDENCE ST JEAN','','','14123','CORMELLES LE ROYAL',NULL,NULL,'1400914654001',163.000000000,'1963-10-04','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1861,'CHAUMERON','GINETTE','1955-01-28','02.73.95.19.71','06.68.12.03.00',NULL,'','','','14000','CAEN',NULL,NULL,'1550150435001',43.000000000,'1985-12-18','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1862,'LECHOISNE','PAUL','1932-05-25','02.10.46.15.96','06.44.32.50.61',NULL,'10 rue maurice moutare','','','61200','ARGENTAN',NULL,NULL,'1320576627001',1133.000000000,'1961-02-20','PREMIUM',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1863,'RENOUF','DENISE','1954-01-08','02.52.42.27.80','06.13.65.66.43',NULL,'17 RUE DES GERANIUMS','','','14123','CORMELLES LE ROYAL',NULL,NULL,'2540114552001',1011.000000000,'1981-03-28','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1864,'DEZIER','JANINE','1954-01-10','02.77.71.40.43','06.14.28.91.53',NULL,'residence les bruyeres','','','14540','SOLIERS',NULL,NULL,'2540114552001',21.000000000,'1984-02-28','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1865,'MANCHON DESRIVIERES','JEAN','1937-04-30','02.54.34.96.31','06.32.62.51.29',NULL,'3 IMPASSE DES CHARMES','','','14110','PONTECOULANT',NULL,NULL,'2370437076001',197.000000000,'1959-03-11','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1866,'MOREL','GERARD','1955-03-26','02.43.03.99.74',NULL,NULL,'33 chemin de l''arguilly','','','14270','MAGNY LE FREULE',NULL,NULL,'2550314294001',141.000000000,'1982-11-13','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1867,'KERIMOV','CLAUDINE','1935-07-23','02.27.80.53.18','06.15.67.22.83',NULL,'5 RUE JEAN DE LA VARENDE','','','14000','CAEN',NULL,NULL,'2350714680001',31.000000000,'1963-03-01','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1868,'','MARIE THERESE','1961-01-03','02.70.55.99.83','06.51.15.21.96',NULL,'8 RUE DU MARECHAL DE LATTRE DE T','ASSIGNY','','14000','CAEN',NULL,NULL,'2610150547001',64.000000000,'1991-03-19','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1869,'THOMAS','JACQUELINE','1937-10-28','02.83.07.26.92','06.10.22.81.14',NULL,'RUE DE PICARDIE','','','14860','RANVILLE',NULL,NULL,'1371014562001',522.000000000,'1959-07-07','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1870,'POTTIER','GUSTAVE','1968-02-23','02.87.61.90.66','06.55.63.66.76',NULL,'FOYER DES PERSONNES AGEES DE LA','FOLIE COUVRECHEF','','61100','ST GEORGES DES GROSEILLERS',NULL,NULL,'2680214114001',1409.000000000,'1991-05-11','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1871,'POTTIER','PIERRE','1932-07-02','02.41.91.08.94','06.88.95.57.58',NULL,'11 RUE DU TOUR DE TERRE','','','14670','TROARN',NULL,NULL,'1320714394001',38.000000000,'1962-11-27','GOLD',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1872,'MASSERON','FERNANDE','1949-12-26','02.44.58.74.20',NULL,NULL,'553 chemin du val','','','14000','CAEN',NULL,NULL,'1491214094001',812.000000000,'1971-05-24','PREMIUM',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1873,'LENOEL','JEAN','1935-04-13','02.67.95.14.10','06.45.74.86.76',NULL,'4 RUE FLEURIE','','','50700','VALOGNES',NULL,NULL,'2350461466001',8.000000000,'1959-12-12','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1874,'LENOEL','DELPHINE','1939-01-26','02.40.02.13.55','06.16.07.96.96',NULL,'FOYER HENRI DUNANT','','','14190','CAUVICOURT',NULL,NULL,'1390150224001',99.000000000,'1961-04-03','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1875,'DIGEON','SIMONE','1936-12-25','02.38.41.30.71','06.11.00.04.05',NULL,'','','','14260','BONNEMAISON',NULL,NULL,'2361214173001',352.000000000,'1960-08-02','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1876,'NOTAMY','BERNADETTE','1941-05-18','02.11.23.45.01','06.85.07.33.25',NULL,'L AIGLERIE','','','14640','AUBERVILLE',NULL,NULL,'1410514538001',431.000000000,'1965-10-16','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1877,'PHILIPPOT','CLAUDE','1962-03-20','02.10.28.48.25','06.24.18.41.50',NULL,'','','','61300','ST SYMPHORIEN DES BRUYERES',NULL,NULL,'1620361122001',3.000000000,'1983-05-21','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1878,'GAUSSEN','ERNESTINE','1961-03-16','02.66.90.21.29','06.16.64.87.84',NULL,'','','','61210','LA FRESNAYE AU SAUVAGE',NULL,NULL,'1610314435001',40.000000000,'1985-03-11','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1879,'LAIDET','LOUISE','1934-12-30','02.17.29.41.35','06.11.68.72.27',NULL,'26 Les Marettes','','','14320','MAY SUR ORNE',NULL,NULL,'2341250371001',37.000000000,'1959-05-04','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1880,'VIGAN','gaetan','1929-04-25','02.59.12.01.38','06.20.51.20.27',NULL,'8 PLACE GARDIN','','','14270','MEZIDON CANON',NULL,NULL,'2290414289001',307.000000000,'1952-02-26','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1881,'BEAUGAS','GAETAN','1930-11-05','02.82.61.65.87','06.22.52.16.58',NULL,'3 rue saint cernin','','','14370','ARGENCES',NULL,NULL,'2301114720001',1977.000000000,'1957-09-05','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1882,'DEFRANCE','JEANNINE','1941-01-15','02.37.69.33.75','06.68.80.56.11',NULL,'3 RUE DES VERGERS','','','50620','LE DEZERT',NULL,NULL,'2410114050001',36.000000000,'1963-09-19','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1883,'REVEL','EMILE','1933-03-21','02.38.42.82.54','06.44.18.29.25',NULL,'2 AVENUE DES AULNAIES','','','14550','BLAINVILLE SUR ORNE',NULL,NULL,'2330327179001',446.000000000,'1956-07-15','PREMIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1884,'PODEVIN','JACQUELINE','1936-03-24','02.61.79.10.29','06.16.13.60.16',NULL,'lieu dit le menil gouffier','','','50530','CHAMPEAUX',NULL,NULL,'1360314020001',58.000000000,'1963-12-11','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1885,'HEBERT','LOUIS','1933-12-31','02.88.65.50.89','06.99.04.10.70',NULL,'VOIE PANORAMIQUE','','','14460','COLOMBELLES',NULL,NULL,'2331214166001',3597.000000000,'1955-06-11','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1886,'VIVIER','EUGENE-CYRILLE','1933-10-04','02.78.96.68.19','06.94.43.17.14',NULL,'','','','14000','CAEN',NULL,NULL,'2331014274001',791.000000000,'1955-12-31','PREMIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1887,'ROUSSEL','LUCIEN','1939-02-11','02.76.93.59.91','06.49.96.50.59',NULL,'203 bis rue de falaise','','','14460','COLOMBELLES',NULL,NULL,'2390280100001',1657.000000000,'1960-04-24','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1888,'BOLLENGIER','marie christine','1938-03-27','02.46.66.07.90','06.59.05.29.50',NULL,'26 rue de la rpublique','','','61200','ARGENTAN',NULL,NULL,'1380314719001',11.000000000,'1960-02-19','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1889,'LEPLEY','SOLANGE','1942-03-31','02.27.53.42.67','06.68.49.29.96',NULL,'27 RUE DE L''ARQUETTE','','','27270','CHAMBLAC',NULL,NULL,'1420350295001',7.000000000,'1970-12-25','SILVER',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1890,'BARBIER','DENISE','1933-09-07','02.61.79.44.55','06.11.66.23.80',NULL,'610 quartier des belles portes','','','14500','VAUDRY',NULL,NULL,'2330950577001',191.000000000,'1958-12-19','PREMIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1891,'DUVAL','REINE','1936-03-17','02.10.88.65.25','06.71.77.49.55',NULL,'3 rue a dumas','','','50100','CHERBOURG',NULL,NULL,'1360314121001',0.000000000,'1965-05-28','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1892,'FERAY','GERARD','1940-02-13','02.50.17.96.90','06.76.41.69.68',NULL,'12 RUE EUGENE BOUDIN','','','14540','HUBERT FOLIE',NULL,NULL,'2400228087001',432.000000000,'1970-02-03','SILVER',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1893,'FOUCHARD','ROLAND','1934-07-04','02.25.79.33.51','06.39.99.54.29',NULL,'46 RUE DE BAYEUX','','','14170','ST PIERRE SUR DIVES',NULL,NULL,'2340761219001',202.000000000,'1956-09-03','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1894,'DALIGAULT','ROBERT','1931-05-18','02.41.94.96.08','06.59.46.61.65',NULL,'4 RUE MARECHAL FOCH','','','50100','CHERBOURG',NULL,NULL,'1310561032001',102.000000000,'1957-03-29','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1895,'CAMBRON','MONIQUE','1934-04-23','02.37.17.81.48','06.66.26.05.01',NULL,'7 RUE ST JEAN BAPTISTE','','','14700','FALAISE',NULL,NULL,'2340414437001',172.000000000,'1960-10-20','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1896,'HELAINE','PASCAL','1930-04-02','02.89.93.54.51','06.77.94.14.20',NULL,'HAMEAU LECTOT','','','14000','CAEN',NULL,NULL,'1300414639001',115.000000000,'1959-07-07','PREMIUM',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1897,'CATHERINE','FLORENCE','1943-02-22','02.44.57.18.07','06.23.33.78.63',NULL,'2 rue du marais','','','14120','MONDEVILLE',NULL,NULL,'1430214367001',54.000000000,'1972-03-16','SILVER',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1898,'LEFOULON','ARSENE',NULL,'02.96.96.21.90','06.75.81.82.85',NULL,'','','','14320','FONTENAY LE MARMION',NULL,NULL,'1350214516001',201.000000000,'2013-07-12','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1899,'FRANOISE','SERGE','1952-02-18','02.11.70.09.20','06.75.17.96.22',NULL,'25 CHEMIN DE BENEAUVILLE','','','14000','CAEN',NULL,NULL,'2520214166001',95.000000000,'1982-03-20','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1900,'GUILLARD','CLAUDE','1934-02-01','02.85.96.16.68','06.12.17.44.75',NULL,'','','','14123','CORMELLES LE ROYAL',NULL,NULL,'1340250105001',346.000000000,'1959-11-03','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1901,'GUERIN','ANDREE','1939-01-20','02.27.29.08.06','06.73.75.79.02',NULL,'23 CHEMIN DE LA CROIX DE FER','','','14000','CAEN',NULL,NULL,'2390114081001',8.000000000,'1968-07-10','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1902,'DECARITE','YVETTE','1938-03-16','02.31.95.26.43','06.85.90.88.27',NULL,'19 RUE DU PONT JALLON','','','14000','CAEN',NULL,NULL,'2380314289001',191.000000000,'1962-02-12','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1903,'BIETRY','YANNICK','1929-04-28','02.70.79.85.87','06.54.94.66.85',NULL,'20 AVENUE DE LA CITE MINIERE','','','76200','DIEPPE',NULL,NULL,'2290461057001',1062.000000000,'1958-03-11','PREMIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1904,'PESQUEREL','ARLETTE','1957-08-02','02.37.69.70.86','06.12.62.79.10',NULL,'LA FONTAINE','','','14540','ROCQUANCOURT',NULL,NULL,'2570814366001',1163.000000000,'1980-09-16','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1905,'CID','MONIQUE','1937-07-13','02.35.26.73.57','06.82.08.22.36',NULL,'55 RUE DE LA COHUE','','','14220','ST LAURENT DE CONDEL',NULL,NULL,'1370778331001',262.000000000,'1959-05-01','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1906,'MICHEL','ELIANE','1928-03-19','02.51.33.36.58','06.63.87.45.66',NULL,'','','','14220','CESNY BOIS HALBOUT',NULL,NULL,'2280350318001',105.000000000,'1951-03-31','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1907,'MAUGER','CHRISTIANE','1933-05-11','02.48.66.40.18','06.68.46.29.28',NULL,'1 ALLEE DES PINCONS','','','14740','BRETTEVILLE L''ORGUEILLEUSE',NULL,NULL,'1330514112001',34.000000000,'1959-09-23','PREMIUM',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1908,'FONTAINE','GHISLAINE','1929-04-29','02.61.55.70.66','06.32.83.05.71',NULL,'1 RUE DE L''ORMELET','','','14000','CAEN',NULL,NULL,'2290461197001',206.000000000,'1957-08-06','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1909,'LIBOIS','ROBERT','1963-02-09','02.65.97.10.21','06.36.91.28.75',NULL,'7 rue de la vierge','','','14120','MONDEVILLE',NULL,NULL,'2630214990001',4167.000000000,'1987-12-19','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1910,'DOLLEY','GINETTE','1935-06-07','02.70.65.64.84','06.69.68.94.04',NULL,'11 RUE DU PLAIN DU ROY','','','14370','MOULT',NULL,NULL,'2350661028001',363.000000000,'1960-03-12','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1911,'LASSEUR','JEAN','1976-06-27','02.59.91.85.83','06.30.29.78.65',NULL,'157 rue haute','','','14540','SOLIERS',NULL,NULL,'2760699238001',602.000000000,'1997-02-20','PREMIUM',12,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1912,'LEGRAS','MAURICETTE','1966-12-29','02.23.14.39.83','06.47.80.92.81',NULL,'4 HAMEAU DE BRAY','','','14260','AUNAY SUR ODON',NULL,NULL,'2661214294001',23.000000000,'1992-08-18','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1913,'LUST','FLORENCE','1936-04-11','02.37.52.16.49','06.82.40.65.25',NULL,'24  av des clairieres','','','14000','CAEN',NULL,NULL,'1360457596001',8.000000000,'1966-10-09','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1914,'RUEL','JANINE',NULL,'02.96.39.98.10','06.87.95.76.46',NULL,'25 rue de l''avenir','','','14000','CAEN',NULL,NULL,'1610361283001',4780.000000000,'2010-04-14','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1915,'ROSEN','','1919-04-02','02.10.60.19.91','06.51.96.02.55',NULL,'FOYER ALBERT 1ER 21 AVENUE ALBE','RT 1ER','','14220','LES MOUTIERS EN CINGLAIS',NULL,NULL,'1190450502001',420.000000000,'1946-07-19','GOLD',22,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1916,'VIARD','JACQUES','1932-09-19','02.14.82.72.96','06.77.76.11.71',NULL,'14 AVENUE GEORGES LANDRY','','','14059','CAEN',NULL,NULL,'2320949019001',29.000000000,'1954-08-20','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1917,'LEMAITRE','VIVIANE','1937-01-06','02.68.21.62.23','06.19.89.16.21',NULL,'1 RUE DU PRIEURE','','','14150','OUISTREHAM',NULL,NULL,'2370114451001',110.000000000,'1964-01-29','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1918,'BAZIN','JACQUELINE','1932-07-16','02.35.00.25.15','06.37.45.96.68',NULL,'','','','14123','IFS',NULL,NULL,'2320714610001',201.000000000,'1953-10-10','PLATINIUM',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1919,'LE METAYER','GUSTAVE','1977-06-20','02.10.25.69.36','06.84.02.89.58',NULL,'1 RUE BIENFAISANCE','','','50800','BOISYVON',NULL,NULL,'2770699302001',223.000000000,'1999-03-23','PREMIUM',11,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1920,'LEMAITRE','PATRICIA','1939-12-29','02.91.22.49.05','06.86.90.83.11',NULL,'D37 ROUTE DE TROARN','','','14370','ARGENCES',NULL,NULL,'1391214455001',339.000000000,'1963-09-07','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1921,'LE BLOND','MARIE JOSEPHE','1935-06-07','02.75.16.09.35','06.11.22.61.48',NULL,'12 rue gandhi','','','14480','CREULLY',NULL,NULL,'2350614229001',1075.000000000,'1958-05-10','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1922,'BERLIN','GENEVIEVE','1937-07-08','02.79.27.76.43','06.11.29.04.96',NULL,'30 RUE LAUNETTE','','','14000','CAEN',NULL,NULL,'1370714404001',100.000000000,'1961-06-13','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1923,'GEHENNE','CHRISTOPHE','1940-03-17','02.30.43.58.00','06.10.12.07.81',NULL,'16 IMPASSE POMONE','','','14700','VIGNATS',NULL,NULL,'1400314672001',27.000000000,'1962-07-18','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1924,'SUPRUN','YVES','1936-11-25','02.12.79.48.56','06.86.16.58.99',NULL,'434 ROUTE DE LANGRUNE','','','14470','COURSEULLES SUR MER',NULL,NULL,'2361127040001',433.000000000,'1958-04-14','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1925,'COLIBOEUF','THERESE','1962-03-07','02.10.52.85.55','06.21.98.88.39',NULL,'16 RUE DE LA POMME','','','14000','CAEN',NULL,NULL,'1620314628001',375.000000000,'1986-03-02','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1926,'DELAMARE','JULIETTE','1963-01-30','02.61.20.32.23','06.78.22.56.28',NULL,'159 RTE DE LION','','','14123','FLEURY SUR ORNE',NULL,NULL,'1630114327001',91.000000000,'1989-07-28','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1927,'LEVERRIER','FLORENCE','1930-12-17','02.97.83.63.40','06.55.69.14.22',NULL,'27 RUE DE BOURGOGNE','','','14220','ST LAURENT DE CONDEL',NULL,NULL,'2301250580001',37.000000000,'1952-04-26','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1928,'ESNOULT','BERNARD','1950-06-19','02.11.36.11.45','06.71.76.92.96',NULL,'50 route de gouvix','','','14220','ST LAURENT DE CONDEL',NULL,NULL,'2500614255001',57.000000000,'1978-02-09','PREMIUM',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1929,'SUSANNE-BEBIN','RENE','1938-05-26','02.24.67.45.34','06.62.30.12.45',NULL,'2 CENTRE DE LA BERGERE','','','14000','CAEN',NULL,NULL,'2380585257001',92.000000000,'1960-11-01','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1930,'LE MAITRE','ANGELE','1930-03-04','02.20.93.12.41','06.73.57.91.87',NULL,'51A RUE VICTOR LEPINE','','','14000','CAEN',NULL,NULL,'2300390010001',14.000000000,'1960-05-25','GOLD',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1931,'JACQUES','JEAN','1957-03-25',NULL,NULL,NULL,'RUE DE L EGLISE','','','14000','GIBERVILLE',NULL,NULL,'1570314328001',19.000000000,'1981-08-23','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1932,'SALLOT','REGINE','1959-11-27','02.28.19.56.65','06.34.66.34.96',NULL,'42 RUE DE L''EGLISE','','','14000','CAEN',NULL,NULL,'1591114729001',3644.000000000,'1980-01-13','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1933,'MERLE','MICHEL','1938-07-18','02.80.03.65.75','06.88.90.65.13',NULL,'LES HAUTS VENTS','','','61430','ATHIS DE L''ORNE',NULL,NULL,'1380714140001',29.000000000,'1959-03-21','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1934,'SKIBA','THERESE','1935-05-05','02.46.51.55.60','06.87.93.34.20',NULL,'53 RUE JEAN VILAR','','','14190','CAUVICOURT',NULL,NULL,'1350561461001',65.000000000,'1956-09-14','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1935,'DAIGREMONT','IRENE','1931-01-24','02.24.10.05.37','06.35.37.72.52',NULL,'24 RUE DES MONTS','','','72520','LAIGNE EN BELIN',NULL,NULL,'2310114196001',395.000000000,'1961-11-21','PREMIUM',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1936,'BELIN','MICHEL','1935-09-15',NULL,NULL,NULL,'','','','14000','CAEN',NULL,NULL,'1350950082001',375.000000000,'1962-07-19','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1937,'CLEMENCE','SUZANNE','1930-04-05','02.45.92.41.00','06.43.62.75.09',NULL,'1 rue dcardinal lavigerie','','','14000','CAEN',NULL,NULL,'1300414181001',1066.000000000,'1951-09-11','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1938,'VAUTIER','CYRILLE','1928-04-26','02.76.44.04.02','06.91.11.67.92',NULL,'4 route de saint clair','','','14230','ISIGNY SUR MER',NULL,NULL,'2280441279001',1976.000000000,'1951-03-15','PREMIUM',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1939,'PESNELLE','JEAN','1961-07-30','02.88.22.50.31','06.98.00.69.30',NULL,'','','','50310','QUINEVILLE',NULL,NULL,'2610714661001',145.000000000,'1987-06-16','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1940,'LOISEL','MARCEL','1940-03-03','02.29.78.96.89','06.46.28.54.69',NULL,'LE BOURG','','','14800','TOUQUES',NULL,NULL,'1400314488001',351.000000000,'1962-11-25','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1941,'DESRUES','JACQUELINE','1940-12-09','02.65.47.68.27','06.19.59.34.33',NULL,'"LE SAUBENARD"','','','50700','VALOGNES',NULL,NULL,'1401214469001',172.000000000,'1969-11-23','SILVER',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1942,'LANGLAIS','JOEL','1934-06-16','02.76.39.42.06','06.10.67.69.34',NULL,'VILLAGE D''INGY','','','14220','CROISILLES',NULL,NULL,'1340656198001',92.000000000,'1958-03-16','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1943,'LECLERC','GERARD','1945-02-24','02.20.97.22.53','06.52.28.75.65',NULL,'res palissis  rue monseigneur ad','am','','14940','TOUFFREVILLE',NULL,NULL,'1450250369001',3503.000000000,'1967-07-09','GOLD',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1944,'MONROTY','JEAN','1962-01-11','02.21.92.41.61','06.34.90.72.84',NULL,'11 rue des pavillon','','','14000','CAEN',NULL,NULL,'2620161049001',20.000000000,'1985-02-21','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1945,'GAUTIER','LOUISE','1933-05-06','02.49.88.93.33','06.11.49.39.79',NULL,'2 RUE DU VAL','','','61230','GACE',NULL,NULL,'2330550161001',142.000000000,'1955-11-03','PREMIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1946,'CHARTRAIN','BERNARD','1930-08-30','02.35.60.29.36','06.17.37.72.20',NULL,'80 AVENUE DE ROUEN','','','14630','CAGNY',NULL,NULL,'2300814338001',48.000000000,'1953-11-14','PREMIUM',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1947,'VILFEU','DOMINIQUE','1929-05-18','02.93.00.62.01','06.66.61.49.57',NULL,'7 RUE DES CAPUCINES','','','14710','LOUVIERES',NULL,NULL,'2290518187001',446.000000000,'1956-09-29','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1948,'LANGLAIS','SERGE','1930-02-01','02.16.07.59.70','06.14.15.89.65',NULL,'RUE DE LIROSE','','','14610','ANISY',NULL,NULL,'1300214564001',48.000000000,'1958-07-11','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1949,'LAUNAY','CHANTAL','1945-03-24',NULL,NULL,NULL,'4 venelle aux morices','','','14123','IFS',NULL,NULL,'1450314316001',12.000000000,'1966-08-21','GOLD',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1950,'MARIE','','1928-02-26','02.74.24.52.02',NULL,NULL,'61 ROUTE DE PORT EN BESSIN BP 6','0000','','14270','OUEZY',NULL,NULL,'1280214530001',1358.000000000,'1958-05-06','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1951,'BROUT','CHRISTIANE','1940-02-11','02.44.98.84.58','06.41.97.74.90',NULL,'11 IMPASSE DES CYCLAMENS','','','14330','LE BREUIL EN BESSIN',NULL,NULL,'1400244116001',6.000000000,'1967-03-18','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1952,'FALET','BRIGITTE','1937-04-20','02.27.04.15.56','06.14.15.17.45',NULL,'4 RUE GUSTAVE FLAUBERT','','','14000','CAEN',NULL,NULL,'1370414020001',94.000000000,'1961-12-14','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1953,'MILANI','VITAL','1933-03-14','02.33.67.43.25','00 33 6.80.83.16.33',NULL,'9 RUE ROMAINE','','','14400','BAYEUX',NULL,NULL,'1330314200001',747.000000000,'1959-07-06','PREMIUM',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1954,'LETELLIER','GENEVIEVE','1936-08-11','02.34.71.76.68','06.82.25.22.90',NULL,'27 RUE CAILLEMER','','','14250','CRISTOT',NULL,NULL,'1360814360001',46.000000000,'1960-07-26','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1955,'LETELLIER','CHRYSTELLE','1939-08-13','02.37.51.91.29','06.19.91.39.60',NULL,'21 RUE DE LA POMMERAIE','','','14000','CAEN',NULL,NULL,'2390814120001',3936.000000000,'1969-03-05','SILVER',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1956,'VAUGEOIS','MONIQUE','1934-09-15','02.86.97.93.59','06.11.42.88.90',NULL,'LE MESNIL','','','14123','CORMELLES LE ROYAL',NULL,NULL,'1340914318001',136.000000000,'1958-11-09','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1957,'CARVILLE','LOUIS','1964-07-19','02.11.82.27.22','06.67.93.31.06',NULL,'7 RUE BOBIGNY','','','14000','CAEN',NULL,NULL,'2640721361001',1157.000000000,'1988-03-02','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1958,'NIARD','ODILE','1945-05-29','02.11.86.63.18','06.57.66.28.55',NULL,'11 YVONNE GUEGAN','','','50340','BRICQUEBOSQ',NULL,NULL,'1450556256001',588.000000000,'1966-09-03','GOLD',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1959,'ADAM','RENE','1934-07-05','02.87.94.21.61','06.55.57.89.89',NULL,'11 RUE DE BRETAGNE','','','14540','GRENTHEVILLE',NULL,NULL,'2340714323001',48.000000000,'1958-12-29','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1960,'DILYS','NELLY','1930-08-11','02.10.21.72.44','06.82.89.74.66',NULL,'VIRCOQ','','','14340','VALSEME',NULL,NULL,'2300814393001',430.000000000,'1958-07-03','PREMIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1961,'','JEANNE','1930-06-17','02.60.82.65.15','06.46.98.84.48',NULL,'14 BD CHURCHILL','','','14700','VIGNATS',NULL,NULL,'1300614027001',12.000000000,'1957-12-14','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1962,'MARIE','ilqar','1954-01-16','02.66.52.21.41','06.11.81.09.79',NULL,'HAMEAU COURTEILLES','','','14630','FRENOUVILLE',NULL,NULL,'1540161278001',11.000000000,'1977-06-15','PREMIUM',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1963,'JEANNETTE','FELIX','1942-01-09','02.10.70.34.36','06.33.19.66.05',NULL,'FERME DU LOGIS','','','14210','TOURVILLE SUR ODON',NULL,NULL,'1420114744001',836.000000000,'1964-02-22','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1964,'TALHI','MADELEINE','1936-05-21','02.22.28.31.76','06.17.41.75.11',NULL,'30 route d''harcourt','','','14400','BAYEUX',NULL,NULL,'1360514651001',1.000000000,'1957-01-06','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1965,'LEGRAS','DANY','1929-07-23','02.43.04.27.26','06.11.70.22.07',NULL,'17 RUE CH BEAUDELAIRE','','',NULL,NULL,NULL,NULL,'1290714121001',383.000000000,'1958-02-07','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1966,'','CLAUDINE','1932-10-16','02.10.62.17.55','06.59.94.17.34',NULL,'37 BIS RUE DE BRAS','','','14190','ESTREES LA CAMPAGNE',NULL,NULL,'1321014109001',17.000000000,'1961-06-04','PREMIUM',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1967,'GRUZA','JACQUELINE','1938-03-29','02.66.26.12.00','06.18.84.37.69',NULL,'11 rue du bissonnet','','','14000','CAEN',NULL,NULL,'1380314157001',461.000000000,'1959-06-05','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1968,'VATRES','CHRISTIANE','1932-07-23','02.99.29.82.90','06.99.25.21.83',NULL,'289 TOURDERIE','','','14000','CAEN',NULL,NULL,'2320714612001',136.000000000,'1958-09-24','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1969,'LETERRIER','SYLVIE','1938-04-22','02.21.98.87.12','06.11.53.11.84',NULL,'39 RUE DE LA DELIVRANDE','','','14000','CAEN',NULL,NULL,'2380461407001',397.000000000,'1962-05-13','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1970,'LEVALLOIS','ROLANDE','1928-08-27','02.82.07.52.16','06.78.89.44.91',NULL,'','','',NULL,NULL,NULL,NULL,'1280872380001',264.000000000,'1952-05-19','PLATINIUM',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1971,'SAGE','ALEXANDRE','1929-02-23','02.90.36.84.19','06.78.89.20.51',NULL,'RESIDENCE DE LA BERGERIE','','','14200','HEROUVILLE ST CLAIR',NULL,NULL,'2290214708001',168.000000000,'1950-01-13','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1972,'GUERIN','CHANTAL','1943-02-27','02.89.99.10.69','06.59.96.86.09',NULL,'23 paul eloire','','','14630','FRENOUVILLE',NULL,NULL,'2430214356001',4775.000000000,'1965-06-06','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1973,'SUPIZET','MICHEL','1939-11-09','02.65.65.82.34','06.14.49.35.45',NULL,'64 rue de la marne','','',NULL,NULL,NULL,NULL,'2391114712001',41.000000000,'1960-03-16','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1974,'LENGRONNE','MICHEL','1934-10-23','02.68.82.21.11','06.43.51.88.25',NULL,'16 AVENUE DU 43 E REGIMENT D''ART','ILLERIE','','14330','SAONNET',NULL,NULL,'2341061236001',735.000000000,'1960-11-11','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1975,'BONNEL','NADINE','1967-10-19','02.42.71.73.94','06.80.91.36.04',NULL,'10 rue du poitou','','','14510','HOULGATE',NULL,NULL,'2671014290001',172.000000000,'1992-10-30','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1976,'LEPOITTEVIN','JULES','1940-12-12','02.99.85.71.69','06.11.03.29.19',NULL,'2 IMPASSE DES GLAIEULS','','','14410','VIESSOIX',NULL,NULL,'2401253201001',2359.000000000,'1969-06-08','SILVER',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1977,'PERI','MARIE LAURE','1953-03-19','02.39.16.13.87','06.42.92.52.30',NULL,'30 BD ALSACE LORRAINE','','','14000','CAEN',NULL,NULL,'2530314119001',39.000000000,'1974-09-10','PREMIUM',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1978,'MEUDIC','','1928-01-23','02.27.80.15.33','06.49.33.05.03',NULL,'46 BIS RUE DE LA SEINE','','','50210','ST DENIS LE VETU',NULL,NULL,'2280172154001',1094.000000000,'1949-12-06','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1979,'VARIN','GENEVIEVE','1938-09-25','02.51.48.98.37','06.18.87.14.66',NULL,'2 rue france choubert','','','14480','LE FRESNE CAMILLY',NULL,NULL,'1380914090001',14.000000000,'1962-01-29','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1980,'VARIN','ARMELLE','1933-02-11','02.17.02.02.55','06.66.80.10.41',NULL,'18 RUE ALBERT 1ER','','','14000','CAEN',NULL,NULL,'1330214364001',327.000000000,'1955-07-21','PREMIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1981,'ROQUET','MAURICE','1956-12-30','02.60.37.06.08','06.36.27.60.33',NULL,'','','','14240','CAHAGNES',NULL,NULL,'2561214657001',352.000000000,'1977-09-03','PREMIUM',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1982,'MARIE','GEORGETTE','1938-09-05','02.60.44.89.43','06.10.74.71.00',NULL,'3 rue de la perquette','','','14000','CAEN',NULL,NULL,'1380914372001',91.000000000,'1966-12-04','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1983,'','CLAUDE','1936-07-29','02.51.00.30.72','06.16.71.02.87',NULL,'16 rue henri barbusse','','','14000','CAEN',NULL,NULL,'1360750325001',67.000000000,'1957-09-03','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1984,'LECHEVALLIER','CLAUDE','1954-03-26','02.30.76.70.31','06.49.34.26.47',NULL,'1 RUE DU NID DU CHIEN','','','14980','ROTS',NULL,NULL,'1540350505001',59.000000000,'1976-07-05','PREMIUM',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1985,'MOSSLER','HELENE','1945-10-24','02.52.37.34.08','06.44.54.55.27',NULL,'IMPASSE LA MARTINIERE','','','14123','IFS',NULL,NULL,'1451097221001',304.000000000,'1970-08-31','GOLD',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1986,'SPINGA','JEANNINE','1931-08-21','02.96.00.28.78','06.39.29.95.30',NULL,'9 rue d isigny chez mme CUDINE','','','14200','HEROUVILLE ST CLAIR',NULL,NULL,'2310814020001',6.000000000,'1953-03-10','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1987,'TRIOLET','MARCELLE','1962-03-23','02.67.78.43.39','06.84.77.78.76',NULL,'19 imp des roses','','','14500','VIRE',NULL,NULL,'1620361122001',31.000000000,'1986-05-02','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1988,'HUREL','PASCAL','1939-03-27','02.77.97.65.00','06.10.45.35.73',NULL,'9 RUE ROGER DUPONT','','','14000','CAEN',NULL,NULL,'2390314186001',186.000000000,'1963-06-30','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1989,'LESAVOUREUX','FERNAND',NULL,'02.60.30.87.69','06.85.48.00.26',NULL,'13 LOTISSEMENT DE LA MOTTE','','','14160','GRANGUES',NULL,NULL,'1340622094001',358.000000000,'2007-11-19','PREMIUM',10,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1990,'LEPAGE','BERNARD','1938-08-27','02.83.97.38.17','06.48.38.94.61',NULL,'2 RUE DU PANORAMA','','','14670','ST OUEN DU MESNIL OGER',NULL,NULL,'2380814117001',264.000000000,'1961-08-22','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1991,'ECHE','PIERRE','1929-03-09','02.11.26.63.96','06.44.46.67.56',NULL,'lieu dit lalonde rd 33','','','61700','AVRILLY',NULL,NULL,'1290310206001',818.000000000,'1955-09-10','PREMIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1992,'SEBIRE','ODETTE','1931-05-10','02.43.41.57.81','06.28.85.72.89',NULL,'4 BIS RUE DU DR PAUL ENOUF','','','14320','FONTENAY LE MARMION',NULL,NULL,'2310522128001',142.000000000,'1960-05-21','GOLD',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1993,'BOUET','CLAUDE','1939-04-02','02.35.32.66.45','06.80.24.07.94',NULL,'56 rue armand marie','','','14123','IFS',NULL,NULL,'2390414388001',15.000000000,'1963-02-08','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1994,'JUMEL','CLAUDE','1932-02-24','02.13.13.74.95',NULL,NULL,'62 C ROUTE DE BRETAGNE','','','14210','NEUILLY LE MALHERBE',NULL,NULL,'1320261295001',100.000000000,'1960-04-20','PREMIUM',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1995,'MAUPILIER','CHANTAL','1934-12-30','02.94.36.36.16','06.12.00.70.15',NULL,'1 RUE DE BAYEUX','','','14490','BALLEROY',NULL,NULL,'2341214535001',384.000000000,'1956-12-29','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1996,'POZNANSKI','fabien','1937-04-28','02.43.34.83.24','06.25.02.71.24',NULL,'4 RUE DU PRESIDENT COTY','','','14670','TROARN',NULL,NULL,'1370414066001',106.000000000,'1966-06-05','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1997,'LANGEVIN','Jean louis','1937-10-26','02.50.32.89.24','06.79.51.47.59',NULL,'3 PLACE DU CLOS DES OUISEAUX','','',NULL,NULL,NULL,NULL,'1371014628001',23.000000000,'1965-12-29','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1998,'MAUBERT','MICHELINE','1938-01-14','02.58.98.28.75','06.50.19.12.65',NULL,'3 rue roger bastion','','',NULL,NULL,NULL,NULL,'1380161232001',197.000000000,'1960-10-09','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (1999,'CHASSERIEAU','VERONIQUE',NULL,'02.37.44.10.14','06.62.34.40.58',NULL,'rue du stade','','','14000','CAEN',NULL,NULL,'1430460516001',38.000000000,'2009-11-20','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2000,'GOUDAL','JEAN','1936-10-15','02.24.03.51.18','06.96.48.28.70',NULL,'4 cite des jardins','','','14610','BASLY',NULL,NULL,'2361077464001',110.000000000,'1958-07-22','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2001,'COUDRAY','SYLVIE','1939-11-05','02.12.07.85.68','06.27.31.32.27',NULL,'6 rue du luxembourg','','','14850','HEROUVILLETTE',NULL,NULL,'2391178066001',79.000000000,'1962-11-07','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2002,'VILAIN','GEORGETTE','1932-06-29','02.51.86.96.21','06.74.86.04.56',NULL,'CHEMIN DU CHAMP BRETON','','','14170','LIEURY',NULL,NULL,'1320653157001',170.000000000,'1962-12-11','PLATINIUM',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2003,'ESNEYS','DENIS','1985-05-20','02.24.67.27.24','06.58.80.91.73',NULL,'5 RUE DE L''EURE','','','14840','CUVERVILLE',NULL,NULL,'1850599336001',11.000000000,'2012-02-02','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2004,'FLEURY','PAULETTE','1968-01-22','02.83.28.24.30','06.11.45.84.07',NULL,'15 RUE DE VERDUN','','','14440','DOUVRES LA DELIVRANDE',NULL,NULL,'1680153166001',99.000000000,'1989-03-21','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2005,'ANNE','ANDRE','1940-11-21','02.19.20.29.76','00 33 6.32.52.11.44',NULL,'','','','14540','GARCELLES SECQUEVILLE',NULL,NULL,'1401114196001',328.000000000,'1967-01-22','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2006,'TOUTAIN','ISABELLE','1934-10-13','02.91.07.23.50','06.41.39.17.18',NULL,'34 AVENUE DE L''HIPPODROME','','','14270','LE MESNIL MAUGER',NULL,NULL,'2341014515001',1179.000000000,'1961-02-18','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2007,'POREY','RENE','1939-08-30','02.94.79.02.16','06.36.08.41.69',NULL,'5/8 CITE DE ROCHES','','','14123','CORMELLES LE ROYAL',NULL,NULL,'2390814163001',78.000000000,'1968-03-16','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2008,'DAUMESNIL','JEANINE','1938-02-07','02.57.37.32.24','06.67.08.82.26',NULL,'27 RUE DU PONT CREON','','','14550','BLAINVILLE SUR ORNE',NULL,NULL,'1380214483001',33.000000000,'1968-09-09','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2009,'BOREL','ANDRE','1935-04-23','02.64.90.26.52','06.43.32.08.71',NULL,'163 RUE DE LA BASSE RIVE','','','14000','CAEN',NULL,NULL,'1350461389001',581.000000000,'1956-06-06','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2010,'QUERE','ALBERT','1941-03-01','02.33.44.77.53','06.25.45.58.37',NULL,'163 RUE DE LA BASSE RIVE','','','14000','CAEN',NULL,NULL,'2410351391001',73.000000000,'1969-06-16','SILVER',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2011,'CHAPPERON','EDOUARD','1940-03-29','02.10.51.29.69','06.11.57.90.18',NULL,'11 RUE DU CHATEAU D''EAU','','','14123','IFS',NULL,NULL,'2400350390001',8.000000000,'1964-01-25','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2012,'GODEFROY','DANIEL','1938-05-16','02.81.00.51.32','06.85.65.00.76',NULL,'5 RUE MARGUERITE DURAS','','','14980','ROTS',NULL,NULL,'1380560653001',41.000000000,'1960-09-02','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2013,'ERROT','MAURICE','1930-01-14','02.61.13.12.09','06.53.95.01.04',NULL,'le lion d or','','','61200','ARGENTAN',NULL,NULL,'2300114168001',29.000000000,'1951-03-28','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2014,'BARBEY','MADELEINE','1936-08-23','02.32.27.69.55','06.10.59.04.82',NULL,'23 rue de la bienfaisance','','','14690','PIERREFITTE EN CINGLAIS',NULL,NULL,'1360814597001',2250.000000000,'1961-09-25','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2015,'RIBOT','COLETTE','1939-05-01','02.20.13.52.53','06.50.69.61.03',NULL,'9 RUE DU 11 NOVEMBRE','','','14120','MONDEVILLE',NULL,NULL,'1390514171001',406.000000000,'1962-11-15','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2016,'VIVIEN','JOSIANE','1948-01-02','02.47.46.64.39','06.24.83.17.97',NULL,'9 RUE PORTE MILLET','','','14120','MONDEVILLE',NULL,NULL,'2480114589001',68.000000000,'1969-11-22','GOLD',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2017,'RIBARD','CHRISTIAN','1947-01-21','02.61.56.01.80','06.88.50.92.60',NULL,'57 RUE DE BEAULIEU','','','14370','ARGENCES',NULL,NULL,'1470135260001',10.000000000,'1968-07-30','GOLD',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2018,'HARDY','MICHEL','1933-02-17','02.11.71.15.73','06.79.45.41.43',NULL,'19 RUE PIERRE CURIE','','','14670','TROARN',NULL,NULL,'1330214336001',61.000000000,'1961-06-07','GOLD',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2019,'LEBAILLY','ALAIN','1931-10-09','02.93.83.86.13','06.87.58.97.32',NULL,'campagnol','','','14370','AIRAN',NULL,NULL,'2311014216001',134.000000000,'1952-10-24','PREMIUM',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2020,'GUERARD','KATIA','1934-09-16','02.14.40.73.39','06.39.74.14.26',NULL,'23 ALLEE DES ORFEVRES','','',NULL,NULL,NULL,NULL,'1340961252001',312.000000000,'1956-04-06','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2021,'GAUCHARD','CHRISTIAN','1928-01-09','02.18.87.47.23','06.36.07.86.16',NULL,'14 rue des maronniers','','','61200','SEVIGNY',NULL,NULL,'1280114396001',8.000000000,'1951-07-09','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2022,'LEPETIT','ALBERT','1931-02-18','02.89.55.71.48','06.10.95.48.13',NULL,'4 2 rue des marguerites','','','14000','CAEN',NULL,NULL,'2310250356001',59.000000000,'1959-03-19','PLATINIUM',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2023,'PICOT','ANDREE','1943-01-20','02.27.12.19.01','06.11.79.44.56',NULL,'62 RUE DU MARAIS','','','14410','BURCY',NULL,NULL,'1430114618001',1188.000000000,'1964-08-25','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2024,'JOHN','PIERRE','1970-03-10','02.26.22.82.35','06.91.08.44.33',NULL,'le bourg','','',NULL,NULL,NULL,NULL,'2700380570001',939.000000000,'1992-09-21','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2025,'CAMBRON','ROLAND','1943-01-10','02.30.36.61.61','06.63.21.58.35',NULL,'1 RUE VOLTAIRE','','','14670','JANVILLE',NULL,NULL,'1430114335001',367.000000000,'1973-07-11','SILVER',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2026,'LE ROY','JACQUELINE','1944-02-11','02.28.53.85.55','06.84.06.31.45',NULL,'7 RUE STE PAIX PORTE B','','','14400','ST MARTIN DES ENTREES',NULL,NULL,'2440212264001',82.000000000,'1969-09-04','GOLD',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2027,'LAFON','BERNARD','1944-02-01','02.27.07.63.82','06.10.66.51.24',NULL,'22 RUE PRE SAINT MARTIN','','','14123','IFS',NULL,NULL,'2440212264001',35.000000000,'1967-06-01','GOLD',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2028,'GUILLON','CLAUDE','1957-01-05','02.35.22.77.51','06.20.30.41.20',NULL,'2 RUE DES CHASSES','','','50360','PICAUVILLE',NULL,NULL,'1570114695001',649.000000000,'1982-01-11','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2029,'FORTIER','NATHALIE','1932-09-17','02.34.02.92.27','06.11.65.16.49',NULL,'12 RUE DU STADE','','','14270','MAGNY LA CAMPAGNE',NULL,NULL,'2320914023001',3.000000000,'1954-07-14','PREMIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2030,'ROULLEAUX','GEORGETTE','1932-09-07','02.83.82.03.64','06.84.57.39.26',NULL,'12 AVENUE DE LA CONCORDE','','','14310','TRACY BOCAGE',NULL,NULL,'2320914023001',2289.000000000,'1957-05-15','PREMIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2031,'LESAULNIER','MAURICE','1929-05-15','02.45.11.39.29','06.43.87.78.51',NULL,'17 PLACE VOLTAIRE','','','14123','FLEURY SUR ORNE',NULL,NULL,'2290553100001',58.000000000,'1958-07-19','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2032,'SEBERT','LOUISE','1939-02-03','02.45.98.03.56','06.77.05.62.61',NULL,'36 RUE ALEXANDRE','','','14700','FALAISE',NULL,NULL,'2390214122001',40.000000000,'1963-07-06','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2033,'LEROUVILLOIS','MADELEINE','1936-09-12','02.70.90.26.39','06.61.40.80.35',NULL,'15 rue de la crte','','',NULL,NULL,NULL,NULL,'2360950289001',380.000000000,'1964-08-26','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2034,'BLIN','ANTHONY','1935-08-15','02.23.50.41.72','06.61.96.49.82',NULL,'','','','14000','CAEN',NULL,NULL,'1350841099001',149.000000000,'1959-05-22','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2035,'RICHARD','CLAUDE','1936-06-19','02.31.47.06.19','06.10.15.58.42',NULL,'fissy','','','14123','IFS',NULL,NULL,'2360661218001',991.000000000,'1958-10-28','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2036,'QUONIAM','DANIEL','1939-07-26','02.54.97.38.09','06.11.10.89.89',NULL,'25 RUE DES CORPS MORANTS','','','14700','FALAISE',NULL,NULL,'1390714258001',27.000000000,'1965-04-11','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2037,'QUONIAM','JOCELYNE','1957-02-20','02.10.57.45.35','06.20.63.17.40',NULL,'','','','14370','ARGENCES',NULL,NULL,'1570214520001',813.000000000,'1985-11-17','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2038,'HOST','MYRIAM','1954-07-08','02.10.28.55.52','06.10.01.94.76',NULL,'3 RUE DE FALAISE','','','14630','EMIEVILLE',NULL,NULL,'1540714188001',5.000000000,'1977-05-25','PREMIUM',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2039,'AZE','GINO','1961-04-10','02.43.04.90.08','06.47.61.93.92',NULL,'6 RUE DE VAUX','','','14270','MEZIDON CANON',NULL,NULL,'1610414454001',24.000000000,'1985-07-11','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2040,'GONIDEC','THERESE','1946-05-26','02.14.59.65.73','06.33.51.28.27',NULL,'85 AVENUE DE LA PLAGE','','','14260','ONDEFONTAINE',NULL,NULL,'2460514146001',1112.000000000,'1971-08-22','GOLD',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2041,'PLET','ALEXANDRE','1962-01-11','02.65.46.60.10','06.76.39.49.45',NULL,'19 RUE DE L''ECUREUIL','','','61300','L''AIGLE',NULL,NULL,'2620114221001',305.000000000,'1990-12-17','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2042,'PALIN','GERALDINE','1936-01-08','02.18.79.02.82','06.64.22.60.64',NULL,'579 ROUTE DU BANC','','','14000','CAEN',NULL,NULL,'2360161069001',91.000000000,'1957-06-02','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2043,'PATRICE','Brigitte','1937-08-25','02.10.64.11.94','06.74.27.11.68',NULL,'16 rte de tilly','','','50340','LES PIEUX',NULL,NULL,'2370814221001',88.000000000,'1961-09-16','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2044,'DESLOGES','claude','1937-12-30','02.79.13.39.97','06.28.18.34.64',NULL,'17 ALLEE LAPEROUZE','','','14210','AVENAY',NULL,NULL,'1371214288001',711.000000000,'1967-04-04','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2045,'GUERIN','CHRISTOPHE','1955-01-26','02.37.05.75.80','06.88.14.29.69',NULL,'2 rue de l''ile de france','','','14000','CAEN',NULL,NULL,'1550114365001',141.000000000,'1984-02-25','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2046,'LEMERCIER','ALAIN','1938-04-28','02.46.75.06.30','06.28.01.32.52',NULL,'3 rue de londres','','','14000','CAEN',NULL,NULL,'2380450033001',79.000000000,'1961-11-22','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2047,'LEVAVASSEUR','ARLETTE','1941-01-08','02.69.42.89.67','06.82.60.82.69',NULL,'36 RUE DE L''EPARGNE','','',NULL,NULL,NULL,NULL,'1410114075001',2237.000000000,'1971-08-30','SILVER',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2048,'LOYAUX','stephane','1961-04-15','02.11.64.81.80','06.49.11.45.73',NULL,'70 RUE DU GENERAL DE GAULLE','','','14400','BAYEUX',NULL,NULL,'1610414483001',78.000000000,'1991-12-22','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2049,'TERRY','IRENE','1939-03-22','02.12.07.63.79','06.52.93.38.85',NULL,'chez m Baiga 9 RUE ALBERT DE MUN','','','61100','FLERS',NULL,NULL,'2390361006001',152.000000000,'1968-03-25','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2050,'JANVIER','CLEMENCE','1932-03-27','02.83.31.71.31','06.72.85.34.36',NULL,'9 route de devant','','','14320','ST MARTIN DE FONTENAY',NULL,NULL,'2320350051001',399.000000000,'1962-10-13','PREMIUM',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2051,'GRUYER','JOEL','1955-02-10','02.12.33.21.30','06.91.39.88.32',NULL,'2 rue a nobell','','','14370','ARGENCES',NULL,NULL,'2550214349001',597.000000000,'1977-07-02','PREMIUM',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2052,'LE CANN','MICHELINE','1934-07-26','02.47.80.57.78','06.88.84.17.38',NULL,'7 CITE DE LA CHAPELLE','','','14860','BAVENT',NULL,NULL,'2340714340001',843.000000000,'1956-12-29','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2053,'BEQUET','ODETTE','1931-12-17','02.72.38.82.60','06.42.62.18.25',NULL,'3 BOULEVARD DU MAINE','','','14000','CAEN',NULL,NULL,'2311261418001',42.000000000,'1955-08-29','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2054,'GEERTS','GERARD','1959-01-30','02.75.60.20.42','06.87.53.61.85',NULL,'4 ROUTE DE CAEN','','','14610','THAON',NULL,NULL,'1590114046001',1180.000000000,'1986-11-13','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2055,'DENIZE','MUGUETTE','1937-06-12','02.89.84.30.48','06.82.87.18.74',NULL,'101 AVENUE GENERAL LECLERC','','','14123','IFS',NULL,NULL,'1370614515001',313.000000000,'1965-06-19','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2056,'SIMON','PIERRE','1935-07-10','02.60.51.98.66','06.67.09.01.37',NULL,'36 RUE GUILLAUUME LE CONQUERANT','','','14480','CREULLY',NULL,NULL,'1350750484001',9.000000000,'1960-02-19','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2057,'MAUGER','JEANNE','1928-12-03','02.56.32.28.44','06.44.59.90.05',NULL,'LE NOUVEAU MONDE','','','14310','VILLERS BOCAGE',NULL,NULL,'1281203314001',647.000000000,'1955-09-24','PREMIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2058,'SALLES','HELENE','1937-11-15','02.39.67.63.94','06.26.87.24.90',NULL,'39 AVENUE DES 2 EGLISES','','','14370','CANTELOUP',NULL,NULL,'2371114011001',315.000000000,'1958-12-15','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2059,'LOREL','SUZANNE','1957-06-04','02.79.93.71.21','06.44.75.26.86',NULL,'CHEMIN DU FRICHE LE DESERT','','','14240','ORBOIS',NULL,NULL,'1570627155001',3657.000000000,'1987-12-23','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2060,'GILBERT','CLAUDE','1968-02-21','02.10.52.36.45','06.59.18.38.45',NULL,'28 rue m utrillo','','','14370','ARGENCES',NULL,NULL,'2680214057001',72.000000000,'1996-04-25','PREMIUM',12,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2061,'ARMAND','Jules','1933-02-02','02.50.16.36.05','06.35.44.87.47',NULL,'1 rue des marches','','',NULL,NULL,NULL,NULL,'1330214127001',175.000000000,'1960-03-10','PLATINIUM',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2062,'GIARD','HUBERT','1936-04-26','02.65.49.07.22','06.11.91.74.95',NULL,'1 rue chagford','','','14370','VIMONT',NULL,NULL,'1360445080001',57.000000000,'1960-05-31','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2063,'BERTHEAUME','LOUISE','1938-03-12','02.46.45.63.45','06.10.02.97.84',NULL,'11 RUE DES REHAUTS','','',NULL,NULL,NULL,NULL,'1380314041001',16.000000000,'1962-03-01','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2064,'HUE','RENE','1929-08-07','02.78.63.22.14','06.10.52.57.06',NULL,'23 RUE DU VILLAGE','','','14100','LISIEUX',NULL,NULL,'2290814743001',196.000000000,'1952-06-23','PREMIUM',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2065,'LEMIERE','PAULETTE','1928-03-12','02.93.41.09.11','06.66.81.85.72',NULL,'32 ROUTE DE ROUEN','','','14790','VERSON',NULL,NULL,'2280350427001',464.000000000,'1956-03-14','PREMIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2066,'SIGNORET','JEAN','1965-01-31','02.10.15.19.44','00 33 6.34.84.76.35',NULL,'','','','14190','ST GERMAIN LE VASSON',NULL,NULL,'1650114060001',10.000000000,'1992-04-21','PREMIUM',13,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2067,'MONTECOT','THERESE','1953-09-20','02.70.56.56.09','06.39.57.60.59',NULL,'LE MESNIL FREMENTAL','','','14460','COLOMBELLES',NULL,NULL,'1530914430001',188.000000000,'1976-07-12','PREMIUM',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2068,'MOREL','FRANCIS','1950-03-01','02.33.30.47.91','06.43.61.20.38',NULL,'','','','14310','LANDES SUR AJON',NULL,NULL,'2500314319001',597.000000000,'1977-03-13','PREMIUM',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2069,'ESCOLIVET','SUZANNE','1957-01-25',NULL,NULL,NULL,'2 ET 4 AVENUE DE PARIS','','','14220','GRIMBOSQ',NULL,NULL,'1570114695001',16.000000000,'1983-08-21','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2070,'MENOYOT','GEORGES','1958-04-27','02.25.22.73.83','06.81.34.51.95',NULL,'','','','14150','OUISTREHAM',NULL,NULL,'2580414589001',2686.000000000,'1985-05-23','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2071,'ROLLOT','JEAN PAUL','1930-05-24','02.38.38.26.03','06.82.74.25.48',NULL,'17 BOULEVARD DE L''AVIATION','','','14630','FRENOUVILLE',NULL,NULL,'1300514037001',121.000000000,'1953-06-29','PREMIUM',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2072,'DUBOIS','SARAH','1930-03-21','02.30.97.19.41','06.67.35.03.21',NULL,'25 AVENUE EDITH DE BEAUMONT','','',NULL,NULL,NULL,NULL,'1300361376001',259.000000000,'1960-10-13','PREMIUM',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2073,'PROST','MARIE THERESE','1929-01-03','02.75.42.85.74',NULL,NULL,'chemin des villiers','','','14350','ST MARTIN DES BESACES',NULL,NULL,'2290114375001',125.000000000,'1951-05-29','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2074,'PITON','MICHEL','1941-01-28','02.83.38.51.32','06.44.85.33.59',NULL,'46 RUE DE LA LIBERATION','','','14170','VAUDELOGES',NULL,NULL,'1410161101001',491.000000000,'1965-02-18','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2075,'HEBERT','','1935-12-14','02.11.55.55.58','06.42.74.96.46',NULL,'43 RUE MONSEIGNEUR ADAM','','','50470','LA GLACERIE',NULL,NULL,'2351214760001',397.000000000,'1961-06-07','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2076,'POREE','COLETTE','1960-02-03',NULL,NULL,NULL,'86 RUE DU SAPIN','','','14000','CAEN',NULL,NULL,'2600214190001',123.000000000,'1987-08-19','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2077,'BECQUET','RAYMONDE','1929-08-12','02.79.23.86.98','06.33.91.81.16',NULL,'20 avenue de l''hippodrome','','','14000','CAEN',NULL,NULL,'1290814546001',11.000000000,'1955-12-19','GOLD',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2078,'LEMIEUX','MARCEL','1964-09-30','02.48.90.91.53','06.79.77.12.22',NULL,'19 BD DE RETHEL','','','14460','COLOMBELLES',NULL,NULL,'2640975009001',6.000000000,'1988-02-27','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2079,'BASSET','VIVIANE','1940-12-12','02.62.98.06.17','06.24.54.06.81',NULL,'15 PLACE DEMI LUNE','','','14670','BURES SUR DIVES',NULL,NULL,'2401207066001',691.000000000,'1962-08-18','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2080,'AUDOUARD','CLAUDE','1953-02-15','02.58.65.98.40','06.46.26.42.20',NULL,'CHEMIN DES BONNEMENTS','','','14123','IFS',NULL,NULL,'1530214274001',1266.000000000,'1976-11-15','PREMIUM',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2081,'CATHERINE','FRANCOISE','1939-02-10','02.20.01.12.12','06.32.45.20.59',NULL,'chemin du basfond','','','14000','CAEN',NULL,NULL,'1390250558001',3.000000000,'1966-07-03','SILVER',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2082,'FALISE','','1965-05-10','02.12.13.51.19','06.11.00.76.59',NULL,'61. rue de bretagne','','','14730','GIBERVILLE',NULL,NULL,'1650514119001',147.000000000,'1986-11-22','PREMIUM',14,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2083,'LECESNE','GERARD',NULL,'02.97.28.58.32','06.75.30.36.82',NULL,'26 rue du dr bougault','','','50820','COUVILLE',NULL,NULL,'1310103314001',25.000000000,'2009-06-09','PREMIUM',NULL,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2084,'GRIMAUX','YVES','1955-01-20','02.43.01.30.38','06.63.75.63.18',NULL,'7 rue de sude','','','14700','FALAISE',NULL,NULL,'1550114119001',76.000000000,'1977-02-14','PREMIUM',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2085,'LAUNEY','MAURICE','1933-03-06','02.84.13.38.10','06.54.98.41.30',NULL,'12 RUE DU MOULIN A TAN','','','14250','LINGEVRES',NULL,NULL,'1330314176001',14.000000000,'1959-01-07','PREMIUM',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2086,'GUINAUDEAU','GUY','1929-08-11','02.53.77.06.48','06.31.99.08.98',NULL,'3 RUE SAINT SERNIN','','','14700','FALAISE',NULL,NULL,'1290814117001',25.000000000,'1955-04-06','PLATINIUM',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2087,'VICTOIRE','JEANINE','1944-02-12','02.53.06.52.54','06.61.63.95.00',NULL,'12 rue trainerie','','','14960','ASNELLES',NULL,NULL,'1440276091001',4.000000000,'1969-11-27','GOLD',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2088,'DUREL','ODILE','1944-03-31','02.46.54.23.40','06.59.38.06.33',NULL,'224 rue des colombes','','',NULL,NULL,NULL,NULL,'1440361103001',3.000000000,'1967-11-23','GOLD',18,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2089,'MONTOYA-ALAYA','THERESE','1947-01-05','02.15.42.13.08','06.97.65.20.11',NULL,'9 RUE BERNARD ZAJEWSKI','','','14740','LASSON',NULL,NULL,'2470114411001',8.000000000,'1969-10-24','GOLD',17,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2090,'HUREL','ROGER','1931-08-22','02.46.42.56.32','06.13.43.34.71',NULL,'1 RESIDENCE ST GERBOLD','','','92100','BOULOGNE BILLANCOURT',NULL,NULL,'1310814489001',63.000000000,'1959-05-02','GOLD',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2091,'SCELLES','MARTINE','1932-11-04','02.22.25.38.89','06.36.37.31.46',NULL,'','','','14000','CAEN',NULL,NULL,'1321114206001',570.000000000,'1961-09-24','GOLD',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2092,'JOHN','MARIE JACQUELIN','1932-07-03','02.10.91.37.90','00 33 6.33.31.32.46',NULL,'','','','14880','HERMANVILLE SUR MER',NULL,NULL,'2320750064001',102.000000000,'1961-04-19','PREMIUM',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2093,'MERCIER','annick','1952-01-11','02.12.14.37.74',NULL,NULL,'21. RUE ALBERT GIROUX','','','27500','PONT AUDEMER',NULL,NULL,'1520114301001',693.000000000,'1975-07-27','PREMIUM',16,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2094,'PALIWODA','CLAUDE','1934-11-12','02.11.85.70.09','06.40.38.54.90',NULL,'les perires','','','14860','BAVENT',NULL,NULL,'2341114268001',134.000000000,'1957-01-04','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2095,'PECATTE','ANDRE','1934-11-01','02.26.77.44.80','06.69.02.64.61',NULL,'9 rue chemin aux boeufs','','','14740','MARTRAGNY',NULL,NULL,'2341114268001',122.000000000,'1958-04-01','SILVER',20,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2096,'BARRE','REMI','1937-12-18','02.74.31.84.20',NULL,NULL,'11 rue de beauvais','','','14000','CAEN',NULL,NULL,'1371254054001',32.000000000,'1959-11-28','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2097,'DOUCERAIN','BERNARD','1960-01-07','02.95.06.52.67','06.51.96.69.19',NULL,'7 RUE DU LAVOIR','','','14320','ST MARTIN DE FONTENAY',NULL,NULL,'1600114557001',6.000000000,'1981-11-21','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2098,'FLAGUAIS','MICHEL','1929-06-29','02.43.63.47.35','06.11.07.53.68',NULL,'19 RUE VICTOR VENDE LA PIERRE H','EUZE','','14000','CAEN',NULL,NULL,'1290614208001',97.000000000,'1952-01-09','GOLD',21,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2099,'GENDRON','SIMONE','1938-04-10','02.12.08.73.78','06.92.52.72.84',NULL,'24 av albert 1er','','','14800','DEAUVILLE',NULL,NULL,'1380414221001',25.000000000,'1959-06-13','SILVER',19,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2100,'','FRANCOIS','1955-06-05','02.11.89.01.52','06.56.03.14.34',NULL,'RUE DU PARC','','','14000','CAEN',NULL,NULL,'1550614316001',168.000000000,'1979-01-02','PREMIUM',15,0);
INSERT INTO dbo.T_ADHERENT_ADR (ADR_ID,ADR_NOM,ADR_PRENOM,ADR_DATE_NAISSANCE,ADR_TEL_FIX,ADR_TEL_MOBILE,ADR_MAIL,ADR_ADRESSE1,ADR_ADRESSE2,ADR_ADRESSE3,ADR_CP,ADR_VILLE,ADR_LOGIN,ADR_PASS,ADR_NUMSECU,ADR_POINTS,ADR_DATE_ADHESION,ADR_CATEGORIE,ADR_REDUCTION_PC,ADR_FONDATEUR) VALUES (2101,'DUMAINE','THERESE','1951-07-15','02.79.59.25.89','06.34.89.54.42',NULL,'16 RUE DU 8 MAI','','','14780','LION SUR MER',NULL,NULL,'2510714734001',78.000000000,'1976-08-15','PREMIUM',16,0);
INSERT INTO